"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_core_bpmn_bpmn-info_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts&":
/*!*************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts& ***!
  \*************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
/* harmony import */ var _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/clipboard/clipboard.vue */ "./src/main/webapp/app/shared/clipboard/clipboard.vue");
/* harmony import */ var _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/core/help/help-tag.vue */ "./src/main/webapp/app/core/help/help-tag.vue");
/* harmony import */ var _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/core/audit/audit-tag.vue */ "./src/main/webapp/app/core/audit/audit-tag.vue");
/* harmony import */ var vue_bpmn__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue-bpmn */ "./node_modules/vue-bpmn/dist/index.esm.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









var bpmnUrl = 'api/bpmn';
// const semVerRegEx ='^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$\n';
var semVerRegEx = '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)$';
var BpmnInfo = /** @class */ (function (_super) {
    __extends(BpmnInfo, _super);
    function BpmnInfo() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.interactionMode = 'EDIT';
        _this.bPNMProcessInfo = {};
        _this.bpmnUpload = { type: 'CA_INVOCATION' };
        _this.bpmnCheckResult = {};
        _this.bpmnBlobUrl = null;
        _this.bpmnFileUploaded = false;
        // strange hack, to ensure that the update process works
        _this.bpmnUploadedVersion = '';
        _this.warningMessage = null;
        _this.csrId = 1;
        _this.certificateId = 1;
        _this.phone = '555-123-456';
        _this.msg = 'message';
        _this.accountId = '';
        return _this;
    }
    BpmnInfo.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            if (to.params.bpmnId) {
                vm.retrieveBpmnInfo(to.params.bpmnId);
            }
            if (to.params.interactionMode) {
                vm.interactionMode = to.params.interactionMode;
            }
            else {
                vm.interactionMode = 'EDIT';
            }
        });
    };
    BpmnInfo.prototype.retrieveBpmnInfo = function (bpmnId) {
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_6___default()({
            method: 'GET',
            url: '/api/bpmn-process-info-view/' + encodeURIComponent(bpmnId),
        })
            .then(function (res) {
            self.bPNMProcessInfo = res.data;
            if (!self.bPNMProcessInfo.bpmnProcessAttributes) {
                self.bPNMProcessInfo.bpmnProcessAttributes = new Array();
            }
            self.bPNMProcessInfo.bpmnProcessAttributes.push({});
            self.getBpmnUrl(self.bPNMProcessInfo.processId);
            self.bpmnUpload.id = self.bPNMProcessInfo.id;
            self.bpmnUpload.name = self.bPNMProcessInfo.name;
            self.bpmnUpload.type = self.bPNMProcessInfo.type;
            self.bpmnUpload.version = self.bPNMProcessInfo.version;
            self.bpmnUpload.bpmnProcessAttributes = self.bPNMProcessInfo.bpmnProcessAttributes;
            self.bpmnUploadedVersion = self.bPNMProcessInfo.version;
        })
            .catch(function (error) {
            console.log(error);
            self.previousState();
            var message = self.$t('problem processing request: ' + error);
            self.alertService().showAlert(message, 'info');
        });
    };
    BpmnInfo.prototype.previousState = function () {
        this.$router.go(-1);
    };
    BpmnInfo.prototype.mounted = function () {
        window.console.info('in mounted()) ');
    };
    BpmnInfo.prototype.showSemVerRegExpFieldWarning = function (value) {
        var regexp = new RegExp(semVerRegEx);
        var valid = regexp.test(value);
        console.log('showRegExpFieldWarning( ' + semVerRegEx + ', "' + value + '") -> ' + valid);
        return !valid;
    };
    Object.defineProperty(BpmnInfo.prototype, "authenticated", {
        get: function () {
            return this.$store.getters.authenticated;
        },
        enumerable: false,
        configurable: true
    });
    BpmnInfo.prototype.isRAOfficer = function () {
        return this.hasRole('ROLE_RA') || this.hasRole('ROLE_RA_DOMAIN');
    };
    BpmnInfo.prototype.isAdmin = function () {
        return this.hasRole('ROLE_ADMIN');
    };
    BpmnInfo.prototype.hasRole = function (targetRole) {
        for (var _i = 0, _a = this.$store.getters.account.authorities; _i < _a.length; _i++) {
            var role = _a[_i];
            if (targetRole === role) {
                return true;
            }
        }
        return false;
    };
    Object.defineProperty(BpmnInfo.prototype, "roles", {
        get: function () {
            return this.$store.getters.account ? this.$store.getters.account.authorities[0] : '';
        },
        enumerable: false,
        configurable: true
    });
    BpmnInfo.prototype.getUsername = function () {
        return this.$store.getters.account ? this.$store.getters.account.login : '';
    };
    BpmnInfo.prototype.alignBPAArraySize = function (index) {
        window.console.info('in alignBPAArraySize(' + index + ')');
        if (this.interactionMode === 'EDIT') {
            var currentSize = this.bpmnUpload.bpmnProcessAttributes.length;
            var name = this.bpmnUpload.bpmnProcessAttributes[index].name || '';
            if (name.trim().length === 0) {
                if (currentSize > 1) {
                    // preserve last element
                    this.bpmnUpload.bpmnProcessAttributes.splice(index, 1);
                    window.console.info('in alignBPAArraySize(' + index + '): dropped empty element');
                }
            }
            else {
                if (index + 1 === currentSize) {
                    this.bpmnUpload.bpmnProcessAttributes.push({});
                    window.console.info('in alignBPAArraySize(' + index + '): appended one element');
                }
            }
        }
    };
    BpmnInfo.prototype.saveBpmn = function () {
        var self = this;
        this.bpmnUpload.version = this.bpmnUploadedVersion;
        this.updateMethod = 'POST';
        if (this.bPNMProcessInfo.id) {
            this.updateMethod = 'PUT';
        }
        axios__WEBPACK_IMPORTED_MODULE_6___default()({
            method: this.updateMethod,
            url: bpmnUrl,
            data: this.bpmnUpload,
        })
            .then(function (response) {
            console.log(response.status);
            if (response.status === 200) {
                self.$router.push({ name: 'BpmnList', params: {} });
            }
            else {
                self.previousState();
            }
        })
            .catch(function (error) {
            console.log(error);
            self.previousState();
            var message = self.$t('problem processing request: ' + error);
            self.alertService().showAlert(message, 'info');
        });
    };
    BpmnInfo.prototype.checkBpmn = function () {
        this.bpmnCheckResult = {};
        var self = this;
        var targetURL = bpmnUrl + "/check/csr/".concat(this.bPNMProcessInfo.processId, "/").concat(this.csrId);
        if (this.bpmnUpload.type === 'CERTIFICATE_NOTIFY') {
            targetURL = bpmnUrl + "/check/certificateNotify/".concat(this.bPNMProcessInfo.processId, "/").concat(encodeURIComponent(this.certificateId));
        }
        else if (this.bpmnUpload.type === 'REQUEST_AUTHORIZATION') {
            targetURL = bpmnUrl + "/check/csrRequestAuthorization/".concat(this.bPNMProcessInfo.processId, "/").concat(encodeURIComponent(this.csrId));
            //    } else if (this.bpmnUpload.type === 'ACME_ACCOUNT_AUTHORIZATION') {
            //      targetURL = bpmnUrl + `/check/accountRequest/${this.bPNMProcessInfo.processId}`;
        }
        else if (this.bpmnUpload.type === 'SEND_SMS') {
            targetURL =
                bpmnUrl + "/check/sendSMS/".concat(this.bPNMProcessInfo.processId, "/").concat(encodeURIComponent(this.phone), "/").concat(encodeURIComponent(this.msg));
        }
        else if (this.bpmnUpload.type === 'ACME_ACCOUNT_AUTHORIZATION') {
            targetURL = bpmnUrl + "/check/acmeAccountAuthorization/".concat(this.bPNMProcessInfo.processId, "/").concat(encodeURIComponent(this.accountId));
        }
        console.log('calling bpmn check endpoint at ' + targetURL);
        axios__WEBPACK_IMPORTED_MODULE_6___default()({
            method: 'post',
            url: targetURL,
        })
            .then(function (response) {
            window.console.info(targetURL + ' returns ' + response.data);
            self.bpmnCheckResult = response.data;
        })
            .catch(function (error) {
            console.log(error);
            var message = self.$t('problem processing BPMN: ' + error);
            self.alertService().showAlert(message, 'info');
        });
    };
    BpmnInfo.prototype.getBpmnUrl = function (bpmnId) {
        if (bpmnId) {
            console.log(bpmnUrl + ' called for ' + bpmnId);
            var self_1 = this;
            axios__WEBPACK_IMPORTED_MODULE_6___default().get(bpmnUrl + '/' + bpmnId, { responseType: 'blob' })
                .then(function (response) {
                var blob = new Blob([response.data], {});
                self_1.bpmnBlobUrl = URL.createObjectURL(blob);
                window.console.info('tmp download url : ' + self_1.bpmnBlobUrl);
            })
                .catch(function (error) {
                console.log(error);
                var message = self_1.$t('problem processing request: ' + error);
                var err = error;
                if (err.response) {
                    console.log(err.response.status);
                    console.log(err.response.data);
                    if (err.response.status === 401) {
                        self_1.alertService().showAlert('Action not allowed', 'warn');
                    }
                    else {
                        self_1.alertService().showAlert(message, 'info');
                    }
                }
                else {
                    self_1.alertService().showAlert(message, 'info');
                }
                self_1.getAlertFromStore();
            });
        }
    };
    BpmnInfo.prototype.getOptions = function () {
        return {
            propertiesPanel: {},
            additionalModules: [],
            moddleExtensions: [],
        };
    };
    BpmnInfo.prototype.handleError = function (err) {
        console.error('failed to show diagram', err);
    };
    BpmnInfo.prototype.handleShown = function () {
        console.log('diagram shown');
    };
    BpmnInfo.prototype.handleLoading = function () {
        console.log('diagram loading');
    };
    BpmnInfo.prototype.notifyFileChange = function (evt) {
        if (!evt || !evt.target || !evt.target.files || evt.target.files.length === 0) {
            return;
        }
        this.warningMessage = null;
        var self = this;
        var readerContent = new FileReader();
        readerContent.onload = function (_result) {
            console.log('uploaded bpmn content read');
            self.bpmnFileUploaded = false;
            self.bpmnUpload.contentXML = '';
            self.bpmnBlobUrl = '';
            self.warningMessage = '';
            if (typeof readerContent.result === 'string') {
                self.bpmnUpload.contentXML = readerContent.result;
                console.log('uploaded bpmn read as XML: ' + readerContent.result);
            }
            else {
                console.error('uploaded bpmn reading URL: unexpected type ' + readerContent.result);
            }
            var readerUrl = new FileReader();
            readerUrl.onload = function (__result) {
                if (typeof readerUrl.result === 'string') {
                    self.bpmnBlobUrl = readerUrl.result;
                    var name = evt.target.files[0].name;
                    if (name.endsWith('.bpmn20.xml')) {
                        name.substring(0, name.length - 11);
                    }
                    var lastDot = name.lastIndexOf('.');
                    self.bpmnUpload.name = name.substring(0, lastDot);
                    self.bpmnFileUploaded = true;
                    var version = self.bpmnUploadedVersion;
                    var lastVersionDot = version.lastIndexOf('.');
                    var currentPatchLevel = parseInt(version.substring(lastVersionDot + 1));
                    self.bpmnUploadedVersion = version.substring(0, lastVersionDot + 1) + (currentPatchLevel + 1);
                    console.log('uploaded bpmn read as URL: ' + self.bpmnBlobUrl);
                }
                else {
                    console.error('uploaded bpmn reading URL: unexpected type ' + readerUrl.result);
                }
            };
            readerUrl.readAsDataURL(evt.target.files[0]);
        };
        readerContent.readAsText(evt.target.files[0]);
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('bPNMProcessInfoService'),
        __metadata("design:type", Function)
    ], BpmnInfo.prototype, "bPNMProcessInfoService", void 0);
    BpmnInfo = __decorate([
        (0,vue_class_component__WEBPACK_IMPORTED_MODULE_7__["default"])({
            components: {
                CopyClipboardButton: _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
                HelpTag: _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
                AuditTag: _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
                VueBpmn: vue_bpmn__WEBPACK_IMPORTED_MODULE_5__["default"],
            },
        })
    ], BpmnInfo);
    return BpmnInfo;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_7__.mixins)(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_1__["default"], vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue)));
/* harmony default export */ __webpack_exports__["default"] = (BpmnInfo);


/***/ }),

/***/ "./src/main/webapp/app/core/bpmn/bpmn-info.vue":
/*!*****************************************************!*\
  !*** ./src/main/webapp/app/core/bpmn/bpmn-info.vue ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bpmn-info.vue?vue&type=template&id=4e189939& */ "./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939&");
/* harmony import */ var _bpmn_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bpmn-info.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _bpmn_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__.render,
  _bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/core/bpmn/bpmn-info.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts&":
/*!***************************************************************************************!*\
  !*** ./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts& ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_bpmn_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./bpmn-info.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/bpmn/bpmn-info.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_bpmn_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939&":
/*!************************************************************************************!*\
  !*** ./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939& ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_bpmn_info_vue_vue_type_template_id_4e189939___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./bpmn-info.vue?vue&type=template&id=4e189939& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939&":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/bpmn/bpmn-info.vue?vue&type=template&id=4e189939& ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    [
      _c(
        "b-alert",
        {
          attrs: {
            show: _vm.dismissCountDown,
            dismissible: "",
            variant: _vm.alertType,
          },
          on: {
            dismissed: function ($event) {
              _vm.dismissCountDown = 0
            },
            "dismiss-count-down": _vm.countDownChanged,
          },
        },
        [_vm._v("\n        " + _vm._s(_vm.alertMessage) + "\n    ")]
      ),
      _vm._v(" "),
      _c("br"),
      _vm._v(" "),
      _c("div", { staticClass: "row justify-content-center" }, [
        _c(
          "div",
          { staticClass: "col-8" },
          [
            _vm.bPNMProcessInfo
              ? _c(
                  "div",
                  [
                    _c("h2", { staticClass: "jh-entity-heading" }, [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.bPNMProcessInfo.detail.title")
                            ),
                          },
                        },
                        [_vm._v("BPMN Info")]
                      ),
                      _vm._v(" " + _vm._s(_vm.bPNMProcessInfo.id)),
                    ]),
                    _vm._v(" "),
                    _c(
                      "div",
                      { staticClass: "form-group" },
                      [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.bPNMProcessInfo.new.name")
                              ),
                            },
                          },
                          [_vm._v("Process name")]
                        ),
                        _vm._v(" "),
                        _c("help-tag", {
                          attrs: { role: "Admin", target: "bpmn.name" },
                        }),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.bpmnUpload.name,
                              expression: "bpmnUpload.name",
                            },
                          ],
                          staticClass: "form-control form-check-inline valid",
                          attrs: {
                            type: "text",
                            name: "bpmn.new.name'",
                            id: "bpmn.new.name",
                            required: "true",
                            readOnly: _vm.interactionMode == "TEST",
                          },
                          domProps: { value: _vm.bpmnUpload.name },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.bpmnUpload,
                                "name",
                                $event.target.value
                              )
                            },
                          },
                        }),
                        _vm._v(" "),
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            attrs: { for: "bpmn.new.type" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.bPNMProcessInfo.new.type")
                              ),
                            },
                          },
                          [_vm._v("Process type")]
                        ),
                        _vm._v(" "),
                        _c("help-tag", {
                          attrs: { role: "Admin", target: "bpmn.type" },
                        }),
                        _vm._v(" "),
                        _c(
                          "select",
                          {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.bpmnUpload.type,
                                expression: "bpmnUpload.type",
                              },
                            ],
                            staticClass: "form-control",
                            attrs: {
                              id: "bpmn.new.type",
                              name: "bpmn.new.type",
                              readOnly: _vm.interactionMode == "TEST",
                              disabled: _vm.interactionMode == "TEST",
                            },
                            on: {
                              change: function ($event) {
                                var $$selectedVal = Array.prototype.filter
                                  .call($event.target.options, function (o) {
                                    return o.selected
                                  })
                                  .map(function (o) {
                                    var val = "_value" in o ? o._value : o.value
                                    return val
                                  })
                                _vm.$set(
                                  _vm.bpmnUpload,
                                  "type",
                                  $event.target.multiple
                                    ? $$selectedVal
                                    : $$selectedVal[0]
                                )
                              },
                            },
                          },
                          [
                            _c("option", {
                              attrs: { value: "CERTIFICATE_CREATION" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.CERTIFICATE_CREATION"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("option", {
                              attrs: { value: "CERTIFICATE_NOTIFY" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.CERTIFICATE_NOTIFY"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("option", {
                              attrs: { value: "CERTIFICATE_REVOCATION" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.CERTIFICATE_REVOCATION"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("option", {
                              attrs: { value: "REQUEST_AUTHORIZATION" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.REQUEST_AUTHORIZATION"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("option", {
                              attrs: { value: "SEND_SMS" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.SEND_SMS"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("option", {
                              attrs: { value: "ACME_ACCOUNT_AUTHORIZATION" },
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.type.ACME_ACCOUNT_AUTHORIZATION"
                                  )
                                ),
                              },
                            }),
                          ]
                        ),
                        _vm._v(" "),
                        _vm.interactionMode == "EDIT"
                          ? _c(
                              "label",
                              {
                                staticClass: "form-control-label",
                                attrs: { for: "fileSelector" },
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t(
                                      "ca3SApp.bPNMProcessInfo.new.fileSelectorBPMN"
                                    )
                                  ),
                                },
                              },
                              [_vm._v("Select a BPMN file")]
                            )
                          : _vm._e(),
                        _vm._v(" "),
                        _c("help-tag", {
                          attrs: { role: "Admin", target: "bpmn.upload" },
                        }),
                        _vm._v(" "),
                        _vm.interactionMode == "EDIT"
                          ? _c("input", {
                              ref: "fileSelector",
                              attrs: {
                                type: "file",
                                id: "fileSelector",
                                name: "fileSelector",
                              },
                              on: { change: _vm.notifyFileChange },
                            })
                          : _vm._e(),
                        _vm._v(" "),
                        _vm.warningMessage
                          ? _c(
                              "small",
                              {
                                staticClass: "form-text text-danger",
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t("entity.validation.required")
                                  ),
                                },
                              },
                              [_vm._v(_vm._s(_vm.warningMessage))]
                            )
                          : _vm._e(),
                      ],
                      1
                    ),
                    _vm._v(" "),
                    _c("div", { staticClass: "row" }, [
                      _vm.bpmnFileUploaded
                        ? _c("div", { staticClass: "col colContent" }, [
                            _c("label", {
                              staticClass: "form-control-label",
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.bPNMProcessInfo.version")
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("input", {
                              directives: [
                                {
                                  name: "model",
                                  rawName: "v-model",
                                  value: _vm.bpmnUploadedVersion,
                                  expression: "bpmnUploadedVersion",
                                },
                              ],
                              staticClass:
                                "form-control form-check-inline valid",
                              attrs: {
                                type: "text",
                                name: "bpmn.new.version'",
                                id: "bpmn.new.version",
                                required: "true",
                                readOnly: _vm.interactionMode == "TEST",
                              },
                              domProps: { value: _vm.bpmnUploadedVersion },
                              on: {
                                input: function ($event) {
                                  if ($event.target.composing) return
                                  _vm.bpmnUploadedVersion = $event.target.value
                                },
                              },
                            }),
                            _vm._v(" "),
                            _vm.showSemVerRegExpFieldWarning(
                              _vm.bpmnUploadedVersion
                            )
                              ? _c(
                                  "small",
                                  {
                                    staticClass: "form-text text-danger",
                                    domProps: {
                                      textContent: _vm._s(
                                        _vm.$t(
                                          "ca3SApp.messages.semver.requirement"
                                        )
                                      ),
                                    },
                                  },
                                  [
                                    _vm._v(
                                      "\n                            version must match RegEx!\n                        "
                                    ),
                                  ]
                                )
                              : _vm._e(),
                          ])
                        : _vm._e(),
                      _vm._v(" "),
                      !_vm.bpmnFileUploaded
                        ? _c("div", { staticClass: "col colContent" }, [
                            _c("label", {
                              staticClass: "form-control-label",
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("ca3SApp.bPNMProcessInfo.version")
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("span", [
                              _vm._v(_vm._s(_vm.bPNMProcessInfo.version)),
                            ]),
                            _vm._v(" \n                        "),
                            _vm.bPNMProcessInfo.lastChange
                              ? _c(
                                  "span",
                                  {
                                    domProps: {
                                      textContent: _vm._s(
                                        _vm.$t(
                                          "ca3SApp.bPNMProcessInfo.createdOn"
                                        )
                                      ),
                                    },
                                  },
                                  [_vm._v("created on")]
                                )
                              : _vm._e(),
                            _vm._v(" \n                        "),
                            _vm.bPNMProcessInfo.lastChange
                              ? _c("span", [
                                  _vm._v(
                                    _vm._s(
                                      _vm.$d(
                                        Date.parse(
                                          _vm.bPNMProcessInfo.lastChange
                                        ),
                                        "long"
                                      )
                                    )
                                  ),
                                ])
                              : _vm._e(),
                          ])
                        : _vm._e(),
                    ]),
                    _vm._v(" "),
                    _c("div", { staticClass: "row" }, [
                      _c("div", { staticClass: "col colContent" }, [
                        _c("label", {
                          staticClass: "form-control-label",
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.bPNMProcessInfo.author")
                            ),
                          },
                        }),
                        _vm._v(" "),
                        _c("span", [
                          _vm._v(_vm._s(_vm.bPNMProcessInfo.author)),
                        ]),
                      ]),
                    ]),
                    _vm._v(" "),
                    _c("p"),
                    _vm._v(" "),
                    _c("h3", { staticClass: "jh-entity-heading" }, [
                      _c("span", {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.bPNMProcessInfo.attribute.title")
                          ),
                        },
                      }),
                    ]),
                    _vm._v(" "),
                    _vm._l(
                      _vm.bpmnUpload.bpmnProcessAttributes,
                      function (bpa, index) {
                        return _c("div", { key: index, staticClass: "row" }, [
                          _c("div", { staticClass: "col colContent" }, [
                            index == 0
                              ? _c("label", {
                                  staticClass: "form-control-label",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "ca3SApp.bPNMProcessInfo.attribute.name"
                                      )
                                    ),
                                  },
                                })
                              : _vm._e(),
                            _vm._v(" "),
                            _c("input", {
                              directives: [
                                {
                                  name: "model",
                                  rawName: "v-model",
                                  value: bpa.name,
                                  expression: "bpa.name",
                                },
                              ],
                              staticClass: "form-control form-check-inline",
                              attrs: {
                                type: "text",
                                autocomplete: "false",
                                name:
                                  "ca3SApp.bPNMProcessInfo.attribute.name." +
                                  bpa.name,
                                id:
                                  "ca3SApp.bPNMProcessInfo.attribute.name." +
                                  bpa.name,
                                readOnly: _vm.interactionMode == "TEST",
                                required: "true",
                              },
                              domProps: { value: bpa.name },
                              on: {
                                input: [
                                  function ($event) {
                                    if ($event.target.composing) return
                                    _vm.$set(bpa, "name", $event.target.value)
                                  },
                                  function ($event) {
                                    return _vm.alignBPAArraySize(index)
                                  },
                                ],
                              },
                            }),
                          ]),
                          _vm._v(" "),
                          _c("div", { staticClass: "col colContent" }, [
                            index == 0
                              ? _c("label", {
                                  staticClass: "form-control-label",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "ca3SApp.bPNMProcessInfo.attribute.value"
                                      )
                                    ),
                                  },
                                })
                              : _vm._e(),
                            _vm._v(" "),
                            (bpa.protectedContent ? "password" : "text") ===
                            "checkbox"
                              ? _c("input", {
                                  directives: [
                                    {
                                      name: "model",
                                      rawName: "v-model",
                                      value: bpa.value,
                                      expression: "bpa.value",
                                    },
                                  ],
                                  staticClass: "form-control form-check-inline",
                                  attrs: {
                                    autocomplete: "false",
                                    name:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    id:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    readOnly: _vm.interactionMode == "TEST",
                                    type: "checkbox",
                                  },
                                  domProps: {
                                    checked: Array.isArray(bpa.value)
                                      ? _vm._i(bpa.value, null) > -1
                                      : bpa.value,
                                  },
                                  on: {
                                    change: function ($event) {
                                      var $$a = bpa.value,
                                        $$el = $event.target,
                                        $$c = $$el.checked ? true : false
                                      if (Array.isArray($$a)) {
                                        var $$v = null,
                                          $$i = _vm._i($$a, $$v)
                                        if ($$el.checked) {
                                          $$i < 0 &&
                                            _vm.$set(
                                              bpa,
                                              "value",
                                              $$a.concat([$$v])
                                            )
                                        } else {
                                          $$i > -1 &&
                                            _vm.$set(
                                              bpa,
                                              "value",
                                              $$a
                                                .slice(0, $$i)
                                                .concat($$a.slice($$i + 1))
                                            )
                                        }
                                      } else {
                                        _vm.$set(bpa, "value", $$c)
                                      }
                                    },
                                  },
                                })
                              : (bpa.protectedContent ? "password" : "text") ===
                                "radio"
                              ? _c("input", {
                                  directives: [
                                    {
                                      name: "model",
                                      rawName: "v-model",
                                      value: bpa.value,
                                      expression: "bpa.value",
                                    },
                                  ],
                                  staticClass: "form-control form-check-inline",
                                  attrs: {
                                    autocomplete: "false",
                                    name:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    id:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    readOnly: _vm.interactionMode == "TEST",
                                    type: "radio",
                                  },
                                  domProps: {
                                    checked: _vm._q(bpa.value, null),
                                  },
                                  on: {
                                    change: function ($event) {
                                      return _vm.$set(bpa, "value", null)
                                    },
                                  },
                                })
                              : _c("input", {
                                  directives: [
                                    {
                                      name: "model",
                                      rawName: "v-model",
                                      value: bpa.value,
                                      expression: "bpa.value",
                                    },
                                  ],
                                  staticClass: "form-control form-check-inline",
                                  attrs: {
                                    autocomplete: "false",
                                    name:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    id:
                                      "ca3SApp.bPNMProcessInfo.attribute.value." +
                                      bpa.name,
                                    readOnly: _vm.interactionMode == "TEST",
                                    type: bpa.protectedContent
                                      ? "password"
                                      : "text",
                                  },
                                  domProps: { value: bpa.value },
                                  on: {
                                    input: function ($event) {
                                      if ($event.target.composing) return
                                      _vm.$set(
                                        bpa,
                                        "value",
                                        $event.target.value
                                      )
                                    },
                                  },
                                }),
                          ]),
                          _vm._v(" "),
                          _c("div", { staticClass: "col colContent" }, [
                            _c("label", {
                              staticClass: "form-control-label",
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t(
                                    "ca3SApp.bPNMProcessInfo.attribute.protected"
                                  )
                                ),
                              },
                            }),
                            _vm._v(" "),
                            _c("input", {
                              directives: [
                                {
                                  name: "model",
                                  rawName: "v-model",
                                  value: bpa.protectedContent,
                                  expression: "bpa.protectedContent",
                                },
                              ],
                              staticClass: "form-check-inline",
                              attrs: {
                                type: "checkbox",
                                name:
                                  "ca3SApp.bPNMProcessInfo.protected." +
                                  bpa.name,
                                id:
                                  "ca3SApp.bPNMProcessInfo.protected." +
                                  bpa.name,
                                readOnly: _vm.interactionMode == "TEST",
                              },
                              domProps: {
                                checked: Array.isArray(bpa.protectedContent)
                                  ? _vm._i(bpa.protectedContent, null) > -1
                                  : bpa.protectedContent,
                              },
                              on: {
                                change: function ($event) {
                                  var $$a = bpa.protectedContent,
                                    $$el = $event.target,
                                    $$c = $$el.checked ? true : false
                                  if (Array.isArray($$a)) {
                                    var $$v = null,
                                      $$i = _vm._i($$a, $$v)
                                    if ($$el.checked) {
                                      $$i < 0 &&
                                        _vm.$set(
                                          bpa,
                                          "protectedContent",
                                          $$a.concat([$$v])
                                        )
                                    } else {
                                      $$i > -1 &&
                                        _vm.$set(
                                          bpa,
                                          "protectedContent",
                                          $$a
                                            .slice(0, $$i)
                                            .concat($$a.slice($$i + 1))
                                        )
                                    }
                                  } else {
                                    _vm.$set(bpa, "protectedContent", $$c)
                                  }
                                },
                              },
                            }),
                          ]),
                        ])
                      }
                    ),
                    _vm._v(" "),
                    _c("p"),
                  ],
                  2
                )
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST"
              ? _c("div", [
                  _c("h3", { staticClass: "jh-entity-heading" }, [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.bPNMProcessInfo.check.subtitle")
                          ),
                        },
                      },
                      [_vm._v("Check BPMN")]
                    ),
                  ]),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST" &&
            _vm.bpmnUpload.type === "CERTIFICATE_CREATION"
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      staticClass: "form-control-label",
                      domProps: {
                        textContent: _vm._s(
                          _vm.$t("ca3SApp.bPNMProcessInfo.check.csrId")
                        ),
                      },
                    },
                    [_vm._v("CSR ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.csrId,
                        expression: "csrId",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.csrId",
                      id: "bpmn.check.csrId",
                      required: "true",
                    },
                    domProps: { value: _vm.csrId },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.csrId = $event.target.value
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST" &&
            (_vm.bpmnUpload.type === "CERTIFICATE_REVOCATION" ||
              _vm.bpmnUpload.type === "CERTIFICATE_NOTIFY")
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      staticClass: "form-control-label",
                      domProps: {
                        textContent: _vm._s(
                          _vm.$t("ca3SApp.bPNMProcessInfo.check.certificateId")
                        ),
                      },
                    },
                    [_vm._v("Certificate ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.certificateId,
                        expression: "certificateId",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.certificateId",
                      id: "bpmn.check.certificateId",
                      required: "true",
                    },
                    domProps: { value: _vm.certificateId },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.certificateId = $event.target.value
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST" &&
            _vm.bpmnUpload.type === "REQUEST_AUTHORIZATION"
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      staticClass: "form-control-label",
                      domProps: {
                        textContent: _vm._s(
                          _vm.$t("ca3SApp.bPNMProcessInfo.check.csrId")
                        ),
                      },
                    },
                    [_vm._v("CSR ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.csrId,
                        expression: "csrId",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.csrId'",
                      id: "bpmn.check.csrId",
                      required: "true",
                    },
                    domProps: { value: _vm.csrId },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.csrId = $event.target.value
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST" && _vm.bpmnUpload.type === "SEND_SMS"
              ? _c("div", { staticClass: "form-group" }, [
                  _c("label", {
                    staticClass: "form-control-label",
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("ca3SApp.bPNMProcessInfo.check.phone")
                      ),
                    },
                  }),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.phone,
                        expression: "phone",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.phone'",
                      id: "bpmn.check.phone",
                      required: "true",
                    },
                    domProps: { value: _vm.phone },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.phone = $event.target.value
                      },
                    },
                  }),
                  _vm._v(" "),
                  _c("label", {
                    staticClass: "form-control-label",
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("ca3SApp.bPNMProcessInfo.check.msg")
                      ),
                    },
                  }),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.msg,
                        expression: "msg",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.msg'",
                      id: "bpmn.check.msg",
                      required: "true",
                    },
                    domProps: { value: _vm.msg },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.msg = $event.target.value
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST" &&
            _vm.bpmnUpload.type === "ACME_ACCOUNT_AUTHORIZATION"
              ? _c("div", { staticClass: "form-group" }, [
                  _c("label", {
                    staticClass: "form-control-label",
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("ca3SApp.bPNMProcessInfo.check.accountId")
                      ),
                    },
                  }),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.accountId,
                        expression: "accountId",
                      },
                    ],
                    staticClass: "form-control form-check-inline valid",
                    attrs: {
                      type: "text",
                      name: "bpmn.check.accountId'",
                      id: "bpmn.check.accountId",
                      required: "true",
                    },
                    domProps: { value: _vm.accountId },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.accountId = $event.target.value
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.interactionMode == "TEST"
              ? _c(
                  "div",
                  { staticClass: "form-group" },
                  [
                    _c(
                      "button",
                      {
                        staticClass: "btn btn-info",
                        attrs: { type: "button" },
                        on: { click: _vm.checkBpmn },
                      },
                      [
                        _c("font-awesome-icon", {
                          attrs: { icon: "arrow-left" },
                        }),
                        _vm._v(" "),
                        _c(
                          "span",
                          {
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("ca3SApp.bPNMProcessInfo.check.check")
                              ),
                            },
                          },
                          [_vm._v("Check")]
                        ),
                      ],
                      1
                    ),
                    _vm._v(" "),
                    _c("help-tag", {
                      attrs: { role: "Admin", target: "bpmn.checkBpmn" },
                    }),
                  ],
                  1
                )
              : _vm._e(),
            _vm._v(" "),
            _vm.bpmnCheckResult.status && _vm.interactionMode == "TEST"
              ? _c("div", [
                  _c(
                    "h3",
                    {
                      domProps: {
                        textContent: _vm._s(
                          _vm.$t("pkcsxx.upload.result.label")
                        ),
                      },
                    },
                    [_vm._v("result")]
                  ),
                  _vm._v(" "),
                  _c("h4", {
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("ca3SApp.notification.message.details")
                      ),
                    },
                  }),
                  _vm._v(" "),
                  _c("dl", { staticClass: "row jh-entity-details" }, [
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("ca3SApp.bPNMProcessInfo.result.status")
                            ),
                          },
                        },
                        [_vm._v("Status")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("span", [_vm._v(_vm._s(_vm.bpmnCheckResult.status))]),
                    ]),
                  ]),
                  _vm._v(" "),
                  _c("dl", { staticClass: "row jh-entity-details" }, [
                    _c("dt", [
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t(
                                "ca3SApp.bPNMProcessInfo.result.failureReason"
                              )
                            ),
                          },
                        },
                        [_vm._v("Failure reason")]
                      ),
                    ]),
                    _vm._v(" "),
                    _c("dd", [
                      _c("span", [
                        _vm._v(_vm._s(_vm.bpmnCheckResult.failureReason)),
                      ]),
                    ]),
                  ]),
                  _vm._v(" "),
                  _c(
                    "dl",
                    { staticClass: "row jh-entity-details" },
                    _vm._l(
                      _vm.bpmnCheckResult.responseAttributes,
                      function (val, valueIndex) {
                        return _c("div", { key: valueIndex }, [
                          _c("dt", [
                            _c("span", [
                              _vm._v(
                                _vm._s(
                                  Object.keys(
                                    _vm.bpmnCheckResult.responseAttributes[
                                      valueIndex
                                    ]
                                  )[0]
                                )
                              ),
                            ]),
                          ]),
                          _vm._v(" "),
                          _c("dd", [
                            _c("span", [
                              _vm._v(
                                _vm._s(
                                  _vm.bpmnCheckResult.responseAttributes[
                                    valueIndex
                                  ][
                                    Object.keys(
                                      _vm.bpmnCheckResult.responseAttributes[
                                        valueIndex
                                      ]
                                    )[0]
                                  ]
                                )
                              ),
                            ]),
                          ]),
                        ])
                      }
                    ),
                    0
                  ),
                  _vm._v(" "),
                  _c(
                    "dl",
                    { staticClass: "row jh-entity-details" },
                    _vm._l(
                      _vm.bpmnCheckResult.csrAttributes,
                      function (val, valueIndex) {
                        return _c("div", { key: valueIndex }, [
                          _c("dt", [
                            _c("span", [
                              _vm._v(
                                _vm._s(
                                  Object.keys(
                                    _vm.bpmnCheckResult.csrAttributes[
                                      valueIndex
                                    ]
                                  )[0]
                                )
                              ),
                            ]),
                          ]),
                          _vm._v(" "),
                          _c("dd", [
                            _c("span", [
                              _vm._v(
                                _vm._s(
                                  _vm.bpmnCheckResult.csrAttributes[valueIndex][
                                    Object.keys(
                                      _vm.bpmnCheckResult.csrAttributes[
                                        valueIndex
                                      ]
                                    )[0]
                                  ]
                                )
                              ),
                            ]),
                          ]),
                        ])
                      }
                    ),
                    0
                  ),
                ])
              : _vm._e(),
            _vm._v(" "),
            _c(
              "form",
              { attrs: { name: "editForm", role: "form", novalidate: "" } },
              [
                _c("div", [
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-info",
                      attrs: { type: "submit" },
                      on: {
                        click: function ($event) {
                          $event.preventDefault()
                          return _vm.previousState()
                        },
                      },
                    },
                    [
                      _c("font-awesome-icon", {
                        attrs: { icon: "arrow-left" },
                      }),
                      _vm._v(" "),
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("entity.action.back")),
                          },
                        },
                        [_vm._v(" Back")]
                      ),
                    ],
                    1
                  ),
                  _vm._v(" "),
                  _vm.interactionMode == "EDIT"
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-secondary",
                          attrs: {
                            type: "button",
                            id: "save",
                            disabled: _vm.showSemVerRegExpFieldWarning(
                              _vm.bpmnUploadedVersion
                            ),
                          },
                          on: {
                            click: function ($event) {
                              return _vm.saveBpmn()
                            },
                          },
                        },
                        [
                          _c("font-awesome-icon", {
                            attrs: { icon: "pencil-alt" },
                          }),
                          _vm._v(" "),
                          _c(
                            "span",
                            {
                              domProps: {
                                textContent: _vm._s(
                                  _vm.$t("entity.action.save")
                                ),
                              },
                            },
                            [_vm._v("Save")]
                          ),
                        ],
                        1
                      )
                    : _vm._e(),
                ]),
              ]
            ),
            _vm._v(" "),
            _vm.bpmnBlobUrl
              ? _c("vue-bpmn", {
                  attrs: { url: _vm.bpmnBlobUrl, options: _vm.getOptions() },
                  on: {
                    error: _vm.handleError,
                    shown: _vm.handleShown,
                    loading: _vm.handleLoading,
                  },
                })
              : _vm._e(),
          ],
          1
        ),
      ]),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_core_bpmn_bpmn-info_vue.ee8b9c348d46066dd9b9.chunk.js.map