"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_core_pipeline_pipeline_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts&":
/*!****************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts& ***!
  \****************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vue2_filters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue2-filters */ "./node_modules/vue2-filters/dist/vue2-filters.js");
/* harmony import */ var vue2_filters__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(vue2_filters__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _shared_date_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/shared/date-utils */ "./src/main/webapp/app/shared/date-utils.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var Pipeline = /** @class */ (function (_super) {
    __extends(Pipeline, _super);
    function Pipeline() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.removeId = null;
        _this.pipelines = [];
        _this.filteredPipelines = [];
        _this.distinctConnectors = [];
        _this.typeFilter = 'all';
        _this.activeFilter = 'all';
        _this.connectorFilter = 'all';
        _this.defaultFilters = [
            { attributeName: 'type', attributeValue: 'all', selector: 'EQUAL' },
            { attributeName: 'active', attributeValue: 'all', selector: 'EQUAL' },
            { attributeName: 'connector', attributeValue: 'all', selector: 'EQUAL' },
        ];
        _this.filters = { filterList: _this.defaultFilters };
        _this.lastFilters = JSON.stringify({ filterList: _this.defaultFilters });
        _this.isFetching = false;
        return _this;
    }
    Pipeline.prototype.mounted = function () {
        this.typeFilter = 'all';
        this.activeFilter = 'all';
        this.getUsersFilterList();
        this.retrieveAllPipelines();
        window.console.info('pipeline mounted, #' + this.filteredPipelines.length + ' filtered pipelines');
    };
    Pipeline.prototype.clear = function () {
        this.retrieveAllPipelines();
    };
    Pipeline.prototype.retrieveAllPipelines = function () {
        this.isFetching = true;
        var self = this;
        this.pipelineViewService()
            .retrieve()
            .then(function (res) {
            self.pipelines = res.data;
            self.filterPipelines();
            self.isFetching = false;
        }, function (err) {
            self.isFetching = false;
        });
    };
    Pipeline.prototype.filterPipelines = function () {
        window.console.info('filter pipeline for ' + this.typeFilter + ' / ' + this.activeFilter);
        var connectorNames = [];
        for (var _i = 0, _a = this.pipelines; _i < _a.length; _i++) {
            var pipeline = _a[_i];
            if (!connectorNames.includes(pipeline.caConnectorName)) {
                connectorNames.push(pipeline.caConnectorName);
            }
        }
        this.distinctConnectors = connectorNames.sort(function (a, b) { return a.localeCompare(b); });
        this.filteredPipelines = [];
        for (var _b = 0, _c = this.pipelines; _b < _c.length; _b++) {
            var pipeline = _c[_b];
            if (this.typeFilter !== 'all') {
                if (pipeline.type !== this.typeFilter) {
                    window.console.info('pipeline dropped: ' + pipeline.type);
                    continue;
                }
            }
            if (this.activeFilter !== 'all') {
                if ((pipeline.active && this.activeFilter === 'disabled') || (!pipeline.active && this.activeFilter === 'enabled')) {
                    window.console.info('pipeline dropped: ' + pipeline.active);
                    continue;
                }
            }
            if (this.connectorFilter !== 'all') {
                if (pipeline.caConnectorName !== this.connectorFilter) {
                    window.console.info('pipeline dropped: ' + pipeline.caConnectorName);
                    continue;
                }
            }
            this.filteredPipelines.push(pipeline);
        }
        this.putUsersFilterList(this);
    };
    Pipeline.prototype.prepareRemove = function (instance) {
        this.removeId = instance.id;
    };
    Pipeline.prototype.removePipeline = function () {
        var _this = this;
        this.pipelineViewService()
            .delete(this.removeId)
            .then(function () {
            var message = _this.$t('ca3SApp.pipeline.deleted', { param: _this.removeId });
            _this.alertService().showAlert(message, 'danger');
            _this.getAlertFromStore();
            _this.removeId = null;
            _this.retrieveAllPipelines();
            _this.closeDialog();
        });
    };
    Pipeline.prototype.toLocalDate = function (dateAsString) {
        return _shared_date_utils__WEBPACK_IMPORTED_MODULE_4__.DateUtils.toLocalDate(dateAsString);
    };
    Pipeline.prototype.getValidToStyle = function (validToString) {
        return _shared_date_utils__WEBPACK_IMPORTED_MODULE_4__.DateUtils.getValidToStyle(validToString);
    };
    Pipeline.prototype.closeDialog = function () {
        this.$refs.removeEntity.hide();
    };
    Pipeline.prototype.getUsersFilterList = function () {
        window.console.info('calling getUsersFilterList fpr Pipeline');
        var self = this;
        axios__WEBPACK_IMPORTED_MODULE_3___default()({
            method: 'get',
            url: 'api/userProperties/filterList/PipelineList',
            responseType: 'stream',
        }).then(function (response) {
            //      window.console.debug('getUsersFilterList returns ' + response.data );
            if (response.status === 200) {
                self.filters.filterList = response.data.filterList;
                //        window.console.debug('getUsersFilterList sets filters to ' + JSON.stringify(self.filters));
                self.lastFilters = JSON.stringify(self.filters);
                for (var _i = 0, _a = self.filters.filterList; _i < _a.length; _i++) {
                    var filter = _a[_i];
                    if ('type' === filter.attributeName) {
                        self.typeFilter = filter.attributeValue;
                    }
                    else if ('active' === filter.attributeName) {
                        self.activeFilter = filter.attributeValue;
                    }
                    else if ('connector' === filter.attributeName) {
                        self.connectorFilter = filter.attributeValue;
                    }
                }
            }
        });
    };
    Pipeline.prototype.putUsersFilterList = function (self) {
        for (var _i = 0, _a = self.filters.filterList; _i < _a.length; _i++) {
            var filter = _a[_i];
            if ('type' === filter.attributeName) {
                filter.attributeValue = self.typeFilter;
            }
            else if ('active' === filter.attributeName) {
                filter.attributeValue = self.activeFilter;
            }
            else if ('connector' === filter.attributeName) {
                filter.attributeValue = self.connectorFilter;
            }
        }
        //    window.console.debug('calling putUsersFilterList ');
        var lastFiltersValue = JSON.stringify(self.filters);
        if (self.lastFilters === lastFiltersValue) {
            //      window.console.debug('putUsersFilterList: no change ...');
        }
        else {
            if (self.$store.getters.authenticated) {
                window.console.debug('putUsersFilterList: change detected ...');
                axios__WEBPACK_IMPORTED_MODULE_3___default()({
                    method: 'put',
                    url: 'api/userProperties/filterList/PipelineList',
                    data: self.filters,
                    responseType: 'stream',
                }).then(function (response) {
                    //        window.console.debug('putUsersFilterList returns ' + response.status);
                    if (response.status === 204) {
                        self.lastFilters = lastFiltersValue;
                    }
                });
            }
            else {
                window.console.debug('putUsersFilterList skipped, not autehticated anymore');
            }
        }
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('pipelineViewService'),
        __metadata("design:type", Function)
    ], Pipeline.prototype, "pipelineViewService", void 0);
    Pipeline = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], Pipeline);
    return Pipeline;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_5__.mixins)((vue2_filters__WEBPACK_IMPORTED_MODULE_1___default().mixin), _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__["default"])));
/* harmony default export */ __webpack_exports__["default"] = (Pipeline);


/***/ }),

/***/ "./src/main/webapp/app/shared/alert/alert.mixin.ts":
/*!*********************************************************!*\
  !*** ./src/main/webapp/app/shared/alert/alert.mixin.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var AlertMixin = /** @class */ (function (_super) {
    __extends(AlertMixin, _super);
    function AlertMixin() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dismissCountDown = _this.$store.getters.dismissCountDown;
        _this.dismissSecs = _this.$store.getters.dismissSecs;
        _this.alertType = _this.$store.getters.alertType;
        _this.alertMessage = _this.$store.getters.alertMessage;
        return _this;
    }
    AlertMixin.prototype.getAlertFromStore = function () {
        this.dismissCountDown = this.$store.getters.dismissCountDown;
        this.dismissSecs = this.$store.getters.dismissSecs;
        this.alertType = this.$store.getters.alertType;
        this.alertMessage = this.$store.getters.alertMessage;
    };
    AlertMixin.prototype.countDownChanged = function (dismissCountDown) {
        this.alertService().countDownChanged(dismissCountDown);
        this.getAlertFromStore();
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], AlertMixin.prototype, "alertService", void 0);
    AlertMixin = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], AlertMixin);
    return AlertMixin;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (AlertMixin);


/***/ }),

/***/ "./src/main/webapp/app/shared/date-utils.ts":
/*!**************************************************!*\
  !*** ./src/main/webapp/app/shared/date-utils.ts ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DateUtils": function() { return /* binding */ DateUtils; }
/* harmony export */ });
var DateUtils = /** @class */ (function () {
    function DateUtils() {
    }
    DateUtils.soon = function () {
        return DateUtils.relativeDate(7);
    };
    DateUtils.recently = function () {
        return DateUtils.relativeDate(-7);
    };
    DateUtils.dateWarn = function () {
        return DateUtils.relativeDate(35);
    };
    DateUtils.dateAlarm = function () {
        return DateUtils.relativeDate(10);
    };
    DateUtils.relativeDate = function (days) {
        var now = new Date();
        var then = new Date();
        then.setDate(now.getDate() + days);
        return then;
    };
    DateUtils.toLocalDate = function (dateAsString) {
        if (dateAsString && dateAsString.length > 8) {
            if (dateAsString.startsWith('+1000000000-12-31')) {
                return '';
            }
            var dateObj = new Date(dateAsString);
            if (dateObj > DateUtils.recently() && dateObj < DateUtils.soon()) {
                return dateObj.toLocaleDateString() + ', ' + dateObj.toLocaleTimeString();
            }
            else {
                return dateObj.toLocaleDateString();
            }
        }
        return '';
    };
    DateUtils.getValidToStyle = function (validToString) {
        var now = new Date();
        var validTo = new Date(validToString);
        if (validTo > now && validTo < DateUtils.dateAlarm()) {
            return 'color:red;font-weight: bold;';
        }
        else if (validTo > now && validTo < DateUtils.dateWarn()) {
            return 'color:olive; font-weight: bold;';
        }
        else if (validTo > now) {
            return 'color:green; font-weight: bold;';
        }
        return '';
    };
    DateUtils.getCertValidToStyle = function (validFromString, validToString, revoked) {
        if (revoked) {
            return '';
        }
        var now = new Date();
        var validTo = new Date(validToString);
        var validFrom = new Date(validFromString);
        if (validTo > now && validTo < DateUtils.dateAlarm()) {
            return 'color:red;font-weight: bold;';
        }
        else if (validTo > now && validTo < DateUtils.dateWarn()) {
            return 'color:olive; font-weight: bold;';
        }
        else if (validTo > now && validFrom <= now) {
            return 'color:green; font-weight: bold;';
        }
        return '';
    };
    return DateUtils;
}());



/***/ }),

/***/ "./src/main/webapp/app/core/pipeline/pipeline.vue":
/*!********************************************************!*\
  !*** ./src/main/webapp/app/core/pipeline/pipeline.vue ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pipeline.vue?vue&type=template&id=2c8a1772& */ "./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772&");
/* harmony import */ var _pipeline_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pipeline.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _pipeline_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__.render,
  _pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/core/pipeline/pipeline.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts&":
/*!******************************************************************************************!*\
  !*** ./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts& ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_pipeline_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./pipeline.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/core/pipeline/pipeline.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_pipeline_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772&":
/*!***************************************************************************************!*\
  !*** ./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772& ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_pipeline_vue_vue_type_template_id_2c8a1772___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./pipeline.vue?vue&type=template&id=2c8a1772& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772&":
/*!*******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/core/pipeline/pipeline.vue?vue&type=template&id=2c8a1772& ***!
  \*******************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    [
      _c(
        "h2",
        { attrs: { id: "page-heading" } },
        [
          _c(
            "span",
            {
              attrs: { id: "pipeline-heading" },
              domProps: {
                textContent: _vm._s(_vm.$t("ca3SApp.pipeline.home.title")),
              },
            },
            [_vm._v("Pipelines")]
          ),
          _vm._v(" "),
          _c(
            "router-link",
            {
              staticClass:
                "btn btn-primary float-right jh-create-entity create-pipeline",
              attrs: {
                to: { name: "ConfPipelineCreate" },
                tag: "button",
                id: "jh-create-entity",
              },
            },
            [
              _c("font-awesome-icon", { attrs: { icon: "plus" } }),
              _vm._v(" "),
              _c(
                "span",
                {
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.pipeline.home.createLabel")
                    ),
                  },
                },
                [
                  _vm._v(
                    "\n                Create a new Pipeline\n            "
                  ),
                ]
              ),
            ],
            1
          ),
        ],
        1
      ),
      _vm._v(" "),
      _c(
        "b-alert",
        {
          attrs: {
            show: _vm.dismissCountDown,
            dismissible: "",
            variant: _vm.alertType,
          },
          on: {
            dismissed: function ($event) {
              _vm.dismissCountDown = 0
            },
            "dismiss-count-down": _vm.countDownChanged,
          },
        },
        [_vm._v("\n        " + _vm._s(_vm.alertMessage) + "\n    ")]
      ),
      _vm._v(" "),
      _c("br"),
      _vm._v(" "),
      !_vm.isFetching && _vm.pipelines && _vm.pipelines.length === 0
        ? _c("div", { staticClass: "alert alert-warning" }, [
            _c(
              "span",
              {
                domProps: {
                  textContent: _vm._s(_vm.$t("ca3SApp.pipeline.home.notFound")),
                },
              },
              [_vm._v("No pipelines found")]
            ),
          ])
        : _vm._e(),
      _vm._v(" "),
      _vm.pipelines && _vm.pipelines.length > 0
        ? _c("div", [
            _c(
              "span",
              {
                domProps: {
                  textContent: _vm._s(_vm.$t("ca3SApp.pipeline.filter.type")),
                },
              },
              [_vm._v("Type: ")]
            ),
            _vm._v(" "),
            _c(
              "select",
              {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.typeFilter,
                    expression: "typeFilter",
                  },
                ],
                staticClass: "smallSelector fa-1x",
                attrs: { float: "left", name: "typeFilter" },
                on: {
                  change: [
                    function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.typeFilter = $event.target.multiple
                        ? $$selectedVal
                        : $$selectedVal[0]
                    },
                    _vm.filterPipelines,
                  ],
                },
              },
              [
                _c("option", { attrs: { value: "all" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.all"))),
                ]),
                _vm._v(" "),
                _c("option", { attrs: { value: "WEB" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.web"))),
                ]),
                _vm._v(" "),
                _c("option", { attrs: { value: "SCEP" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.scep"))),
                ]),
                _vm._v(" "),
                _c("option", { attrs: { value: "ACME" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.acme"))),
                ]),
              ]
            ),
            _vm._v(" "),
            _c(
              "span",
              {
                domProps: {
                  textContent: _vm._s(_vm.$t("ca3SApp.pipeline.filter.state")),
                },
              },
              [_vm._v(" State: ")]
            ),
            _vm._v(" "),
            _c(
              "select",
              {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.activeFilter,
                    expression: "activeFilter",
                  },
                ],
                staticClass: "smallSelector fa-1x",
                attrs: { float: "left", name: "activeFilter" },
                on: {
                  change: [
                    function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.activeFilter = $event.target.multiple
                        ? $$selectedVal
                        : $$selectedVal[0]
                    },
                    _vm.filterPipelines,
                  ],
                },
              },
              [
                _c("option", { attrs: { value: "all" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.all"))),
                ]),
                _vm._v(" "),
                _c("option", { attrs: { value: "enabled" } }, [
                  _vm._v(
                    _vm._s(_vm.$t("ca3SApp.pipeline.filter.active.enabled"))
                  ),
                ]),
                _vm._v(" "),
                _c("option", { attrs: { value: "disabled" } }, [
                  _vm._v(
                    _vm._s(_vm.$t("ca3SApp.pipeline.filter.active.disabled"))
                  ),
                ]),
              ]
            ),
            _vm._v(" "),
            _c(
              "span",
              {
                domProps: {
                  textContent: _vm._s(
                    _vm.$t("ca3SApp.pipeline.filter.connector")
                  ),
                },
              },
              [_vm._v(" Connector: ")]
            ),
            _vm._v(" "),
            _c(
              "select",
              {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.connectorFilter,
                    expression: "connectorFilter",
                  },
                ],
                staticClass: "smallSelector fa-1x",
                attrs: { float: "left", name: "connectorFilter" },
                on: {
                  change: [
                    function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.connectorFilter = $event.target.multiple
                        ? $$selectedVal
                        : $$selectedVal[0]
                    },
                    _vm.filterPipelines,
                  ],
                },
              },
              [
                _c("option", { attrs: { value: "all" } }, [
                  _vm._v(_vm._s(_vm.$t("ca3SApp.pipeline.filter.type.all"))),
                ]),
                _vm._v(" "),
                _vm._l(_vm.distinctConnectors, function (connector) {
                  return _c("option", { domProps: { value: connector } }, [
                    _vm._v(_vm._s(connector)),
                  ])
                }),
              ],
              2
            ),
          ])
        : _vm._e(),
      _vm._v(" "),
      _vm.pipelines && _vm.pipelines.length > 0
        ? _c("div", { staticClass: "table-responsive" }, [
            _c("table", { staticClass: "table table-striped" }, [
              _c("thead", [
                _c("tr", [
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(_vm.$t("global.field.id")),
                        },
                      },
                      [_vm._v("ID")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(_vm.$t("ca3SApp.pipeline.name")),
                        },
                      },
                      [_vm._v("Name")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(_vm.$t("ca3SApp.pipeline.type")),
                        },
                      },
                      [_vm._v("Type")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.active")
                          ),
                        },
                      },
                      [_vm._v("Active")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.expiresOn")
                          ),
                        },
                      },
                      [_vm._v("Active")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.urlPart")
                          ),
                        },
                      },
                      [_vm._v("Url Part")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.description")
                          ),
                        },
                      },
                      [_vm._v("Description")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.approvalRequired")
                          ),
                        },
                      },
                      [_vm._v("Approval Required")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th", [
                    _c(
                      "span",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.pipeline.caConnector")
                          ),
                        },
                      },
                      [_vm._v("Ca Connector")]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("th"),
                ]),
              ]),
              _vm._v(" "),
              _c(
                "tbody",
                _vm._l(_vm.filteredPipelines, function (pipeline) {
                  return _c("tr", { key: pipeline.id }, [
                    _c("td", [_vm._v(_vm._s(pipeline.id))]),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.name))]),
                    _vm._v(" "),
                    _c(
                      "td",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("ca3SApp.PipelineType." + pipeline.type)
                          ),
                        },
                      },
                      [_vm._v(_vm._s(pipeline.type))]
                    ),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.active))]),
                    _vm._v(" "),
                    _c(
                      "td",
                      { style: _vm.getValidToStyle(pipeline.expiryDate) },
                      [_vm._v(_vm._s(_vm.toLocalDate(pipeline.expiryDate)))]
                    ),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.urlPart))]),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.description))]),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.approvalRequired))]),
                    _vm._v(" "),
                    _c("td", [_vm._v(_vm._s(pipeline.caConnectorName))]),
                    _vm._v(" "),
                    _c("td", { staticClass: "text-right" }, [
                      _c(
                        "div",
                        { staticClass: "btn-group" },
                        [
                          _c(
                            "router-link",
                            {
                              staticClass: "btn btn-primary btn-sm edit",
                              attrs: {
                                to: {
                                  name: "ConfPipelineEdit",
                                  params: {
                                    pipelineId: pipeline.id,
                                    mode: "edit",
                                  },
                                },
                                tag: "button",
                              },
                            },
                            [
                              _c("font-awesome-icon", {
                                attrs: { icon: "pencil-alt" },
                              }),
                              _vm._v(" "),
                              _c(
                                "span",
                                {
                                  staticClass: "d-none d-md-inline",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t("entity.action.edit")
                                    ),
                                  },
                                },
                                [_vm._v("Edit")]
                              ),
                            ],
                            1
                          ),
                          _vm._v(" "),
                          _c(
                            "router-link",
                            {
                              staticClass: "btn btn-secondary btn-sm copy",
                              attrs: {
                                to: {
                                  name: "ConfPipelineEdit",
                                  params: {
                                    pipelineId: pipeline.id,
                                    mode: "copy",
                                  },
                                },
                                tag: "button",
                              },
                            },
                            [
                              _c("font-awesome-icon", {
                                attrs: { icon: "clone" },
                              }),
                              _vm._v(" "),
                              _c(
                                "span",
                                {
                                  staticClass: "d-none d-md-inline",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t("entity.action.copy")
                                    ),
                                  },
                                },
                                [_vm._v("Copy")]
                              ),
                            ],
                            1
                          ),
                          _vm._v(" "),
                          _c(
                            "b-button",
                            {
                              directives: [
                                {
                                  name: "b-modal",
                                  rawName: "v-b-modal.removeEntity",
                                  modifiers: { removeEntity: true },
                                },
                              ],
                              staticClass: "btn btn-sm",
                              attrs: { variant: "danger" },
                              on: {
                                click: function ($event) {
                                  return _vm.prepareRemove(pipeline)
                                },
                              },
                            },
                            [
                              _c("font-awesome-icon", {
                                attrs: { icon: "times" },
                              }),
                              _vm._v(" "),
                              _c(
                                "span",
                                {
                                  staticClass: "d-none d-md-inline",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t("entity.action.delete")
                                    ),
                                  },
                                },
                                [_vm._v("Delete")]
                              ),
                            ],
                            1
                          ),
                        ],
                        1
                      ),
                    ]),
                  ])
                }),
                0
              ),
            ]),
          ])
        : _vm._e(),
      _vm._v(" "),
      _c("b-modal", { ref: "removeEntity", attrs: { id: "removeEntity" } }, [
        _c("span", { attrs: { slot: "modal-title" }, slot: "modal-title" }, [
          _c(
            "span",
            {
              attrs: { id: "ca3SApp.pipeline.delete.question" },
              domProps: { textContent: _vm._s(_vm.$t("entity.delete.title")) },
            },
            [_vm._v("Confirm delete operation")]
          ),
        ]),
        _vm._v(" "),
        _c("div", { staticClass: "modal-body" }, [
          _c(
            "p",
            {
              attrs: { id: "jhi-delete-pipeline-heading" },
              domProps: {
                textContent: _vm._s(
                  _vm.$t("ca3SApp.pipeline.delete.question", {
                    id: _vm.removeId,
                  })
                ),
              },
            },
            [_vm._v("Are you sure you want to delete this Pipeline?")]
          ),
        ]),
        _vm._v(" "),
        _c("div", { attrs: { slot: "modal-footer" }, slot: "modal-footer" }, [
          _c(
            "button",
            {
              staticClass: "btn btn-secondary",
              attrs: { type: "button" },
              domProps: { textContent: _vm._s(_vm.$t("entity.action.cancel")) },
              on: {
                click: function ($event) {
                  return _vm.closeDialog()
                },
              },
            },
            [_vm._v("Cancel")]
          ),
          _vm._v(" "),
          _c(
            "button",
            {
              staticClass: "btn btn-primary",
              attrs: { type: "button", id: "jhi-confirm-delete-pipeline" },
              domProps: { textContent: _vm._s(_vm.$t("entity.action.delete")) },
              on: {
                click: function ($event) {
                  return _vm.removePipeline()
                },
              },
            },
            [_vm._v("Delete")]
          ),
        ]),
      ]),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_core_pipeline_pipeline_vue.f9482907c1ec65a5e891.chunk.js.map