/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.config.ClientAuthConfig;
import de.trustable.ca3s.core.service.dto.CryptoConfigView;
import java.security.Provider;
import java.security.Security;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CryptoConfiguration {
    private final Logger log = LoggerFactory.getLogger(CryptoConfiguration.class);
    private final String[] validPBEAlgoArr;
    private final String[] allHashAlgoArr;
    private final String[] allSignAlgoArr;
    private final String regexpPkcs12Description;
    private final String pkcs12SecretRegexp;
    private final String regexpPasswordDescription;
    private final String passwordRegexp;
    private final ClientAuthConfig clientAuthConfig;

    public CryptoConfiguration(@Value(value="${ca3s.pkcs12.pbe.algos:PBEWithHmacSHA256AndAES_256}") String[] validPBEAlgoArr, @Value(value="${ca3s.catalog.hash.algos:sha-1,sha-256,sha-384,sha-512}") String[] allHashAlgoArr, @Value(value="${ca3s.catalog.sign.algos:rsa-1024,rsa-2048,rsa-3072,rsa-4096,rsa-8192}") String[] allSignAlgoArr, @Value(value="${ca3s.pkcs12.secret.description:min6NumberUpperLower}") String regexpPkcs12Description, @Value(value="${ca3s.pkcs12.secret.regexp:^(?=.*\\d)(?=.*[a-z]).{6,100}$}") String pkcs12SecretRegexp, @Value(value="${ca3s.ui.password.check.description:min6NumberUpperLower}") String regexpPasswordDescription, @Value(value="${ca3s.ui.password.check.regexp:^(?=.*\\d)(?=.*[a-z]).{6,100}$}") String passwordRegexp, ClientAuthConfig clientAuthConfig) {
        this.validPBEAlgoArr = validPBEAlgoArr;
        this.allHashAlgoArr = allHashAlgoArr;
        this.allSignAlgoArr = allSignAlgoArr;
        this.regexpPkcs12Description = regexpPkcs12Description;
        this.pkcs12SecretRegexp = pkcs12SecretRegexp;
        this.regexpPasswordDescription = regexpPasswordDescription;
        this.passwordRegexp = passwordRegexp;
        this.clientAuthConfig = clientAuthConfig;
        for (Provider provider : Security.getProviders()) {
            TreeSet algs = new TreeSet();
            provider.getServices().stream().map(Provider.Service::getAlgorithm).forEach(algs::add);
        }
    }

    public CryptoConfigView getCryptoConfigView() {
        return new CryptoConfigView(this.validPBEAlgoArr, this.getDefaultPBEAlgo(), this.allHashAlgoArr, this.allSignAlgoArr, this.regexpPkcs12Description, this.pkcs12SecretRegexp, this.regexpPasswordDescription, this.passwordRegexp, this.clientAuthConfig.getClientAuthTarget());
    }

    public String getDefaultPBEAlgo() {
        String passwordProtectionAlgo = "PBEWithHmacSHA256AndAES_256";
        if (this.validPBEAlgoArr.length > 0) {
            passwordProtectionAlgo = this.validPBEAlgoArr[0];
        }
        return passwordProtectionAlgo;
    }

    public boolean isPBEAlgoAllowed(String reqAlgo) {
        return ArrayUtils.contains((Object[])this.validPBEAlgoArr, (Object)reqAlgo.trim());
    }
}

