/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="acme_authorization")
@NamedQueries(value={@NamedQuery(name="AcmeAuthorization.findByAcmeAuthorizationId", query="SELECT a FROM AcmeAuthorization a WHERE a.acmeAuthorizationId = :acmeAuthorizationId")})
public class AcmeAuthorization
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="acme_authorization_id", nullable=false)
    private Long acmeAuthorizationId;
    @NotNull
    @Column(name="type", nullable=false)
    private String type;
    @NotNull
    @Column(name="value_", nullable=false)
    private String value;
    @OneToMany(mappedBy="acmeAuthorization")
    @JsonIgnoreProperties(value={"acmeAuthorization"}, allowSetters=true)
    private Set<AcmeChallenge> challenges = new HashSet();
    @ManyToOne
    @JsonIgnoreProperties(value={"acmeAuthorizations"})
    private AcmeOrder order;

    public Long getId() {
        return this.id;
    }

    public AcmeAuthorization id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAcmeAuthorizationId() {
        return this.acmeAuthorizationId;
    }

    public AcmeAuthorization acmeAuthorizationId(Long acmeAuthorizationId) {
        this.setAcmeAuthorizationId(acmeAuthorizationId);
        return this;
    }

    public void setAcmeAuthorizationId(Long acmeAuthorizationId) {
        this.acmeAuthorizationId = acmeAuthorizationId;
    }

    public String getType() {
        return this.type;
    }

    public AcmeAuthorization type(String type) {
        this.setType(type);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public AcmeAuthorization value(String value) {
        this.value = value;
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Set<AcmeChallenge> getChallenges() {
        return this.challenges;
    }

    public void setChallenges(Set<AcmeChallenge> acmeChallenges) {
        if (this.challenges != null) {
            this.challenges.forEach(i -> i.setAcmeAuthorization(null));
        }
        if (acmeChallenges != null) {
            acmeChallenges.forEach(i -> i.setAcmeAuthorization(this));
        }
        this.challenges = acmeChallenges;
    }

    public AcmeAuthorization challenges(Set<AcmeChallenge> acmeChallenges) {
        this.setChallenges(acmeChallenges);
        return this;
    }

    public AcmeAuthorization addChallenges(AcmeChallenge acmeChallenge) {
        this.challenges.add(acmeChallenge);
        acmeChallenge.setAcmeAuthorization(this);
        return this;
    }

    public AcmeAuthorization removeChallenges(AcmeChallenge acmeChallenge) {
        this.challenges.remove(acmeChallenge);
        acmeChallenge.setAcmeAuthorization(null);
        return this;
    }

    public AcmeOrder getOrder() {
        return this.order;
    }

    public void setOrder(AcmeOrder acmeOrder) {
        this.order = acmeOrder;
    }

    public AcmeAuthorization order(AcmeOrder acmeOrder) {
        this.setOrder(acmeOrder);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcmeAuthorization)) {
            return false;
        }
        return this.id != null && this.id.equals(((AcmeAuthorization)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "AcmeAuthorization{id=" + this.getId() + ", acmeAuthorizationId=" + this.getAcmeAuthorizationId() + ", type='" + this.getType() + "', value='" + this.getValue() + "'}";
    }
}

