/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.AlgorithmType;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="algorithm_restriction")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AlgorithmRestriction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private AlgorithmType type;
    @Column(name="not_after")
    private Instant notAfter;
    @Column(name="identifier")
    private String identifier;
    @Column(name="name")
    private String name;
    @NotNull
    @Column(name="acceptable", nullable=false)
    private Boolean acceptable;
    @ManyToMany(mappedBy="algorithms")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @JsonIgnoreProperties(value={"pipelineAttributes", "caConnector", "processInfo", "algorithms"}, allowSetters=true)
    private Set<Pipeline> pipelines = new HashSet();

    public Long getId() {
        return this.id;
    }

    public AlgorithmRestriction id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AlgorithmType getType() {
        return this.type;
    }

    public AlgorithmRestriction type(AlgorithmType type) {
        this.setType(type);
        return this;
    }

    public void setType(AlgorithmType type) {
        this.type = type;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public AlgorithmRestriction notAfter(Instant notAfter) {
        this.setNotAfter(notAfter);
        return this;
    }

    public void setNotAfter(Instant notAfter) {
        this.notAfter = notAfter;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public AlgorithmRestriction identifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getName() {
        return this.name;
    }

    public AlgorithmRestriction name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getAcceptable() {
        return this.acceptable;
    }

    public AlgorithmRestriction acceptable(Boolean acceptable) {
        this.setAcceptable(acceptable);
        return this;
    }

    public void setAcceptable(Boolean acceptable) {
        this.acceptable = acceptable;
    }

    public Set<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public void setPipelines(Set<Pipeline> pipelines) {
        if (this.pipelines != null) {
            this.pipelines.forEach(i -> i.removeAlgorithms(this));
        }
        if (pipelines != null) {
            pipelines.forEach(i -> i.addAlgorithms(this));
        }
        this.pipelines = pipelines;
    }

    public AlgorithmRestriction pipelines(Set<Pipeline> pipelines) {
        this.setPipelines(pipelines);
        return this;
    }

    public AlgorithmRestriction addPipelines(Pipeline pipeline) {
        this.pipelines.add(pipeline);
        pipeline.getAlgorithms().add(this);
        return this;
    }

    public AlgorithmRestriction removePipelines(Pipeline pipeline) {
        this.pipelines.remove(pipeline);
        pipeline.getAlgorithms().remove(this);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlgorithmRestriction)) {
            return false;
        }
        return this.id != null && this.id.equals(((AlgorithmRestriction)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "AlgorithmRestriction{id=" + this.getId() + ", type='" + String.valueOf(this.getType()) + "', notAfter='" + String.valueOf(this.getNotAfter()) + "', identifier='" + this.getIdentifier() + "', name='" + this.getName() + "', acceptable='" + this.getAcceptable() + "'}";
    }
}

