/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClientAuthService {
    private final Logger log = LoggerFactory.getLogger(ClientAuthService.class);
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certificateUtil;
    private final TokenProvider tokenProvider;

    public ClientAuthService(CertificateRepository certificateRepository, CertificateUtil certificateUtil, TokenProvider tokenProvider) {
        this.certificateRepository = certificateRepository;
        this.certificateUtil = certificateUtil;
        this.tokenProvider = tokenProvider;
    }

    public boolean isClientCertValidForUser(String jwt, User user) {
        String ski = this.tokenProvider.getSKIClaim(jwt);
        this.log.info("client certificate with ski {}", (Object)ski);
        List certificateList = this.certificateRepository.findActiveBySKI(ski);
        for (Certificate cert : certificateList) {
            String certIdString = this.certificateUtil.getCertAttribute(cert, "USER_CLIENT_CERT");
            if (user.getId().toString().equalsIgnoreCase(certIdString)) {
                this.log.info("client certificate {} valid for user {}", (Object)cert.getId(), (Object)user.getId());
                return true;
            }
            this.log.warn("client certificate {} assigned to user {} but not requesting user {}", new Object[]{cert.getId(), certIdString, user.getId()});
        }
        return false;
    }
}

