/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.acme.problem;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Immutable
public class ProblemDetail {
    public static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    private final URI type;
    private final URI instance;
    private final String title;
    private final String detail;
    private final HttpStatus status;

    public ProblemDetail() {
        this.type = null;
        this.title = "";
        this.detail = "";
        this.instance = null;
        this.status = null;
    }

    public ProblemDetail(URI type, String title, HttpStatus status, String detail, URI instance) {
        this.type = type;
        this.title = title;
        this.detail = detail;
        this.instance = instance;
        this.status = status;
    }

    @JsonProperty(value="type")
    public final URI getType() {
        return this.type;
    }

    @JsonProperty(value="title")
    public final String getTitle() {
        return this.title;
    }

    @JsonProperty(value="detail")
    public final String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="instance")
    public final URI getInstance() {
        return this.instance;
    }

    @JsonIgnore
    public final HttpStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public final Integer getStatusCode() {
        return this.status == null ? null : Integer.valueOf(this.status.value());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProblemDetail)) {
            return false;
        }
        ProblemDetail that = (ProblemDetail)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.instance.equals(that.instance)) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        if (!this.detail.equals(that.detail)) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.instance.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.detail.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public String toString() {
        return "ProblemDetail{type=" + String.valueOf(this.type) + ", title='" + this.title + "', detail='" + this.detail + "', instance=" + String.valueOf(this.instance) + ", status=" + String.valueOf(this.status) + "}";
    }
}

