/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.service.util.BPMNExecutor;
import java.util.HashMap;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BPMNAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNAsyncUtil.class);
    private final BPMNExecutor bpmnExecutor;

    public BPMNAsyncUtil(BPMNExecutor bpmnExecutor) {
        this.bpmnExecutor = bpmnExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Transactional
    public void onChange(String processName, Long certificateId, Authentication auth) {
        String string;
        LOG.info("******************  Async call to onChange( '{}', {})", (Object)processName, (Object)certificateId);
        if (certificateId == null) {
            return;
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("certificateId", certificateId.toString());
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication currentAuth = securityContext.getAuthentication();
        try {
            if (auth != null) {
                LOG.info("Setting authentication to : {}", (Object)auth.getName());
                securityContext.setAuthentication(auth);
            }
            for (int retryCounter = 0; retryCounter < 3; ++retryCounter) {
                try {
                    ProcessInstanceWithVariables processInstance = this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
                    String status = processInstance.getVariables().get((Object)"status").toString();
                    LOG.info("ProcessInstance '{}' terminates with status {}", (Object)processInstance.getId(), (Object)status);
                    break;
                }
                catch (RuntimeException processException) {
                    String msg = "Exception while calling bpmn process '" + processName + "', retry: " + retryCounter;
                    LOG.debug(msg, (Throwable)processException);
                    continue;
                }
            }
            string = currentAuth == null ? null : currentAuth.getName();
        }
        catch (Throwable throwable) {
            String currentAuthName = currentAuth == null ? null : currentAuth.getName();
            LOG.info("Restoring authentication to : {}", (Object)currentAuthName);
            securityContext.setAuthentication(currentAuth);
            throw throwable;
        }
        String currentAuthName = string;
        LOG.info("Restoring authentication to : {}", (Object)currentAuthName);
        securityContext.setAuthentication(currentAuth);
    }
}

