/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeContact;
import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessAttribute;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.domain.enumeration.BPMNProcessType;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.exception.CAFailureException;
import de.trustable.ca3s.core.exception.SMSSendingFaiedException;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.repository.BPMNProcessAttributeRepository;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.BPMNProcessInfoView;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.util.BPMNAsyncUtil;
import de.trustable.ca3s.core.service.util.BPMNExecutor;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ConfigUtil;
import de.trustable.ca3s.core.service.util.NameAndRoleUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x509.CRLReason;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class BPMNUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNUtil.class);
    public static final String HISTORIC_PROCESS_DELETION_REASON = "processOutdated";
    private final ConfigUtil configUtil;
    private final CaConnectorAdapter caConnAdapter;
    private final CAConnectorConfigRepository caConnConRepo;
    private final CryptoUtil cryptoUtil;
    private final RepositoryService repoService;
    private final HistoryService historyService;
    private final BPMNProcessInfoRepository bpnmInfoRepo;
    private final BPMNProcessAttributeRepository bpnmAttributeRepo;
    private final ProtectedContentUtil protectedContentUtil;
    private final CSRRepository csrRepository;
    private final CertificateRepository certRepository;
    private final CertificateUtil certUtil;
    private final NameAndRoleUtil nameAndRoleUtil;
    private final AuditService auditService;
    private final BPMNAsyncUtil bpmnAsyncUtil;
    private final BPMNExecutor bpmnExecutor;
    private final AcmeAccountRepository acmeAccountRepository;
    private final boolean useDefaultProcess;

    @Autowired
    public BPMNUtil(ConfigUtil configUtil, CaConnectorAdapter caConnAdapter, CAConnectorConfigRepository caConnConRepo, CryptoUtil cryptoUtil, RepositoryService repoService, HistoryService historyService, BPMNProcessInfoRepository bpnmInfoRepo, BPMNProcessAttributeRepository bpnmAttributeRepo, ProtectedContentUtil protectedContentUtil, CSRRepository csrRepository, CertificateRepository certRepository, CertificateUtil certUtil, NameAndRoleUtil nameAndRoleUtil, AuditService auditService, BPMNAsyncUtil bpmnAsyncUtil, BPMNExecutor bpmnExecutor, AcmeAccountRepository acmeAccountRepository, @Value(value="${ca3s.bpmn.use-default-process:false}") boolean useDefaultProcess) {
        this.configUtil = configUtil;
        this.caConnAdapter = caConnAdapter;
        this.caConnConRepo = caConnConRepo;
        this.cryptoUtil = cryptoUtil;
        this.repoService = repoService;
        this.historyService = historyService;
        this.bpnmInfoRepo = bpnmInfoRepo;
        this.bpnmAttributeRepo = bpnmAttributeRepo;
        this.protectedContentUtil = protectedContentUtil;
        this.csrRepository = csrRepository;
        this.certRepository = certRepository;
        this.certUtil = certUtil;
        this.nameAndRoleUtil = nameAndRoleUtil;
        this.auditService = auditService;
        this.bpmnAsyncUtil = bpmnAsyncUtil;
        this.bpmnExecutor = bpmnExecutor;
        this.acmeAccountRepository = acmeAccountRepository;
        this.useDefaultProcess = useDefaultProcess;
    }

    public String addModel(String bpmnString, String name) {
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(bpmnString.getBytes(StandardCharsets.UTF_8)));
        String modelName = name + ".bpmn20.xml";
        Deployment deployment = this.repoService.createDeployment().addModelInstance(modelName, modelInstance).deploy();
        LOG.debug("deployment with name {} and if {} is a {}", new Object[]{modelName, deployment.getId(), deployment.getClass().getName()});
        for (ProcessDefinition pd : this.getProcessDefinitions()) {
            LOG.debug("process definition with name {}, id {}, versionTag {}, deploymentId {}, key {} found", new Object[]{pd.getName(), pd.getId(), pd.getVersionTag(), pd.getDeploymentId(), pd.getKey()});
        }
        ProcessDefinition pdNew = (ProcessDefinition)this.repoService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list().get(0);
        LOG.debug("New process definition Id '{}'", (Object)pdNew.getId());
        return pdNew.getId();
    }

    public List<ProcessDefinition> getProcessDefinitions() {
        return this.repoService.createProcessDefinitionQuery().latestVersion().list();
    }

    public InputStream getProcessContent(String processId) {
        return this.repoService.getProcessModel(processId);
    }

    public void updateProcessDefinitions() {
        List pdList = this.getProcessDefinitions();
        for (ProcessDefinition pd : pdList) {
            List bpmnProcessInfoList = this.bpnmInfoRepo.findByNameOrderedBylastChange(pd.getKey());
            if (bpmnProcessInfoList.isEmpty()) {
                this.buildBPMNProcessInfoByProcess(pd, pd.getKey(), BPMNProcessType.CERTIFICATE_CREATION);
                continue;
            }
            LOG.debug("BPNMProcessInfo {} already exists", (Object)pd.getKey());
        }
    }

    public void deleteHistoricProcesses(int historicProcessRetentionPeriodDays) {
        Date finishedBeforeLimit = Date.from(Instant.now().minus(historicProcessRetentionPeriodDays, ChronoUnit.DAYS));
        LOG.info("Update removal time for historic instances finished before {} ", (Object)finishedBeforeLimit);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().finishedBefore(finishedBeforeLimit);
        try {
            this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(new Date()).byQuery(query).hierarchical().executeAsync();
            LOG.debug("Update removal time for historic instances scheduled ...");
        }
        catch (BadUserRequestException badUserRequestException) {
            LOG.info("Problem setting removal time: " + badUserRequestException.getMessage());
        }
        try {
            this.historyService.deleteHistoricProcessInstancesAsync(query, HISTORIC_PROCESS_DELETION_REASON);
            LOG.debug("starting to delete historic instances ...");
        }
        catch (BadUserRequestException bure) {
            LOG.info("Problem starting 'historyService.deleteHistoricProcessInstancesAsync': {}", (Object)bure.getMessage());
        }
    }

    public BPMNProcessInfo buildBPMNProcessInfoByProcessId(String processId, String name, BPMNProcessType bpmnProcessType) {
        List pdList = this.repoService.createProcessDefinitionQuery().processDefinitionId(processId).list();
        if (pdList.isEmpty()) {
            LOG.debug("retrieving ProcessDefinition for id '{}' failed ...", (Object)processId);
        }
        return this.buildBPMNProcessInfoByProcess((ProcessDefinition)pdList.get(0), name, bpmnProcessType);
    }

    public BPMNProcessInfo buildBPMNProcessInfoByProcess(ProcessDefinition pd, String name, BPMNProcessType bpmnProcessType) {
        BPMNProcessInfo newBI = new BPMNProcessInfo();
        newBI.setAuthor(this.nameAndRoleUtil.getNameAndRole().getName());
        newBI.setLastChange(Instant.now());
        newBI.setName(name);
        String version = pd.getVersionTag();
        if (version == null) {
            version = "0.0.1";
        }
        newBI.setVersion(version);
        newBI.setType(bpmnProcessType);
        newBI.setSignatureBase64("1234");
        newBI.setBpmnHashBase64("bpmnHash");
        newBI.setProcessId(pd.getId());
        LOG.info("added new BPNMProcessInfo from camunda database: {}", (Object)newBI);
        this.bpnmInfoRepo.save((Object)newBI);
        return newBI;
    }

    public void deleteProcessDefinitions(String processId) {
        this.repoService.deleteProcessDefinitions().byIds(new String[]{processId}).delete();
    }

    public Certificate startCertificateCreationProcess(CSR csr) {
        CAConnectorConfig caConfig;
        Pipeline pipeline = null;
        if (csr.getPipeline() == null) {
            LOG.warn("No pipeline information in CSR #{}", (Object)csr.getId());
            caConfig = this.configUtil.getDefaultConfig();
        } else {
            caConfig = csr.getPipeline().getCaConnector();
            pipeline = csr.getPipeline();
        }
        return this.startCertificateCreationProcess(csr, caConfig, pipeline);
    }

    public Certificate startCertificateCreationProcess(CSR csr, CAConnectorConfig caConfig, Pipeline pipeline) {
        String failureReason;
        Certificate certificate;
        String status;
        block13: {
            status = "Failed";
            String certificateId = "";
            certificate = null;
            failureReason = "";
            BPMNProcessInfo bpmnProcessInfo = null;
            if (pipeline != null) {
                bpmnProcessInfo = pipeline.getProcessInfoCreate();
            }
            if (caConfig != null) {
                if (bpmnProcessInfo != null) {
                    try {
                        Map variables = this.buildVariableMapFromCSR(csr, caConfig);
                        variables.put("certificateId", certificateId);
                        ProcessInstanceWithVariables processInstance = this.bpmnExecutor.executeBPMNProcessByBPMNProcessInfo(bpmnProcessInfo, variables);
                        certificate = (Certificate)processInstance.getVariables().get((Object)"certificate");
                        status = processInstance.getVariables().get((Object)"status").toString();
                        Object reason = processInstance.getVariables().get((Object)"failureReason");
                        if (reason != null && !reason.toString().isEmpty()) {
                            failureReason = processInstance.getVariables().get((Object)"failureReason").toString();
                            break block13;
                        }
                        this.notifyOnCertificate(pipeline.getProcessInfoNotify(), certificate.getId().longValue());
                    }
                    catch (Exception e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.warn("execution of '" + bpmnProcessInfo.getName() + "' failed ", (Throwable)e);
                    }
                } else {
                    try {
                        certificate = this.caConnAdapter.signCertificateRequest(csr, caConfig);
                        status = "Created";
                        if (pipeline != null && certificate != null) {
                            this.notifyOnCertificate(pipeline.getProcessInfoNotify(), certificate.getId().longValue());
                        }
                    }
                    catch (GeneralSecurityException e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.error(failureReason);
                    }
                }
            } else {
                failureReason = "no default and active CA configured";
                LOG.error(failureReason);
            }
        }
        if ("Created".equals(status)) {
            if (certificate != null) {
                certificate.setCsr(csr);
                this.certUtil.setCertAttribute(certificate, "CA_CONNECTOR_ID", caConfig.getId().longValue());
                this.certRepository.save((Object)certificate);
                csr.setCertificate(certificate);
                csr.setStatus(CsrStatus.ISSUED);
                this.csrRepository.save((Object)csr);
                LOG.debug("new certificate id {} created", (Object)certificate.getId());
                return certificate;
            }
            LOG.warn("creation of certificate failed, no certificate returned");
            throw new CAFailureException();
        }
        LOG.warn("creation of certificate by BPMN process failed with reason '{}'", (Object)failureReason);
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr, failureReason));
        throw new CAFailureException(failureReason);
    }

    public ProcessInstanceWithVariables checkCertificateNotificationProcess(Certificate certificate, CAConnectorConfig caConfig, String processName) {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("certificateId", certificate.getId());
        return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
    }

    public ProcessInstanceWithVariables checkCertificateCreationProcess(CSR csr, CAConnectorConfig caConfig, String processName) {
        Map variables = this.buildVariableMapFromCSR(csr, caConfig);
        return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
    }

    public ProcessInstanceWithVariables checkCsrRequestAuthorization(String processName, CSR csr) {
        Map variables = this.buildVariableMapFromCSR(csr, null);
        return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
    }

    public ProcessInstanceWithVariables checkBatchProcess(String processName) {
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("now", new Date());
        return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
    }

    public void startSMSProcess(String phone, String msg) {
        List bpmnProcessInfoList = this.bpnmInfoRepo.findByType(BPMNProcessType.SEND_SMS);
        if (bpmnProcessInfoList.isEmpty()) {
            throw new SMSSendingFaiedException("No BPMN Process Info with type BPMNProcessType.SEND_SMS not present!");
        }
        if (bpmnProcessInfoList.size() > 1) {
            throw new SMSSendingFaiedException("Too many BPMN Process Info with type BPMNProcessType.SEND_SMS present!");
        }
        BPMNProcessInfo smsProcessInfo = (BPMNProcessInfo)bpmnProcessInfoList.get(0);
        ProcessInstanceWithVariables processInstanceWithVariables = this.checkSMSProcess(smsProcessInfo.getProcessId(), phone, msg);
        Object reason = processInstanceWithVariables.getVariables().get((Object)"failureReason");
        if (reason != null && !reason.toString().isEmpty()) {
            throw new SMSSendingFaiedException(reason.toString());
        }
    }

    public ProcessInstanceWithVariables checkAcmeAccountAuthorizationProzess(String processName, String accountId) {
        HashMap<String, AccountRequest> variables = new HashMap<String, AccountRequest>();
        Optional acmeAccountOptional = this.acmeAccountRepository.findById((Object)Long.parseLong(accountId));
        if (acmeAccountOptional.isPresent()) {
            AcmeAccount acmeAccount = (AcmeAccount)acmeAccountOptional.get();
            AccountRequest accountRequest = new AccountRequest();
            accountRequest.setStatus(AccountStatus.PENDING);
            accountRequest.setTermsAgreed(true);
            for (AcmeContact acmeContact : acmeAccount.getContacts()) {
                accountRequest.getContacts().add(acmeContact.getContactUrl());
            }
            variables.put("accountRequest", accountRequest);
            return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
        }
        throw new RuntimeException("accountId '" + accountId + "' is unknown");
    }

    public ProcessInstanceWithVariables checkSMSProcess(String processName, String phone, String msg) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("phone", phone);
        variables.put("msg", msg);
        return this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
    }

    @NotNull
    private Map<String, Object> buildVariableMapFromCSR(CSR csr, CAConnectorConfig caConfig) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("csrId", csr.getId());
        variables.put("csr", csr);
        variables.put("csrAttributes", csr.getCsrAttributes());
        if (caConfig != null) {
            variables.put("caConfigId", caConfig.getId());
        }
        return variables;
    }

    public void startCertificateRevocationProcess(Certificate certificate, CRLReason crlReason, Date revocationDate) throws GeneralSecurityException {
        String processInstanceId;
        Object failureReason;
        String status;
        block18: {
            CAConnectorConfig caConfigDefault;
            String caConnectorId;
            if (certificate == null) {
                throw new GeneralSecurityException("certificate to be revoked MUST be provided");
            }
            if (crlReason == null) {
                throw new GeneralSecurityException("revocation reason for certificate " + certificate.getId() + " MUST be provided");
            }
            if (revocationDate == null) {
                throw new GeneralSecurityException("revocation date for certificate " + certificate.getId() + " MUST be provided");
            }
            status = "Failed";
            failureReason = "";
            processInstanceId = "";
            Pipeline pipeline = null;
            BPMNProcessInfo bpmnProcessInfo = null;
            BPMNProcessInfo bpmnProcessInfoNotify = null;
            if (certificate.getCsr() != null && certificate.getCsr().getPipeline() != null) {
                pipeline = certificate.getCsr().getPipeline();
                bpmnProcessInfo = pipeline.getProcessInfoRevoke();
                if (bpmnProcessInfo != null) {
                    LOG.debug("ProcessInfoRevoke '{}' defined by pipeline '{}' ", (Object)bpmnProcessInfo.getName(), (Object)pipeline.getName());
                }
                if ((bpmnProcessInfoNotify = pipeline.getProcessInfoNotify()) != null) {
                    LOG.debug("ProcessInfoNotify '{}' defined by pipeline '{}' ", (Object)bpmnProcessInfoNotify.getName(), (Object)pipeline.getName());
                }
            }
            if ((caConnectorId = this.certUtil.getCertAttribute(certificate, "CA_CONNECTOR_ID")) == null && (caConfigDefault = this.configUtil.getDefaultConfig()) != null) {
                caConnectorId = caConfigDefault.getId().toString();
            }
            if (caConnectorId != null) {
                LOG.debug("revoke certificate '{}' at CA with config '{}' ", (Object)certificate.getId(), (Object)caConnectorId);
                if (bpmnProcessInfo != null) {
                    try {
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        variables.put("action", "Revoke");
                        variables.put("caConfigId", caConnectorId);
                        variables.put("status", "Failed");
                        variables.put("certificateId", certificate.getId());
                        variables.put("certificate", certificate);
                        variables.put("revocationReason", this.cryptoUtil.crlReasonAsString(crlReason));
                        variables.put("revocationDate", revocationDate.getTime());
                        variables.put("failureReason", failureReason);
                        ProcessInstanceWithVariables processInstance = this.bpmnExecutor.executeBPMNProcessByBPMNProcessInfo(bpmnProcessInfo, variables);
                        processInstanceId = processInstance.getId();
                        LOG.info("ProcessInstance: {}", (Object)processInstanceId);
                        status = processInstance.getVariables().get((Object)"status").toString();
                        if (processInstance.getVariables().get((Object)"failureReason") != null) {
                            failureReason = processInstance.getVariables().get((Object)"failureReason").toString();
                        }
                        this.notifyOnCertificate(bpmnProcessInfoNotify, certificate.getId().longValue());
                    }
                    catch (Exception e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.warn("execution of '" + bpmnProcessInfo.getName() + "' failed ", (Throwable)e);
                    }
                } else {
                    try {
                        Optional caConfigOpt = this.caConnConRepo.findById((Object)Long.parseLong(caConnectorId));
                        if (caConfigOpt.isPresent()) {
                            this.caConnAdapter.revokeCertificate(certificate, crlReason, revocationDate, (CAConnectorConfig)caConfigOpt.get());
                            this.notifyOnCertificate(bpmnProcessInfoNotify, certificate.getId().longValue());
                            status = "Revoked";
                            break block18;
                        }
                        failureReason = "caConnectorId '" + caConnectorId + "' is unknown";
                        LOG.error((String)failureReason);
                    }
                    catch (GeneralSecurityException e) {
                        failureReason = e.getLocalizedMessage();
                        LOG.error((String)failureReason);
                    }
                }
            } else {
                failureReason = "no default and active CA configured";
                LOG.error((String)failureReason);
            }
        }
        if (!"Revoked".equals(status)) {
            LOG.warn("revocation of certificate by BPMN process {} failed with reason '{}' ", (Object)processInstanceId, failureReason);
            throw new GeneralSecurityException((String)failureReason);
        }
        LOG.debug("certificate id {} revoked by BPMN process {}", (Object)certificate.getId(), (Object)processInstanceId);
    }

    public void startACMEAccountAuthorizationProcess(AccountRequest accountRequest, Pipeline pipeline) throws GeneralSecurityException {
        if (accountRequest == null) {
            throw new GeneralSecurityException("accountRequest for ACME account creation MUST be provided");
        }
        if (pipeline == null) {
            throw new GeneralSecurityException("pipeline for ACME account creation MUST be provided");
        }
        String status = "Failed";
        String failureReason = "";
        String processInstanceId = "";
        BPMNProcessInfo bpmnProcessInfoAccountAuthorization = pipeline.getProcessInfoAccountAuthorization();
        if (bpmnProcessInfoAccountAuthorization == null) {
            return;
        }
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("action", "ACMEAccountAuthorization");
            variables.put("accountRequest", (String)accountRequest);
            variables.put("status", status);
            variables.put("failureReason", failureReason);
            ProcessInstanceWithVariables processInstance = this.bpmnExecutor.executeBPMNProcessByBPMNProcessInfo(bpmnProcessInfoAccountAuthorization, variables);
            processInstanceId = processInstance.getId();
            LOG.info("startACMEAccountAuthorizationProcess ProcessInstance: {}", (Object)processInstanceId);
            status = processInstance.getVariables().get((Object)"status").toString();
            if (processInstance.getVariables().get((Object)"failureReason") != null) {
                failureReason = processInstance.getVariables().get((Object)"failureReason").toString();
            }
        }
        catch (Exception e) {
            failureReason = e.getLocalizedMessage();
            LOG.warn("execution of '" + bpmnProcessInfoAccountAuthorization.getName() + "' failed ", (Throwable)e);
        }
        if (!"Success".equals(status)) {
            LOG.warn("ACME account creation check by BPMN process {} failed with reason '{}' ", (Object)processInstanceId, (Object)failureReason);
            throw new GeneralSecurityException(failureReason);
        }
        LOG.debug("ACME account creation confirmed by BPMN process {}", (Object)processInstanceId);
    }

    private void notifyOnCertificate(BPMNProcessInfo processInfo, long certificateId) {
        if (processInfo != null && processInfo.getProcessId() != null) {
            if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                LOG.warn("notifyOnCertificate: no transaction active !");
            }
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            LOG.info("notifyOnCertificate: '{}', {} for auth {}", new Object[]{processInfo.getProcessId(), certificateId, auth});
            this.executeAfterTransactionCommits(() -> this.bpmnAsyncUtil.onChange(processInfo.getProcessId(), Long.valueOf(certificateId), auth));
        } else {
            LOG.info("notifyOnCertificate: no notify process defined ");
        }
    }

    private void executeAfterTransactionCommits(Runnable task) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BPMNProcessInfoView toBPMNProcessInfoView(BPMNProcessInfo bpmnProcessInfo) {
        BPMNProcessInfoView bpmnProcessInfoView = new BPMNProcessInfoView();
        bpmnProcessInfoView.setId(bpmnProcessInfo.getId());
        bpmnProcessInfoView.setName(bpmnProcessInfo.getName());
        bpmnProcessInfoView.setType(bpmnProcessInfo.getType());
        bpmnProcessInfoView.setVersion(bpmnProcessInfo.getVersion());
        bpmnProcessInfoView.setAuthor(bpmnProcessInfo.getAuthor());
        bpmnProcessInfoView.setLastChange(bpmnProcessInfo.getLastChange());
        bpmnProcessInfoView.setBpmnHashBase64(bpmnProcessInfo.getBpmnHashBase64());
        bpmnProcessInfoView.setProcessId(bpmnProcessInfo.getProcessId());
        ArrayList<BPMNProcessAttribute> bpmnProcessAttributelist = new ArrayList<BPMNProcessAttribute>();
        for (BPMNProcessAttribute bpmnProcessAttribute : bpmnProcessInfo.getBpmnProcessAttributes()) {
            BPMNProcessAttribute bpmnProcessAttributeNew = new BPMNProcessAttribute();
            bpmnProcessAttributeNew.setId(bpmnProcessAttribute.getId());
            bpmnProcessAttributeNew.setName(bpmnProcessAttribute.getName());
            bpmnProcessAttributeNew.setValue(bpmnProcessAttribute.getValue());
            bpmnProcessAttributeNew.setProtectedContent(bpmnProcessAttribute.getProtectedContent());
            bpmnProcessAttributelist.add(bpmnProcessAttributeNew);
        }
        bpmnProcessInfoView.setBpmnProcessAttributes(bpmnProcessAttributelist.toArray(new BPMNProcessAttribute[0]));
        return bpmnProcessInfoView;
    }

    public BPMNProcessInfo toBPMNProcessInfo(BPMNProcessInfoView bpmnProcessInfoView) {
        BPMNProcessInfo bpmnProcessInfo;
        ArrayList<AuditTrace> auditList = new ArrayList<AuditTrace>();
        Optional bpmnProcessInfoOptByName = this.bpnmInfoRepo.findByName(bpmnProcessInfoView.getName());
        if (bpmnProcessInfoView.getId() != null) {
            Optional optP = this.bpnmInfoRepo.findById((Object)bpmnProcessInfoView.getId());
            if (optP.isPresent()) {
                bpmnProcessInfo = (BPMNProcessInfo)optP.get();
                if (bpmnProcessInfoOptByName.isPresent() && !((BPMNProcessInfo)bpmnProcessInfoOptByName.get()).getId().equals(bpmnProcessInfo.getId())) {
                    throw new BadRequestAlertException("Name '" + bpmnProcessInfoView.getName() + "' already assigned", "BPMN", "name already used");
                }
            } else {
                if (bpmnProcessInfoOptByName.isPresent()) {
                    throw new BadRequestAlertException("Name '" + bpmnProcessInfoView.getName() + "' already assigned", "BPMN", "name already used");
                }
                bpmnProcessInfo = this.createBPMNProcessInfo(bpmnProcessInfoView, auditList);
            }
        } else {
            if (bpmnProcessInfoOptByName.isPresent()) {
                throw new BadRequestAlertException("Name '" + ((BPMNProcessInfo)bpmnProcessInfoOptByName.get()).getName() + "' already assigned", "pipeline", "name already used");
            }
            bpmnProcessInfo = this.createBPMNProcessInfo(bpmnProcessInfoView, auditList);
        }
        if (!Objects.equals(bpmnProcessInfoView.getName(), bpmnProcessInfo.getName())) {
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_NAME_CHANGED", bpmnProcessInfo.getName(), bpmnProcessInfoView.getName(), bpmnProcessInfo));
            bpmnProcessInfo.setName(bpmnProcessInfoView.getName());
        }
        if (!Objects.equals(bpmnProcessInfoView.getName(), bpmnProcessInfo.getName())) {
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_TYPE_CHANGED", bpmnProcessInfo.getType().toString(), bpmnProcessInfoView.getType().toString(), bpmnProcessInfo));
            bpmnProcessInfo.setType(bpmnProcessInfoView.getType());
        }
        if (!Objects.equals(bpmnProcessInfoView.getAuthor(), bpmnProcessInfo.getAuthor())) {
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_AUTHOR_CHANGED", bpmnProcessInfo.getAuthor(), bpmnProcessInfoView.getAuthor(), bpmnProcessInfo));
            bpmnProcessInfo.setAuthor(bpmnProcessInfoView.getAuthor());
        }
        if (!Objects.equals(bpmnProcessInfoView.getVersion(), bpmnProcessInfo.getVersion())) {
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_VERSION_CHANGED", bpmnProcessInfo.getVersion(), bpmnProcessInfoView.getVersion(), bpmnProcessInfo));
            bpmnProcessInfo.setVersion(bpmnProcessInfoView.getVersion());
        }
        if (!Objects.equals(bpmnProcessInfoView.getProcessId(), bpmnProcessInfo.getProcessId())) {
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_PROCESS_ID_CHANGED", bpmnProcessInfo.getProcessId(), bpmnProcessInfoView.getProcessId(), bpmnProcessInfo));
            bpmnProcessInfo.setProcessId(bpmnProcessInfoView.getProcessId());
        }
        this.handleAttributes(bpmnProcessInfoView.getBpmnProcessAttributes(), auditList, bpmnProcessInfo);
        this.bpnmInfoRepo.save((Object)bpmnProcessInfo);
        return bpmnProcessInfo;
    }

    public void handleAttributes(BPMNProcessAttribute[] bpmnProcessAttributes, List<AuditTrace> auditList, BPMNProcessInfo bpmnProcessInfo) {
        if (bpmnProcessAttributes == null) {
            bpmnProcessAttributes = new BPMNProcessAttribute[]{};
        }
        for (BPMNProcessAttribute attributeNew : bpmnProcessAttributes) {
            if (StringUtils.isBlank((CharSequence)attributeNew.getName())) continue;
            boolean isNewAttribute = true;
            for (BPMNProcessAttribute attributeOld : bpmnProcessInfo.getBpmnProcessAttributes()) {
                if (!attributeNew.getName().equals(attributeOld.getName())) continue;
                if (Boolean.TRUE.equals(attributeNew.getProtectedContent())) {
                    this.changeProtectedAttribute(attributeNew, attributeOld, bpmnProcessInfo, auditList);
                } else {
                    this.changeAttribute(attributeNew, attributeOld, bpmnProcessInfo, auditList);
                }
                isNewAttribute = false;
            }
            if (!isNewAttribute) continue;
            if (Boolean.TRUE.equals(attributeNew.getProtectedContent())) {
                this.changeProtectedAttribute(attributeNew, null, bpmnProcessInfo, auditList);
                continue;
            }
            this.changeAttribute(attributeNew, null, bpmnProcessInfo, auditList);
        }
        LOG.debug("in toBPMNProcessInfo, process attributes");
        for (BPMNProcessAttribute attributeOld : bpmnProcessInfo.getBpmnProcessAttributes()) {
            boolean isDeletedAttribute = true;
            for (BPMNProcessAttribute attributeNew : bpmnProcessAttributes) {
                if (StringUtils.isBlank((CharSequence)attributeNew.getName()) || !attributeNew.getName().equals(attributeOld.getName())) continue;
                isDeletedAttribute = false;
            }
            if (!isDeletedAttribute) continue;
            if (Boolean.TRUE.equals(attributeOld.getProtectedContent())) {
                this.changeProtectedAttribute(null, attributeOld, bpmnProcessInfo, auditList);
                continue;
            }
            this.changeAttribute(null, attributeOld, bpmnProcessInfo, auditList);
        }
    }

    private void changeAttribute(BPMNProcessAttribute attributeNew, BPMNProcessAttribute attributeOld, BPMNProcessInfo bpmnProcessInfo, List<AuditTrace> auditList) {
        if (attributeNew == null) {
            LOG.debug("in changeAttribute, delete {}", (Object)attributeOld.getName());
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeOld.getName(), attributeOld.getValue(), null, bpmnProcessInfo));
            this.bpnmAttributeRepo.delete((Object)attributeOld);
            bpmnProcessInfo.getBpmnProcessAttributes().remove(attributeOld);
        } else if (attributeOld == null) {
            LOG.debug("in changeAttribute, new attribute {}", (Object)attributeNew.getName());
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeNew.getName(), null, attributeNew.getValue(), bpmnProcessInfo));
            attributeNew.setBpmnProcessInfo(bpmnProcessInfo);
            this.bpnmAttributeRepo.save((Object)attributeNew);
            bpmnProcessInfo.getBpmnProcessAttributes().add(attributeNew);
        } else if (!attributeNew.getValue().equals(attributeOld.getValue()) || attributeNew.getProtectedContent() != attributeOld.getProtectedContent()) {
            if (!attributeNew.getValue().equals(attributeOld.getValue())) {
                LOG.debug("in changeAttribute, change {} from '{}' to  '{}'", new Object[]{attributeNew.getName(), attributeOld.getValue(), attributeNew.getValue()});
                attributeOld.setValue(attributeNew.getValue());
            }
            if (attributeNew.getProtectedContent() != attributeOld.getProtectedContent()) {
                LOG.debug("in changeAttribute, change {} protection status from '{}' to  '{}'", new Object[]{attributeNew.getName(), attributeOld.getProtectedContent(), attributeNew.getProtectedContent()});
                attributeOld.setProtectedContent(attributeNew.getProtectedContent());
            }
            this.bpnmAttributeRepo.save((Object)attributeOld);
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeNew.getName(), attributeOld.getValue(), attributeNew.getValue(), bpmnProcessInfo));
        }
        if (attributeOld != null) {
            this.protectedContentUtil.deleteProtectedContent(ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, attributeOld.getId().longValue());
        }
    }

    private void changeProtectedAttribute(BPMNProcessAttribute attributeNew, BPMNProcessAttribute attributeOld, BPMNProcessInfo bpmnProcessInfo, List<AuditTrace> auditList) {
        if (attributeNew == null) {
            LOG.debug("in changeAttribute, delete {}", (Object)attributeOld.getName());
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeOld.getName(), attributeOld.getValue(), null, bpmnProcessInfo));
            this.protectedContentUtil.deleteProtectedContent(ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, attributeOld.getId().longValue());
            bpmnProcessInfo.getBpmnProcessAttributes().remove(attributeOld);
        } else if (attributeOld == null) {
            LOG.debug("in changeAttribute, new attribute {}", (Object)attributeNew.getName());
            String value = attributeNew.getValue();
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeNew.getName(), null, "******", bpmnProcessInfo));
            attributeNew.setValue("******");
            attributeNew.setBpmnProcessInfo(bpmnProcessInfo);
            attributeNew = (BPMNProcessAttribute)this.bpnmAttributeRepo.save((Object)attributeNew);
            bpmnProcessInfo.getBpmnProcessAttributes().add(attributeNew);
            this.protectedContentUtil.createProtectedContent(value, ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, attributeNew.getId().longValue());
        } else if (!attributeNew.getValue().equals("******")) {
            List oldProtectedContents = this.protectedContentUtil.retrieveProtectedContent(ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, attributeOld.getId().longValue());
            if (oldProtectedContents.size() < 1) {
                this.protectedContentUtil.createProtectedContent(attributeNew.getValue(), ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, attributeNew.getId().longValue());
            } else if (oldProtectedContents.size() > 1) {
                LOG.warn("in changeProtectedAttribute, too many old protected contents present ({})!", (Object)oldProtectedContents.size());
                for (int i = 1; i < oldProtectedContents.size(); ++i) {
                    this.protectedContentUtil.deleteProtectedContent((ProtectedContent)oldProtectedContents.get(i));
                }
            }
            ProtectedContent protectedContent = (ProtectedContent)oldProtectedContents.get(0);
            String value = this.protectedContentUtil.unprotectString(protectedContent.getContentBase64());
            if (!attributeNew.getValue().equals(value)) {
                LOG.debug("in changeAttribute, change {} from '{}' to  '{}'", new Object[]{attributeNew.getName(), value, attributeNew.getValue()});
                protectedContent.setContentBase64(this.protectedContentUtil.protectString(attributeNew.getValue()));
            }
            auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_ATTRIBUTE_CHANGED", attributeNew.getName(), attributeOld.getValue(), attributeNew.getValue(), bpmnProcessInfo));
        }
    }

    private BPMNProcessInfo createBPMNProcessInfo(BPMNProcessInfoView bpmnProcessInfoView, List<AuditTrace> auditList) {
        LOG.debug("in createBPMNProcessInfo");
        BPMNProcessInfo bpmnProcessInfo = new BPMNProcessInfo();
        bpmnProcessInfo.setId(bpmnProcessInfoView.getId());
        bpmnProcessInfo.setName(bpmnProcessInfoView.getName());
        bpmnProcessInfo.setType(bpmnProcessInfoView.getType());
        bpmnProcessInfo.setAuthor(bpmnProcessInfoView.getAuthor());
        bpmnProcessInfo.setVersion(bpmnProcessInfoView.getVersion());
        bpmnProcessInfo.setProcessId(bpmnProcessInfoView.getProcessId());
        bpmnProcessInfo.setLastChange(bpmnProcessInfoView.getLastChange());
        bpmnProcessInfo.setBpmnHashBase64(bpmnProcessInfoView.getBpmnHashBase64());
        bpmnProcessInfo.setSignatureBase64(bpmnProcessInfoView.getSignatureBase64());
        if (bpmnProcessInfoView.getBpmnProcessAttributes() == null) {
            bpmnProcessInfoView.setBpmnProcessAttributes(new BPMNProcessAttribute[0]);
        }
        HashSet<BPMNProcessAttribute> bpmnProcessAttributeSet = new HashSet<BPMNProcessAttribute>();
        for (BPMNProcessAttribute attribute : bpmnProcessInfoView.getBpmnProcessAttributes()) {
            bpmnProcessAttributeSet.add(attribute);
            this.bpnmAttributeRepo.save((Object)attribute);
        }
        bpmnProcessInfo.setBpmnProcessAttributes(bpmnProcessAttributeSet);
        this.bpnmInfoRepo.save((Object)bpmnProcessInfo);
        auditList.add(this.auditService.createAuditTraceBPMNProcessInfo("AUDIT_BPMN_CREATED", null, null, bpmnProcessInfo));
        return bpmnProcessInfo;
    }
}

