/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.domain.CertificateComment;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CertificateAttributeRepository;
import de.trustable.ca3s.core.repository.CertificateCommentRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.CRLUpdateInfo;
import de.trustable.ca3s.core.service.dto.KeyAlgoLengthOrSpec;
import de.trustable.ca3s.core.service.util.CRLUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.service.util.RandomUtil;
import de.trustable.ca3s.core.service.util.ReplacementCandidateUtil;
import de.trustable.util.AlgorithmInfo;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import javax.crypto.spec.PBEParameterSpec;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AltSignatureAlgorithm;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectAltPublicKeyInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPublicKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;
import org.bouncycastle.pqc.jcajce.spec.DilithiumParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CertificateUtil {
    private static final String SERIAL_PADDING_PATTERN = "000000000000000000000000000000000000000000000000000000000000000";
    private static final String TIMESTAMP_PADDING_PATTERN = "000000000000000000";
    public static final int CURRENT_ATTRIBUTES_VERSION = 5;
    public static HashMap<String, Integer> nameGeneralNameMap = new HashMap();
    public static HashMap<String, ASN1ObjectIdentifier> nameOIDMap = new HashMap();
    static HashSet<Integer> lenSet = new HashSet();
    private static final Map<ASN1ObjectIdentifier, Integer> dnOrderMap;
    private static final Logger LOG;
    private final CertificateRepository certificateRepository;
    private final CertificateAttributeRepository certificateAttributeRepository;
    private final CertificateCommentRepository certificateCommentRepository;
    private final ProtectedContentRepository protContentRepository;
    private final ProtectedContentUtil protUtil;
    private final PreferenceUtil preferenceUtil;
    private final CryptoService cryptoUtil;
    private final AuditService auditService;
    private final ReplacementCandidateUtil replacementCandidateUtil;

    @Autowired
    public CertificateUtil(CertificateRepository certificateRepository, CertificateAttributeRepository certificateAttributeRepository, CertificateCommentRepository certificateCommentRepository, ProtectedContentRepository protContentRepository, ProtectedContentUtil protUtil, PreferenceUtil preferenceUtil, CryptoService cryptoUtil, AuditService auditService, ReplacementCandidateUtil replacementCandidateUtil) {
        this.certificateRepository = certificateRepository;
        this.certificateAttributeRepository = certificateAttributeRepository;
        this.certificateCommentRepository = certificateCommentRepository;
        this.protContentRepository = protContentRepository;
        this.protUtil = protUtil;
        this.preferenceUtil = preferenceUtil;
        this.cryptoUtil = cryptoUtil;
        this.auditService = auditService;
        this.replacementCandidateUtil = replacementCandidateUtil;
    }

    private static Map<ASN1ObjectIdentifier, Integer> createDnOrderMap() {
        HashMap<ASN1ObjectIdentifier, Integer> orderMap = new HashMap<ASN1ObjectIdentifier, Integer>();
        int count = 0;
        orderMap.put(BCStyle.C, count++);
        orderMap.put(BCStyle.O, count++);
        orderMap.put(BCStyle.OU, count++);
        orderMap.put(BCStyle.CN, count++);
        orderMap.put(BCStyle.L, count++);
        orderMap.put(BCStyle.ST, count++);
        orderMap.put(BCStyle.STREET, count++);
        orderMap.put(BCStyle.DC, count++);
        orderMap.put(BCStyle.UID, count++);
        orderMap.put(BCStyle.E, count++);
        orderMap.put(BCStyle.BUSINESS_CATEGORY, count++);
        orderMap.put(BCStyle.COUNTRY_OF_CITIZENSHIP, count++);
        orderMap.put(BCStyle.COUNTRY_OF_RESIDENCE, count++);
        orderMap.put(BCStyle.DATE_OF_BIRTH, count++);
        orderMap.put(BCStyle.DESCRIPTION, count++);
        orderMap.put(BCStyle.DMD_NAME, count++);
        orderMap.put(BCStyle.DN_QUALIFIER, count++);
        orderMap.put(BCStyle.EmailAddress, count++);
        orderMap.put(BCStyle.GENDER, count++);
        orderMap.put(BCStyle.GENERATION, count++);
        orderMap.put(BCStyle.GIVENNAME, count++);
        orderMap.put(BCStyle.INITIALS, count++);
        orderMap.put(BCStyle.NAME, count++);
        orderMap.put(BCStyle.NAME_AT_BIRTH, count++);
        orderMap.put(BCStyle.ORGANIZATION_IDENTIFIER, count++);
        orderMap.put(BCStyle.PLACE_OF_BIRTH, count++);
        orderMap.put(BCStyle.POSTAL_ADDRESS, count++);
        orderMap.put(BCStyle.POSTAL_CODE, count++);
        orderMap.put(BCStyle.PSEUDONYM, count++);
        orderMap.put(BCStyle.ROLE, count++);
        orderMap.put(BCStyle.SERIALNUMBER, count++);
        orderMap.put(BCStyle.SURNAME, count++);
        orderMap.put(BCStyle.T, count++);
        orderMap.put(BCStyle.TELEPHONE_NUMBER, count++);
        orderMap.put(BCStyle.UNIQUE_IDENTIFIER, count++);
        orderMap.put(BCStyle.UnstructuredAddress, count);
        return Collections.unmodifiableMap(orderMap);
    }

    public Optional<de.trustable.ca3s.core.domain.Certificate> findCertificateById(Long id) {
        return this.certificateRepository.findById((Object)id);
    }

    public static String getNormalizedName(String inputName) throws InvalidNameException {
        if (inputName.trim().isEmpty()) {
            return "";
        }
        try {
            X500Name x500Name = new X500Name(BCStrictStyle.INSTANCE, inputName);
            RDN[] rdNs = x500Name.getRDNs();
            Arrays.sort(rdNs, new /* Unavailable Anonymous Inner Class!! */);
            return new LdapName(new X500Name(rdNs).toString()).toString();
        }
        catch (Exception ex) {
            LOG.error("problem normalizing name : '" + inputName + "'", (Throwable)ex);
            return inputName;
        }
    }

    public void setCertificateComment(de.trustable.ca3s.core.domain.Certificate cert, String comment) {
        String oldCommentText;
        if (cert == null || comment == null) {
            return;
        }
        CertificateComment oldCcomment = cert.getComment() == null ? new CertificateComment() : cert.getComment();
        String string = oldCommentText = oldCcomment.getComment() == null ? "" : oldCcomment.getComment();
        if (!oldCommentText.trim().equals(comment.trim())) {
            oldCcomment.setCertificate(cert);
            oldCcomment.setComment(comment);
            this.certificateCommentRepository.save((Object)oldCcomment);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateAttribute("COMMENT", oldCommentText, comment, cert));
        }
    }

    public X509Certificate getCertifcateFromBase64(String base64Cert) throws CertificateException {
        return this.getCertifcateFromBytes(Base64.decodeBase64((String)base64Cert));
    }

    public X509Certificate getCertifcateFromBytes(byte[] encodedCert) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encodedCert));
    }

    public de.trustable.ca3s.core.domain.Certificate createCertificate(byte[] encodedCert, CSR csr, String executionId, boolean reimport) throws GeneralSecurityException {
        return this.createCertificate(encodedCert, csr, executionId, reimport, null);
    }

    public de.trustable.ca3s.core.domain.Certificate createCertificate(byte[] encodedCert, CSR csr, String executionId, boolean reimport, String importUrl) throws GeneralSecurityException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encodedCert));
            String pemCert = this.cryptoUtil.x509CertToPem(cert);
            return this.createCertificate(pemCert, csr, executionId, reimport, importUrl);
        }
        catch (GeneralSecurityException e) {
            LOG.debug("problem importing certificate: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.debug("problem importing certificate: " + e.getMessage(), (Throwable)e);
            throw new GeneralSecurityException(e);
        }
        catch (Throwable th) {
            LOG.debug("problem importing certificate: " + th.getMessage(), th);
            throw new GeneralSecurityException("problem importing certificate: " + th.getMessage());
        }
    }

    public de.trustable.ca3s.core.domain.Certificate createCertificate(String pemCert, CSR csr, String executionId) throws GeneralSecurityException, IOException {
        return this.createCertificate(pemCert, csr, executionId, false, null);
    }

    public de.trustable.ca3s.core.domain.Certificate createCertificate(String pemCert, CSR csr, String executionId, boolean reimport) throws GeneralSecurityException, IOException {
        return this.createCertificate(pemCert, csr, executionId, reimport, null);
    }

    public de.trustable.ca3s.core.domain.Certificate getCertificateByBase64(String b64Cert) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = this.getCertifcateFromBase64(b64Cert);
        return this.getCertificateByX509(x509Cert);
    }

    public de.trustable.ca3s.core.domain.Certificate getCertificateByPEM(String pemCert) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)pemCert);
        return this.getCertificateByX509(x509Cert);
    }

    public de.trustable.ca3s.core.domain.Certificate getCertificateByX509(X509Certificate x509Cert) throws GeneralSecurityException {
        String tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
        LOG.debug("looking for TBS hash '" + tbsDigestBase64 + "' in certificate store");
        List certList = this.certificateRepository.findByTBSDigest(tbsDigestBase64);
        if (certList.isEmpty()) {
            return null;
        }
        if (certList.size() > 1) {
            LOG.debug("#{} certificates found in certificate database for TBS hash '{}'", (Object)certList.size(), (Object)tbsDigestBase64);
            return (de.trustable.ca3s.core.domain.Certificate)certList.get(0);
        }
        return (de.trustable.ca3s.core.domain.Certificate)certList.get(0);
    }

    public de.trustable.ca3s.core.domain.Certificate getCurrentSCEPRecipient(Pipeline pipeline) {
        LOG.debug("start: getCurrentSCEPRecipient ");
        List certList = this.certificateRepository.findByAttributeValue("CA3S:SCEP_RECIPIENT", "" + pipeline.getId());
        LOG.debug("getCurrentSCEPRecipient #{} found as recipient certificate", (Object)certList.size());
        Instant now = Instant.now();
        de.trustable.ca3s.core.domain.Certificate currentRecipientCert = null;
        for (de.trustable.ca3s.core.domain.Certificate recCert : certList) {
            if (recCert.isRevoked() || !now.isAfter(recCert.getValidFrom()) || !now.isBefore(recCert.getValidTo())) continue;
            if (currentRecipientCert == null) {
                currentRecipientCert = recCert;
                continue;
            }
            if (!recCert.getValidTo().isAfter(currentRecipientCert.getValidTo())) continue;
            currentRecipientCert = recCert;
        }
        return currentRecipientCert;
    }

    public de.trustable.ca3s.core.domain.Certificate createCertificate(String pemCert, CSR csr, String executionId, boolean reimport, String importUrl) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)pemCert);
        de.trustable.ca3s.core.domain.Certificate cert = this.getCertificateByX509(x509Cert);
        if (cert == null) {
            String tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
            cert = this.createCertificate(pemCert, csr, executionId, x509Cert, tbsDigestBase64);
            LOG.info("----------------------- certificate validTo '" + String.valueOf(cert.getValidTo()) + "'.");
            this.setCertAttribute(cert, "SOURCE", importUrl);
        } else {
            LOG.info("certificate '" + cert.getSubject() + "' already exists");
            if (reimport) {
                LOG.debug("existing certificate '" + cert.getSubject() + "' overwriting some attributes, only");
                this.addAdditionalCertificateAttributes(x509Cert, cert);
            }
        }
        return cert;
    }

    private de.trustable.ca3s.core.domain.Certificate createCertificate(String pemCert, CSR csr, String executionId, X509Certificate x509Cert, String tbsDigestBase64) throws CertificateEncodingException, IOException, NoSuchAlgorithmException, CertificateParsingException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        LOG.debug("creating new certificate '" + x509Cert.getSubjectX500Principal().toString() + "'");
        byte[] certBytes = x509Cert.getEncoded();
        X509CertificateHolder x509CertHolder = new X509CertificateHolder(certBytes);
        de.trustable.ca3s.core.domain.Certificate cert = new de.trustable.ca3s.core.domain.Certificate();
        cert.setCertificateAttributes(new HashSet());
        String type = "X509V" + x509Cert.getVersion();
        cert.setType(type);
        String serial = x509Cert.getSerialNumber().toString();
        cert.setSerial(serial);
        cert.setContent(pemCert);
        if (csr != null) {
            cert.setCsr(csr);
        }
        cert.setTbsDigest(tbsDigestBase64);
        String desc = this.cryptoUtil.getDescription(x509Cert);
        cert.setDescription(CryptoService.limitLength((String)desc, (int)250));
        String fingerprint = Base64.encodeBase64String((byte[])CertificateUtil.generateSHA1Fingerprint((byte[])certBytes));
        cert.setFingerprint(fingerprint);
        cert.setValidFrom(DateUtil.asInstant((Date)x509Cert.getNotBefore()));
        cert.setValidTo(DateUtil.asInstant((Date)x509Cert.getNotAfter()));
        Instant instant_1_1_38 = Instant.parse("2038-01-01T01:00:00.00Z");
        if (cert.getValidTo().isAfter(instant_1_1_38)) {
            cert.setValidTo(instant_1_1_38);
        }
        cert.setActive(Boolean.valueOf(true));
        Date now = new Date();
        if (x509Cert.getNotBefore().after(now)) {
            cert.setActive(Boolean.valueOf(false));
        }
        if (x509Cert.getNotAfter().before(now)) {
            cert.setActive(Boolean.valueOf(false));
        }
        cert.setRevokedSince(null);
        cert.setRevocationReason(null);
        cert.setRevoked(Boolean.valueOf(false));
        if (executionId != null) {
            cert.setCreationExecutionId(executionId);
        }
        cert.setContentAddedAt(Instant.now());
        String issuer = CryptoService.limitLength((String)x509Cert.getIssuerX500Principal().toString(), (int)250);
        cert.setIssuer(issuer);
        String subject = CryptoService.limitLength((String)x509Cert.getSubjectX500Principal().toString(), (int)250);
        cert.setSubject(subject);
        cert.setSelfsigned(Boolean.valueOf(false));
        this.certificateRepository.save((Object)cert);
        this.interpretBasicConstraint(x509Cert, cert);
        this.usageAsCertAttributes(x509Cert.getKeyUsage(), cert);
        List<String> extKeyUsageList = x509Cert.getExtendedKeyUsage();
        if (extKeyUsageList != null) {
            for (String extUsage : extKeyUsageList) {
                this.setCertMultiValueAttribute(cert, "EXTENDED_USAGE_OID", extUsage);
                this.setCertMultiValueAttribute(cert, "EXTENDED_USAGE", OidNameMapper.lookupOid((String)extUsage));
            }
        }
        this.setCertAttribute(cert, "ISSUER", issuer.toLowerCase());
        X500Name x500NameIssuer = x509CertHolder.getIssuer();
        this.insertNameAttributes(cert, "ISSUER", x500NameIssuer);
        this.setCertAttribute(cert, "SUBJECT", subject.toLowerCase());
        X500Name x500NameSubject = x509CertHolder.getSubject();
        this.insertNameAttributes(cert, "SUBJECT", x500NameSubject);
        this.setCertAttribute(cert, "TYPE", type);
        JcaX509ExtensionUtils util = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier ski = util.createSubjectKeyIdentifier(x509Cert.getPublicKey());
        String b46Ski = Base64.encodeBase64String((byte[])ski.getKeyIdentifier());
        this.setCertAttribute(cert, "SKI", b46Ski);
        SubjectKeyIdentifier skiTruncated = util.createTruncatedSubjectKeyIdentifier(x509Cert.getPublicKey());
        if (!ski.equals((Object)skiTruncated)) {
            this.setCertAttribute(cert, "SKI", Base64.encodeBase64String((byte[])skiTruncated.getKeyIdentifier()));
        }
        this.setCertAttribute(cert, "SERIAL", serial);
        this.setCertAttribute(cert, "SERIAL_PADDED", CertificateUtil.getPaddedSerial((String)serial));
        this.setCertAttribute(cert, "VALID_FROM_TIMESTAMP", "" + x509Cert.getNotBefore().getTime());
        this.setCertAttribute(cert, "VALID_TO_TIMESTAMP", "" + x509Cert.getNotAfter().getTime());
        long validityPeriod = (x509Cert.getNotAfter().getTime() - x509Cert.getNotBefore().getTime()) / 1000L;
        this.setCertAttribute(cert, "VALIDITY_PERIOD", "" + validityPeriod);
        this.addAdditionalCertificateAttributes(x509Cert, cert);
        this.copyCsrAttributesToCertificate(csr, cert);
        this.certificateRepository.save((Object)cert);
        this.certificateAttributeRepository.saveAll((Iterable)cert.getCertificateAttributes());
        if (x500NameIssuer.equals((Object)x500NameSubject)) {
            x509Cert.verify(x509Cert.getPublicKey());
            cert.setSelfsigned(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:SELFSIGNED", "true");
            cert.setIssuingCertificate(null);
            cert.setRootCertificate(null);
            cert.setRoot(cert.getSubject());
            this.setCertAttribute(cert, "ROOT", cert.getSubject().toLowerCase());
            LOG.debug("certificate '" + x509Cert.getSubjectX500Principal().toString() + "' is selfsigned");
        } else {
            try {
                de.trustable.ca3s.core.domain.Certificate issuingCert = this.findIssuingCertificate(x509CertHolder);
                if (issuingCert == null) {
                    LOG.info("unable to find issuer for non-self-signed certificate '" + x509Cert.getSubjectX500Principal().toString() + "' right now ...");
                } else {
                    cert.setIssuingCertificate(issuingCert);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("certificate '" + x509Cert.getSubjectX500Principal().toString() + "' issued by " + issuingCert.getSubject());
                    }
                }
                de.trustable.ca3s.core.domain.Certificate rootCert = this.findRootCertificate(issuingCert);
                if (rootCert != null) {
                    cert.setRootCertificate(rootCert);
                    cert.setRoot(rootCert.getSubject());
                    this.setCertAttribute(cert, "ROOT", rootCert.getSubject().toLowerCase());
                }
            }
            catch (GeneralSecurityException gse) {
                LOG.info("problem retrieving issuer for certificate '" + x509Cert.getSubjectX500Principal().toString() + "' right now ...");
            }
        }
        this.certificateRepository.save((Object)cert);
        X509Principal principal = PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Cert);
        Vector values = principal.getValues(X509Name.CN);
        String cn = values.size() > 0 ? (String)values.get(0) : null;
        List sanList = this.getCertAttributes(cert, "SAN");
        sanList.addAll(this.getCertAttributes(cert, "TYPED_SAN"));
        sanList.addAll(this.getCertAttributes(cert, "TYPED_VSAN"));
        List replacedCerts = this.replacementCandidateUtil.findReplaceCandidates(Instant.now(), cn, sanList, cert);
        if (replacedCerts.isEmpty()) {
            LOG.debug("certificate id {} does not replace any certificate", (Object)cert.getId());
        } else {
            this.setCertAttribute(cert, "REPLACES_NUMBER_OF_CERTS", (long)replacedCerts.size());
            for (de.trustable.ca3s.core.domain.Certificate replacedCert : replacedCerts) {
                if (cert.equals((Object)replacedCert)) continue;
                LOG.debug("certificate id {} replaces certificate id {}", (Object)cert.getId(), (Object)replacedCert.getId());
                this.setCertMultiValueAttribute(replacedCert, "REPLACED_BY", cert.getId().toString());
                this.certificateAttributeRepository.saveAll((Iterable)replacedCert.getCertificateAttributes());
            }
        }
        this.certificateAttributeRepository.saveAll((Iterable)cert.getCertificateAttributes());
        LOG.debug("certificate id '{}' saved containing #{} attributes", (Object)cert.getId(), (Object)cert.getCertificateAttributes().size());
        for (CertificateAttribute cad : cert.getCertificateAttributes()) {
            LOG.debug("Name '" + cad.getName() + "' got value '" + cad.getValue() + "'");
        }
        return cert;
    }

    public void interpretBasicConstraint(X509Certificate x509Cert, de.trustable.ca3s.core.domain.Certificate cert) {
        int basicConstraint = x509Cert.getBasicConstraints();
        if (Integer.MAX_VALUE == basicConstraint) {
            cert.setEndEntity(Boolean.valueOf(false));
            this.setCertAttribute(cert, "CA3S:CA", "true");
        } else if (-1 == basicConstraint) {
            cert.setEndEntity(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:END_ENTITY", "true");
        } else {
            cert.setEndEntity(Boolean.valueOf(false));
            this.setCertAttribute(cert, "CA3S:CA", "true");
            this.setCertAttribute(cert, "CA3S:CHAIN_LENGTH", "" + basicConstraint);
        }
    }

    private void copyCsrAttributesToCertificate(CSR csr, de.trustable.ca3s.core.domain.Certificate cert) {
        if (csr == null || cert == null) {
            return;
        }
        cert.setTenant(csr.getTenant());
        if (!StringUtils.isBlank((String)csr.getRequestedBy())) {
            this.setCertAttribute(cert, "REQUESTED_BY", csr.getRequestedBy());
        }
        if (csr.getComment() != null && !StringUtils.isBlank((String)csr.getComment().getComment())) {
            this.setCertificateComment(cert, csr.getComment().getComment());
        }
        for (CsrAttribute csrAttr : csr.getCsrAttributes()) {
            if (!csrAttr.getName().startsWith("_ARA_")) continue;
            this.setCertAttribute(cert, csrAttr.getName(), csrAttr.getValue());
        }
    }

    public void addAdditionalCertificateAttributes(X509Certificate x509Cert, de.trustable.ca3s.core.domain.Certificate cert) throws CertificateParsingException, IOException {
        int version = Integer.parseInt(this.getCertAttribute(cert, "ATTRIBUTES_VERSION", "0"));
        if (version == 0) {
            Collection<List<?>> altNames;
            block36: {
                String keyAlgName = KeyAlgoLengthOrSpec.getAlgorithmName((PublicKey)x509Cert.getPublicKey());
                cert.setKeyAlgorithm(keyAlgName.toLowerCase());
                RDN[] algorithmInfo = new AlgorithmInfo(x509Cert.getSigAlgName());
                cert.setHashingAlgorithm(algorithmInfo.getHashAlgName());
                cert.setPaddingAlgorithm(algorithmInfo.getPaddingAlgName());
                cert.setSigningAlgorithm(algorithmInfo.getSigAlgName());
                try {
                    String curveName = CertificateUtil.deriveCurveName((PublicKey)x509Cert.getPublicKey());
                    LOG.info("found curve name " + curveName + " for certificate '" + x509Cert.getSubjectX500Principal().toString() + "' with key algo " + keyAlgName);
                    cert.setCurveName(curveName.toLowerCase());
                }
                catch (GeneralSecurityException e) {
                    if (!keyAlgName.contains("ec")) break block36;
                    LOG.info("unable to derive curve name for certificate '" + x509Cert.getSubjectX500Principal().toString() + "' with key algo " + keyAlgName);
                }
            }
            String subject = x509Cert.getSubjectX500Principal().toString();
            if (subject != null && subject.trim().length() > 0) {
                try {
                    InetAddressValidator inv = InetAddressValidator.getInstance();
                    List<Rdn> rdnList = new LdapName(subject).getRdns();
                    for (Rdn rdn : rdnList) {
                        if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                        String cn = rdn.getValue().toString();
                        if (inv.isValid(cn)) {
                            LOG.debug("CN found IP in subject: '{}'", (Object)cn);
                            this.setCertMultiValueAttribute(cert, "TYPED_VSAN", "IP:" + cn);
                            continue;
                        }
                        LOG.debug("CN found DNS name in subject: '{}'", (Object)cn);
                        this.setCertMultiValueAttribute(cert, "TYPED_VSAN", "DNS:" + cn);
                    }
                }
                catch (InvalidNameException e) {
                    e.printStackTrace();
                }
            }
            Object allSans = "";
            if (x509Cert.getSubjectAlternativeNames() != null && (altNames = x509Cert.getSubjectAlternativeNames()) != null) {
                for (List list : altNames) {
                    int altNameType = (Integer)list.get(0);
                    String sanValue = "";
                    if (list.get(1) instanceof String) {
                        sanValue = ((String)list.get(1)).toLowerCase();
                    } else if (0 != altNameType) {
                        if (list.get(1) instanceof byte[]) {
                            sanValue = new String((byte[])list.get(1)).toLowerCase();
                        } else {
                            LOG.info("unexpected content type in SANS : {}", (Object)list.get(1).toString());
                        }
                    }
                    if (((String)allSans).length() > 0) {
                        allSans = (String)allSans + ";";
                    }
                    allSans = (String)allSans + sanValue;
                    this.setCertMultiValueAttribute(cert, "SAN", sanValue);
                    this.setCertMultiValueAttribute(cert, "TYPED_SAN", CertificateUtil.getTypedSAN((int)altNameType, (String)sanValue));
                }
            }
            cert.setSans(CryptoUtil.limitLength((String)allSans, (int)250));
            int keyLength = CertificateUtil.getAlignedKeyLength((PublicKey)x509Cert.getPublicKey());
            cert.setKeyLength(Integer.valueOf(keyLength));
            List crlUrls = this.getCrlDistributionPoints(x509Cert);
            for (String crlUrl : crlUrls) {
                this.setCertAttribute(cert, "CRL_URL", crlUrl);
            }
            String string = this.getOCSPUrl(x509Cert);
            if (string != null) {
                this.setCertAttribute(cert, "OCSP_URL", string);
            }
            List certificatePolicyIds = this.getCertificatePolicies(x509Cert);
            for (String polId : certificatePolicyIds) {
                this.setCertAttribute(cert, "POLICY_ID", polId);
            }
        }
        if (version < 2) {
            try {
                this.setCertAttribute(cert, "FINGERPRINT_SHA1", DigestUtils.sha1Hex((byte[])x509Cert.getEncoded()).toLowerCase());
                this.setCertAttribute(cert, "FINGERPRINT_SHA256", DigestUtils.sha256Hex((byte[])x509Cert.getEncoded()).toLowerCase());
            }
            catch (CertificateEncodingException e) {
                LOG.error("Problem getting encoded certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)e);
            }
            try {
                if (!cert.getSubject().trim().isEmpty()) {
                    X500Name x500Name = new X500Name(cert.getSubject());
                    for (RDN rdn : x500Name.getRDNs()) {
                        AttributeTypeAndValue[] attrTVArr;
                        for (AttributeTypeAndValue attrTV : attrTVArr = rdn.getTypesAndValues()) {
                            String rdnReadableName = OidNameMapper.lookupOid((String)attrTV.getType().toString());
                            this.setCertAttribute(cert, "RDN_" + rdnReadableName.toUpperCase(), attrTV.getValue().toString());
                        }
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Problem building X500Name for subject for certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)iae);
            }
        }
        if (version < 4) {
            try {
                String subjectRfc2253 = CertificateUtil.getNormalizedName((String)cert.getSubject());
                this.setCertAttribute(cert, "SUBJECT_RFC_2253", subjectRfc2253, false);
            }
            catch (InvalidNameException e) {
                LOG.error("Problem building RFC 2253-styled subject for  certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)e);
            }
        }
        if (version < 5) {
            try {
                JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(x509Cert);
                AltSignatureAlgorithm altSignatureAlgorithm = AltSignatureAlgorithm.fromExtensions((Extensions)certHolder.getExtensions());
                if (altSignatureAlgorithm != null) {
                    this.setCertAttribute(cert, "ALT_ALGO", OidNameMapper.lookupOid((String)altSignatureAlgorithm.getAlgorithm().getAlgorithm().toString()), false);
                } else {
                    SubjectAltPublicKeyInfo subjectAltPublicKeyInfo = SubjectAltPublicKeyInfo.fromExtensions((Extensions)certHolder.getExtensions());
                    if (subjectAltPublicKeyInfo != null) {
                        this.setCertAttribute(cert, "ALT_ALGO", OidNameMapper.lookupOid((String)subjectAltPublicKeyInfo.getAlgorithm().getAlgorithm().toString()), false);
                    }
                }
            }
            catch (CertificateEncodingException e) {
                LOG.error("Problem building X509CertificateHolder for certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)e);
            }
            this.setCertAttribute(cert, "ATTRIBUTES_VERSION", "5", false);
        }
    }

    public List<String> getCertificatePolicies(X509Certificate x509Cert) {
        ArrayList<String> certificatePolicyIds = new ArrayList<String>();
        byte[] extVal = x509Cert.getExtensionValue(Extension.certificatePolicies.getId());
        if (extVal == null) {
            return certificatePolicyIds;
        }
        try {
            PolicyInformation[] information;
            CertificatePolicies cf = CertificatePolicies.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extVal));
            for (PolicyInformation p : information = cf.getPolicyInformation()) {
                ASN1ObjectIdentifier aIdentifier = p.getPolicyIdentifier();
                certificatePolicyIds.add(aIdentifier.getId());
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to get OCSP URL for certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)ex);
        }
        return certificatePolicyIds;
    }

    private String getOCSPUrl(X509Certificate x509Cert) {
        AccessDescription[] accessDescriptions;
        ASN1Primitive obj;
        try {
            obj = CertificateUtil.getExtensionValue((X509Certificate)x509Cert, (String)Extension.authorityInfoAccess.getId());
        }
        catch (IOException ex) {
            LOG.error("Failed to get OCSP URL for certificate '" + x509Cert.getSubjectX500Principal().toString() + "'", (Throwable)ex);
            return null;
        }
        if (obj == null) {
            return null;
        }
        AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)obj);
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName name;
            boolean correctAccessMethod = accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.ocspAccessMethod);
            if (!correctAccessMethod || (name = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
            return name.getName().toString();
        }
        return null;
    }

    private static ASN1Primitive getExtensionValue(X509Certificate x509Cert, String oid) throws IOException {
        byte[] bytes = x509Cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    public static String getSAN(GeneralName gn) {
        if (7 == gn.getTagNo()) {
            DEROctetString derOctetString = (DEROctetString)gn.getName();
            try {
                InetAddress addr = InetAddress.getByAddress(derOctetString.getOctets());
                return addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.debug("Problem parsing ip address '" + gn.getName().toString() + "'!", (Object)e.getLocalizedMessage());
                return CertificateUtil.getTypedSAN((int)gn.getTagNo(), (String)gn.getName().toString());
            }
        }
        return CertificateUtil.getTypedSAN((int)gn.getTagNo(), (String)gn.getName().toString());
    }

    public static String getTypedSAN(GeneralName gn) {
        if (7 == gn.getTagNo()) {
            DEROctetString derOctetString = (DEROctetString)gn.getName();
            try {
                InetAddress addr = InetAddress.getByAddress(derOctetString.getOctets());
                return CertificateUtil.getTypedSAN((int)gn.getTagNo(), (String)addr.getHostAddress());
            }
            catch (UnknownHostException e) {
                LOG.debug("Problem parsing ip address '" + gn.getName().toString() + "'!", (Object)e.getLocalizedMessage());
                return CertificateUtil.getTypedSAN((int)gn.getTagNo(), (String)gn.getName().toString());
            }
        }
        return CertificateUtil.getTypedSAN((int)gn.getTagNo(), (String)gn.getName().toString());
    }

    public static String getTypedSAN(int altNameType, String sanValue) {
        if (2 == altNameType) {
            return "DNS:" + sanValue;
        }
        if (7 == altNameType) {
            return "IP:" + sanValue;
        }
        if (5 == altNameType) {
            return "EDI:" + sanValue;
        }
        if (0 == altNameType) {
            return "other:" + sanValue;
        }
        if (8 == altNameType) {
            return "regID:" + sanValue;
        }
        if (1 == altNameType) {
            return "rfc822:" + sanValue;
        }
        if (6 == altNameType) {
            return "URI:" + sanValue;
        }
        if (3 == altNameType) {
            return "X400:" + sanValue;
        }
        if (4 == altNameType) {
            return "DirName:" + sanValue;
        }
        LOG.warn("unexpected name / tag '{}' in SANs for san {}", (Object)altNameType, (Object)sanValue);
        return "Unknown:" + sanValue;
    }

    public static GeneralName getGeneralNameFromTypedSAN(String typedSAN) {
        int type = 2;
        if (typedSAN.startsWith("DNS:")) {
            type = 2;
        } else if (typedSAN.startsWith("IP:")) {
            type = 7;
        } else if (typedSAN.startsWith("EDI:")) {
            type = 5;
        } else if (typedSAN.startsWith("other:")) {
            type = 0;
        } else if (typedSAN.startsWith("regID:")) {
            type = 8;
        } else if (typedSAN.startsWith("rfc822:")) {
            type = 1;
        } else if (typedSAN.startsWith("URI:")) {
            type = 6;
        } else if (typedSAN.startsWith("X400:")) {
            type = 3;
        } else if (typedSAN.startsWith("DirName:")) {
            type = 4;
        } else {
            LOG.warn("unexpected type in TypedSANs for san {}", (Object)typedSAN);
        }
        String[] valueArr = typedSAN.split(":");
        if (valueArr != null && valueArr.length == 2) {
            return new GeneralName(type, valueArr[1].toLowerCase(Locale.ROOT));
        }
        LOG.warn("unexpected value in TypedSANs for san {}", (Object)typedSAN);
        return null;
    }

    public static String getAlgoName(Pkcs10RequestHolder p10ReqHolder) {
        String algoName = p10ReqHolder.getSigningAlgorithmName().toLowerCase(Locale.ROOT);
        if (algoName.contains("withrsaencryption")) {
            return "rsa";
        }
        if (algoName.contains("with")) {
            algoName = algoName.split("with")[0];
        }
        return algoName;
    }

    public static int getAlignedKeyLength(PublicKey pk) {
        int keyLength = CertificateUtil.getKeyLength((PublicKey)pk);
        if (lenSet.contains(keyLength + 1)) {
            return keyLength + 1;
        }
        if (lenSet.contains(keyLength + 2)) {
            return keyLength + 2;
        }
        return keyLength;
    }

    public static boolean isHashRequired(String algoName) {
        String algoNameLC = algoName.toLowerCase();
        return !algoNameLC.startsWith("dilithium") && !algoNameLC.startsWith("falcon");
    }

    public static int getKeyLength(PublicKey pk) {
        int len = -1;
        LOG.debug("getKeyLength() for {}", (Object)pk.getClass().getName());
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof JCEECPublicKey) {
            JCEECPublicKey ecpriv = (JCEECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec spec = ecpriv.getParameters();
            len = spec != null ? spec.getN().bitLength() : 0;
        } else if (pk instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey ecpriv = (java.security.interfaces.ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        } else if (pk instanceof EdDSAPublicKey) {
            len = 256;
        } else if (pk instanceof BCDilithiumPublicKey) {
            BCDilithiumPublicKey dilPubKey = (BCDilithiumPublicKey)pk;
            if (DilithiumParameterSpec.dilithium2.equals(dilPubKey.getParameterSpec())) {
                len = 20224;
            } else if (DilithiumParameterSpec.dilithium3.equals(dilPubKey.getParameterSpec())) {
                len = 32000;
            } else if (DilithiumParameterSpec.dilithium5.equals(dilPubKey.getParameterSpec())) {
                len = 38912;
            } else {
                LOG.warn("getKeyLength(): unexpected dilithium parameterSpec {}", (Object)dilPubKey.getParameterSpec().getClass().getName());
            }
        } else if (pk instanceof BCFalconPublicKey) {
            BCFalconPublicKey falconPubKey = (BCFalconPublicKey)pk;
            if (FalconParameterSpec.falcon_512.equals(falconPubKey.getParameterSpec())) {
                len = 7176;
            } else if (FalconParameterSpec.falcon_1024.equals(falconPubKey.getParameterSpec())) {
                len = 14344;
            } else {
                LOG.warn("getKeyLength(): unexpected falcon parameterSpec {}", (Object)falconPubKey.getParameterSpec().getClass().getName());
            }
        }
        return len;
    }

    public static String deriveCurveName(org.bouncycastle.jce.spec.ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        Enumeration names = ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            X9ECParameters params = ECNamedCurveTable.getByName((String)name);
            if (!params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return name;
        }
        throw new GeneralSecurityException("Could not find name for curve");
    }

    public static String deriveCurveName(PublicKey publicKey) throws GeneralSecurityException {
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey pk = (java.security.interfaces.ECPublicKey)publicKey;
            ECParameterSpec params = pk.getParams();
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)EC5Util.convertSpec((ECParameterSpec)params));
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey pk = (ECPublicKey)publicKey;
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)pk.getParameters());
        }
        throw new GeneralSecurityException("Can only be used with instances of ECPublicKey (either jce or bc implementation)");
    }

    public static String deriveCurveName(PrivateKey privateKey) throws GeneralSecurityException {
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey pk = (java.security.interfaces.ECPrivateKey)privateKey;
            ECParameterSpec params = pk.getParams();
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)EC5Util.convertSpec((ECParameterSpec)params));
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey pk = (ECPrivateKey)privateKey;
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)pk.getParameters());
        }
        throw new GeneralSecurityException("Can only be used with instances of ECPrivateKey (either jce or bc implementation)");
    }

    public void insertNameAttributes(de.trustable.ca3s.core.domain.Certificate cert, String attributeName, X500Name x500NameSubject) {
        try {
            List<Rdn> rdnList = new LdapName(x500NameSubject.toString()).getRdns();
            for (Rdn rdn : rdnList) {
                String rdnExpression = rdn.getType().toLowerCase() + "=" + rdn.getValue().toString().toLowerCase().trim();
                this.setCertMultiValueAttribute(cert, attributeName, rdnExpression);
            }
        }
        catch (InvalidNameException e) {
            LOG.info("problem parsing RDN for {}", (Object)x500NameSubject);
        }
        for (RDN rdn : x500NameSubject.getRDNs()) {
            for (AttributeTypeAndValue atv : rdn.getTypesAndValues()) {
                String value = atv.getValue().toString().toLowerCase().trim();
                this.setCertMultiValueAttribute(cert, attributeName, value);
                String oid = atv.getType().getId().toLowerCase();
                this.setCertMultiValueAttribute(cert, attributeName, oid + "=" + value);
                if (oid.equals(atv.getType().toString().toLowerCase())) continue;
                this.setCertMultiValueAttribute(cert, attributeName, atv.getType().toString().toLowerCase() + "=" + value);
            }
        }
    }

    public String getCertAttribute(de.trustable.ca3s.core.domain.Certificate certDao, String name, String defaultValue) {
        String value = this.getCertAttribute(certDao, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getCertAttribute(de.trustable.ca3s.core.domain.Certificate certDao, String name) {
        for (CertificateAttribute certAttr : certDao.getCertificateAttributes()) {
            if (!certAttr.getName().equals(name)) continue;
            return certAttr.getValue();
        }
        return null;
    }

    @Transactional
    public void deleteCertAttribute(de.trustable.ca3s.core.domain.Certificate certDao, String name) {
        for (CertificateAttribute certAttr : certDao.getCertificateAttributes()) {
            if (!certAttr.getName().equals(name)) continue;
            LOG.info("deleting certificateAttribute {}", (Object)certAttr);
            this.certificateAttributeRepository.delete((Object)certAttr);
        }
    }

    public List<String> getCertAttributes(de.trustable.ca3s.core.domain.Certificate certDao, String name) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (CertificateAttribute certAttr : certDao.getCertificateAttributes()) {
            if (!certAttr.getName().equals(name)) continue;
            stringList.add(certAttr.getValue());
        }
        return stringList;
    }

    public void setCertAttribute(de.trustable.ca3s.core.domain.Certificate certDao, String name, long value) {
        this.setCertAttribute(certDao, name, Long.toString(value));
    }

    public void setCertMultiValueAttribute(de.trustable.ca3s.core.domain.Certificate cert, String name, String value) {
        this.setCertAttribute(cert, name, value, true);
    }

    public void setCertAttribute(de.trustable.ca3s.core.domain.Certificate cert, String name, String value) {
        this.setCertAttribute(cert, name, value, true);
    }

    public void setCertAttribute(de.trustable.ca3s.core.domain.Certificate cert, String name, String value, boolean multiValue) {
        if (name == null) {
            LOG.warn("no use to insert attribute with name 'null'", (Throwable)new Exception());
            return;
        }
        if (value == null) {
            value = "";
        }
        value = CryptoUtil.limitLength((String)value, (int)250);
        Set certAttrList = cert.getCertificateAttributes();
        for (CertificateAttribute certAttr : certAttrList) {
            if (!name.equals(certAttr.getName())) continue;
            if (value.equalsIgnoreCase(certAttr.getValue())) {
                return;
            }
            if (multiValue) continue;
            certAttr.setValue(value);
            return;
        }
        CertificateAttribute cAtt = new CertificateAttribute();
        cAtt.setCertificate(cert);
        cAtt.setName(name);
        cAtt.setValue(value);
        cert.getCertificateAttributes().add(cAtt);
        this.certificateAttributeRepository.save((Object)cAtt);
    }

    public List<de.trustable.ca3s.core.domain.Certificate> getCertificateChain(de.trustable.ca3s.core.domain.Certificate startCertDao) throws GeneralSecurityException {
        int MAX_CHAIN_LENGTH = 10;
        ArrayList<de.trustable.ca3s.core.domain.Certificate> certChain = new ArrayList<de.trustable.ca3s.core.domain.Certificate>();
        de.trustable.ca3s.core.domain.Certificate certDao = startCertDao;
        LOG.debug("added end entity cert id {} to the chain", (Object)certDao.getId());
        certChain.add(certDao);
        for (int i = 0; i <= MAX_CHAIN_LENGTH; ++i) {
            de.trustable.ca3s.core.domain.Certificate issuingCertDao;
            if (certDao.isSelfsigned()) {
                LOG.debug("certificate chain ended with selfsigned cert: {}", (Object)certDao.getDescription());
                break;
            }
            if (i == MAX_CHAIN_LENGTH) {
                String msg = "maximum chain length ecxeeded for  cert id : " + startCertDao.getId();
                LOG.info(msg);
                throw new GeneralSecurityException(msg);
            }
            try {
                issuingCertDao = this.findIssuingCertificate(certDao);
                if (issuingCertDao == null) {
                    String msg = "no issuing certificate available / retrievable for cert id : " + certDao.getId();
                    LOG.info(msg);
                    throw new GeneralSecurityException(msg);
                }
                LOG.debug("added issuing cert id {} to the chain", (Object)issuingCertDao.getId());
                certChain.add(issuingCertDao);
            }
            catch (GeneralSecurityException e) {
                String msg = "Error retrieving issuing certificate for cert id : " + certDao.getId();
                LOG.info(msg);
                throw new GeneralSecurityException(msg);
            }
            if (issuingCertDao.getIssuingCertificate() == null) {
                String msg = "no issuing certificate available / retrievable for issuing cert id : " + issuingCertDao.getId();
                LOG.info(msg);
                break;
            }
            if (certDao.isSelfsigned() || issuingCertDao.getId().equals(issuingCertDao.getIssuingCertificate().getId())) {
                LOG.debug("certificate chain complete, cert id '{}' is selfsigned", (Object)issuingCertDao.getId());
                break;
            }
            certDao = issuingCertDao;
        }
        return certChain;
    }

    public X509Certificate[] getX509CertificateChain(de.trustable.ca3s.core.domain.Certificate startCert) throws GeneralSecurityException {
        List certList = this.getCertificateChain(startCert);
        X509Certificate[] chainArr = new X509Certificate[certList.size()];
        for (int i = 0; i < certList.size(); ++i) {
            X509Certificate x509Cert;
            chainArr[i] = x509Cert = CryptoService.convertPemToCertificate((String)((de.trustable.ca3s.core.domain.Certificate)certList.get(i)).getContent());
        }
        return chainArr;
    }

    public List<X509Certificate> getX509CertificateChainAsList(de.trustable.ca3s.core.domain.Certificate startCert) throws GeneralSecurityException {
        List certList = this.getCertificateChain(startCert);
        ArrayList<X509Certificate> x509chainList = new ArrayList<X509Certificate>();
        for (int i = 0; i < certList.size(); ++i) {
            X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)((de.trustable.ca3s.core.domain.Certificate)certList.get(i)).getContent());
            x509chainList.add(x509Cert);
        }
        return x509chainList;
    }

    public static String getPaddedSerial(String serial) {
        if (serial == null) {
            return "000000000000000000000000000000000000000000000000000000000000000";
        }
        int len = serial.length();
        if (len >= "000000000000000000000000000000000000000000000000000000000000000".length()) {
            return serial;
        }
        return "000000000000000000000000000000000000000000000000000000000000000".substring(serial.length()) + serial;
    }

    public static String getPaddedTimestamp(String timestamp) {
        if (timestamp == null) {
            return "000000000000000000";
        }
        int len = timestamp.length();
        if (len >= "000000000000000000".length()) {
            return timestamp;
        }
        return "000000000000000000".substring(timestamp.length()) + timestamp;
    }

    public static byte[] generateSHA1Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error("SHA1 algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static String usageAsString(boolean[] usage) {
        if (usage == null || usage.length == 0) {
            return "unspecified usage";
        }
        Object desc = "valid for ";
        if (usage[0]) {
            desc = (String)desc + "digitalSignature ";
        }
        if (usage.length > 1 && usage[1]) {
            desc = (String)desc + "nonRepudiation ";
        }
        if (usage.length > 2 && usage[2]) {
            desc = (String)desc + "keyEncipherment ";
        }
        if (usage.length > 3 && usage[3]) {
            desc = (String)desc + "dataEncipherment ";
        }
        if (usage.length > 4 && usage[4]) {
            desc = (String)desc + "keyAgreement ";
        }
        if (usage.length > 5 && usage[5]) {
            desc = (String)desc + "keyCertSign ";
        }
        if (usage.length > 6 && usage[6]) {
            desc = (String)desc + "cRLSign ";
        }
        if (usage.length > 7 && usage[7]) {
            desc = (String)desc + "encipherOnly ";
        }
        if (usage.length > 8 && usage[8]) {
            desc = (String)desc + "decipherOnly ";
        }
        return desc;
    }

    public void usageAsCertAttributes(boolean[] usage, de.trustable.ca3s.core.domain.Certificate cert) {
        if (usage == null || usage.length == 0) {
            this.setCertAttribute(cert, "USAGE", "unspecified");
            return;
        }
        if (usage[0]) {
            this.setCertAttribute(cert, "USAGE", "digitalSignature");
        }
        if (usage.length > 1 && usage[1]) {
            this.setCertAttribute(cert, "USAGE", "nonRepudiation");
        }
        if (usage.length > 2 && usage[2]) {
            this.setCertAttribute(cert, "USAGE", "keyEncipherment");
        }
        if (usage.length > 3 && usage[3]) {
            this.setCertAttribute(cert, "USAGE", "dataEncipherment");
        }
        if (usage.length > 4 && usage[4]) {
            this.setCertAttribute(cert, "USAGE", "keyAgreement");
        }
        if (usage.length > 5 && usage[5]) {
            this.setCertAttribute(cert, "USAGE", "keyCertSign");
        }
        if (usage.length > 6 && usage[6]) {
            this.setCertAttribute(cert, "USAGE", "cRLSign");
        }
        if (usage.length > 7 && usage[7]) {
            this.setCertAttribute(cert, "USAGE", "encipherOnly");
        }
        if (usage.length > 8 && usage[8]) {
            this.setCertAttribute(cert, "USAGE", "decipherOnly");
        }
    }

    public de.trustable.ca3s.core.domain.Certificate findIssuingCertificate(de.trustable.ca3s.core.domain.Certificate cert) throws GeneralSecurityException {
        if (cert.isSelfsigned()) {
            return cert;
        }
        de.trustable.ca3s.core.domain.Certificate issuingCert = cert.getIssuingCertificate();
        if (issuingCert == null) {
            issuingCert = this.findIssuingCertificate(CertificateUtil.convertPemToCertificateHolder((String)cert.getContent()));
            if (issuingCert != null) {
                if (issuingCert.equals((Object)cert)) {
                    LOG.warn("found untagged self-signed certificate id '{}', '{}'", (Object)cert.getId(), (Object)cert.getDescription());
                    return cert;
                }
                cert.setIssuingCertificate(issuingCert);
                this.certificateRepository.save((Object)cert);
            } else {
                LOG.debug("not able to find and store issuing certificate for '" + cert.getDescription() + "'");
            }
        }
        return issuingCert;
    }

    public static X509CertificateHolder convertPemToCertificateHolder(String pem) throws GeneralSecurityException {
        X509Certificate x509Cert = CertificateUtil.convertPemToCertificate((String)pem);
        try {
            return new X509CertificateHolder(x509Cert.getEncoded());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static X509Certificate convertPemToCertificate(String pem) throws GeneralSecurityException {
        X509Certificate cert;
        block11: {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                if (parsedObj instanceof X509CertificateHolder) {
                    cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)parsedObj);
                    break block11;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOG.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOG.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return cert;
    }

    public PrivateKey convertPemToPrivateKey(String pem) throws GeneralSecurityException {
        PrivateKey privKey;
        block11: {
            ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                if (parsedObj instanceof PrivateKeyInfo) {
                    privKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey((PrivateKeyInfo)parsedObj);
                    break block11;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOG.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOG.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return privKey;
    }

    public de.trustable.ca3s.core.domain.Certificate findIssuingCertificate(X509CertificateHolder x509CertHolder) throws GeneralSecurityException {
        AuthorityKeyIdentifier aki;
        Objects.requireNonNull(x509CertHolder, "x509CertHolder can't be null");
        List rawIssuingCertList = new ArrayList();
        if (x509CertHolder.getExtensions() != null && (aki = AuthorityKeyIdentifier.fromExtensions((Extensions)x509CertHolder.getExtensions())) != null) {
            rawIssuingCertList = this.findCertsByAKI(x509CertHolder, aki);
        }
        if (rawIssuingCertList.isEmpty()) {
            LOG.debug("AKI from crt extension failed, trying to find issuer name");
            rawIssuingCertList = this.certificateRepository.findCACertByIssuer(x509CertHolder.getIssuer().toString());
            if (rawIssuingCertList.isEmpty()) {
                try {
                    X509Certificate x509Cert = this.getCertifcateFromBytes(x509CertHolder.getEncoded());
                    rawIssuingCertList = this.certificateRepository.findCACertByIssuer(x509Cert.getIssuerX500Principal().getName());
                }
                catch (IOException e) {
                    LOG.info("problem parsing certificate '{}' from holder", (Object)x509CertHolder.getSubject().toString());
                }
            }
            if (rawIssuingCertList.size() > 1) {
                LOG.debug("more than one issuer found by matching issuer name '{}'", (Object)x509CertHolder.getIssuer().toString());
            }
        }
        if (rawIssuingCertList.isEmpty()) {
            throw new GeneralSecurityException("no issuing certificate for '" + x509CertHolder.getSubject().toString() + "' in certificate store.");
        }
        List<Object> issuingCertList = rawIssuingCertList;
        if (issuingCertList.size() > 1) {
            Date notBefore = x509CertHolder.getNotBefore();
            ArrayList<de.trustable.ca3s.core.domain.Certificate> issuingCertListChecked = new ArrayList<de.trustable.ca3s.core.domain.Certificate>();
            for (de.trustable.ca3s.core.domain.Certificate issuer : issuingCertList) {
                if (issuer.isRevoked() && notBefore.after(DateUtil.asDate((Instant)issuer.getRevokedSince()))) {
                    LOG.debug("issuer {} was revoked on {}", (Object)issuer.getId(), (Object)notBefore);
                    continue;
                }
                if (notBefore.after(DateUtil.asDate((Instant)issuer.getValidTo()))) {
                    LOG.debug("issuer {} was already expired on {}", (Object)issuer.getId(), (Object)notBefore);
                    continue;
                }
                if (notBefore.before(DateUtil.asDate((Instant)issuer.getValidFrom()))) {
                    LOG.debug("issuer {} was not yet valid on {}", (Object)issuer.getId(), (Object)notBefore);
                    continue;
                }
                if (issuer.isEndEntity()) {
                    LOG.debug("probable issuer {} is an end entity, ignoring as issuer", (Object)issuer.getId());
                    continue;
                }
                X509CertificateHolder x509CertHolderIssuer = this.cryptoUtil.convertPemToCertificateHolder(issuer.getContent());
                try {
                    ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().build(x509CertHolderIssuer);
                    if (x509CertHolder.isSignatureValid(contentVerifierProvider)) {
                        issuingCertListChecked.add(issuer);
                        continue;
                    }
                    LOG.warn("probable issuer {} does not verify certificate {}, ignoring as issuer", (Object)issuer.getId(), (Object)x509CertHolder.getSubject().toString());
                }
                catch (CertException | OperatorCreationException e) {
                    LOG.warn("probable issuer {} not a valid certificate: {}", (Object)issuer.getId(), (Object)e.getMessage());
                }
            }
            issuingCertList = issuingCertListChecked;
            if (issuingCertList.size() > 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("more than one issuer found ");
                    for (de.trustable.ca3s.core.domain.Certificate issuer : issuingCertList) {
                        LOG.warn("possible issuer id '{}' subject '{}'", (Object)issuer.getId(), (Object)issuer.getSubject());
                    }
                }
                throw new GeneralSecurityException("more than one (" + issuingCertList.size() + ") issuing certificate for '" + x509CertHolder.getSubject().toString() + "' in certificate store.");
            }
        }
        de.trustable.ca3s.core.domain.Certificate issuerDao = (de.trustable.ca3s.core.domain.Certificate)issuingCertList.iterator().next();
        if (LOG.isDebugEnabled()) {
            // empty if block
        }
        return issuerDao;
    }

    private de.trustable.ca3s.core.domain.Certificate findRootCertificate(de.trustable.ca3s.core.domain.Certificate cert) throws GeneralSecurityException {
        for (int i = 0; i < 10; ++i) {
            if (cert.isSelfsigned()) {
                return cert;
            }
            de.trustable.ca3s.core.domain.Certificate issuingCert = cert.getIssuingCertificate();
            if (issuingCert == null) {
                issuingCert = this.findIssuingCertificate(cert);
                if (issuingCert == null) break;
                cert.setIssuingCertificate(issuingCert);
                this.certificateRepository.save((Object)cert);
                LOG.debug("determined issuing certificate {} for {}", (Object)issuingCert.getId(), (Object)cert.getId());
            }
            cert = issuingCert;
        }
        LOG.info("unable to determined issuing certificate for {}", (Object)cert.getId());
        return null;
    }

    private List<de.trustable.ca3s.core.domain.Certificate> findCertsByAKI(X509CertificateHolder x509CertHolder, AuthorityKeyIdentifier aki) {
        String aKIBase64 = Base64.encodeBase64String((byte[])aki.getKeyIdentifier());
        LOG.debug("looking for issuer of certificate '" + x509CertHolder.getSubject().toString() + "', issuer selected by its SKI '" + aKIBase64 + "'");
        List issuingCertList = this.certificateRepository.findByAttributeValue("SKI", aKIBase64);
        if (issuingCertList.isEmpty()) {
            LOG.debug("no certificate found for AKI {}", (Object)aKIBase64);
        }
        return issuingCertList;
    }

    public boolean hasIssuedActiveCertificates(de.trustable.ca3s.core.domain.Certificate issuingCertificate) {
        String sKIBase64 = this.getCertAttribute(issuingCertificate, "SKI");
        LOG.debug("looking for certificate issued by '" + issuingCertificate.getSubject() + "', selected by their AKI '" + sKIBase64 + "'");
        List activeIssuedCertList = this.certificateRepository.findActiveByAttributeValue("AKI", sKIBase64);
        return activeIssuedCertList.isEmpty();
    }

    public List<de.trustable.ca3s.core.domain.Certificate> findCertsBySubjectRFC2253(String subject) {
        LOG.debug("looking for certificate by subject (by RFC 2253) '" + subject + "'");
        List issuingCertList = this.certificateRepository.findByAttributeValue("SUBJECT_RFC_2253", subject);
        if (issuingCertList.isEmpty()) {
            LOG.debug("no certificate found for subject '{}'", (Object)subject);
        }
        return issuingCertList;
    }

    public Set<GeneralName> getSANList(X509CertificateHolder x509CertHolder) {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        Extensions exts = x509CertHolder.getExtensions();
        for (ASN1ObjectIdentifier objId : exts.getExtensionOIDs()) {
            if (!Extension.subjectAlternativeName.equals((ASN1Primitive)objId)) continue;
            ASN1OctetString octString = exts.getExtension(objId).getExtnValue();
            GeneralNames names = GeneralNames.getInstance((Object)octString);
            LOG.debug("Attribute value SAN" + String.valueOf(names));
            LOG.debug("SAN values #" + names.getNames().length);
            for (GeneralName gnSAN : names.getNames()) {
                LOG.debug("GN " + gnSAN.toString());
                generalNameSet.add(gnSAN);
            }
        }
        return generalNameSet;
    }

    public Set<GeneralName> getSANList(Pkcs10RequestHolder p10ReqHolder) {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        for (Attribute attr : p10ReqHolder.getReqAttributes()) {
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            ASN1Set valueSet = attr.getAttrValues();
            LOG.debug("ExtensionRequest / AttrValues has {} elements", (Object)valueSet.size());
            for (ASN1Encodable asn1Enc : valueSet) {
                DERSequence derSeq = (DERSequence)asn1Enc;
                LOG.debug("ExtensionRequest / DERSequence has {} elements", (Object)derSeq.size());
                LOG.debug("ExtensionRequest / DERSequence[0] is a  {}", (Object)derSeq.getObjectAt(0).getClass().getName());
                DERSequence derSeq2 = (DERSequence)derSeq.getObjectAt(0);
                LOG.debug("ExtensionRequest / DERSequence2 has {} elements", (Object)derSeq2.size());
                LOG.debug("ExtensionRequest / DERSequence2[0] is a  {}", (Object)derSeq2.getObjectAt(0).getClass().getName());
                ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)derSeq2.getObjectAt(0);
                if (Extension.subjectAlternativeName.equals((ASN1Primitive)objId)) {
                    DEROctetString derStr = (DEROctetString)derSeq2.getObjectAt(1);
                    GeneralNames names = GeneralNames.getInstance((Object)derStr.getOctets());
                    LOG.debug("Attribute value SAN" + String.valueOf(names));
                    LOG.debug("SAN values #" + names.getNames().length);
                    for (GeneralName gnSAN : names.getNames()) {
                        LOG.debug("GN " + gnSAN.toString());
                        generalNameSet.add(gnSAN);
                    }
                    continue;
                }
                LOG.info("Unexpected Extensions Attribute value " + objId.getId());
            }
        }
        return generalNameSet;
    }

    public void storePrivateKey(CSR csr, KeyPair keyPair, int leftUsages, Instant validTo) throws IOException {
        StringWriter sw = this.keyToPEM(keyPair);
        ProtectedContent pt = this.protUtil.createProtectedContent(sw.toString(), ProtectedContentType.KEY, ContentRelationType.CSR, csr.getId().longValue(), leftUsages, validTo);
        this.protContentRepository.save((Object)pt);
    }

    public void storePrivateKey(de.trustable.ca3s.core.domain.Certificate cert, KeyPair keyPair) throws IOException {
        StringWriter sw = this.keyToPEM(keyPair);
        ProtectedContent pt = this.protUtil.createProtectedContent(sw.toString(), ProtectedContentType.KEY, ContentRelationType.CERTIFICATE, cert.getId().longValue());
        this.protContentRepository.save((Object)pt);
    }

    public void storePrivateKey(de.trustable.ca3s.core.domain.Certificate cert, KeyPair keyPair, Instant validTo) throws IOException {
        StringWriter sw = this.keyToPEM(keyPair);
        ProtectedContent pt = this.protUtil.createProtectedContent(sw.toString(), ProtectedContentType.KEY, ContentRelationType.CERTIFICATE, cert.getId().longValue(), -1, validTo);
        this.protContentRepository.save((Object)pt);
    }

    private StringWriter keyToPEM(KeyPair keyPair) throws IOException {
        StringWriter sw = new StringWriter();
        PemObject pemObject = new PemObject("PRIVATE KEY", keyPair.getPrivate().getEncoded());
        try (PemWriter pemWriter = new PemWriter((Writer)sw);){
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        return sw;
    }

    public PrivateKey getPrivateKey(CSR csr) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByCertificateId(csr.getId());
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for csr '{}' returns no key!", (Object)csr.getId());
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for certificate '{}' returns more than one key ({}) !", (Object)csr.getId(), (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns key for csr #" + csr.getId());
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public PrivateKey getPrivateKey(de.trustable.ca3s.core.domain.Certificate cert) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByCertificateId(cert.getId());
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for certificate '{}' returns not key!", (Object)cert.getId());
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for certificate '{}' returns more than one key ({}) !", (Object)cert.getId(), (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns key for csr #" + cert.getId());
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public PrivateKey getPrivateKey(ProtectedContentType type, ContentRelationType relationType, Long id) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByTypeRelationId(type, relationType, id);
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for element with id '{}' returns not key!", (Object)id);
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for element with id '{}' returns more than one key ({}) !", (Object)id, (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns key for ProtectedContent #" + id);
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public List<String> getCrlDistributionPoints(X509Certificate cert) throws IOException {
        ArrayList<String> crlUrls = new ArrayList<String>();
        byte[] crldpExt = cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (crldpExt != null && crldpExt.length > 0) {
            ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
            ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
            DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
            byte[] crldpExtOctets = dosCrlDP.getOctets();
            ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
            ASN1Primitive derObj2 = oAsnInStream2.readObject();
            CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)derObj2);
            for (DistributionPoint dp : distPoint.getDistributionPoints()) {
                DistributionPointName dpn = dp.getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    if (genNames[j].getTagNo() != 6) continue;
                    String url = DERIA5String.getInstance((Object)genNames[j].getName()).getString();
                    crlUrls.add(url);
                }
            }
            oAsnInStream.close();
            oAsnInStream2.close();
        }
        return crlUrls;
    }

    public void setRevocationStatus(de.trustable.ca3s.core.domain.Certificate cert, String revocationReason, Date revocationDate) {
        this.setRevocationStatus(cert, revocationReason, DateUtil.asInstant((Date)revocationDate));
    }

    public void setRevocationStatus(de.trustable.ca3s.core.domain.Certificate cert, String revocationReason, Instant revocationDate) {
        cert.setActive(Boolean.valueOf(false));
        cert.setRevoked(Boolean.valueOf(true));
        if (revocationReason == null || revocationReason.trim().isEmpty()) {
            cert.setRevocationReason("unspecified");
        } else {
            cert.setRevocationReason(revocationReason);
        }
        cert.setRevokedSince(revocationDate);
    }

    public static String getDownloadFilename(de.trustable.ca3s.core.domain.Certificate cert) {
        String cn = null;
        String e = null;
        String firstSAN = null;
        for (CertificateAttribute certificateAttribute : cert.getCertificateAttributes()) {
            if ("RDN_COMMONNAME".equals(certificateAttribute.getName()) && cn == null) {
                cn = certificateAttribute.getValue();
                LOG.debug("getDownloadFilename: cn = {}", (Object)cn);
            }
            if ("SUBJECT".equals(certificateAttribute.getName()) && certificateAttribute.getValue().startsWith("e=") && e == null) {
                e = certificateAttribute.getValue().substring(2);
                LOG.debug("getDownloadFilename: e = {}", (Object)e);
            }
            if (!"SAN".equals(certificateAttribute.getName()) || firstSAN != null) continue;
            firstSAN = certificateAttribute.getValue();
            LOG.debug("getDownloadFilename: firstSAN = {}", (Object)firstSAN);
        }
        Object downloadFilename = cert.getSubject();
        if (cn != null) {
            downloadFilename = cn;
        } else if (e != null) {
            downloadFilename = e;
        } else if (firstSAN != null) {
            downloadFilename = firstSAN;
        }
        downloadFilename = ((String)downloadFilename).replaceAll("[^a-zA-Z0-9.\\-]", "_");
        if (((String)downloadFilename).trim().isEmpty()) {
            downloadFilename = "cert" + cert.getSerial();
        }
        return downloadFilename;
    }

    public static GeneralName[] splitSANString(String sans, String hostname) {
        String[] sanArr = sans.split(",");
        ArrayList<GeneralName> generalNameList = new ArrayList<GeneralName>();
        if (hostname != null && !hostname.trim().isEmpty()) {
            generalNameList.add(CertificateUtil.buildGeneralNameFromName((String)hostname));
        }
        for (int i = 0; i < sanArr.length; ++i) {
            GeneralName generalName = CertificateUtil.buildGeneralNameFromName((String)sanArr[i]);
            if (generalNameList.contains(generalName)) continue;
            generalNameList.add(generalName);
        }
        return generalNameList.toArray(new GeneralName[0]);
    }

    public static boolean isIPAddress(String rawName) {
        String name = rawName.trim();
        InetAddressValidator inv = InetAddressValidator.getInstance();
        return inv.isValidInet4Address(name) || inv.isValidInet6Address(name);
    }

    public static GeneralName buildGeneralNameFromName(String rawName) {
        String name = rawName.trim();
        if (CertificateUtil.isIPAddress((String)name)) {
            return new GeneralName(7, name);
        }
        return new GeneralName(2, name);
    }

    public CRLUpdateInfo checkAllCRLsForCertificate(de.trustable.ca3s.core.domain.Certificate cert, X509Certificate x509Cert, CRLUtil crlUtil, HashSet<String> brokenCrlUrlList) {
        long now = System.currentTimeMillis();
        CRLUpdateInfo info = new CRLUpdateInfo();
        long maxNextUpdate = System.currentTimeMillis() + 1000L * this.preferenceUtil.getMaxNextUpdatePeriodCRLSec();
        for (CertificateAttribute certAtt : cert.getCertificateAttributes()) {
            if (!"CRL_URL".equals(certAtt.getName())) continue;
            String crlUrl = certAtt.getValue();
            if (brokenCrlUrlList.contains(crlUrl)) {
                LOG.debug("CRL URL'{}' already marked as broken / inaccessible", (Object)crlUrl);
                continue;
            }
            info.incUrlCount();
            try {
                LOG.debug("downloading CRL '{}'", (Object)crlUrl);
                X509CRL crl = crlUtil.downloadCRL(crlUrl);
                if (crl == null) {
                    LOG.debug("downloaded CRL == null ");
                    continue;
                }
                if (crl.getNextUpdate() == null) {
                    LOG.warn("nextUpdate missing in CRL '{}' of certificate #{}", (Object)crlUrl, (Object)cert.getId());
                } else {
                    long nextUpdate = crl.getNextUpdate().getTime();
                    if (nextUpdate > maxNextUpdate) {
                        LOG.debug("nextUpdate {} from CRL limited to {}", (Object)crl.getNextUpdate(), (Object)new Date(maxNextUpdate));
                        nextUpdate = maxNextUpdate;
                    }
                    if (nextUpdate < now) {
                        LOG.warn("nextUpdate {} of CRL '{}' of certificate #{} already expired", new Object[]{crl.getNextUpdate(), crlUrl, cert.getId()});
                        nextUpdate = maxNextUpdate;
                    }
                    this.setCertAttribute(cert, "CRL_NEXT_UPDATE", Long.toString(nextUpdate), false);
                }
                this.setRevocationStatus(cert, x509Cert, crl);
                info.setSuccess();
                break;
            }
            catch (IOException | CRLException | CertificateException | NamingException e2) {
                LOG.info("Problem retrieving CRL for certificate " + cert.getId());
                LOG.debug("CRL retrieval for certificate " + cert.getId() + " failed", (Throwable)e2);
                brokenCrlUrlList.add(crlUrl);
            }
        }
        return info;
    }

    public boolean setRevocationStatus(de.trustable.ca3s.core.domain.Certificate cert, X509Certificate x509Cert, X509CRL crl) {
        X509CRLEntry crlItem = crl.getRevokedCertificate(new BigInteger(cert.getSerial()));
        if (crlItem != null && crl.isRevoked(x509Cert)) {
            String revocationReason = "unspecified";
            if (crlItem.getRevocationReason() != null && this.cryptoUtil.crlReasonAsString(CRLReason.lookup((int)crlItem.getRevocationReason().ordinal())) != null) {
                revocationReason = this.cryptoUtil.crlReasonAsString(CRLReason.lookup((int)crlItem.getRevocationReason().ordinal()));
            }
            Date revocationDate = new Date();
            if (crlItem.getRevocationDate() != null) {
                revocationDate = crlItem.getRevocationDate();
            } else {
                LOG.debug("Checking certificate {}: no RevocationDate present for reason {}!", (Object)cert.getId(), (Object)revocationReason);
            }
            this.setRevocationStatus(cert, revocationReason, revocationDate);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("CERTIFICATE_REVOKED_BY_CRL", cert));
            return true;
        }
        return false;
    }

    public byte[] getContainerBytes(de.trustable.ca3s.core.domain.Certificate certDao, String entryAlias, CSR csr, String passwordProtectionAlgo) throws IOException, GeneralSecurityException {
        byte[] contentBytes;
        KeyStoreAndPassphrase keyStoreAndPassphrase = this.getContainer(certDao, entryAlias, csr, passwordProtectionAlgo);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            keyStoreAndPassphrase.keyStore.store(baos, keyStoreAndPassphrase.getPassphraseChars());
            contentBytes = baos.toByteArray();
            if (LOG.isDebugEnabled()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(contentBytes);
                KeyStore store = KeyStore.getInstance("pkcs12");
                store.load(bais, keyStoreAndPassphrase.getPassphraseChars());
                Certificate cert = store.getCertificate(entryAlias);
                LOG.debug("retrieved cert " + String.valueOf(cert));
            }
        }
        return contentBytes;
    }

    @NotNull
    public KeyStoreAndPassphrase getContainer(de.trustable.ca3s.core.domain.Certificate certDao, String entryAlias, CSR csr, String passwordProtectionAlgo) throws IOException, GeneralSecurityException {
        if (!csr.isServersideKeyGeneration().booleanValue()) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ": key not generated serverside");
        }
        List protContentList = this.protUtil.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CSR, csr.getId().longValue());
        if (protContentList.size() == 0) {
            throw new GeneralSecurityException("problem downloading keystore content for csr id " + csr.getId() + ": no keystore passphrase available ");
        }
        char[] passphraseChars = this.protUtil.unprotectString(((ProtectedContent)protContentList.get(0)).getContentBase64()).toCharArray();
        PrivateKey key = this.getPrivateKey(ProtectedContentType.KEY, ContentRelationType.CSR, csr.getId());
        return this.getContainer(certDao, entryAlias, passphraseChars, key, passwordProtectionAlgo);
    }

    @NotNull
    public KeyStoreAndPassphrase getContainer(de.trustable.ca3s.core.domain.Certificate certDao, String entryAlias, char[] passphraseChars, String passwordProtectionAlgo) throws IOException, GeneralSecurityException {
        CSR csr = certDao.getCsr();
        if (csr == null) {
            PrivateKey key = this.getPrivateKey(ProtectedContentType.KEY, ContentRelationType.CERTIFICATE, certDao.getId());
            return this.getContainer(certDao, entryAlias, passphraseChars, key, passwordProtectionAlgo);
        }
        return this.getContainer(certDao, entryAlias, csr, passwordProtectionAlgo);
    }

    @NotNull
    public KeyStoreAndPassphrase getContainer(de.trustable.ca3s.core.domain.Certificate certDao, String entryAlias, char[] passphraseChars, PrivateKey key, String passwordProtectionAlgo) throws IOException, GeneralSecurityException {
        byte[] salt = new byte[20];
        RandomUtil.getSecureRandom().nextBytes(salt);
        KeyStore p12 = KeyStore.getInstance("pkcs12");
        p12.load(null, passphraseChars);
        Certificate[] chain = this.getX509CertificateChain(certDao);
        HashSet<KeyStore.Entry.Attribute> privateKeyAttributes = new HashSet<KeyStore.Entry.Attribute>();
        p12.setEntry(entryAlias, new KeyStore.PrivateKeyEntry(key, chain, privateKeyAttributes), new KeyStore.PasswordProtection(passphraseChars, passwordProtectionAlgo, new PBEParameterSpec(salt, 100000)));
        return new KeyStoreAndPassphrase(p12, passphraseChars);
    }

    static {
        lenSet.add(256);
        lenSet.add(512);
        lenSet.add(1024);
        lenSet.add(2048);
        lenSet.add(3072);
        lenSet.add(4096);
        lenSet.add(6144);
        lenSet.add(8192);
        dnOrderMap = CertificateUtil.createDnOrderMap();
        LOG = LoggerFactory.getLogger(CertificateUtil.class);
        nameGeneralNameMap.put("DNS-NAME", 2);
        nameGeneralNameMap.put("DNS", 2);
        nameGeneralNameMap.put("IP", 7);
        nameOIDMap.put("C", BCStyle.C);
        nameOIDMap.put("CN", BCStyle.CN);
        nameOIDMap.put("O", BCStyle.O);
        nameOIDMap.put("OU", BCStyle.OU);
        nameOIDMap.put("L", BCStyle.L);
        nameOIDMap.put("ST", BCStyle.ST);
        nameOIDMap.put("E", BCStyle.E);
    }
}

