/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.SignedJWT;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JWSService {
    private static final Logger log = LoggerFactory.getLogger(JWSService.class);
    private final ProtectedContentUtil protectedContentUtil;

    public JWSService(ProtectedContentUtil protectedContentUtil) {
        this.protectedContentUtil = protectedContentUtil;
    }

    public String getJWSPayload(String jwsAsString) throws JOSEException, ParseException, GeneralSecurityException {
        int requestProxyId;
        JWSObject jwsObject = JWSObject.parse((String)jwsAsString);
        String requestProxyIdString = jwsObject.getHeader().getKeyID();
        if (!requestProxyIdString.startsWith("rid-")) {
            throw new JOSEException("unrecognized key id '" + requestProxyIdString + "' in JWS");
        }
        try {
            requestProxyId = Integer.parseInt(requestProxyIdString.substring(4));
        }
        catch (NumberFormatException nfe) {
            throw new JOSEException("invalid key id '" + requestProxyIdString + "' in JWS");
        }
        List protectedContents = this.protectedContentUtil.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, (long)requestProxyId);
        log.debug("checking #{} connection secrets for request proxy '{}'", (Object)protectedContents.size(), (Object)requestProxyId);
        for (ProtectedContent protectedContent : protectedContents) {
            String secret = this.protectedContentUtil.unprotectString(protectedContent.getContentBase64());
            log.debug("NOT FOR PRODUCTION: iterating stored secret: " + secret);
            byte[] derivedSecret = this.protectedContentUtil.deriveSecret(secret);
            log.debug("NOT FOR PRODUCTION: calculated secret as " + Base64.getEncoder().encodeToString(derivedSecret));
            MACVerifier verifier = new MACVerifier(derivedSecret);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                return jwsObject.getPayload().toString();
            }
            log.debug("jws '{}' failed (trial) verification", (Object)jwsAsString);
        }
        throw new JOSEException("verification of JWS failed for request proxy '" + requestProxyId + "'");
    }

    public void checkJWT(String jwtAsString, int intendedId) throws JOSEException, ParseException, GeneralSecurityException {
        int requestProxyId;
        SignedJWT signedJWT = SignedJWT.parse((String)jwtAsString);
        if (signedJWT.getJWTClaimsSet().getExpirationTime().before(new Date())) {
            log.debug("jwt '{}' failed verification, already expired (exp: {})", (Object)jwtAsString, (Object)signedJWT.getJWTClaimsSet().getExpirationTime());
            throw new JOSEException("verification of JWT failed, already expired (exp: " + String.valueOf(signedJWT.getJWTClaimsSet().getExpirationTime()) + ")");
        }
        String requestProxyIdString = signedJWT.getHeader().getKeyID();
        if (!requestProxyIdString.startsWith("rid-")) {
            throw new JOSEException("unrecognized key id '" + requestProxyIdString + "' in JWS");
        }
        try {
            requestProxyId = Integer.parseInt(requestProxyIdString.substring(4));
        }
        catch (NumberFormatException nfe) {
            throw new JOSEException("invalid key id '" + requestProxyIdString + "' in JWS");
        }
        if (requestProxyId != intendedId) {
            throw new JOSEException("invalid key id '" + requestProxyIdString + "' / '" + intendedId + "'");
        }
        List protectedContents = this.protectedContentUtil.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, (long)requestProxyId);
        log.debug("checking #{} connection secrets for request proxy '{}'", (Object)protectedContents.size(), (Object)requestProxyId);
        for (ProtectedContent protectedContent : protectedContents) {
            String secret = this.protectedContentUtil.unprotectString(protectedContent.getContentBase64());
            log.debug("NOT FOR PRODUCTION: stored secret: " + secret);
            byte[] derivedSecret = this.protectedContentUtil.deriveSecret(secret);
            log.debug("NOT FOR PRODUCTION: calculated secret as " + Base64.getEncoder().encodeToString(derivedSecret));
            MACVerifier verifier = new MACVerifier(derivedSecret);
            if (signedJWT.verify((JWSVerifier)verifier)) {
                return;
            }
            log.debug("jwt '{}' failed verification", (Object)jwtAsString);
        }
        throw new JOSEException("verification of JWS failed for request proxy '" + requestProxyId + "'");
    }
}

