/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.service.dto.KeyAlgoLengthOrSpec;
import de.trustable.ca3s.core.service.util.RandomUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KeyUtil {
    private final String defaultKeySpec;
    private static final Logger LOG = LoggerFactory.getLogger(KeyUtil.class);

    public KeyUtil(@Value(value="${ca3s.keyspec.default:RSA_4096}") String defaultKeySpec) {
        this.defaultKeySpec = defaultKeySpec;
    }

    public KeyPair createKeyPair() {
        try {
            return this.createKeyPair(this.defaultKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("unexpected vale for 'ca3s.keyspec.default', using RSA-4096 as fallback.");
            try {
                return this.createKeyPair("RSA_4096");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException("Problem using default algorithm! Maybe a general crypto setup problem?", ex);
            }
        }
    }

    public KeyPair createKeyPair(String keySpec) throws NoSuchAlgorithmException {
        KeyAlgoLengthOrSpec kal = KeyAlgoLengthOrSpec.from((String)keySpec);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(kal.getAlgoName());
        keyPairGenerator.initialize(kal.getKeyLength(), RandomUtil.getSecureRandom());
        return keyPairGenerator.generateKeyPair();
    }
}

