/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.NotificationService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReplacementCandidateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReplacementCandidateUtil.class);
    private final CertificateRepository certificateRepository;
    private final UserRepository userRepository;
    private final AcmeAccountRepository acmeAccountRepository;
    private final AuditService auditService;
    private final NotificationService notificationService;
    final int notifyActiveParallelCertificates;
    final int rejectActiveParallelCertificates;

    public ReplacementCandidateUtil(CertificateRepository certificateRepository, UserRepository userRepository, AcmeAccountRepository acmeAccountRepository, AuditService auditService, @Lazy NotificationService notificationService, @Value(value="${ca3s.issuance.limit.notify.active-parallel-certificates:20}") int notifyActiveParallelCertificates, @Value(value="${ca3s.issuance.limit.reject.active-parallel-certificates:100}") int rejectActiveParallelCertificates) {
        this.certificateRepository = certificateRepository;
        this.userRepository = userRepository;
        this.acmeAccountRepository = acmeAccountRepository;
        this.auditService = auditService;
        this.notificationService = notificationService;
        this.notifyActiveParallelCertificates = notifyActiveParallelCertificates;
        this.rejectActiveParallelCertificates = rejectActiveParallelCertificates;
    }

    public List<Certificate> findReplaceCandidates(String[] sanArr) {
        return this.findReplaceCandidates(null, sanArr);
    }

    public List<Certificate> findReplaceCandidates(String cn, String[] sanArr) {
        return this.findReplaceCandidates(Instant.now(), cn, sanArr);
    }

    public List<Certificate> findReplaceCandidates(Instant validOn, String cn, String[] sanArr) {
        ArrayList<String> sans = new ArrayList<String>();
        for (String san : sanArr) {
            LOG.debug("SAN present: {} ", (Object)san);
            sans.add(san.toLowerCase(Locale.ROOT));
        }
        return this.findReplaceCandidates(validOn, cn, sans, null);
    }

    public List<Certificate> findReplaceCandidates(Instant validOn, String cn, List<String> sanList, Certificate cert) {
        ArrayList<Object> sanListLowerCase = new ArrayList<Object>();
        if (sanList != null) {
            for (String san : sanList) {
                sanListLowerCase.add(san.toLowerCase(Locale.ROOT));
            }
        }
        if (cn != null && !sanListLowerCase.contains(cn.toLowerCase(Locale.ROOT))) {
            if (CertificateUtil.isIPAddress((String)cn)) {
                sanListLowerCase.add("IP:" + cn.toLowerCase(Locale.ROOT));
            } else {
                sanListLowerCase.add("DNS:" + cn.toLowerCase(Locale.ROOT));
            }
        }
        return this.findReplaceCandidates(validOn, sanListLowerCase, cert);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<Certificate> findReplaceCandidates(Instant validOn, List<String> sans, Certificate cert) {
        LOG.debug("sans list contains {} elements", (Object)sans.size());
        ArrayList<Certificate> candidateList = new ArrayList<Certificate>();
        if (sans.size() == 0) {
            return candidateList;
        }
        int maxPageRows = this.notifyActiveParallelCertificates;
        if (this.rejectActiveParallelCertificates > maxPageRows) {
            maxPageRows = this.rejectActiveParallelCertificates;
        }
        Page matchingCertList = this.certificateRepository.findActiveCertificatesBySANs((Pageable)PageRequest.of((int)0, (int)(maxPageRows += 10)), validOn, sans);
        int resultRowCount = matchingCertList.getNumberOfElements();
        LOG.debug("objArrList contains {} elements", (Object)resultRowCount);
        for (Certificate candidateCert : matchingCertList) {
            LOG.debug("replacement candidate {}: {} ", (Object)candidateCert.getId(), (Object)candidateCert.getSubject());
            boolean matches = true;
            for (CertificateAttribute certAttr : candidateCert.getCertificateAttributes()) {
                String san;
                if (!certAttr.getName().equals("TYPED_SAN") && !certAttr.getName().equals("TYPED_VSAN") || sans.contains(san = certAttr.getValue().toLowerCase(Locale.ROOT))) continue;
                matches = false;
                LOG.debug("candidate san {} NOT in provided san list", (Object)san);
                break;
            }
            if (!matches) continue;
            candidateList.add(candidateCert);
            LOG.debug("replacement candidate {}: contains all SANs", (Object)candidateCert.getId());
        }
        if (candidateList.size() > this.rejectActiveParallelCertificates) {
            LOG.warn("maximum number of active, parallel certificates (#{}) exceeded for certificate id {}", (Object)resultRowCount, (Object)cert.getId());
        }
        return candidateList;
    }

    public void notifyOnExcessiveActiveCertificates(Certificate cert, List<String> emailAddressList) {
        if (emailAddressList == null || emailAddressList.isEmpty()) {
            return;
        }
        for (CertificateAttribute certAttr : cert.getCertificateAttributes()) {
            if (!certAttr.getName().equals("REPLACES_NUMBER_OF_CERTS")) continue;
            try {
                int nReplacedCerts = Integer.parseInt(certAttr.getValue());
                if (nReplacedCerts <= this.notifyActiveParallelCertificates) continue;
                this.notificationService.notifyRequestorOnExcessiveActiveCertificates(emailAddressList.get(0), nReplacedCerts, cert);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("number of replaced certificates '{}' for certificate id {} is not a number", (Object)certAttr.getValue(), (Object)cert.getId());
            }
        }
    }
}

