/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.service.AcmeAccountService;
import de.trustable.ca3s.core.service.dto.AcmeAccountView;
import de.trustable.ca3s.core.service.util.AcmeAccountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.ResponseUtil;

@Transactional
@RestController
@RequestMapping(value={"/api"})
public class AcmeAccountViewResource {
    private final Logger log = LoggerFactory.getLogger(AcmeAccountViewResource.class);
    private final AcmeAccountService acmeAccountService;
    private final AcmeAccountUtil acmeAccountUtil;

    public AcmeAccountViewResource(AcmeAccountService acmeAccountService, AcmeAccountUtil acmeAccountUtil) {
        this.acmeAccountService = acmeAccountService;
        this.acmeAccountUtil = acmeAccountUtil;
    }

    @GetMapping(value={"/acmeAccountViews"})
    public List<AcmeAccountView> getAllAcmeAccountViews() {
        this.log.debug("REST request to get all AcmeAccountViews");
        ArrayList<AcmeAccountView> avList = new ArrayList<AcmeAccountView>();
        for (AcmeAccount acmeAccount : this.acmeAccountService.findAll()) {
            avList.add(this.acmeAccountUtil.from(acmeAccount));
        }
        return avList;
    }

    @GetMapping(value={"/acmeAccountViews/{id}"})
    public ResponseEntity<AcmeAccountView> getAcmeAccount(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeAccountView : {}", (Object)id);
        Optional acmeAccountOptional = this.acmeAccountService.findOne(id);
        Optional<Object> avOpt = Optional.empty();
        if (acmeAccountOptional.isPresent()) {
            AcmeAccount acmeAccount = (AcmeAccount)acmeAccountOptional.get();
            AcmeAccountView acmeAccountView = this.acmeAccountUtil.from(acmeAccount);
            avOpt = Optional.of(acmeAccountView);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }

    @GetMapping(value={"/acmeAccountViews/acmeAccoundId/{acmeAccoundId}"})
    public ResponseEntity<AcmeAccountView> getAcmeAccountByAccountId(@PathVariable Long acmeAccoundId) {
        this.log.debug("REST request to get AcmeAccountView by acmeAccoundId : {}", (Object)acmeAccoundId);
        Optional acmeAccountOptional = this.acmeAccountService.findOneByAccountId(acmeAccoundId);
        Optional<Object> avOpt = Optional.empty();
        if (acmeAccountOptional.isPresent()) {
            AcmeAccount acmeAccount = (AcmeAccount)acmeAccountOptional.get();
            AcmeAccountView acmeAccountView = this.acmeAccountUtil.from(acmeAccount);
            avOpt = Optional.of(acmeAccountView);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }
}

