/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.AcmeChallengeService;
import de.trustable.ca3s.core.service.util.JWSService;
import de.trustable.ca3s.core.web.rest.acme.ChallengeController;
import de.trustable.ca3s.core.web.rest.data.AcmeChallengeValidation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeChallengeResource {
    private final Logger log = LoggerFactory.getLogger(AcmeChallengeResource.class);
    private static final String ENTITY_NAME = "acmeChallenge";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeChallengeService acmeChallengeService;
    private final ChallengeController challengeController;
    private final JWSService jwsService;
    private final ObjectMapper objectMapper;

    public AcmeChallengeResource(AcmeChallengeService acmeChallengeService, ChallengeController challengeController, JWSService jwsService, ObjectMapper objectMapper) {
        this.acmeChallengeService = acmeChallengeService;
        this.challengeController = challengeController;
        this.jwsService = jwsService;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/acme-challenges"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeChallenge> createAcmeChallenge(@Valid @RequestBody AcmeChallenge acmeChallenge) throws URISyntaxException {
        this.log.debug("REST request to save AcmeChallenge : {}", (Object)acmeChallenge);
        if (acmeChallenge.getId() != null) {
            throw new BadRequestAlertException("A new acmeChallenge cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeChallenge result = this.acmeChallengeService.save(acmeChallenge);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-challenges/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-challenges"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeChallenge> updateAcmeChallenge(@Valid @RequestBody AcmeChallenge acmeChallenge) {
        this.log.debug("REST request to update AcmeChallenge : {}", (Object)acmeChallenge);
        if (acmeChallenge.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeChallenge result = this.acmeChallengeService.save(acmeChallenge);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeChallenge.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-challenges"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<AcmeChallenge> getAllAcmeChallenges() {
        this.log.debug("REST request to get all AcmeChallenges");
        return this.acmeChallengeService.findAll();
    }

    @GetMapping(value={"/acme-challenges/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeChallenge> getAcmeChallenge(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeChallenge : {}", (Object)id);
        Optional acmeChallenge = this.acmeChallengeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeChallenge);
    }

    @DeleteMapping(value={"/acme-challenges/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteAcmeChallenge(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeChallenge : {}", (Object)id);
        this.acmeChallengeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/acme-challenges/pending/request-proxy-configs/{requestProxyId}"})
    public ResponseEntity<?> postPendingAcmeChallenges(@Parameter(description="AcmeChallengeValidation wrapped in a JWS") @Valid @RequestBody String body, @RequestHeader(value="Accept", required=false) String accept, @PathVariable Long requestProxyId) {
        this.log.debug("REST request to retrieve all pending AcmeChallenges for a given proxy");
        if (accept != null && accept.contains("application/json")) {
            try {
                this.log.debug("incoming JWT " + body);
                this.jwsService.checkJWT(body, requestProxyId.intValue());
                return ResponseEntity.ok((Object)this.acmeChallengeService.findPendingByRequestProxy(requestProxyId));
            }
            catch (GeneralSecurityException e) {
                this.log.error("Couldn't process request", (Throwable)e);
                return ResponseEntity.internalServerError().build();
            }
            catch (JOSEException | ParseException e) {
                this.log.error("Couldn't process JOSE element", e);
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @PostMapping(value={"/acme-challenges/validation"})
    public ResponseEntity<Void> processChallengeValidation(@Parameter(description="AcmeChallengeValidation wrapped in a JWS") @Valid @RequestBody String body, @RequestHeader(value="Accept", required=false) String accept) {
        if (accept != null && accept.contains("application/json")) {
            try {
                this.log.debug("incoming JWS " + body);
                String payload = this.jwsService.getJWSPayload(body);
                AcmeChallengeValidation acmeChallengeValidation = (AcmeChallengeValidation)this.objectMapper.readValue(payload, AcmeChallengeValidation.class);
                return this.challengeController.checkChallengeValidation(acmeChallengeValidation);
            }
            catch (IOException | GeneralSecurityException e) {
                this.log.error("Couldn't process request", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (JOSEException | ParseException e) {
                this.log.error("Couldn't process JOSE element", e);
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
        }
        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }
}

