/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.AcmeOrderService;
import de.trustable.ca3s.core.service.dto.AcmeChallengeView;
import de.trustable.ca3s.core.service.dto.AcmeOrderView;
import de.trustable.ca3s.core.service.util.AcmeOrderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.ResponseUtil;

@Transactional
@RestController
@RequestMapping(value={"/api"})
public class AcmeOrderViewResource {
    private final Logger log = LoggerFactory.getLogger(AcmeOrderViewResource.class);
    private final AcmeOrderService acmeOrderService;
    private final AcmeOrderUtil acmeOrderUtil;

    public AcmeOrderViewResource(AcmeOrderService acmeOrderService, AcmeOrderUtil acmeOrderUtil) {
        this.acmeOrderService = acmeOrderService;
        this.acmeOrderUtil = acmeOrderUtil;
    }

    @GetMapping(value={"/acmeOrderViews"})
    public List<AcmeOrderView> getAllAcmeOrderViews() {
        this.log.debug("REST request to get all AcmeOrderViews");
        ArrayList<AcmeOrderView> avList = new ArrayList<AcmeOrderView>();
        for (AcmeOrder acmeOrder : this.acmeOrderService.findAll()) {
            avList.add(this.acmeOrderUtil.from(acmeOrder));
        }
        return avList;
    }

    @GetMapping(value={"/acmeOrderViews/{id}"})
    public ResponseEntity<AcmeOrderView> getacmeOrder(@PathVariable Long id) {
        this.log.debug("REST request to get acmeOrderView : {}", (Object)id);
        Optional acmeOrderOptional = this.acmeOrderService.findOne(id);
        Optional<Object> avOpt = Optional.empty();
        if (acmeOrderOptional.isPresent()) {
            AcmeOrder acmeOrder = (AcmeOrder)acmeOrderOptional.get();
            AcmeOrderView acmeOrderView = this.acmeOrderUtil.from(acmeOrder);
            avOpt = Optional.of(acmeOrderView);
        } else {
            this.log.info("acme order not found, order id '{}' unknown!", (Object)id);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }

    @GetMapping(value={"/acmeOrderViews/acmeOrderId/{orderId}"})
    public ResponseEntity<AcmeOrderView> getacmeOrderByAcmeOrderId(@PathVariable Long orderId) {
        this.log.debug("REST request to get acmeOrderView for AcmeOrderId : {}", (Object)orderId);
        Optional acmeOrderOptional = this.acmeOrderService.findOneByAcmeOrderId(orderId);
        Optional<Object> avOpt = Optional.empty();
        if (acmeOrderOptional.isPresent()) {
            AcmeOrder acmeOrder = (AcmeOrder)acmeOrderOptional.get();
            AcmeOrderView acmeOrderView = this.acmeOrderUtil.from(acmeOrder);
            avOpt = Optional.of(acmeOrderView);
        } else {
            this.log.info("acme order not found, order id '{}' unknown!", (Object)orderId);
        }
        return ResponseUtil.wrapOrNotFound(avOpt);
    }

    @GetMapping(value={"/acmeOrderView/{id}/challenges"})
    public ResponseEntity<List<AcmeChallengeView>> getAcmeChallenges(@PathVariable Long id) {
        this.log.debug("REST request to get challenges of acme order : {}", (Object)id);
        Optional acmeOrderOptional = this.acmeOrderService.findOne(id);
        if (acmeOrderOptional.isPresent()) {
            AcmeOrder acmeOrder = (AcmeOrder)acmeOrderOptional.get();
            List acmeChallengeViewList = this.acmeOrderUtil.challengeListfrom(acmeOrder);
            HttpHeaders additionalHeaders = new HttpHeaders();
            additionalHeaders.add("X-Total-Count", Long.toString(acmeChallengeViewList.size()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)acmeChallengeViewList);
        }
        this.log.info("challenges of acme order not found, order id '{}' unknown!", (Object)id);
        return ResponseEntity.notFound().build();
    }
}

