/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CertificateViewRepository;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.util.UserUtil;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/api"})
public class CertificateViewResource {
    private final Logger LOG = LoggerFactory.getLogger(CertificateViewResource.class);
    private final CertificateViewRepository certificateViewRepository;
    private final UserUtil userUtil;
    private final String certificateStoreIsolation;

    public CertificateViewResource(CertificateViewRepository certificateViewRepository, UserUtil userUtil, @Value(value="${ca3s.ui.certificate-store.isolation:none}") String certificateStoreIsolation) {
        this.certificateViewRepository = certificateViewRepository;
        this.userUtil = userUtil;
        this.certificateStoreIsolation = certificateStoreIsolation;
    }

    @GetMapping(value={"/certificateViews/{id}"})
    @Transactional
    public ResponseEntity<CertificateView> getCertificate(@PathVariable Long id) {
        this.LOG.debug("REST request to get CertificateView : {}", (Object)id);
        Optional optCert = this.certificateViewRepository.findbyCertificateId(id);
        if (optCert.isPresent()) {
            CertificateView certView = (CertificateView)optCert.get();
            this.checkTenant(certView);
            this.userUtil.addUserDetails(certView);
            return new ResponseEntity((Object)certView, HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    private void checkTenant(CertificateView certView) {
        User currentUser;
        Tenant tenant;
        if ("none".equalsIgnoreCase(this.certificateStoreIsolation)) {
            return;
        }
        if (!this.userUtil.isAdministrativeUser() && (tenant = (currentUser = this.userUtil.getCurrentUser()).getTenant()) != null && !Objects.equals(tenant.getId(), certView.getTenantId()) && Boolean.TRUE.equals(certView.getEndEntity())) {
            this.LOG.info("user [{}] tried to download EE certificate [{}] of tenant [{}]", new Object[]{currentUser.getLogin(), certView.getId(), tenant.getLongname()});
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
    }
}

