/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.AuthSecondFactor;
import de.trustable.ca3s.core.exception.UserNotAuthenticatedException;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import de.trustable.ca3s.core.service.ClientAuthService;
import de.trustable.ca3s.core.service.SMSService;
import de.trustable.ca3s.core.service.TotpService;
import de.trustable.ca3s.core.service.UserCredentialService;
import de.trustable.ca3s.core.service.UserService;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.UserUtil;
import de.trustable.ca3s.core.web.rest.JWTToken;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import de.trustable.ca3s.core.web.rest.vm.LoginData;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class UserJWTController {
    private final Logger log = LoggerFactory.getLogger(UserJWTController.class);
    private final TokenProvider tokenProvider;
    private final UserService userService;
    private final UserCredentialService userCredentialService;
    private final UserUtil userUtil;
    private final TotpService totpService;
    private final SMSService smsService;
    private final ClientAuthService clientAuthService;

    public UserJWTController(TokenProvider tokenProvider, UserService userService, UserCredentialService userCredentialService, UserUtil userUtil, TotpService totpService, SMSService smsService, ClientAuthService clientAuthService) {
        this.tokenProvider = tokenProvider;
        this.userService = userService;
        this.userCredentialService = userCredentialService;
        this.userUtil = userUtil;
        this.totpService = totpService;
        this.smsService = smsService;
        this.clientAuthService = clientAuthService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(noRollbackFor={BadCredentialsException.class, AuthenticationException.class, InternalAuthenticationServiceException.class, UserNotAuthenticatedException.class})
    @PostMapping(value={"/authenticate"})
    public ResponseEntity<?> authorize(@Valid @RequestBody LoginData loginData) {
        this.userUtil.checkIPBlocked(loginData.getUsername());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.log.info("--- is already authenticated: {}", (Object)authentication.isAuthenticated());
        try {
            String jwt;
            User user;
            block17: {
                authentication = this.userCredentialService.validateUserPassword(loginData.getUsername(), loginData.getPassword());
                if (authentication == null) {
                    return this.buildProblemDetailForAuthenticationFailure(loginData, "authentication failed");
                }
                user = this.userUtil.getUserByLogin(loginData.getUsername());
                if (loginData.getAuthSecondFactor() == AuthSecondFactor.TOTP) {
                    if (loginData.getSecondSecret() != null && !loginData.getSecondSecret().isEmpty()) {
                        this.totpService.checkOtpToken(user, loginData.getSecondSecret());
                        break block17;
                    } else {
                        this.log.warn("OTP value missing");
                        throw new BadCredentialsException("Client credentials invalid");
                    }
                }
                if (loginData.getAuthSecondFactor() == AuthSecondFactor.SMS) {
                    if (loginData.getSecondSecret() != null && !loginData.getSecondSecret().isEmpty()) {
                        this.smsService.checkSMS(user, loginData.getSecondSecret());
                        break block17;
                    } else {
                        this.log.warn("OTP value missing");
                        throw new BadCredentialsException("Client credentials invalid");
                    }
                }
                if (loginData.getAuthSecondFactor() == AuthSecondFactor.CLIENT_CERT) {
                    if (loginData.getSecondSecret() != null && !loginData.getSecondSecret().isEmpty()) {
                        jwt = loginData.getSecondSecret();
                        if (!this.tokenProvider.validateToken(jwt)) {
                            this.log.warn("Client cert JWT invalid");
                            throw new BadCredentialsException("Client credentials invalid");
                        }
                        this.log.info("jwt for second factor containing related to client cert : {}", (Object)jwt);
                        if (!this.clientAuthService.isClientCertValidForUser(jwt, user)) {
                            this.log.warn("Client cert ski of JWT does not match user");
                            throw new BadCredentialsException("Client credentials invalid");
                        }
                        this.log.debug("jwt holds ski matching user's client cert ");
                        break block17;
                    } else {
                        this.log.warn("Client cert JWT missing");
                        throw new BadCredentialsException("Client credentials invalid");
                    }
                }
                if (loginData.getAuthSecondFactor() == AuthSecondFactor.NONE) {
                    this.userService.updateSecondFactorRequirement(user, true);
                    if (user.isSecondFactorRequired()) {
                        this.log.warn("Second factor missing but it is required");
                        throw new BadCredentialsException("Client credentials invalid");
                    }
                }
            }
            this.userUtil.handleSuccesfulAuthentication(user, loginData.getAuthSecondFactor());
            SecurityContextHolder.getContext().setAuthentication(authentication);
            jwt = this.tokenProvider.createToken(authentication, loginData.isRememberMe());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Authorization", "Bearer " + jwt);
            return new ResponseEntity((Object)new JWTToken(jwt), (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (AuthenticationException authenticationException) {
            return this.buildProblemDetailForAuthenticationFailure(loginData, authenticationException.getMessage());
        }
        catch (Throwable th) {
            this.log.info("login failed for user '" + loginData.getUsername() + "' with unexpected exception !", th);
            throw th;
        }
    }

    @NotNull
    private ResponseEntity<ProblemDetail> buildProblemDetailForAuthenticationFailure(LoginData loginData, String authenticationExceptionMsg) {
        this.log.info("login failed for user '{}' with reason {} !", (Object)loginData.getUsername(), (Object)authenticationExceptionMsg);
        ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Authentication problem", HttpStatus.FORBIDDEN, authenticationExceptionMsg, AcmeUtil.NO_INSTANCE);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }
}

