/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.web.rest.data.DataCollection;
import de.trustable.ca3s.core.web.rest.data.DataSet;
import de.trustable.ca3s.core.web.rest.support.RequestType;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class DashBoardContent {
    private final Logger LOG = LoggerFactory.getLogger(DashBoardContent.class);
    private final CertificateRepository certificateRepository;
    private final CSRRepository csrRepository;
    public static final String RED = "#FF0000";
    public static final String ORANGE = "#FFA500";
    public static final String GRAY = "#888888";
    public static final String[] DAY_OF_WEEK = new String[]{"So", "Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"};
    static Float MAX_COLOR = Float.valueOf("16777215");

    public DashBoardContent(CertificateRepository certificateRepository, CSRRepository csrRepository) {
        this.certificateRepository = certificateRepository;
        this.csrRepository = csrRepository;
    }

    @GetMapping(value={"/requestsByMonth"})
    public ResponseEntity<DataCollection> getRequestsByMonth(@RequestParam(name="years") int years, @RequestParam(name="requestsAcme") boolean requestsAcme, @RequestParam(name="requestsScep") boolean requestsScep, @RequestParam(name="requestsWeb") boolean requestsWeb) {
        int nMonth = 12 * years;
        String[] labels = new String[nMonth];
        Instant now = Instant.now();
        ArrayList<RequestType> requestTypeList = new ArrayList<RequestType>();
        if (requestsWeb) {
            requestTypeList.add(new RequestType("WEB", "requested Web CSRs", GRAY));
        }
        if (requestsScep) {
            requestTypeList.add(new RequestType("SCEP", "requested SCEP CSRs", RED));
        }
        if (requestsAcme) {
            requestTypeList.add(new RequestType("ACME", "requested ACME CSRs", ORANGE));
        }
        LocalDateTime ldtNow = LocalDateTime.ofInstant(now, ZoneId.systemDefault());
        LocalDateTime ldtYearAgo = ldtNow.minusDays(365L * (long)years);
        int year = ldtYearAgo.getYear();
        int month = ldtYearAgo.getMonthValue();
        HashMap monthDataMap = new HashMap();
        for (int i = 0; i < nMonth; ++i) {
            HashMap<String, Long> countByType = new HashMap<String, Long>();
            countByType.put("INTERNAL", 0L);
            for (RequestType requestType : requestTypeList) {
                countByType.put(requestType.getName(), 0L);
            }
            String monthLabel = month + "." + year;
            monthDataMap.put((CallSite)((Object)monthLabel), countByType);
            labels[i] = monthLabel;
            this.LOG.info("counter setup for month {}", (Object)monthLabel);
            if (++month != 13) continue;
            month = 1;
            ++year;
        }
        Instant after = now.minus(years * 365, ChronoUnit.DAYS);
        List objects = this.csrRepository.groupByTypeRequestedMonth(after);
        this.LOG.debug("objects has #{} elements after {}", (Object)objects.size(), (Object)after);
        for (Object[] resArr : objects) {
            String summaryMonth = resArr[0].toString();
            String summaryType = resArr[1].toString();
            Long count = (Long)resArr[2];
            this.LOG.debug("resArr: {} / {} / {} of type {}", new Object[]{summaryMonth, summaryType, count, resArr[2].getClass().getName()});
            if (monthDataMap.containsKey(summaryMonth)) {
                Map countByTypeMap = (Map)monthDataMap.get(summaryMonth);
                this.LOG.debug("month entry for '{}' contains {} pipeline types", (Object)summaryMonth, (Object)countByTypeMap.size());
                if (countByTypeMap.containsKey(summaryType)) {
                    Long c = (Long)countByTypeMap.get(summaryType);
                    this.LOG.debug("updated: {} / {} to {}", new Object[]{summaryMonth, summaryType, c + count});
                    countByTypeMap.put(summaryType, c + count);
                    continue;
                }
                this.LOG.debug("no counter found for month {} / type {}", (Object)summaryMonth, (Object)summaryType);
                continue;
            }
            this.LOG.debug("no month entry found for '{}'", resArr[0]);
        }
        DataCollection dc = new DataCollection();
        dc.setLabels(labels);
        DataSet[] dataSets = new DataSet[requestTypeList.size()];
        int j = 0;
        for (RequestType requestType : requestTypeList) {
            dataSets[j] = new DataSet(requestType.getLabel(), nMonth);
            dataSets[j].setBackgroundColor(requestType.getColor());
            ++j;
        }
        String[][] backgroundColorArr = new String[3][monthDataMap.size()];
        dc.setDatasets(dataSets);
        int i = 0;
        for (String label : monthDataMap.keySet()) {
            this.LOG.debug("label: {}", (Object)label);
            Map countByTypeMap = (Map)monthDataMap.get(label);
            int k = 0;
            for (RequestType requestType : requestTypeList) {
                dataSets[k].getData()[i] = ((Long)countByTypeMap.get(requestType.getName())).intValue();
                backgroundColorArr[k][i] = requestType.getColor();
                ++k;
            }
            ++i;
        }
        for (int ndx = 0; ndx < dataSets.length; ++ndx) {
            dataSets[ndx].setBackgroundColor(backgroundColorArr[ndx]);
        }
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/expiringCertificatesByDate"})
    public ResponseEntity<DataCollection> getExpiringCertificatesByDate() {
        int nDays = 30;
        int urgentLimitDays = 7;
        int urgentWeekendLimitDays = 10;
        Instant after = Instant.now();
        long nowSec = after.getEpochSecond();
        Instant urgent = Instant.now().plus((long)urgentLimitDays, ChronoUnit.DAYS);
        Instant urgentWeekend = Instant.now().plus((long)urgentWeekendLimitDays, ChronoUnit.DAYS);
        Instant before = Instant.now().plus((long)nDays, ChronoUnit.DAYS);
        List certList = this.certificateRepository.findByValidTo(after, before);
        DataCollection dc = new DataCollection();
        String[] labels = new String[nDays];
        dc.setLabels(labels);
        DataSet[] dataSets = new DataSet[1];
        dc.setDatasets(dataSets);
        for (int i = 0; i < nDays; ++i) {
            Instant instant = after.plus((long)i, ChronoUnit.DAYS);
            int dow = instant.atZone(ZoneId.systemDefault()).getDayOfWeek().getValue();
            labels[i] = DAY_OF_WEEK[dow];
        }
        dataSets[0] = new DataSet("Expiring soon", nDays);
        for (Certificate cert : certList) {
            if (cert.isRevoked()) {
                this.LOG.debug("revoked certificate ignored");
                continue;
            }
            int relativeDay = (int)((cert.getValidTo().getEpochSecond() - nowSec) / 86400L);
            DataSet ds = dataSets[0];
            String color = GRAY;
            if (cert.getValidTo().isBefore(urgent)) {
                color = RED;
            } else if (cert.getValidTo().isBefore(urgentWeekend)) {
                int dow = cert.getValidTo().atZone(ZoneId.systemDefault()).getDayOfWeek().getValue();
                color = dow >= 5 ? RED : ORANGE;
            }
            ds.getBackgroundColor()[relativeDay] = color;
            int[] nArray = ds.getData();
            int n = relativeDay;
            nArray[n] = nArray[n] + 1;
        }
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByHashAlgo"})
    public ResponseEntity<DataCollection> getActiveCertificatesByHashAlgo() {
        List algos = this.certificateRepository.findActiveCertificatesByHashAlgo(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Hash algorithm");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByKeyAlgo"})
    public ResponseEntity<DataCollection> getActiveCertificatesByKeyAlgo() {
        List algos = this.certificateRepository.findActiveCertificatesByKeyAlgo(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Key algorithm");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByKeyLength"})
    public ResponseEntity<DataCollection> getActiveCertificatesByKeyLength() {
        List algos = this.certificateRepository.findActiveCertificatesByKeyLength(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Key length");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    private DataCollection fillDataCollection(List<Object[]> valuesArr, String headingText) {
        int nAlgos = valuesArr.size();
        DataCollection dc = new DataCollection();
        String[] labels = new String[nAlgos];
        dc.setLabels(labels);
        DataSet ds = new DataSet(headingText, new String[nAlgos], nAlgos);
        DataSet[] dataSets = new DataSet[]{ds};
        dc.setDatasets(dataSets);
        int i = 0;
        for (Object[] resArr : valuesArr) {
            if (resArr.length > 0 && resArr[0] != null) {
                this.LOG.debug("resArr[0].toString() : {}", resArr[0]);
                labels[i] = resArr[0].toString();
                ds.getData()[i] = ((Long)resArr[1]).intValue();
                ds.getBackgroundColor()[i] = this.getRandomColor();
            }
            ++i;
        }
        return dc;
    }

    String getRandomColor() {
        BigInteger bi = BigInteger.valueOf((long)(Math.random() * (double)MAX_COLOR.floatValue()));
        return "#" + bi.toString(16);
    }
}

