"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_entities_certificate_certificate-update_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts&":
/*!*********************************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts& ***!
  \*********************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/data/data-utils.service */ "./src/main/webapp/app/shared/data/data-utils.service.ts");
/* harmony import */ var vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuelidate/lib/validators */ "./node_modules/vuelidate/lib/validators/index.js");
/* harmony import */ var date_fns_format__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns/format */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns_parse__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! date-fns/parse */ "./node_modules/date-fns/esm/parse/index.js");
/* harmony import */ var _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/date/filters */ "./src/main/webapp/app/shared/date/filters.ts");
/* harmony import */ var _shared_model_certificate_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/shared/model/certificate.model */ "./src/main/webapp/app/shared/model/certificate.model.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








var validations = {
    certificate: {
        tbsDigest: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        subject: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        sans: {},
        issuer: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        root: {},
        type: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        description: {},
        fingerprint: {},
        serial: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        validFrom: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        validTo: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        },
        keyAlgorithm: {},
        keyLength: {},
        curveName: {},
        hashingAlgorithm: {},
        paddingAlgorithm: {},
        signingAlgorithm: {},
        creationExecutionId: {},
        contentAddedAt: {},
        revokedSince: {},
        revocationReason: {},
        revoked: {},
        revocationExecutionId: {},
        administrationComment: {},
        endEntity: {},
        selfsigned: {},
        trusted: {},
        active: {},
        content: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required
        }
    }
};
var CertificateUpdate = /** @class */ (function (_super) {
    __extends(CertificateUpdate, _super);
    function CertificateUpdate() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.certificate = new _shared_model_certificate_model__WEBPACK_IMPORTED_MODULE_3__.Certificate();
        _this.cSRS = [];
        _this.certificateAttributes = [];
        _this.certificates = [];
        _this.cAConnectorConfigs = [];
        _this.isSaving = false;
        return _this;
    }
    CertificateUpdate.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            if (to.params.certificateId) {
                vm.retrieveCertificate(to.params.certificateId);
            }
            vm.initRelationships();
        });
    };
    CertificateUpdate.prototype.save = function () {
        var _this = this;
        this.isSaving = true;
        if (this.certificate.id) {
            this.certificateService()
                .update(this.certificate)
                .then(function (param) {
                _this.isSaving = false;
                _this.$router.go(-1);
                var message = _this.$t('ca3SApp.certificate.updated', { param: param.id });
                _this.alertService().showAlert(message, 'info');
            });
        }
        else {
            this.certificateService()
                .create(this.certificate)
                .then(function (param) {
                _this.isSaving = false;
                _this.$router.go(-1);
                var message = _this.$t('ca3SApp.certificate.created', { param: param.id });
                _this.alertService().showAlert(message, 'success');
            });
        }
    };
    CertificateUpdate.prototype.convertDateTimeFromServer = function (date) {
        if (date) {
            return (0,date_fns_format__WEBPACK_IMPORTED_MODULE_5__["default"])(date, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT);
        }
        return null;
    };
    CertificateUpdate.prototype.updateInstantField = function (field, event) {
        if (event.target.value) {
            this.certificate[field] = (0,date_fns_parse__WEBPACK_IMPORTED_MODULE_6__["default"])(event.target.value, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT, new Date());
        }
        else {
            this.certificate[field] = null;
        }
    };
    CertificateUpdate.prototype.updateZonedDateTimeField = function (field, event) {
        if (event.target.value) {
            this.certificate[field] = (0,date_fns_parse__WEBPACK_IMPORTED_MODULE_6__["default"])(event.target.value, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT, new Date());
        }
        else {
            this.certificate[field] = null;
        }
    };
    CertificateUpdate.prototype.retrieveCertificate = function (certificateId) {
        var _this = this;
        this.certificateService()
            .find(certificateId)
            .then(function (res) {
            res.validFrom = new Date(res.validFrom);
            res.validTo = new Date(res.validTo);
            res.contentAddedAt = new Date(res.contentAddedAt);
            res.revokedSince = new Date(res.revokedSince);
            _this.certificate = res;
        });
    };
    CertificateUpdate.prototype.previousState = function () {
        this.$router.go(-1);
    };
    CertificateUpdate.prototype.initRelationships = function () {
        var _this = this;
        this.cSRService()
            .retrieve()
            .then(function (res) {
            _this.cSRS = res.data;
        });
        this.certificateAttributeService()
            .retrieve()
            .then(function (res) {
            _this.certificateAttributes = res.data;
        });
        this.certificateService()
            .retrieve()
            .then(function (res) {
            _this.certificates = res.data;
        });
        this.certificateService()
            .retrieve()
            .then(function (res) {
            _this.certificates = res.data;
        });
        this.cAConnectorConfigService()
            .retrieve()
            .then(function (res) {
            _this.cAConnectorConfigs = res.data;
        });
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], CertificateUpdate.prototype, "alertService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('certificateService'),
        __metadata("design:type", Function)
    ], CertificateUpdate.prototype, "certificateService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('cSRService'),
        __metadata("design:type", Function)
    ], CertificateUpdate.prototype, "cSRService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('certificateAttributeService'),
        __metadata("design:type", Function)
    ], CertificateUpdate.prototype, "certificateAttributeService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('cAConnectorConfigService'),
        __metadata("design:type", Function)
    ], CertificateUpdate.prototype, "cAConnectorConfigService", void 0);
    CertificateUpdate = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            validations: validations
        })
    ], CertificateUpdate);
    return CertificateUpdate;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_7__.mixins)(_shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_1__["default"])));
/* harmony default export */ __webpack_exports__["default"] = (CertificateUpdate);


/***/ }),

/***/ "./src/main/webapp/app/shared/data/data-utils.service.ts":
/*!***************************************************************!*\
  !*** ./src/main/webapp/app/shared/data/data-utils.service.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
Copyright 2013-2017 the original author or authors from the JHipster project.
This file is part of the JHipster project, see https://jhipster.github.io/
for more information.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * An utility service for data.
 */
var JhiDataUtils = /** @class */ (function (_super) {
    __extends(JhiDataUtils, _super);
    function JhiDataUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Method to abbreviate the text given
     */
    JhiDataUtils.prototype.abbreviate = function (text, append) {
        if (append === void 0) { append = '...'; }
        if (text.length < 30) {
            return text;
        }
        return text ? text.substring(0, 15) + append + text.slice(-10) : '';
    };
    /**
     * Method to find the byte size of the string provides
     */
    JhiDataUtils.prototype.byteSize = function (base64String) {
        return this.formatAsBytes(this.size(base64String));
    };
    /**
     * Method to open file
     */
    JhiDataUtils.prototype.openFile = function (contentType, data) {
        if (window.navigator && window.navigator.msSaveOrOpenBlob) {
            // To support IE and Edge
            var byteCharacters = atob(data);
            var byteNumbers = new Array(byteCharacters.length);
            for (var i = 0; i < byteCharacters.length; i++) {
                byteNumbers[i] = byteCharacters.charCodeAt(i);
            }
            var byteArray = new Uint8Array(byteNumbers);
            var blob = new Blob([byteArray], {
                type: contentType
            });
            window.navigator.msSaveOrOpenBlob(blob);
        }
        else {
            // Other browsers
            var fileURL = "data:".concat(contentType, ";base64,").concat(data);
            var win = window.open();
            win.document.write('<iframe src="' +
                fileURL +
                '" frameborder="0" style="border:0; top:0px; left:0px; bottom:0px; right:0px; width:100%; height:100%;" allowfullscreen></iframe>');
        }
    };
    /**
     * Method to convert the file to base64
     */
    JhiDataUtils.prototype.toBase64 = function (file, cb) {
        var fileReader = new FileReader();
        fileReader.readAsDataURL(file);
        fileReader.onload = function (e) {
            var base64Data = e.target.result.substr(e.target.result.indexOf('base64,') + 'base64,'.length);
            cb(base64Data);
        };
    };
    /**
     * Method to clear the input
     */
    JhiDataUtils.prototype.clearInputImage = function (entity, elementRef, field, fieldContentType, idInput) {
        if (entity && field && fieldContentType) {
            if (entity.hasOwnProperty(field)) {
                entity[field] = null;
            }
            if (entity.hasOwnProperty(fieldContentType)) {
                entity[fieldContentType] = null;
            }
            if (elementRef && idInput && elementRef.nativeElement.querySelector('#' + idInput)) {
                elementRef.nativeElement.querySelector('#' + idInput).value = null;
            }
        }
    };
    JhiDataUtils.prototype.endsWith = function (suffix, str) {
        return str.indexOf(suffix, str.length - suffix.length) !== -1;
    };
    JhiDataUtils.prototype.paddingSize = function (value) {
        if (this.endsWith('==', value)) {
            return 2;
        }
        if (this.endsWith('=', value)) {
            return 1;
        }
        return 0;
    };
    JhiDataUtils.prototype.size = function (value) {
        return (value.length / 4) * 3 - this.paddingSize(value);
    };
    JhiDataUtils.prototype.formatAsBytes = function (size) {
        return size.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ') + ' bytes';
    };
    JhiDataUtils.prototype.setFileData = function (event, entity, field, isImage) {
        if (event && event.target.files && event.target.files[0]) {
            var file_1 = event.target.files[0];
            if (isImage && !/^image\//.test(file_1.type)) {
                return;
            }
            this.toBase64(file_1, function (base64Data) {
                entity[field] = base64Data;
                entity["".concat(field, "ContentType")] = file_1.type;
            });
        }
    };
    /**
     * Method to download file
     */
    JhiDataUtils.prototype.downloadFile = function (contentType, data, fileName) {
        var byteCharacters = atob(data);
        var byteNumbers = new Array(byteCharacters.length);
        for (var i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        var byteArray = new Uint8Array(byteNumbers);
        var blob = new Blob([byteArray], {
            type: contentType
        });
        var tempLink = document.createElement('a');
        tempLink.href = window.URL.createObjectURL(blob);
        tempLink.download = fileName;
        tempLink.target = '_blank';
        tempLink.click();
    };
    JhiDataUtils = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], JhiDataUtils);
    return JhiDataUtils;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (JhiDataUtils);


/***/ }),

/***/ "./src/main/webapp/app/shared/model/certificate.model.ts":
/*!***************************************************************!*\
  !*** ./src/main/webapp/app/shared/model/certificate.model.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Certificate": function() { return /* binding */ Certificate; }
/* harmony export */ });
var Certificate = /** @class */ (function () {
    function Certificate(id, tbsDigest, subject, sans, issuer, root, type, description, fingerprint, serial, validFrom, validTo, keyAlgorithm, keyLength, curveName, hashingAlgorithm, paddingAlgorithm, signingAlgorithm, creationExecutionId, contentAddedAt, revokedSince, revocationReason, revoked, revocationExecutionId, administrationComment, endEntity, selfsigned, trusted, active, content, csr, certificateAttributes, issuingCertificate, rootCertificate, revocationCA) {
        this.id = id;
        this.tbsDigest = tbsDigest;
        this.subject = subject;
        this.sans = sans;
        this.issuer = issuer;
        this.root = root;
        this.type = type;
        this.description = description;
        this.fingerprint = fingerprint;
        this.serial = serial;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.keyAlgorithm = keyAlgorithm;
        this.keyLength = keyLength;
        this.curveName = curveName;
        this.hashingAlgorithm = hashingAlgorithm;
        this.paddingAlgorithm = paddingAlgorithm;
        this.signingAlgorithm = signingAlgorithm;
        this.creationExecutionId = creationExecutionId;
        this.contentAddedAt = contentAddedAt;
        this.revokedSince = revokedSince;
        this.revocationReason = revocationReason;
        this.revoked = revoked;
        this.revocationExecutionId = revocationExecutionId;
        this.administrationComment = administrationComment;
        this.endEntity = endEntity;
        this.selfsigned = selfsigned;
        this.trusted = trusted;
        this.active = active;
        this.content = content;
        this.csr = csr;
        this.certificateAttributes = certificateAttributes;
        this.issuingCertificate = issuingCertificate;
        this.rootCertificate = rootCertificate;
        this.revocationCA = revocationCA;
        this.revoked = this.revoked || false;
        this.endEntity = this.endEntity || false;
        this.selfsigned = this.selfsigned || false;
        this.trusted = this.trusted || false;
        this.active = this.active || false;
    }
    return Certificate;
}());



/***/ }),

/***/ "./src/main/webapp/app/entities/certificate/certificate-update.vue":
/*!*************************************************************************!*\
  !*** ./src/main/webapp/app/entities/certificate/certificate-update.vue ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./certificate-update.vue?vue&type=template&id=3e26af62& */ "./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62&");
/* harmony import */ var _certificate_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./certificate-update.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _certificate_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__.render,
  _certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/entities/certificate/certificate-update.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts&":
/*!***********************************************************************************************************!*\
  !*** ./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts& ***!
  \***********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_certificate_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./certificate-update.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/certificate/certificate-update.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_certificate_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62&":
/*!********************************************************************************************************!*\
  !*** ./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62& ***!
  \********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_certificate_update_vue_vue_type_template_id_3e26af62___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./certificate-update.vue?vue&type=template&id=3e26af62& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62&":
/*!************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/certificate/certificate-update.vue?vue&type=template&id=3e26af62& ***!
  \************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c("div", { staticClass: "row justify-content-center" }, [
    _c("div", { staticClass: "col-8" }, [
      _c(
        "form",
        {
          attrs: { name: "editForm", role: "form", novalidate: "" },
          on: {
            submit: function ($event) {
              $event.preventDefault()
              return _vm.save()
            },
          },
        },
        [
          _c(
            "h2",
            {
              attrs: { id: "ca3SApp.certificate.home.createOrEditLabel" },
              domProps: {
                textContent: _vm._s(
                  _vm.$t("ca3SApp.certificate.home.createOrEditLabel")
                ),
              },
            },
            [_vm._v("Create or edit a Certificate")]
          ),
          _vm._v(" "),
          _c("div", [
            _vm.certificate.id
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      attrs: { for: "id" },
                      domProps: {
                        textContent: _vm._s(_vm.$t("global.field.id")),
                      },
                    },
                    [_vm._v("ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.certificate.id,
                        expression: "certificate.id",
                      },
                    ],
                    staticClass: "form-control",
                    attrs: { type: "text", id: "id", name: "id", readonly: "" },
                    domProps: { value: _vm.certificate.id },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.$set(_vm.certificate, "id", $event.target.value)
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-tbsDigest" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.tbsDigest")
                    ),
                  },
                },
                [_vm._v("Tbs Digest")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.tbsDigest.$model,
                    expression: "$v.certificate.tbsDigest.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.tbsDigest.$invalid,
                  invalid: _vm.$v.certificate.tbsDigest.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "tbsDigest",
                  id: "certificate-tbsDigest",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.tbsDigest.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.tbsDigest,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.tbsDigest.$anyDirty &&
              _vm.$v.certificate.tbsDigest.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.tbsDigest.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-subject" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.subject")),
                  },
                },
                [_vm._v("Subject")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.subject.$model,
                    expression: "$v.certificate.subject.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.subject.$invalid,
                  invalid: _vm.$v.certificate.subject.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "subject",
                  id: "certificate-subject",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.subject.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.subject,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.subject.$anyDirty &&
              _vm.$v.certificate.subject.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.subject.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-sans" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.sans")),
                  },
                },
                [_vm._v("Sans")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.sans.$model,
                    expression: "$v.certificate.sans.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.sans.$invalid,
                  invalid: _vm.$v.certificate.sans.$invalid,
                },
                attrs: { type: "text", name: "sans", id: "certificate-sans" },
                domProps: { value: _vm.$v.certificate.sans.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.sans,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-issuer" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.issuer")),
                  },
                },
                [_vm._v("Issuer")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.issuer.$model,
                    expression: "$v.certificate.issuer.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.issuer.$invalid,
                  invalid: _vm.$v.certificate.issuer.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "issuer",
                  id: "certificate-issuer",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.issuer.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.issuer,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.issuer.$anyDirty &&
              _vm.$v.certificate.issuer.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.issuer.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-root" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.root")),
                  },
                },
                [_vm._v("Root")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.root.$model,
                    expression: "$v.certificate.root.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.root.$invalid,
                  invalid: _vm.$v.certificate.root.$invalid,
                },
                attrs: { type: "text", name: "root", id: "certificate-root" },
                domProps: { value: _vm.$v.certificate.root.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.root,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-type" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.type")),
                  },
                },
                [_vm._v("Type")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.type.$model,
                    expression: "$v.certificate.type.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.type.$invalid,
                  invalid: _vm.$v.certificate.type.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "type",
                  id: "certificate-type",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.type.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.type,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.type.$anyDirty &&
              _vm.$v.certificate.type.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.type.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-description" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.description")
                    ),
                  },
                },
                [_vm._v("Description")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.description.$model,
                    expression: "$v.certificate.description.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.description.$invalid,
                  invalid: _vm.$v.certificate.description.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "description",
                  id: "certificate-description",
                },
                domProps: { value: _vm.$v.certificate.description.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.description,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-fingerprint" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.fingerprint")
                    ),
                  },
                },
                [_vm._v("Fingerprint")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.fingerprint.$model,
                    expression: "$v.certificate.fingerprint.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.fingerprint.$invalid,
                  invalid: _vm.$v.certificate.fingerprint.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "fingerprint",
                  id: "certificate-fingerprint",
                },
                domProps: { value: _vm.$v.certificate.fingerprint.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.fingerprint,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-serial" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.serial")),
                  },
                },
                [_vm._v("Serial")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.serial.$model,
                    expression: "$v.certificate.serial.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.serial.$invalid,
                  invalid: _vm.$v.certificate.serial.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "serial",
                  id: "certificate-serial",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.serial.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.serial,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.serial.$anyDirty &&
              _vm.$v.certificate.serial.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.serial.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-validFrom" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.validFrom")
                    ),
                  },
                },
                [_vm._v("Valid From")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.certificate.validFrom.$invalid,
                    invalid: _vm.$v.certificate.validFrom.$invalid,
                  },
                  attrs: {
                    id: "certificate-validFrom",
                    type: "datetime-local",
                    name: "validFrom",
                    required: "",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.certificate.validFrom.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("validFrom", $event)
                    },
                  },
                }),
              ]),
              _vm._v(" "),
              _vm.$v.certificate.validFrom.$anyDirty &&
              _vm.$v.certificate.validFrom.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.validFrom.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                    _vm._v(" "),
                    !_vm.$v.certificate.validFrom.ZonedDateTimelocal
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.ZonedDateTimelocal")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field should be a date and time.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-validTo" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.validTo")),
                  },
                },
                [_vm._v("Valid To")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.certificate.validTo.$invalid,
                    invalid: _vm.$v.certificate.validTo.$invalid,
                  },
                  attrs: {
                    id: "certificate-validTo",
                    type: "datetime-local",
                    name: "validTo",
                    required: "",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.certificate.validTo.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("validTo", $event)
                    },
                  },
                }),
              ]),
              _vm._v(" "),
              _vm.$v.certificate.validTo.$anyDirty &&
              _vm.$v.certificate.validTo.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.validTo.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                    _vm._v(" "),
                    !_vm.$v.certificate.validTo.ZonedDateTimelocal
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.ZonedDateTimelocal")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field should be a date and time.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-keyAlgorithm" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.keyAlgorithm")
                    ),
                  },
                },
                [_vm._v("Key Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.keyAlgorithm.$model,
                    expression: "$v.certificate.keyAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.keyAlgorithm.$invalid,
                  invalid: _vm.$v.certificate.keyAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "keyAlgorithm",
                  id: "certificate-keyAlgorithm",
                },
                domProps: { value: _vm.$v.certificate.keyAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.keyAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-keyLength" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.keyLength")
                    ),
                  },
                },
                [_vm._v("Key Length")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model.number",
                    value: _vm.$v.certificate.keyLength.$model,
                    expression: "$v.certificate.keyLength.$model",
                    modifiers: { number: true },
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.keyLength.$invalid,
                  invalid: _vm.$v.certificate.keyLength.$invalid,
                },
                attrs: {
                  type: "number",
                  name: "keyLength",
                  id: "certificate-keyLength",
                },
                domProps: { value: _vm.$v.certificate.keyLength.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.keyLength,
                      "$model",
                      _vm._n($event.target.value)
                    )
                  },
                  blur: function ($event) {
                    return _vm.$forceUpdate()
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-curveName" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.curveName")
                    ),
                  },
                },
                [_vm._v("Curve Name")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.curveName.$model,
                    expression: "$v.certificate.curveName.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.curveName.$invalid,
                  invalid: _vm.$v.certificate.curveName.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "curveName",
                  id: "certificate-curveName",
                },
                domProps: { value: _vm.$v.certificate.curveName.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.curveName,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-hashingAlgorithm" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.hashingAlgorithm")
                    ),
                  },
                },
                [_vm._v("Hashing Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.hashingAlgorithm.$model,
                    expression: "$v.certificate.hashingAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.hashingAlgorithm.$invalid,
                  invalid: _vm.$v.certificate.hashingAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "hashingAlgorithm",
                  id: "certificate-hashingAlgorithm",
                },
                domProps: { value: _vm.$v.certificate.hashingAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.hashingAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-paddingAlgorithm" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.paddingAlgorithm")
                    ),
                  },
                },
                [_vm._v("Padding Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.paddingAlgorithm.$model,
                    expression: "$v.certificate.paddingAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.paddingAlgorithm.$invalid,
                  invalid: _vm.$v.certificate.paddingAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "paddingAlgorithm",
                  id: "certificate-paddingAlgorithm",
                },
                domProps: { value: _vm.$v.certificate.paddingAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.paddingAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-signingAlgorithm" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.signingAlgorithm")
                    ),
                  },
                },
                [_vm._v("Signing Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.signingAlgorithm.$model,
                    expression: "$v.certificate.signingAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.signingAlgorithm.$invalid,
                  invalid: _vm.$v.certificate.signingAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "signingAlgorithm",
                  id: "certificate-signingAlgorithm",
                },
                domProps: { value: _vm.$v.certificate.signingAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.signingAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-creationExecutionId" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.creationExecutionId")
                    ),
                  },
                },
                [_vm._v("Creation Execution Id")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.creationExecutionId.$model,
                    expression: "$v.certificate.creationExecutionId.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.creationExecutionId.$invalid,
                  invalid: _vm.$v.certificate.creationExecutionId.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "creationExecutionId",
                  id: "certificate-creationExecutionId",
                },
                domProps: {
                  value: _vm.$v.certificate.creationExecutionId.$model,
                },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.creationExecutionId,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-contentAddedAt" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.contentAddedAt")
                    ),
                  },
                },
                [_vm._v("Content Added At")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.certificate.contentAddedAt.$invalid,
                    invalid: _vm.$v.certificate.contentAddedAt.$invalid,
                  },
                  attrs: {
                    id: "certificate-contentAddedAt",
                    type: "datetime-local",
                    name: "contentAddedAt",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.certificate.contentAddedAt.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("contentAddedAt", $event)
                    },
                  },
                }),
              ]),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-revokedSince" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.revokedSince")
                    ),
                  },
                },
                [_vm._v("Revoked Since")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.certificate.revokedSince.$invalid,
                    invalid: _vm.$v.certificate.revokedSince.$invalid,
                  },
                  attrs: {
                    id: "certificate-revokedSince",
                    type: "datetime-local",
                    name: "revokedSince",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.certificate.revokedSince.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("revokedSince", $event)
                    },
                  },
                }),
              ]),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-revocationReason" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.revocationReason")
                    ),
                  },
                },
                [_vm._v("Revocation Reason")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.revocationReason.$model,
                    expression: "$v.certificate.revocationReason.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.revocationReason.$invalid,
                  invalid: _vm.$v.certificate.revocationReason.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "revocationReason",
                  id: "certificate-revocationReason",
                },
                domProps: { value: _vm.$v.certificate.revocationReason.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.revocationReason,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-revoked" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.revoked")),
                  },
                },
                [_vm._v("Revoked")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.revoked.$model,
                    expression: "$v.certificate.revoked.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.certificate.revoked.$invalid,
                  invalid: _vm.$v.certificate.revoked.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "revoked",
                  id: "certificate-revoked",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.certificate.revoked.$model)
                    ? _vm._i(_vm.$v.certificate.revoked.$model, null) > -1
                    : _vm.$v.certificate.revoked.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.certificate.revoked.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.certificate.revoked,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.certificate.revoked,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.certificate.revoked, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-revocationExecutionId" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.revocationExecutionId")
                    ),
                  },
                },
                [_vm._v("Revocation Execution Id")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.revocationExecutionId.$model,
                    expression: "$v.certificate.revocationExecutionId.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.revocationExecutionId.$invalid,
                  invalid: _vm.$v.certificate.revocationExecutionId.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "revocationExecutionId",
                  id: "certificate-revocationExecutionId",
                },
                domProps: {
                  value: _vm.$v.certificate.revocationExecutionId.$model,
                },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.revocationExecutionId,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-administrationComment" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.administrationComment")
                    ),
                  },
                },
                [_vm._v("Administration Comment")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.administrationComment.$model,
                    expression: "$v.certificate.administrationComment.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.administrationComment.$invalid,
                  invalid: _vm.$v.certificate.administrationComment.$invalid,
                },
                attrs: {
                  name: "administrationComment",
                  id: "certificate-administrationComment",
                },
                domProps: {
                  value: _vm.$v.certificate.administrationComment.$model,
                },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.administrationComment,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-endEntity" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.endEntity")
                    ),
                  },
                },
                [_vm._v("End Entity")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.endEntity.$model,
                    expression: "$v.certificate.endEntity.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.certificate.endEntity.$invalid,
                  invalid: _vm.$v.certificate.endEntity.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "endEntity",
                  id: "certificate-endEntity",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.certificate.endEntity.$model)
                    ? _vm._i(_vm.$v.certificate.endEntity.$model, null) > -1
                    : _vm.$v.certificate.endEntity.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.certificate.endEntity.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.certificate.endEntity,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.certificate.endEntity,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.certificate.endEntity, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-selfsigned" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.selfsigned")
                    ),
                  },
                },
                [_vm._v("Selfsigned")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.selfsigned.$model,
                    expression: "$v.certificate.selfsigned.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.certificate.selfsigned.$invalid,
                  invalid: _vm.$v.certificate.selfsigned.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "selfsigned",
                  id: "certificate-selfsigned",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.certificate.selfsigned.$model)
                    ? _vm._i(_vm.$v.certificate.selfsigned.$model, null) > -1
                    : _vm.$v.certificate.selfsigned.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.certificate.selfsigned.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.certificate.selfsigned,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.certificate.selfsigned,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.certificate.selfsigned, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-trusted" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.trusted")),
                  },
                },
                [_vm._v("Trusted")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.trusted.$model,
                    expression: "$v.certificate.trusted.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.certificate.trusted.$invalid,
                  invalid: _vm.$v.certificate.trusted.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "trusted",
                  id: "certificate-trusted",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.certificate.trusted.$model)
                    ? _vm._i(_vm.$v.certificate.trusted.$model, null) > -1
                    : _vm.$v.certificate.trusted.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.certificate.trusted.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.certificate.trusted,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.certificate.trusted,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.certificate.trusted, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-active" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.active")),
                  },
                },
                [_vm._v("Active")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.active.$model,
                    expression: "$v.certificate.active.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.certificate.active.$invalid,
                  invalid: _vm.$v.certificate.active.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "active",
                  id: "certificate-active",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.certificate.active.$model)
                    ? _vm._i(_vm.$v.certificate.active.$model, null) > -1
                    : _vm.$v.certificate.active.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.certificate.active.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.certificate.active,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.certificate.active,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.certificate.active, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-content" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.content")),
                  },
                },
                [_vm._v("Content")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.certificate.content.$model,
                    expression: "$v.certificate.content.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.certificate.content.$invalid,
                  invalid: _vm.$v.certificate.content.$invalid,
                },
                attrs: {
                  name: "content",
                  id: "certificate-content",
                  required: "",
                },
                domProps: { value: _vm.$v.certificate.content.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.certificate.content,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.certificate.content.$anyDirty &&
              _vm.$v.certificate.content.$invalid
                ? _c("div", [
                    !_vm.$v.certificate.content.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-csr" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.certificate.csr")),
                  },
                },
                [_vm._v("Csr")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.certificate.csr,
                      expression: "certificate.csr",
                    },
                  ],
                  staticClass: "form-control",
                  attrs: { id: "certificate-csr", name: "csr" },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.certificate,
                        "csr",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c("option", { domProps: { value: null } }),
                  _vm._v(" "),
                  _vm._l(_vm.csrs, function (cSROption) {
                    return _c(
                      "option",
                      {
                        key: cSROption.id,
                        domProps: {
                          value:
                            _vm.certificate.csr &&
                            cSROption.id === _vm.certificate.csr.id
                              ? _vm.certificate.csr
                              : cSROption,
                        },
                      },
                      [_vm._v(_vm._s(cSROption.id))]
                    )
                  }),
                ],
                2
              ),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-issuingCertificate" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.issuingCertificate")
                    ),
                  },
                },
                [_vm._v("Issuing Certificate")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.certificate.issuingCertificate,
                      expression: "certificate.issuingCertificate",
                    },
                  ],
                  staticClass: "form-control",
                  attrs: {
                    id: "certificate-issuingCertificate",
                    name: "issuingCertificate",
                  },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.certificate,
                        "issuingCertificate",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c("option", { domProps: { value: null } }),
                  _vm._v(" "),
                  _vm._l(_vm.certificates, function (certificateOption) {
                    return _c(
                      "option",
                      {
                        key: certificateOption.id,
                        domProps: {
                          value:
                            _vm.certificate.issuingCertificate &&
                            certificateOption.id ===
                              _vm.certificate.issuingCertificate.id
                              ? _vm.certificate.issuingCertificate
                              : certificateOption,
                        },
                      },
                      [_vm._v(_vm._s(certificateOption.id))]
                    )
                  }),
                ],
                2
              ),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-rootCertificate" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.rootCertificate")
                    ),
                  },
                },
                [_vm._v("Root Certificate")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.certificate.rootCertificate,
                      expression: "certificate.rootCertificate",
                    },
                  ],
                  staticClass: "form-control",
                  attrs: {
                    id: "certificate-rootCertificate",
                    name: "rootCertificate",
                  },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.certificate,
                        "rootCertificate",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c("option", { domProps: { value: null } }),
                  _vm._v(" "),
                  _vm._l(_vm.certificates, function (certificateOption) {
                    return _c(
                      "option",
                      {
                        key: certificateOption.id,
                        domProps: {
                          value:
                            _vm.certificate.rootCertificate &&
                            certificateOption.id ===
                              _vm.certificate.rootCertificate.id
                              ? _vm.certificate.rootCertificate
                              : certificateOption,
                        },
                      },
                      [_vm._v(_vm._s(certificateOption.id))]
                    )
                  }),
                ],
                2
              ),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "certificate-revocationCA" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.certificate.revocationCA")
                    ),
                  },
                },
                [_vm._v("Revocation CA")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.certificate.revocationCA,
                      expression: "certificate.revocationCA",
                    },
                  ],
                  staticClass: "form-control",
                  attrs: {
                    id: "certificate-revocationCA",
                    name: "revocationCA",
                  },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.certificate,
                        "revocationCA",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c("option", { domProps: { value: null } }),
                  _vm._v(" "),
                  _vm._l(
                    _vm.cAConnectorConfigs,
                    function (cAConnectorConfigOption) {
                      return _c(
                        "option",
                        {
                          key: cAConnectorConfigOption.id,
                          domProps: {
                            value:
                              _vm.certificate.revocationCA &&
                              cAConnectorConfigOption.id ===
                                _vm.certificate.revocationCA.id
                                ? _vm.certificate.revocationCA
                                : cAConnectorConfigOption,
                          },
                        },
                        [_vm._v(_vm._s(cAConnectorConfigOption.id))]
                      )
                    }
                  ),
                ],
                2
              ),
            ]),
          ]),
          _vm._v(" "),
          _c("div", [
            _c(
              "button",
              {
                staticClass: "btn btn-secondary",
                attrs: { type: "button", id: "cancel-save" },
                on: {
                  click: function ($event) {
                    return _vm.previousState()
                  },
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "ban" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.cancel")),
                    },
                  },
                  [_vm._v("Cancel")]
                ),
              ],
              1
            ),
            _vm._v(" "),
            _c(
              "button",
              {
                staticClass: "btn btn-primary",
                attrs: {
                  type: "submit",
                  id: "save-entity",
                  disabled: _vm.$v.certificate.$invalid || _vm.isSaving,
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "save" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.save")),
                    },
                  },
                  [_vm._v("Save")]
                ),
              ],
              1
            ),
          ]),
        ]
      ),
    ]),
  ])
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_entities_certificate_certificate-update_vue.a94f663d94051bfc23e3.chunk.js.map