/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.Authority_;
import de.trustable.ca3s.core.domain.Tenant_;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.User_;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.NamedValue;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.dto.UserDTO;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UserSpecifications {
    static Logger logger = LoggerFactory.getLogger(UserSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";
    static final String DEFAULT_FILTER = "id,login,firstName,lastName,email,phone,activated,secondFactorRequired,langKey,blockedUntilDate,credentialsValidToDate,managedExternally,authorities";

    private UserSpecifications() {
    }

    public static String getStringValue(String[] inArr) {
        return UserSpecifications.getStringValue((String[])inArr, (String)"");
    }

    public static String getStringValue(String[] inArr, String defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return inArr[0];
    }

    public static int getIntValue(String[] inArr, int defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return Integer.parseInt(inArr[0]);
    }

    public static Page<UserDTO> handleQueryParamsUser(EntityManager entityManager, CriteriaBuilder cb, Map<String, String[]> parameterMap) {
        Object selDataList;
        String[] paramArr;
        long startTime = System.currentTimeMillis();
        ArrayList userSelectionAttributes = new ArrayList();
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(User.class);
        String sortCol = UserSpecifications.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = UserSpecifications.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = UserSpecifications.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = UserSpecifications.getIntValue((String[])parameterMap.get("limit"), (int)20);
        logger.debug("buildPredicate: offset '{}', limit '{}' ", (Object)pageOffset, (Object)pagesize);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = UserSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = "id,login,firstName,lastName,email,phone,activated,secondFactorRequired,langKey,blockedUntilDate,credentialsValidToDate,managedExternally,authorities".split(",");
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            logger.debug("handleQueryParamsCertificateView handles column '{}' ", (Object)col);
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                selDataList = (List)selectionMap.get(col);
                Iterator iterator = selDataList.iterator();
                while (iterator.hasNext()) {
                    SelectionData selDataItem = (SelectionData)iterator.next();
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(UserSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList, userSelectionAttributes));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(UserSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList, userSelectionAttributes));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        ArrayList selectionListDummy = new ArrayList();
        for (String selection : selectionMap.keySet()) {
            boolean handled = false;
            for (String col : columnArr) {
                if (!selection.equals(col)) continue;
                handled = true;
            }
            if (handled) continue;
            selDataList = (List)selectionMap.get(selection);
            Iterator iterator = selDataList.iterator();
            while (iterator.hasNext()) {
                SelectionData selDataItem = (SelectionData)iterator.next();
                predList.add(UserSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)selection, (String)selDataItem.selector, (String)selDataItem.value, selectionListDummy, userSelectionAttributes));
            }
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        long queryStartTime = System.currentTimeMillis();
        List listResponse = typedQuery.getResultList();
        logger.debug("typedQuery.getResultList() took {} msecs", (Object)(System.currentTimeMillis() - queryStartTime));
        ArrayList<UserDTO> userList = new ArrayList<UserDTO>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            userList.add(UserSpecifications.buildUserFromObjArr(colList, (Object[])objArr));
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        Long nTotalElements = 1000L;
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(User.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        Predicate predCount = null;
        ArrayList selectionListCount = new ArrayList();
        for (String string : columnArr) {
            colList.add(string);
            if (selectionMap.containsKey(string)) {
                List selDataList2 = (List)selectionMap.get(string);
                for (SelectionData selDataItem : selDataList2) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{string, selDataItem.selector, selDataItem.value});
                    predCountList.add(UserSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)string, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount, userSelectionAttributes));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)string);
            predCountList.add(UserSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)string, null, (String)"", selectionListCount, userSelectionAttributes));
        }
        selectionListDummy.clear();
        for (String selection : selectionMap.keySet()) {
            boolean handled = false;
            for (String col : columnArr) {
                if (!selection.equals(col)) continue;
                handled = true;
            }
            if (handled) continue;
            List list = (List)selectionMap.get(selection);
            for (SelectionData selDataItem : list) {
                predCountList.add(UserSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)selection, (String)selDataItem.selector, (String)selDataItem.value, selectionListDummy, userSelectionAttributes));
            }
        }
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        try {
            TypedQuery typedCountQuery = entityManager.createQuery(queryCount);
            logger.debug("assembled count query: " + ((Query)typedCountQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        long countStartTime = System.currentTimeMillis();
        nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("count getSingleResult() took {} msecs", (Object)(System.currentTimeMillis() - countStartTime));
        logger.debug("buildPredicate selects {} elements in {} msecs", (Object)nTotalElements, (Object)(System.currentTimeMillis() - startTime));
        return new PageImpl(userList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static UserDTO buildUserFromObjArr(ArrayList<String> colList, Object[] objArr) {
        UserDTO user = new UserDTO();
        ArrayList<NamedValue> namedValueList = new ArrayList<NamedValue>();
        int i = 0;
        for (String attribute : colList) {
            if ("id".equalsIgnoreCase(attribute)) {
                user.setId((Long)objArr[i]);
            } else if ("login".equalsIgnoreCase(attribute)) {
                user.setLogin(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("firstName".equalsIgnoreCase(attribute)) {
                user.setFirstName(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("lastName".equalsIgnoreCase(attribute)) {
                user.setLastName(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("email".equalsIgnoreCase(attribute)) {
                user.setEmail(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("phone".equalsIgnoreCase(attribute)) {
                user.setPhone(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("activated".equalsIgnoreCase(attribute)) {
                user.setActivated(((Boolean)objArr[i]).booleanValue());
            } else if ("secondFactorRequired".equalsIgnoreCase(attribute)) {
                user.setSecondFactorRequired(((Boolean)objArr[i]).booleanValue());
            } else if ("langKey".equalsIgnoreCase(attribute)) {
                user.setLangKey(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("createdDate".equalsIgnoreCase(attribute)) {
                user.setCreatedDate((Instant)objArr[i]);
            } else if ("blockedUntilDate".equalsIgnoreCase(attribute)) {
                user.setBlockedUntilDate((Instant)objArr[i]);
            } else if ("lastModifiedBy".equalsIgnoreCase(attribute)) {
                user.setLastModifiedBy(objArr[i] == null ? "" : objArr[i].toString());
            } else if ("credentialsValidToDate".equalsIgnoreCase(attribute)) {
                user.setCredentialsValidToDate((Instant)objArr[i]);
            } else if ("isManagedExternally".equalsIgnoreCase(attribute)) {
                user.setManagedExternally(((Boolean)objArr[i]).booleanValue());
            } else if (!"isBlocked".equalsIgnoreCase(attribute)) {
                if ("failedLogins".equalsIgnoreCase(attribute)) {
                    user.setFailedLogins((Long)objArr[i]);
                } else if (!"tenant".equalsIgnoreCase(attribute)) {
                    if ("authorities".equalsIgnoreCase(attribute)) {
                        logger.info("attribute '{}' from query returns: {}", (Object)attribute, objArr[i]);
                    } else {
                        logger.info("attribute '{}' from query added as additionalRestriction", (Object)attribute);
                        NamedValue namedValue = new NamedValue();
                        namedValue.setName(attribute);
                        namedValueList.add(namedValue);
                        continue;
                    }
                }
            }
            ++i;
        }
        return user;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = UserSpecifications.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = UserSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = UserSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<User> root, CriteriaBuilder cb, CriteriaQuery<?> userQuery, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList, List<String> certificateSelectionAttributes) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.id));
            pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.id), (String)attributeValue);
        } else if ("login".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.login));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.login), (String)attributeValue);
        } else if ("firstName".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.firstName));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.firstName), (String)attributeValue);
        } else if ("lastName".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.lastName));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.lastName), (String)attributeValue);
        } else if ("email".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.email));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.email), (String)attributeValue);
        } else if ("phone".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.phone));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.phone), (String)attributeValue);
        } else if ("langKey".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.langKey));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.langKey), (String)attributeValue);
        } else if ("activated".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.activated));
            pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.activated), (String)attributeValue);
        } else if ("secondFactorRequired".equalsIgnoreCase(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.secondFactorRequired));
            pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.secondFactorRequired), (String)attributeValue);
        } else if ("failedLogins".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.failedLogins));
            pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.failedLogins), (String)attributeValue);
        } else if ("isManagedExternally".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.managedExternally));
            pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.managedExternally), (String)attributeValue);
        } else if ("createdDate".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.createdDate));
            pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.createdDate), (String)attributeValue);
        } else if ("lastModifiedBy".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.lastModifiedBy));
            pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.lastModifiedBy), (String)attributeValue);
        } else if ("blockedUntilDate".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.blockedUntilDate));
            pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.blockedUntilDate), (String)attributeValue);
        } else if ("credentialsValidToDate".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(User_.credentialsValidToDate));
            pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(User_.credentialsValidToDate), (String)attributeValue);
        } else if ("tenant".equals(attribute)) {
            selectionList.add((Selection<?>)root.get(User_.id));
            if (!attributeValue.isEmpty()) {
                Join attJoin = root.join(User_.tenant, JoinType.LEFT);
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(Tenant_.longname), (String)attributeValue);
            }
        } else if ("authorities".equals(attribute)) {
            selectionList.add((Selection<?>)root.get(User_.id));
            if (attributeValue.trim().length() > 0) {
                Subquery authoritySubquery = userQuery.subquery(Authority.class);
                Root authorityRoot = authoritySubquery.from(Authority.class);
                pred = cb.exists(authoritySubquery.select((Expression)authorityRoot).where((Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)authorityRoot.get(Authority_.name), (String)attributeValue)));
            }
        } else if ("isBlocked".equals(attribute)) {
            // empty if block
        }
        return pred;
    }
}

