/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.BPMNAsyncUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class CertNotificationScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertNotificationScheduler.class);
    private final int maxRecordsPerTransaction;
    private final CertificateRepository certificateRepo;
    private final BPMNAsyncUtil bpmnAsyncUtil;

    public CertNotificationScheduler(@Value(value="${ca3s.batch.maxRecordsPerTransaction:1000}") int maxRecordsPerTransaction, CertificateRepository certificateRepo, BPMNAsyncUtil bpmnAsyncUtil) {
        this.maxRecordsPerTransaction = maxRecordsPerTransaction;
        this.certificateRepo = certificateRepo;
        this.bpmnAsyncUtil = bpmnAsyncUtil;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.certNotification:3600000}")
    public void retrieveCertificates() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Page notificationPendingList = this.certificateRepo.findByAttribute((Pageable)PageRequest.of((int)0, (int)this.maxRecordsPerTransaction), "CERTIFICATE_NOTIFICATION_PROCESS");
        int count = 0;
        for (Certificate certificate : notificationPendingList) {
            this.bpmnAsyncUtil.processChange(certificate, auth);
            this.LOG.info("processed notification for certificate {} ", (Object)certificate.getId());
            if (count++ <= this.maxRecordsPerTransaction) continue;
            this.LOG.info("limited certificate notification processing to {} per call", (Object)this.maxRecordsPerTransaction);
            break;
        }
    }
}

