/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.adcsCertUtil.ADCSProxyUnavailableException;
import de.trustable.ca3s.adcsCertUtil.OODBConnectionsADCSException;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.enumeration.CAConnectorType;
import de.trustable.ca3s.core.domain.enumeration.Interval;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.adcs.ADCSConnector;
import de.trustable.ca3s.core.service.dir.DirectoryConnector;
import de.trustable.ca3s.core.service.ejbca.EjbcaConnector;
import de.trustable.ca3s.core.service.vault.VaultCertificateConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CertificateImportScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertificateImportScheduler.class);
    private final CAConnectorConfigRepository caConfigRepo;
    private final ADCSConnector adcsController;
    private final DirectoryConnector dirConnector;
    private final VaultCertificateConnector vaultCertificateConnector;
    private final EjbcaConnector ejbcaConnector;
    private final AuditService auditService;
    @Value(value="${certificate.import.active:true}")
    private String certificateImportActive;

    public CertificateImportScheduler(CAConnectorConfigRepository caConfigRepo, ADCSConnector adcsController, DirectoryConnector dirConnector, VaultCertificateConnector vaultCertificateConnector, EjbcaConnector ejbcaConnector, AuditService auditService) {
        this.caConfigRepo = caConfigRepo;
        this.adcsController = adcsController;
        this.dirConnector = dirConnector;
        this.vaultCertificateConnector = vaultCertificateConnector;
        this.ejbcaConnector = ejbcaConnector;
        this.auditService = auditService;
    }

    @Scheduled(fixedDelay=30000L)
    public void runMinute() {
        if ("true".equalsIgnoreCase(this.certificateImportActive)) {
            for (CAConnectorConfig caConfig : this.caConfigRepo.findAll()) {
                if (!Interval.MINUTE.equals((Object)caConfig.getInterval()) || !caConfig.isActive().booleanValue()) continue;
                this.runImporter(caConfig);
            }
            this.LOG.debug("retrieveCertificates 'Minute' finished");
        } else {
            this.LOG.debug("retrieveCertificates disabled");
        }
    }

    @Scheduled(cron="0 3 * * * *")
    public void runHour() {
        if ("true".equalsIgnoreCase(this.certificateImportActive)) {
            for (CAConnectorConfig caConfig : this.caConfigRepo.findAll()) {
                if (!Interval.HOUR.equals((Object)caConfig.getInterval()) || !caConfig.isActive().booleanValue()) continue;
                this.runImporter(caConfig);
            }
            this.LOG.debug("retrieveCertificates 'Hour' finished");
        } else {
            this.LOG.debug("retrieveCertificates disabled");
        }
    }

    @Scheduled(cron="0 14 1 * * *")
    public void runDay() {
        if ("true".equalsIgnoreCase(this.certificateImportActive)) {
            for (CAConnectorConfig caConfig : this.caConfigRepo.findAll()) {
                if (!Interval.DAY.equals((Object)caConfig.getInterval()) || !caConfig.isActive().booleanValue()) continue;
                this.runImporter(caConfig);
            }
            this.LOG.debug("retrieveCertificates 'Day' finished");
        } else {
            this.LOG.debug("retrieveCertificates disabled");
        }
    }

    @Scheduled(cron="0 5 2 ? * SUN")
    public void runWeek() {
        if ("true".equalsIgnoreCase(this.certificateImportActive)) {
            for (CAConnectorConfig caConfig : this.caConfigRepo.findAll()) {
                if (!Interval.WEEK.equals((Object)caConfig.getInterval()) || !caConfig.isActive().booleanValue()) continue;
                this.runImporter(caConfig);
            }
            this.LOG.debug("retrieveCertificates 'Week' finished");
        } else {
            this.LOG.debug("retrieveCertificates disabled");
        }
    }

    @Scheduled(cron="22 5 3 1 * ?")
    public void runMonth() {
        if ("true".equalsIgnoreCase(this.certificateImportActive)) {
            for (CAConnectorConfig caConfig : this.caConfigRepo.findAll()) {
                if (!Interval.MONTH.equals((Object)caConfig.getInterval()) || !caConfig.isActive().booleanValue()) continue;
                this.runImporter(caConfig);
            }
            this.LOG.debug("retrieveCertificates 'Month' finished");
        } else {
            this.LOG.debug("retrieveCertificates disabled");
        }
    }

    private void runImporter(CAConnectorConfig caConfig) {
        block24: {
            CAConnectorType conType = caConfig.getCaConnectorType();
            if (CAConnectorType.ADCS_CERTIFICATE_INVENTORY.equals((Object)conType)) {
                if (caConfig.isActive().booleanValue()) {
                    try {
                        int nNewCerts = this.adcsController.retrieveCertificates(caConfig);
                        if (nNewCerts > 0) {
                            this.LOG.info("ADCS certificate retrieval for '{}' (url '{}') processed {} certificates", new Object[]{caConfig.getName(), caConfig.getCaUrl(), nNewCerts});
                            this.caConfigRepo.save((Object)caConfig);
                            break block24;
                        }
                        this.LOG.debug("ADCS certificate retrieval for '{}' (url '{}') found no new certificates", (Object)caConfig.getName(), (Object)caConfig.getCaUrl());
                    }
                    catch (OODBConnectionsADCSException e) {
                        this.LOG.warn("deferring ADCS querying for '{}'", (Object)caConfig.getName());
                    }
                    catch (ADCSProxyUnavailableException e) {
                        this.LOG.warn("ADCS proxy '{}' unavailable, trying later ...", (Object)caConfig.getName());
                    }
                    catch (Throwable th) {
                        this.LOG.info("ADCS certificate retrieval for '{}' (url '{}') failed with msg '{}'", new Object[]{caConfig.getName(), caConfig.getCaUrl(), th.getMessage()});
                        this.LOG.debug("ADCS certificate retrieval", th);
                    }
                } else {
                    this.LOG.info("ADCS proxy '{}' disabled", (Object)caConfig.getName());
                }
            } else if (CAConnectorType.DIRECTORY.equals((Object)caConfig.getCaConnectorType())) {
                this.LOG.debug("CAConnectorType DIRECTORY for " + caConfig.getCaUrl());
                try {
                    int nNewCerts = this.dirConnector.retrieveCertificates(caConfig);
                    if (nNewCerts > 0) {
                        this.LOG.info("Directory certificate retrieval for '{}' (url '{}') processed {} certificates", new Object[]{caConfig.getName(), caConfig.getCaUrl(), nNewCerts});
                        this.caConfigRepo.save((Object)caConfig);
                        break block24;
                    }
                    this.LOG.debug("Directory certificate retrieval for '{}' (url '{}') found no new certificates", (Object)caConfig.getName(), (Object)caConfig.getCaUrl());
                }
                catch (Throwable th) {
                    this.LOG.info("Directory certificate retrieval for '{}' (url '{}') failed with msg '{}'", new Object[]{caConfig.getName(), caConfig.getCaUrl(), th.getMessage()});
                    this.LOG.debug("Directory certificate retrieval", th);
                }
            } else if (CAConnectorType.VAULT_INVENTORY.equals((Object)caConfig.getCaConnectorType())) {
                this.LOG.debug("CAConnectorType VAULT_INVENTORY for " + caConfig.getCaUrl());
                try {
                    int nNewCerts = this.vaultCertificateConnector.retrieveCertificates(caConfig);
                    if (nNewCerts > 0) {
                        this.LOG.info("VAULT_INVENTORY certificate retrieval for '{}' (url '{}') processed {} certificates", new Object[]{caConfig.getName(), caConfig.getCaUrl(), nNewCerts});
                        this.caConfigRepo.save((Object)caConfig);
                        break block24;
                    }
                    this.LOG.debug("VAULT_INVENTORY certificate retrieval for '{}' (url '{}') found no new certificates", (Object)caConfig.getName(), (Object)caConfig.getCaUrl());
                }
                catch (Throwable th) {
                    this.LOG.info("VAULT_INVENTORY certificate retrieval for '{}' (url '{}') failed with msg '{}'", new Object[]{caConfig.getName(), caConfig.getCaUrl(), th.getMessage()});
                    this.LOG.debug("VAULT_INVENTORY certificate retrieval", th);
                }
            } else if (CAConnectorType.EJBCA_INVENTORY.equals((Object)caConfig.getCaConnectorType())) {
                this.LOG.debug("CAConnectorType EJBCA_INVENTORY for " + caConfig.getCaUrl());
                try {
                    int nNewCerts = this.ejbcaConnector.retrieveCertificates(caConfig);
                    if (nNewCerts > 0) {
                        this.LOG.info("EJBCA inventory retrieval for '{}' (url '{}') processed {} certificates", new Object[]{caConfig.getName(), caConfig.getCaUrl(), nNewCerts});
                        this.caConfigRepo.save((Object)caConfig);
                        break block24;
                    }
                    this.LOG.debug("EJBCA inventory retrieval for '{}' (url '{}') found no new certificates", (Object)caConfig.getName(), (Object)caConfig.getCaUrl());
                }
                catch (Throwable th) {
                    this.LOG.info("EJBCA inventory retrieval for '{}' (url '{}') failed with msg '{}'", new Object[]{caConfig.getName(), caConfig.getCaUrl(), th.getMessage()});
                    this.LOG.debug("EJBCA inventory retrieval", th);
                }
            } else {
                this.LOG.debug("CAConnectorType '{}' not suitable for certificate retrieval", (Object)conType);
            }
        }
    }
}

