/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule.spider;

import de.trustable.ca3s.core.schedule.spider.CrawlerWorker;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    private static final int MAX_PAGES_TO_SEARCH = 100;

    public Set<String> search(String url, String regEx) {
        HashSet<String> pagesVisited = new HashSet<String>();
        HashSet<String> certificateSet = new HashSet<String>();
        LinkedList<String> pagesToVisit = new LinkedList<String>();
        pagesToVisit.add(url);
        Pattern searchPattern = Pattern.compile(regEx);
        while (!pagesToVisit.isEmpty() && pagesVisited.size() < 100) {
            CrawlerWorker leg = new CrawlerWorker();
            String nextUrl = url;
            if (!pagesToVisit.isEmpty()) {
                while (pagesVisited.contains(nextUrl = (String)pagesToVisit.remove(0)) && !pagesToVisit.isEmpty()) {
                }
                pagesVisited.add(nextUrl);
            }
            try {
                if (!leg.crawl(nextUrl, searchPattern, certificateSet)) continue;
                pagesToVisit.addAll(leg.getLinks());
            }
            catch (IllegalArgumentException mue) {
                this.LOGGER.debug("unexpected URL found at url '" + url + "'", (Throwable)mue);
            }
        }
        this.LOGGER.debug("Visited " + pagesVisited.size() + " web page(s), found #" + certificateSet.size() + " different certificates");
        return certificateSet;
    }
}

