/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.repository.AuthorityRepository;
import de.trustable.ca3s.core.repository.UserPreferenceRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.KeycloakUserDetails;
import de.trustable.ca3s.core.security.KeycloakUserId;
import de.trustable.ca3s.core.service.dto.Languages;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.thymeleaf.util.StringUtils;

@Service
public class OIDCRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OIDCRestService.class);
    private final String clientId;
    private final String clientSecret;
    private final String[] rolesUserArr;
    private final String[] rolesDomainRAArr;
    private final String[] rolesRAArr;
    private final String[] rolesAdminArr;
    private final UserPreferenceRepository userPreferenceRepository;
    private final UserRepository userRepository;
    private final AuthorityRepository authorityRepository;
    private final PasswordEncoder passwordEncoder;
    private final Languages languages;

    public OIDCRestService(@Value(value="${ca3s.oidc.roles.user:USER}") String[] rolesUserArr, @Value(value="${ca3s.oidc.roles.domainra:DOMAIN_RA}") String[] rolesDomainRAArr, @Value(value="${ca3s.oidc.roles.ra:RA}") String[] rolesRAArr, @Value(value="${ca3s.oidc.roles.admin:ADMIN}") String[] rolesAdminArr, @Value(value="${ca3s.oidc.client-id:#{null}}") String clientId, @Value(value="${ca3s.oidc.client-secret:clientSecret}") String clientSecret, @Value(value="${ca3s.ui.languages:en,de,pl}") String availableLanguages, UserPreferenceRepository userPreferenceRepository, UserRepository userRepository, AuthorityRepository authorityRepository, PasswordEncoder passwordEncoder) {
        this.rolesUserArr = rolesUserArr;
        this.rolesDomainRAArr = rolesDomainRAArr;
        this.rolesRAArr = rolesRAArr;
        this.rolesAdminArr = rolesAdminArr;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userPreferenceRepository = userPreferenceRepository;
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.passwordEncoder = passwordEncoder;
        this.languages = new Languages(availableLanguages);
    }

    public String exchangeCodeToToken(String keycloakTokenUri, String authCode, String redirectUri) throws JsonProcessingException, UnsupportedEncodingException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"code", (Object)authCode);
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)redirectUri);
        LOG.info("sending map: {} to URL '{}'", (Object)map, (Object)keycloakTokenUri);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        String authToken = (String)restTemplate.postForObject(keycloakTokenUri, (Object)request, String.class, new Object[0]);
        LOG.info("authToken: {}", (Object)authToken);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        KeycloakUserId keycloakUserId = (KeycloakUserId)objectMapper.readValue(authToken, KeycloakUserId.class);
        return keycloakUserId.getAccess_token();
    }

    @Transactional
    public KeycloakUserDetails getUserInfo(String keycloakUserInfoUrl, String token) throws JsonProcessingException {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Authorization", (Object)("Bearer " + token));
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity request = new HttpEntity(null, (MultiValueMap)headers);
        LOG.info("request: {}", (Object)request);
        String userInfo = (String)restTemplate.postForObject(keycloakUserInfoUrl, (Object)request, String.class, new Object[0]);
        LOG.debug("userInfo: {}", (Object)userInfo);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        KeycloakUserDetails keycloakUserDetails = (KeycloakUserDetails)objectMapper.readValue(userInfo, KeycloakUserDetails.class);
        this.storeUserInfo(keycloakUserDetails);
        return keycloakUserDetails;
    }

    @Transactional
    public KeycloakUserDetails getUserInfo(AccessToken token) {
        KeycloakUserDetails keycloakUserDetails = new KeycloakUserDetails();
        keycloakUserDetails.setEmail(token.getEmail());
        keycloakUserDetails.setName(token.getName());
        keycloakUserDetails.setFamily_name(token.getFamilyName());
        keycloakUserDetails.setGiven_name(token.getGivenName());
        keycloakUserDetails.setPreferred_username(token.getPreferredUsername());
        String[] roleArr = new String[]{"ROLE_USER"};
        keycloakUserDetails.setRoles(roleArr);
        keycloakUserDetails.setSub(token.getSubject());
        this.storeUserInfo(keycloakUserDetails);
        return keycloakUserDetails;
    }

    private void storeUserInfo(KeycloakUserDetails keycloakUserDetails) {
        if (keycloakUserDetails.getSub().isEmpty()) {
            LOG.info("no subscriber retrieved for token {}", (Object)keycloakUserDetails);
        } else {
            List userPreferenceList = this.userPreferenceRepository.findByNameContent("KEYCLOAK_ID", keycloakUserDetails.getSub());
            if (userPreferenceList.isEmpty()) {
                User user = new User();
                user.setPassword(this.passwordEncoder.encode((CharSequence)RandomStringUtils.random((int)16)));
                user.setActivated(true);
                user.setManagedExternally(true);
                user.setLangKey(this.languages.alignLanguage("en"));
                this.updateUserFromKeycloak(keycloakUserDetails, user);
                UserPreference userPreference = new UserPreference();
                userPreference.setUserId(user.getId());
                userPreference.setName("KEYCLOAK_ID");
                userPreference.setContent(keycloakUserDetails.getSub());
                this.userPreferenceRepository.save((Object)userPreference);
                LOG.info("created new user {}", (Object)user.getId());
            } else {
                UserPreference userPreference = (UserPreference)userPreferenceList.get(0);
                Optional userOptional = this.userRepository.findById((Object)userPreference.getUserId());
                if (userOptional.isPresent()) {
                    User user = (User)userOptional.get();
                    this.updateUserFromKeycloak(keycloakUserDetails, user);
                } else {
                    LOG.warn("no user retrievable for user id {}", (Object)userPreference.getUserId());
                }
            }
        }
    }

    private void updateUserFromKeycloak(KeycloakUserDetails keycloakUserDetails, User user) {
        Set authoritySet;
        boolean update = false;
        String effLoginName = this.retrieveUserName(keycloakUserDetails);
        if (!StringUtils.equals((Object)user.getLogin(), (Object)effLoginName).booleanValue()) {
            LOG.info("oidc data updates user name from '{}' to '{}'", (Object)user.getLogin(), (Object)effLoginName);
            user.setLogin(effLoginName);
            update = true;
        }
        if (!StringUtils.equals((Object)user.getFirstName(), (Object)keycloakUserDetails.getGiven_name()).booleanValue()) {
            LOG.info("oidc data updates first name from '{}' to '{}'", (Object)user.getFirstName(), (Object)keycloakUserDetails.getGiven_name());
            user.setFirstName(keycloakUserDetails.getGiven_name());
            update = true;
        }
        if (!StringUtils.equals((Object)user.getLastName(), (Object)keycloakUserDetails.getFamily_name()).booleanValue()) {
            LOG.info("oidc data updates first name from '{}' to '{}'", (Object)user.getLastName(), (Object)keycloakUserDetails.getFamily_name());
            user.setLastName(keycloakUserDetails.getFamily_name());
            update = true;
        }
        if (!StringUtils.equals((Object)user.getEmail(), (Object)keycloakUserDetails.getEmail()).booleanValue()) {
            LOG.info("oidc data updates first name from '{}' to '{}'", (Object)user.getEmail(), (Object)keycloakUserDetails.getEmail());
            user.setEmail(keycloakUserDetails.getEmail());
            update = true;
        }
        if (!user.isManagedExternally()) {
            user.setManagedExternally(true);
            update = true;
        }
        if ((authoritySet = this.getAuthoritiesFromKeycloak(keycloakUserDetails.getRoles())).containsAll(user.getAuthorities()) && user.getAuthorities().containsAll(authoritySet)) {
            LOG.debug("Roles local / oidc are identical");
        } else {
            LOG.info("oidc roles '{}' != current roles '{}'", (Object)authoritySet, (Object)user.getAuthorities());
            user.setAuthorities(authoritySet);
            update = true;
        }
        if (update) {
            user.setLastUserDetailsUpdate(Instant.now());
            this.userRepository.save((Object)user);
        }
    }

    @NotNull
    public String retrieveUserName(KeycloakUserDetails keycloakUserDetails) {
        String effLoginName = keycloakUserDetails.getName();
        if (effLoginName == null || effLoginName.isEmpty()) {
            effLoginName = keycloakUserDetails.getPreferred_username();
            if (effLoginName == null || effLoginName.isEmpty()) {
                effLoginName = keycloakUserDetails.getEmail();
                if (effLoginName == null || effLoginName.isEmpty()) {
                    effLoginName = (keycloakUserDetails.getGiven_name() + "_" + keycloakUserDetails.getFamily_name()).trim();
                    LOG.debug("using 'given name' and 'family name' ('{}') as login", (Object)effLoginName);
                } else {
                    LOG.debug("using 'email' ('{}') as login", (Object)effLoginName);
                }
            } else {
                LOG.debug("using 'preferred_username' ('{}') as login", (Object)effLoginName);
            }
        } else {
            LOG.debug("using 'name' ('{}') as login", (Object)effLoginName);
        }
        effLoginName = effLoginName.replaceAll("[^_.@A-Za-z0-9-]", "_");
        return effLoginName;
    }

    public Set<GrantedAuthority> getAuthorities(KeycloakUserDetails keycloakUserDetails) {
        HashSet<GrantedAuthority> grantedAuthoritySet = new HashSet<GrantedAuthority>();
        for (Authority authority : this.getAuthoritiesFromKeycloak(keycloakUserDetails.getRoles())) {
            LOG.debug("oidc role '{}' added to granted roles", (Object)authority.getName());
            grantedAuthoritySet.add((GrantedAuthority)new SimpleGrantedAuthority(authority.getName()));
        }
        return grantedAuthoritySet;
    }

    private Set<Authority> getAuthoritiesFromKeycloak(String[] roles) {
        HashSet<Authority> authoritySet = new HashSet<Authority>();
        for (Authority authority : this.authorityRepository.findAll()) {
            if (authority.getName().equalsIgnoreCase("ROLE_USER")) {
                this.addMatchedRole(authoritySet, roles, authority, this.rolesUserArr);
                continue;
            }
            if (authority.getName().equalsIgnoreCase("ROLE_RA_DOMAIN")) {
                this.addMatchedRole(authoritySet, roles, authority, this.rolesDomainRAArr);
                continue;
            }
            if (authority.getName().equalsIgnoreCase("ROLE_RA")) {
                this.addMatchedRole(authoritySet, roles, authority, this.rolesRAArr);
                continue;
            }
            if (authority.getName().equalsIgnoreCase("ROLE_ADMIN")) {
                this.addMatchedRole(authoritySet, roles, authority, this.rolesAdminArr);
                continue;
            }
            LOG.warn("Unexpected authority '{}' !", (Object)authority.getName());
        }
        if (authoritySet.isEmpty()) {
            for (Authority authority : this.authorityRepository.findAll()) {
                if (!authority.getName().equalsIgnoreCase("ROLE_USER")) continue;
                authoritySet.add(authority);
                LOG.warn("No relevant authority from oidc, adding fallback role 'ROLE_USER' !");
            }
        }
        return authoritySet;
    }

    private boolean addMatchedRole(Set<Authority> authoritySet, String[] oidcRoles, Authority authority, String[] rolesNameArr) {
        if (oidcRoles == null || oidcRoles.length == 0) {
            LOG.debug("addMatchedRole : roles from identity provider are empty");
            return false;
        }
        for (String role : rolesNameArr) {
            if ("*".equals(role.trim())) {
                authoritySet.add(authority);
                LOG.debug("addMatchedRole added authority '{}' as default role", (Object)role, (Object)authority.getName());
                return true;
            }
            LOG.debug("addMatchedRole accepts role '{}' for authority '{}'", (Object)role, (Object)authority.getName());
        }
        boolean hasMatch = false;
        for (String role : oidcRoles) {
            if (ArrayUtils.contains((Object[])rolesNameArr, (Object)role)) {
                authoritySet.add(authority);
                hasMatch = true;
                LOG.debug("addMatchedRole checking oidc role '{}' does match mapping !", (Object)role);
                continue;
            }
            LOG.debug("addMatchedRole checking oidc role '{}' does not match mapping", (Object)role);
        }
        return hasMatch;
    }
}

