/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.provider;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.security.provider.Ca3sTrustManager;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Ca3sClientCertTrustManager
extends Ca3sTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ca3sClientCertTrustManager.class);

    public Ca3sClientCertTrustManager(CertificateRepository certificateRepository, CryptoService cryptoUtil, CertificateUtil certUtil, AuditService auditService) {
        super(certificateRepository, cryptoUtil, certUtil, auditService);
    }

    List<Certificate> getAcceptedIssuerList() {
        LOGGER.debug("In getAcceptedIssuerList ... ");
        HashSet<Certificate> clientCertRootSet = new HashSet<Certificate>();
        List clientCertList = this.certificateRepository.findActiveByAttribute("USER_CLIENT_CERT");
        for (Certificate cert : clientCertList) {
            if (cert.getRootCertificate() == null) continue;
            clientCertRootSet.add(cert.getRootCertificate());
        }
        LOGGER.debug("#{} active client certs, #{} corresponding roots", (Object)clientCertList.size(), (Object)clientCertRootSet.size());
        for (Certificate cert : clientCertRootSet) {
            LOGGER.debug("client cert root {}", (Object)cert.getSubject());
        }
        return new ArrayList<Certificate>(clientCertRootSet);
    }
}

