/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.dto.ARAContentType;
import de.trustable.ca3s.core.service.dto.ARARestriction;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.NameMessages;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.service.util.StateOverview;
import de.trustable.ca3s.core.service.util.UserUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.transaction.Transactional;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationService.class);
    private final CertificateRepository certificateRepo;
    private final CSRRepository csrRepo;
    private final UserRepository userRepository;
    private final CAConnectorConfigRepository caConnectorConfigRepository;
    private final PipelineRepository pipelineRepository;
    private final PipelineUtil pipelineUtil;
    private final ProtectedContentUtil protectedContentUtil;
    private final CertificateUtil certificateUtil;
    private final CSRUtil csrUtil;
    private final MailService mailService;
    private final AuditService auditService;
    private final int nDaysExpiryEE;
    private final int nDaysExpiryCA;
    private final int nDaysPending;
    private final List<Integer> notificationDayList;
    private final boolean notifyUserOnly;
    private final boolean doNotifyAdminOnConnectorExpiry;
    private final boolean doNotifyRAOfficerHolderOnExpiry;
    private final boolean doNotifyRequestorOnExpiry;
    private final boolean doNotifyCertificateRevoked;
    private final boolean doNotifyUserCertificateRejected;
    private final boolean doNotifyUserCertificateIssued;
    private final boolean doNotifyRAOfficerOnRequest;
    private final boolean doNotifyRAOfficerOnUserRevocation;
    private final boolean doNotifyRequestorOnExcessiveActiveCertificates;
    private final UserUtil userUtil;

    @Autowired
    public NotificationService(CertificateRepository certificateRepo, CSRRepository csrRepo, UserRepository userRepository, PipelineUtil pipelineUtil, CAConnectorConfigRepository caConnectorConfigRepository, CertificateUtil certificateUtil, MailService mailService, PipelineRepository pipelineRepository, AuditService auditService, @Value(value="${ca3s.schedule.ra-officer-notification.days-before-expiry.ee:30}") int nDaysExpiryEE, @Value(value="${ca3s.schedule.ra-officer-notification.days-before-expiry.ca:90}") int nDaysExpiryCA, @Value(value="${ca3s.schedule.ra-officer-notification.days-pending:30}") int nDaysPending, @Value(value="${ca3s.schedule.requestor.notification.days:30,14,7,6,5,4,3,2,1}") String notificationDays, ProtectedContentUtil protectedContentUtil, @Value(value="${ca3s.schedule.requestor.notification.user-only:false}") boolean notifyUserOnly, @Value(value="${ca3s.notify.adminOnConnectorExpiry:true}") boolean doNotifyAdminOnConnectorExpiry, @Value(value="${ca3s.notify.raOfficerHolderOnExpiry:true}") boolean doNotifyRAOfficerHolderOnExpiry, @Value(value="${ca3s.notify.requestorOnExpiry:true}") boolean doNotifyRequestorOnExpiry, @Value(value="${ca3s.notify.CertificateRevoked:true}") boolean doNotifyCertificateRevoked, @Value(value="${ca3s.notify.userCertificateRejected:true}") boolean doNotifyUserCertificateRejected, @Value(value="${ca3s.notify.userCertificateIssued:true}") boolean doNotifyUserCertificateIssued, @Value(value="${ca3s.notify.raOfficerOnRequest:true}") boolean doNotifyRAOfficerOnRequest, @Value(value="${ca3s.notify.raOfficerOnUserRevocation:true}") boolean doNotifyRAOfficerOnUserRevocation, @Value(value="${ca3s.notify.requestorOnExcessiveActiveCertificates:true}") boolean doNotifyRequestorOnExcessiveActiveCertificates, CSRUtil csrUtil, UserUtil userUtil) {
        String[] parts;
        this.certificateRepo = certificateRepo;
        this.csrRepo = csrRepo;
        this.userRepository = userRepository;
        this.pipelineUtil = pipelineUtil;
        this.certificateUtil = certificateUtil;
        this.protectedContentUtil = protectedContentUtil;
        this.csrUtil = csrUtil;
        this.userUtil = userUtil;
        this.mailService = mailService;
        this.auditService = auditService;
        this.nDaysExpiryEE = nDaysExpiryEE;
        this.nDaysExpiryCA = nDaysExpiryCA;
        this.nDaysPending = nDaysPending;
        this.caConnectorConfigRepository = caConnectorConfigRepository;
        this.pipelineRepository = pipelineRepository;
        this.notifyUserOnly = notifyUserOnly;
        this.doNotifyAdminOnConnectorExpiry = doNotifyAdminOnConnectorExpiry;
        this.doNotifyRAOfficerHolderOnExpiry = doNotifyRAOfficerHolderOnExpiry;
        this.doNotifyRequestorOnExpiry = doNotifyRequestorOnExpiry;
        this.doNotifyCertificateRevoked = doNotifyCertificateRevoked;
        this.doNotifyUserCertificateRejected = doNotifyUserCertificateRejected;
        this.doNotifyUserCertificateIssued = doNotifyUserCertificateIssued;
        this.doNotifyRAOfficerOnRequest = doNotifyRAOfficerOnRequest;
        this.doNotifyRAOfficerOnUserRevocation = doNotifyRAOfficerOnUserRevocation;
        this.doNotifyRequestorOnExcessiveActiveCertificates = doNotifyRequestorOnExcessiveActiveCertificates;
        this.notificationDayList = new ArrayList();
        for (String part : parts = notificationDays.split(",")) {
            try {
                this.notificationDayList.add(Integer.parseInt(part));
            }
            catch (NumberFormatException nfe) {
                LOG.info("Unexpected value '{}' in 'ca3s.schedule.requestor.notification.days': {}", (Object)part, (Object)nfe.getMessage());
            }
        }
    }

    @Transactional
    public int notifyAdminOnConnectorExpiry() {
        return this.notifyAdminOnConnectorExpiry(this.findAllAdmin("ROLE_ADMIN"), true);
    }

    @Transactional
    public int notifyAdminOnConnectorExpiry(List<User> adminList, boolean logNotification) {
        if (!this.doNotifyAdminOnConnectorExpiry) {
            LOG.info("notifyAdminOnConnectorExpiry deactivated");
            return 0;
        }
        Instant now = Instant.now();
        Instant beforeEE = now.plus((long)this.nDaysExpiryEE, ChronoUnit.DAYS);
        StateOverview stateOverviewConnector = new StateOverview();
        ArrayList<NameMessages> connectorMsgList = new ArrayList<NameMessages>();
        for (CAConnectorConfig caConnectorConfig : this.caConnectorConfigRepository.findAll()) {
            ProtectedContent protectedContent;
            Certificate msgProt;
            stateOverviewConnector.incAll();
            if (!caConnectorConfig.isActive().booleanValue()) {
                stateOverviewConnector.incInactive();
                LOG.info("no notification for deactivated connector '{}'", (Object)caConnectorConfig.getName());
                continue;
            }
            stateOverviewConnector.incActive();
            boolean expiringSoon = false;
            Certificate tlsAuth = caConnectorConfig.getTlsAuthentication();
            if (tlsAuth != null) {
                if (!tlsAuth.isActive()) {
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.inactiveTLSAuthenticationCertificate", now));
                    expiringSoon = true;
                } else if (beforeEE.isAfter(tlsAuth.getValidTo())) {
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.expiringTLSAuthenticationCertificate", tlsAuth.getValidTo()));
                    expiringSoon = true;
                }
            }
            if ((msgProt = caConnectorConfig.getMessageProtection()) != null) {
                if (!msgProt.isActive()) {
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.inactiveMessageProtectionCertificate", now));
                    expiringSoon = true;
                } else if (beforeEE.isAfter(msgProt.getValidTo())) {
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.expiringMessageProtectionCertificate", msgProt.getValidTo()));
                    expiringSoon = true;
                }
            }
            if ((protectedContent = caConnectorConfig.getSecret()) != null) {
                if (this.protectedContentUtil.hasMinimumOrLessLeftUsages(protectedContent, 10)) {
                    LOG.warn("unexpected problem with left usages of secret of connector '{}'", (Object)caConnectorConfig.getName());
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.protectedContentUsagesExpires", now));
                    expiringSoon = true;
                }
                if (protectedContent.getValidTo() == null || beforeEE.isAfter(protectedContent.getValidTo())) {
                    connectorMsgList.add(new NameMessages(caConnectorConfig.getName(), "email.connector.protectedContentExpires", protectedContent.getValidTo()));
                    expiringSoon = true;
                }
            }
            if (!expiringSoon) continue;
            stateOverviewConnector.incExpiringSoon();
        }
        StateOverview stateOverviewPipeline = new StateOverview();
        ArrayList<NameMessages> pipelineMsgList = new ArrayList<NameMessages>();
        for (Pipeline pipeline : this.pipelineRepository.findAll()) {
            Instant connectorExpiry;
            stateOverviewPipeline.incAll();
            if (!pipeline.isActive().booleanValue()) {
                stateOverviewPipeline.incInactive();
                LOG.info("no notification for deactivated connector '{}'", (Object)pipeline.getName());
                continue;
            }
            stateOverviewPipeline.incActive();
            boolean expiringSoon = false;
            Certificate recipientCert = this.certificateUtil.getCurrentSCEPRecipient(pipeline);
            if (recipientCert != null) {
                if (!recipientCert.isActive()) {
                    pipelineMsgList.add(new NameMessages(pipeline.getName(), "email.pipeline.inactiveRecipientCertificate", now));
                    expiringSoon = true;
                } else if (beforeEE.isAfter(recipientCert.getValidTo())) {
                    pipelineMsgList.add(new NameMessages(pipeline.getName(), "email.pipeline.expiringRecipientCertificate", recipientCert.getValidTo()));
                    expiringSoon = true;
                }
            }
            if (Instant.MAX.isAfter(connectorExpiry = pipeline.getCaConnector().getExpiryDate())) {
                pipelineMsgList.add(new NameMessages(pipeline.getName(), "email.pipeline.connector.expires", connectorExpiry));
                expiringSoon = true;
            }
            if (!expiringSoon) continue;
            stateOverviewPipeline.incExpiringSoon();
        }
        if (connectorMsgList.isEmpty() && pipelineMsgList.isEmpty()) {
            LOG.info("No expiring certificates / passphrases in the next {} days in pipelines or CA connectors", (Object)this.nDaysExpiryEE);
        } else {
            LOG.info("#{} expiring certificate  / passphrases in the next {} days in pipelines or CA connectors.", (Object)(connectorMsgList.size() + pipelineMsgList.size()), (Object)this.nDaysExpiryEE);
            for (User admin : adminList) {
                Locale locale = NotificationService.getUserLocale((User)admin);
                Context context = new Context(locale);
                context.setVariable("connectorMsgList", connectorMsgList);
                context.setVariable("stateOverviewConnector", (Object)stateOverviewConnector);
                context.setVariable("pipelineMsgList", pipelineMsgList);
                context.setVariable("stateOverviewPipeline", (Object)stateOverviewPipeline);
                context.setVariable("nDaysExpiryEE", (Object)this.nDaysExpiryEE);
                try {
                    this.mailService.sendEmailFromTemplate(context, admin, null, "mail/connectorPipelineExpiringCredentials", "email.connectorPipelineExpiringCredentials.subject");
                }
                catch (Throwable throwable) {
                    LOG.warn("Problem occurred while sending a notification eMail to admin address '" + admin.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(admin.getEmail()));
                }
            }
        }
        return connectorMsgList.size() + pipelineMsgList.size();
    }

    private static Locale getUserLocale(User user) {
        if (user != null && user.getLangKey() != null) {
            return Locale.forLanguageTag(user.getLangKey());
        }
        return Locale.forLanguageTag("en");
    }

    @Transactional
    public int notifyRAOfficerHolderOnExpiry() throws MessagingException {
        return this.notifyRAOfficerHolderOnExpiry(this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    @Transactional
    public int notifyRAOfficerHolderOnExpiry(List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        if (!this.doNotifyRAOfficerHolderOnExpiry) {
            LOG.info("notifyRAOfficerHolderOnExpiry deactivated");
            return 0;
        }
        Instant now = Instant.now();
        Instant beforeCA = now.plus((long)this.nDaysExpiryCA, ChronoUnit.DAYS);
        List expiringCAList = this.certificateRepo.findNonRevokedByTypeAndValidTo(false, now, beforeCA);
        Instant beforeEE = now.plus((long)this.nDaysExpiryEE, ChronoUnit.DAYS);
        List expiringEECertList = this.certificateRepo.findNonRevokedByTypeAndValidTo(true, now, beforeEE);
        Instant relevantPendingStart = now.minus(this.nDaysPending, ChronoUnit.DAYS);
        List pendingCsrList = this.csrRepo.findPendingByDay(relevantPendingStart, now);
        if (expiringEECertList.isEmpty() && pendingCsrList.isEmpty()) {
            LOG.info("No expiring certificates in the next {} days / no pending requests requested in the last {} days. No need to send a notification eMail to RA officers", (Object)this.nDaysExpiryEE, (Object)this.nDaysPending);
        } else {
            LOG.info("#{} expiring certificate in the next {} days, #{} pending requests issued in the last {} days.", new Object[]{expiringEECertList.size(), this.nDaysExpiryEE, pendingCsrList.size(), this.nDaysPending});
            for (User raOfficer : raOfficerList) {
                Locale locale = NotificationService.getUserLocale((User)raOfficer);
                Context context = new Context(locale);
                context.setVariable("expiringCAList", (Object)expiringCAList);
                context.setVariable("expiringEECertList", (Object)expiringEECertList);
                context.setVariable("pendingCsrList", (Object)pendingCsrList);
                context.setVariable("nDaysPending", (Object)this.nDaysPending);
                context.setVariable("nDaysExpiryEE", (Object)this.nDaysExpiryEE);
                context.setVariable("nDaysExpiryCA", (Object)this.nDaysExpiryCA);
                try {
                    this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/pendingReqExpiringCertificateEmail", "email.allExpiringCertificate.subject");
                }
                catch (Throwable throwable) {
                    LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(raOfficer.getEmail()));
                }
            }
            for (User domainOfficer : domainOfficerList) {
                ArrayList<CSR> pendingDomainCsrList = new ArrayList<CSR>();
                for (CSR csr : pendingCsrList) {
                    if (!this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), domainOfficer)) continue;
                    pendingDomainCsrList.add(csr);
                }
                Locale locale = NotificationService.getUserLocale((User)domainOfficer);
                Context context = new Context(locale);
                context.setVariable("expiringCAList", (Object)expiringCAList);
                context.setVariable("expiringEECertList", (Object)expiringEECertList);
                context.setVariable("pendingCsrList", (Object)pendingCsrList);
                context.setVariable("nDaysPending", (Object)this.nDaysPending);
                context.setVariable("nDaysExpiryEE", (Object)this.nDaysExpiryEE);
                context.setVariable("nDaysExpiryCA", (Object)this.nDaysExpiryCA);
                try {
                    this.mailService.sendEmailFromTemplate(context, domainOfficer, null, "mail/pendingReqExpiringCertificateEmail", "email.allExpiringCertificate.subject");
                }
                catch (Throwable throwable) {
                    LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + domainOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(domainOfficer.getEmail()));
                }
            }
            if (logNotification) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationSent(expiringEECertList.size()));
            }
        }
        return expiringEECertList.size();
    }

    @Transactional
    public int notifyRequestorOnExpiry(User testUser, boolean logNotification) {
        if (!this.doNotifyRequestorOnExpiry) {
            LOG.info("notifyRequestorOnExpiry deactivated");
            return 0;
        }
        Instant now = Instant.now();
        int maxExpiry = this.notificationDayList.stream().max(Integer::compareTo).orElse(40);
        Instant beforeEE = now.plus((long)maxExpiry, ChronoUnit.DAYS);
        List expiringEECertList = this.certificateRepo.findNonRevokedByTypeAndValidTo(true, now, beforeEE);
        return this.notifyRequestorOnExpiry(testUser, logNotification, expiringEECertList, maxExpiry, false);
    }

    @Transactional
    public int notifyRequestorOnExpiry(User testUser, boolean logNotification, String certId) {
        Optional optionalCertificate = this.certificateRepo.findById((Object)Long.parseLong(certId));
        return optionalCertificate.map(certificate -> this.notifyRequestorOnExpiry(testUser, logNotification, Collections.singletonList(certificate), 9999, true)).orElse(0);
    }

    private int notifyRequestorOnExpiry(User testUser, boolean logNotification, List<Certificate> expiringEECertList, int maxExpiry, boolean forceSendAnyday) {
        Instant now = Instant.now();
        LOG.debug("list of notification days: " + this.notificationDayList.stream().map(n -> Integer.toString(n)).collect(Collectors.joining(",")));
        if (expiringEECertList.isEmpty()) {
            LOG.info("No expiring certificates in the next {} days / no pending requests requested in the last {} days. No need to send a notification eMail to RA officers", (Object)this.nDaysExpiryEE, (Object)this.nDaysPending);
        } else {
            LOG.info("#{} expiring certificate in the next {} days.", (Object)expiringEECertList.size(), (Object)maxExpiry);
            HashMap certListGroupedByUser = new HashMap();
            for (Certificate cert : expiringEECertList) {
                int diffDays = (int)ChronoUnit.DAYS.between(now, cert.getValidTo());
                if (!this.notificationDayList.contains(diffDays) && !forceSendAnyday) {
                    LOG.debug("#{} days until expiry are NOT in the list of notification days.", (Object)diffDays);
                    continue;
                }
                LOG.debug("#{} days until expiry are in the list of notification days.", (Object)diffDays);
                if (cert.getCsr() != null && cert.getCsr().getRequestedBy() != null && cert.getCsr().getPipeline() != null) {
                    if (!PipelineType.WEB.equals((Object)cert.getCsr().getPipeline().getType())) {
                        LOG.debug("Non-Web Pipelines will be ignored for notification.");
                        continue;
                    }
                    LOG.debug("Web Pipelines will be processed for notification.");
                    Optional optionalUser = this.userRepository.findOneByLogin(cert.getCsr().getRequestedBy());
                    if (!optionalUser.isPresent()) continue;
                    User user = testUser;
                    if (user == null) {
                        user = (User)optionalUser.get();
                    }
                    if (certListGroupedByUser.containsKey(user)) {
                        ((List)certListGroupedByUser.get(user)).add(cert);
                        continue;
                    }
                    ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
                    certificateList.add(cert);
                    certListGroupedByUser.put(user, certificateList);
                    continue;
                }
                LOG.debug("Expiring certificate #{} not applicable for notification: csr {}, requestor {}, pipeline {}", new Object[]{cert.getId(), cert.getCsr(), cert.getCsr() == null || cert.getCsr().getRequestedBy() == null ? "null" : cert.getCsr().getRequestedBy(), cert.getCsr() == null || cert.getCsr().getPipeline() == null ? "null" : cert.getCsr().getPipeline().getName()});
            }
            for (User requestor : certListGroupedByUser.keySet()) {
                LOG.info("#{} expiring certificates for requestor {}.", (Object)((List)certListGroupedByUser.get(requestor)).size(), (Object)requestor.getId());
                Locale locale = NotificationService.getUserLocale((User)requestor);
                Context context = new Context(locale);
                context.setVariable("now", (Object)now);
                context.setVariable("user", (Object)requestor);
                if (this.notifyUserOnly) {
                    this.sentExpiryNotificationUserOnly(logNotification, certListGroupedByUser, requestor, context);
                    continue;
                }
                this.sentExpiryNotificationAllParticipants(logNotification, certListGroupedByUser, requestor, context);
            }
            if (logNotification) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceExpiryNotificationSent(expiringEECertList.size()));
            }
        }
        return expiringEECertList.size();
    }

    private void sentExpiryNotificationUserOnly(boolean logNotification, Map<User, List<Certificate>> certListGroupedByUser, User requestor, Context context) {
        block3: {
            context.setVariable("expiringCertList", certListGroupedByUser.get(requestor));
            try {
                this.mailService.sendEmailFromTemplate(context, requestor, null, "mail/expiringUserCertificateEmail", "email.allExpiringCertificate.subject");
                if (logNotification) {
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationSent(requestor.getEmail(), "email.allExpiringCertificate.subject"));
                }
            }
            catch (Throwable throwable) {
                LOG.warn("Problem occurred while sending a notification eMail to requestor address '" + requestor.getEmail() + "'", throwable);
                if (!logNotification) break block3;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(requestor.getEmail()));
            }
        }
    }

    private void sentExpiryNotificationAllParticipants(boolean logNotification, Map<User, List<Certificate>> certListGroupedByUser, User requestor, Context context) {
        for (Certificate cert : certListGroupedByUser.get(requestor)) {
            LOG.info("sending notification for expiring certificate {} to requestor {}.", (Object)cert.getId(), (Object)requestor.getId());
            ArrayList ccList = new ArrayList();
            if (cert.getCsr() != null && cert.getCsr().getPipeline() != null) {
                Pipeline pipeline = cert.getCsr().getPipeline();
                PipelineView pipelineView = this.pipelineUtil.from(pipeline);
                if (pipelineView.getWebConfigItems() != null && pipelineView.getWebConfigItems().getAdditionalEMailRecipients() != null) {
                    NotificationService.addSplittedEMailAddress(ccList, (String)pipelineView.getWebConfigItems().getAdditionalEMailRecipients());
                }
                ccList.addAll(this.findARAEmailRecipients(pipelineView, cert));
            }
            context.setVariable("expiringCertList", Collections.singletonList(cert));
            try {
                this.mailService.sendEmailFromTemplate(context, requestor, ccList.toArray(new String[0]), "mail/expiringUserCertificateEmail", "email.allExpiringCertificate.subject");
                if (!logNotification) continue;
                String email = requestor.getEmail() + ", cc: " + String.join((CharSequence)", ", ccList);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationSent(email, "email.allExpiringCertificate.subject"));
            }
            catch (Throwable throwable) {
                LOG.warn("Problem occurred while sending a notification eMail to requestor address '" + requestor.getEmail() + "'", throwable);
                if (!logNotification) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(requestor.getEmail()));
            }
        }
    }

    public static void addSplittedEMailAddress(Collection<String> emailList, String additionalEmailRecipients) {
        int added = 0;
        if (additionalEmailRecipients != null && !additionalEmailRecipients.isEmpty()) {
            String[] parts;
            for (String part : parts = additionalEmailRecipients.split("[;, ]")) {
                String normalizedPart = part.trim().toLowerCase(Locale.ROOT);
                if (normalizedPart.isBlank() || emailList.contains(normalizedPart) || !EmailValidator.getInstance().isValid(normalizedPart)) continue;
                emailList.add(part.trim());
                ++added;
            }
        }
        LOG.debug("#{} parts added from additionalEmailRecipients '{}'.", (Object)added, (Object)additionalEmailRecipients);
    }

    public void notifyRequestorOnExcessiveActiveCertificates(String requestorEmail, int numberActive, Certificate certificate) {
        if (!this.doNotifyRequestorOnExcessiveActiveCertificates) {
            LOG.info("notifyRequestorOnExcessiveActiveCertificates deactivated");
            return;
        }
        Locale locale = Locale.getDefault();
        Context context = new Context(locale);
        context.setVariable("numberActive", (Object)numberActive);
        context.setVariable("certificate", (Object)certificate);
        try {
            this.mailService.sendEmailFromTemplate(context, null, requestorEmail, null, "mail/excessiveActiveCertificates", "email.excessive.active.title");
        }
        catch (Throwable throwable) {
            LOG.warn("Problem occurred while sending a notification eMail to requestor address '" + requestorEmail + "'", throwable);
        }
    }

    @Transactional
    public void notifyRAOfficerOnUserRevocation(Certificate certificate) {
        this.notifyRAOfficerOnUserRevocation(certificate, this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    public void notifyRAOfficerOnUserRevocation(Certificate certificate, List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        if (!this.doNotifyRAOfficerOnUserRevocation) {
            LOG.info("notifyRAOfficerOnUserRevocation deactivated");
            return;
        }
        LOG.info("certificate revoked by user (certificate # {})", (Object)certificate.getId());
        String revokedByUser = this.certificateUtil.getCertAttribute(certificate, "REVOKED_BY");
        for (User raOfficer : raOfficerList) {
            Locale locale = NotificationService.getUserLocale((User)raOfficer);
            Context context = new Context(locale);
            context.setVariable("cert", (Object)certificate);
            context.setVariable("revokedByUser", (Object)revokedByUser);
            try {
                this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/userRevokedCertificateEmail", "email.userRevokedCertificateEmail.subject");
            }
            catch (Throwable throwable) {
                LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
            }
        }
        if (certificate.getCsr() != null && certificate.getCsr().getPipeline() != null) {
            Pipeline pipeline = certificate.getCsr().getPipeline();
            for (User domainOfficer : domainOfficerList) {
                if (!this.pipelineUtil.isUserValidAsRA(pipeline, domainOfficer)) continue;
                Locale locale = NotificationService.getUserLocale((User)domainOfficer);
                Context context = new Context(locale);
                context.setVariable("cert", (Object)certificate);
                context.setVariable("revokedByUser", (Object)revokedByUser);
                try {
                    this.mailService.sendEmailFromTemplate(context, domainOfficer, null, "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
                }
                catch (Throwable throwable) {
                    LOG.warn("Problem occurred while sending a notification eMail to domain officer address '" + domainOfficer.getEmail() + "'", throwable);
                    if (!logNotification) continue;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(domainOfficer.getEmail()));
                }
            }
        }
    }

    @Transactional
    public void notifyRAOfficerOnRequest(CSR csr) {
        this.notifyRAOfficerOnRequest(csr, this.findAllRAOfficer("ROLE_RA"), this.findAllRAOfficer("ROLE_RA_DOMAIN"), true);
    }

    public void notifyRAOfficerOnRequest(CSR csr, List<User> raOfficerList, List<User> domainOfficerList, boolean logNotification) {
        ArrayList<CSR> newCsrList;
        block8: {
            User requestor;
            LOG.info("certificate requested, causing a new pending requests (CSR # {})", (Object)csr.getId());
            newCsrList = new ArrayList<CSR>();
            newCsrList.add(csr);
            List araEmailList = new ArrayList();
            if (csr.getPipeline() != null) {
                PipelineView pipelineView = this.pipelineUtil.from(csr.getPipeline());
                araEmailList = this.findARAEmailRecipients(pipelineView, csr);
            }
            if ((requestor = this.userUtil.getUserByLogin(csr.getRequestedBy())) != null) {
                Locale locale = NotificationService.getUserLocale((User)requestor);
                Context context = new Context(locale);
                context.setVariable("newCsrList", newCsrList);
                try {
                    this.mailService.sendEmailFromTemplate(context, requestor, araEmailList.toArray(new String[0]), "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
                }
                catch (Throwable throwable) {
                    LOG.warn("Problem occurred while sending a notification eMail to domain officer address '" + requestor.getEmail() + "'", throwable);
                    if (!logNotification) break block8;
                    this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(requestor.getEmail()));
                }
            }
        }
        if (!this.doNotifyRAOfficerOnRequest) {
            LOG.info("notifyRAOfficerOnRequest deactivated");
            return;
        }
        ArrayList<User> officerList = new ArrayList<User>(raOfficerList);
        officerList.addAll(domainOfficerList);
        for (User raOfficer : officerList) {
            Locale locale = NotificationService.getUserLocale((User)raOfficer);
            Context context = new Context(locale);
            context.setVariable("newCsrList", newCsrList);
            try {
                this.mailService.sendEmailFromTemplate(context, raOfficer, null, "mail/newPendingRequestEmail", "email.newPendingRequestEmail.subject");
            }
            catch (Throwable throwable) {
                LOG.warn("Problem occurred while sending a notification eMail to RA officer address '" + raOfficer.getEmail() + "'", throwable);
                if (!logNotification) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceNotificationFailed(raOfficer.getEmail()));
            }
        }
    }

    @Transactional
    public void notifyUserCertificateIssued(User requestor, Certificate cert, Set<String> additionalEmailSet) throws MessagingException {
        if (!this.doNotifyUserCertificateIssued) {
            LOG.info("notifyUserCertificateIssued deactivated");
            return;
        }
        Locale locale = NotificationService.getUserLocale((User)requestor);
        Context context = new Context(locale);
        context.setVariable("certId", (Object)cert.getId());
        context.setVariable("certSKI", (Object)URLEncoder.encode(this.certificateUtil.getCertAttribute(cert, "SKI"), StandardCharsets.UTF_8));
        context.setVariable("subject", (Object)cert.getSubject());
        context.setVariable("sans", (Object)cert.getSans());
        String downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
        Instant requestedOn = cert.getValidFrom();
        boolean isServersideKeyGeneration = false;
        if (cert.getCsr() != null) {
            requestedOn = cert.getCsr().getRequestedOn();
            isServersideKeyGeneration = cert.getCsr().isServersideKeyGeneration();
        }
        context.setVariable("requestedOn", (Object)requestedOn);
        context.setVariable("isServersideKeyGeneration", (Object)isServersideKeyGeneration);
        context.setVariable("filenameCrt", (Object)(downloadFilename + ".crt"));
        context.setVariable("filenamePem", (Object)(downloadFilename + ".pem"));
        context.setVariable("filenameFullChainPem", (Object)(downloadFilename + ".full.pem"));
        this.mailService.sendEmailFromTemplate(context, requestor, additionalEmailSet.toArray(new String[0]), "mail/acceptedRequestEmail", "email.acceptedRequest.title");
    }

    @Transactional
    public void notifyUserCertificateRejected(User requestor, CSR csr, Set<String> additionalEmailSet) throws MessagingException {
        if (!this.doNotifyUserCertificateRejected) {
            LOG.info("notifyUserCertificateRejected deactivated");
            return;
        }
        Locale locale = NotificationService.getUserLocale((User)requestor);
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        this.mailService.sendEmailFromTemplate(context, requestor, additionalEmailSet.toArray(new String[0]), "mail/rejectedRequestEmail", "email.request.rejection.title");
    }

    @Transactional
    public void notifyCertificateRevoked(User requestor, Certificate cert, CSR csr, Set<String> additionalEmailSet) throws MessagingException {
        if (!this.doNotifyCertificateRevoked) {
            LOG.info("notifyCertificateRevoked deactivated");
            return;
        }
        Locale locale = NotificationService.getUserLocale((User)requestor);
        Context context = new Context(locale);
        context.setVariable("csr", (Object)csr);
        context.setVariable("cert", (Object)cert);
        String subject = cert.getSubject();
        if (subject == null) {
            subject = "";
        }
        String[] args = new String[]{subject, cert.getSerial(), cert.getIssuer()};
        this.mailService.sendEmailFromTemplate(context, requestor, additionalEmailSet.toArray(new String[0]), "mail/revokedCertificateEmail", "email.revokedCertificate.title", args);
    }

    @Transactional
    public void notifyAccountHolderOnKeyReuse(AcmeOrder acmeOrder) {
        Locale locale = Locale.ENGLISH;
        Context context = new Context(locale);
        AcmeAccount acmeAccount = acmeOrder.getAccount();
        CSR csr = acmeOrder.getCsr();
        context.setVariable("acmeAccount", (Object)acmeAccount);
        context.setVariable("acmeOrder", (Object)acmeOrder);
        context.setVariable("csr", (Object)csr);
        Set emailSet = acmeAccount.getContacts().stream().map(contact -> contact.getContactUrl().replace("mailto:", "")).filter(email -> !email.isEmpty()).collect(Collectors.toSet());
        for (String email2 : emailSet) {
            try {
                this.mailService.sendEmailFromTemplate(context, null, email2, null, "mail/notifyOnKeyReuseEmail", "email.request.rejection.title");
            }
            catch (MessagingException e) {
                LOG.info("Problem occurred while sending a notification eMail to acme account contact address '" + email2 + "'", (Throwable)e);
            }
        }
    }

    @Transactional
    public void notifyAccountHolderOnACMEProblem(AcmeOrder acmeOrder, ProblemDetail acmeProblem) {
        AcmeAccount acmeAccount = acmeOrder.getAccount();
        Set emailSet = acmeAccount.getContacts().stream().map(contact -> contact.getContactUrl().replace("mailto:", "")).filter(email -> !email.isEmpty()).collect(Collectors.toSet());
        this.notifyAccountHolderOnACMEProblem(acmeOrder, acmeProblem, emailSet);
    }

    @Transactional
    public void notifyAccountHolderOnACMEProblem(AcmeOrder acmeOrder, ProblemDetail acmeProblem, Set<String> emailSet) {
        Locale locale = Locale.ENGLISH;
        Context context = new Context(locale);
        AcmeAccount acmeAccount = acmeOrder.getAccount();
        context.setVariable("acmeAccount", (Object)acmeAccount);
        context.setVariable("acmeOrder", (Object)acmeOrder);
        context.setVariable("acmeProblem", (Object)acmeProblem);
        for (String email : emailSet) {
            try {
                this.mailService.sendEmailFromTemplate(context, null, email, null, "mail/notifyOnACMEProblemEmail", "email.request.acme.problem.title");
            }
            catch (MessagingException e) {
                LOG.info("Problem occurred while sending a notification eMail to acme account contact address '" + email + "'", (Throwable)e);
            }
        }
    }

    private List<String> findARAEmailRecipients(PipelineView pipelineView, CSR csr) {
        ArrayList<String> emailAttributeList = new ArrayList<String>();
        for (ARARestriction araRestriction : pipelineView.getAraRestrictions()) {
            if (ARAContentType.EMAIL_ADDRESS != araRestriction.getContentType()) continue;
            emailAttributeList.add(araRestriction.getName());
        }
        ArrayList<String> recipientList = new ArrayList<String>();
        for (String araAttribute : emailAttributeList) {
            String emailAttribute = this.csrUtil.getCSRAttribute(csr, "_ARA_" + araAttribute);
            NotificationService.addSplittedEMailAddress(recipientList, (String)emailAttribute);
        }
        return recipientList;
    }

    private List<String> findARAEmailRecipients(PipelineView pipelineView, Certificate cert) {
        ArrayList<String> emailAttributeList = new ArrayList<String>();
        for (ARARestriction araRestriction : pipelineView.getAraRestrictions()) {
            if (ARAContentType.EMAIL_ADDRESS != araRestriction.getContentType()) continue;
            emailAttributeList.add(araRestriction.getName());
        }
        ArrayList<String> recipientList = new ArrayList<String>();
        for (String araAttribute : emailAttributeList) {
            String emailAttribute = this.certificateUtil.getCertAttribute(cert, "_ARA_" + araAttribute, "");
            NotificationService.addSplittedEMailAddress(recipientList, (String)emailAttribute);
        }
        return recipientList;
    }

    private List<User> findAllRAOfficer(String authority) {
        ArrayList<User> raOfficerList = new ArrayList<User>();
        block0: for (User user : this.userRepository.findAll()) {
            for (Authority auth : user.getAuthorities()) {
                LOG.debug("user {} {} has role {}", new Object[]{user.getFirstName(), user.getLastName(), auth.getName()});
                if (!authority.equalsIgnoreCase(auth.getName())) continue;
                raOfficerList.add(user);
                LOG.debug("found user {} {} having the role of a RA officers", (Object)user.getFirstName(), (Object)user.getLastName());
                continue block0;
            }
        }
        return raOfficerList;
    }

    private List<User> findAllAdmin(String authority) {
        ArrayList<User> adminList = new ArrayList<User>();
        block0: for (User user : this.userRepository.findAll()) {
            for (Authority auth : user.getAuthorities()) {
                LOG.debug("user {} {} has role {}", new Object[]{user.getFirstName(), user.getLastName(), auth.getName()});
                if (!authority.equalsIgnoreCase(auth.getName())) continue;
                adminList.add(user);
                LOG.debug("found user {} {} having the role of admin", (Object)user.getFirstName(), (Object)user.getLastName());
                continue block0;
            }
        }
        return adminList;
    }
}

