/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.util.List;
import org.jboss.aerogear.security.otp.Totp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TotpService {
    private final Logger log = LoggerFactory.getLogger(TotpService.class);
    private final ProtectedContentUtil protectedContentUtil;
    private final String appName;
    static final String TOTP_URL_TEMPLATE = "otpauth://totp/%s:%s?secret=%s&issuer=%s";

    public TotpService(ProtectedContentUtil protectedContentUtil, @Value(value="${ca3s.app.name:ca3s}") String appName) {
        this.protectedContentUtil = protectedContentUtil;
        this.appName = appName;
    }

    public String generateTotpUrlForUser(String userLogin, String base32Seed) {
        String totpUrl = String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", this.appName, userLogin, base32Seed, this.appName);
        return totpUrl;
    }

    public void checkOtpToken(User user, String otp) {
        try {
            Long.parseLong(otp);
        }
        catch (NumberFormatException e) {
            throw new BadCredentialsException("Invalid format of otp");
        }
        List protectedContents = this.protectedContentUtil.retrieveProtectedContent(ProtectedContentType.SECRET, ContentRelationType.OTP_SECRET, user.getId().longValue());
        for (ProtectedContent protectedContent : protectedContents) {
            String secret = this.protectedContentUtil.unprotectString(protectedContent.getContentBase64());
            if (!TotpService.verifyOTP((String)secret, (String)otp)) continue;
            this.log.debug("otp matches for user {}", (Object)user.getLogin());
            return;
        }
        throw new BadCredentialsException("Invalid otp");
    }

    public static boolean verifyOTP(String seed, String otp) {
        Totp totp = new Totp(seed);
        return totp.verify(otp);
    }
}

