/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.Tenant;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.TenantRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class UserDTO {
    private Long id;
    @NotBlank
    @Pattern(regexp="^[_.@A-Za-z0-9-]*$")
    @Size(min=1, max=50)
    private @NotBlank @Pattern(regexp="^[_.@A-Za-z0-9-]*$") @Size(min=1, max=50) String login;
    @Size(max=50)
    private @Size(max=50) String firstName;
    @Size(max=50)
    private @Size(max=50) String lastName;
    @Email
    @Size(min=5, max=254)
    private @Email @Size(min=5, max=254) String email;
    @Size(min=0, max=254)
    private @Size(min=0, max=254) String phone;
    @Size(max=256)
    private @Size(max=256) String imageUrl;
    private boolean secondFactorRequired = false;
    private boolean activated = false;
    @Size(min=2, max=10)
    private @Size(min=2, max=10) String langKey;
    private String createdBy;
    private Instant createdDate;
    private String lastModifiedBy;
    private Instant lastModifiedDate;
    private boolean isManagedExternally;
    private Set<String> authorities;
    private String tenantName;
    private Long tenantId;
    private boolean isBlocked;
    private Long failedLogins;
    private Instant blockedUntilDate = null;
    private Instant credentialsValidToDate = null;

    public UserDTO() {
    }

    public UserDTO(User user, TenantRepository tenantRepository) {
        this(user);
        if (user.getTenant() != null) {
            this.tenantId = user.getTenant().getId();
            Optional tenantOptional = tenantRepository.findById((Object)this.tenantId);
            if (tenantOptional.isPresent()) {
                this.tenantName = ((Tenant)tenantOptional.get()).getLongname();
            }
        }
    }

    public UserDTO(User user) {
        this.id = user.getId();
        this.login = user.getLogin();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.email = user.getEmail();
        this.phone = user.getPhone();
        this.secondFactorRequired = user.isSecondFactorRequired();
        this.activated = user.getActivated();
        this.imageUrl = user.getImageUrl();
        this.langKey = user.getLangKey();
        this.createdBy = user.getCreatedBy();
        this.createdDate = user.getCreatedDate();
        this.lastModifiedBy = user.getLastModifiedBy();
        this.lastModifiedDate = user.getLastModifiedDate();
        this.isManagedExternally = user.isManagedExternally();
        this.failedLogins = user.getFailedLogins();
        this.blockedUntilDate = user.getBlockedUntilDate();
        this.isBlocked = user.getBlockedUntilDate() == null ? false : Instant.now().isBefore(user.getBlockedUntilDate());
        this.credentialsValidToDate = user.getCredentialsValidToDate();
        this.authorities = user.getAuthorities().stream().map(Authority::getName).collect(Collectors.toSet());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean isSecondFactorRequired() {
        return this.secondFactorRequired;
    }

    public void setSecondFactorRequired(boolean secondFactorRequired) {
        this.secondFactorRequired = secondFactorRequired;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Instant getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public boolean isManagedExternally() {
        return this.isManagedExternally;
    }

    public void setManagedExternally(boolean managedExternally) {
        this.isManagedExternally = managedExternally;
    }

    public void setLastModifiedDate(Instant lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set<String> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<String> authorities) {
        this.authorities = authorities;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public Long getFailedLogins() {
        return this.failedLogins;
    }

    public void setFailedLogins(Long failedLogins) {
        this.failedLogins = failedLogins;
    }

    public Instant getBlockedUntilDate() {
        return this.blockedUntilDate;
    }

    public void setBlockedUntilDate(Instant blockedUntilDate) {
        this.blockedUntilDate = blockedUntilDate;
    }

    public Instant getCredentialsValidToDate() {
        return this.credentialsValidToDate;
    }

    public void setCredentialsValidToDate(Instant credentialsValidToDate) {
        this.credentialsValidToDate = credentialsValidToDate;
    }

    public String toString() {
        return "UserDTO{id=" + this.id + ", login='" + this.login + "', firstName='" + this.firstName + "', lastName='" + this.lastName + "', email='" + this.email + "', phone='" + this.phone + "', imageUrl='" + this.imageUrl + "', activated=" + this.activated + ", secondFactorRequired=" + this.secondFactorRequired + ", langKey='" + this.langKey + "', createdBy='" + this.createdBy + "', createdDate=" + String.valueOf(this.createdDate) + ", lastModifiedBy='" + this.lastModifiedBy + "', lastModifiedDate=" + String.valueOf(this.lastModifiedDate) + ", isManagedExternally=" + this.isManagedExternally + ", authorities=" + String.valueOf(this.authorities) + ", tenantName='" + this.tenantName + "', tenantId=" + this.tenantId + ", failedLogins=" + this.failedLogins + ", blockedUntilDate=" + String.valueOf(this.blockedUntilDate) + ", credentialsValidToDate=" + String.valueOf(this.credentialsValidToDate) + "}";
    }
}

