/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AcmeOrderService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AcmeOrderServiceImpl
implements AcmeOrderService {
    private final Logger log = LoggerFactory.getLogger(AcmeOrderServiceImpl.class);
    private final AcmeOrderRepository acmeOrderRepository;

    public AcmeOrderServiceImpl(AcmeOrderRepository acmeOrderRepository) {
        this.acmeOrderRepository = acmeOrderRepository;
    }

    public AcmeOrder save(AcmeOrder acmeOrder) {
        this.log.debug("Request to save AcmeOrder : {}", (Object)acmeOrder);
        return (AcmeOrder)this.acmeOrderRepository.save((Object)acmeOrder);
    }

    @Transactional(readOnly=true)
    public List<AcmeOrder> findAll() {
        this.log.debug("Request to get all AcmeOrders");
        return this.acmeOrderRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<AcmeOrder> findOne(Long id) {
        this.log.debug("Request to get AcmeOrder : {}", (Object)id);
        return this.acmeOrderRepository.findById((Object)id);
    }

    public Optional<AcmeOrder> findOneByAcmeOrderId(Long orderId) {
        this.log.debug("Request to get AcmeOrder by orderId: {}", (Object)orderId);
        return this.acmeOrderRepository.findByOrderId(orderId.longValue());
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AcmeOrder : {}", (Object)id);
        this.acmeOrderRepository.deleteById((Object)id);
    }
}

