/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.service.BPMNProcessInfoService;
import de.trustable.ca3s.core.service.dto.BPMNProcessInfoView;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional
public class BPMNProcessInfoServiceImpl
implements BPMNProcessInfoService {
    private final Logger log = LoggerFactory.getLogger(BPMNProcessInfoServiceImpl.class);
    private final BPMNProcessInfoRepository bPMNProcessInfoRepository;
    private final BPMNUtil bpmnUtil;
    private final PlatformTransactionManager transactionManager;

    public BPMNProcessInfoServiceImpl(BPMNProcessInfoRepository bPMNProcessInfoRepository, BPMNUtil bpmnUtil, PlatformTransactionManager transactionManager) {
        this.bPMNProcessInfoRepository = bPMNProcessInfoRepository;
        this.bpmnUtil = bpmnUtil;
        this.transactionManager = transactionManager;
    }

    public BPMNProcessInfo save(BPMNProcessInfo bPMNProcessInfo) {
        this.log.debug("Request to save BPMNProcessInfo : {}", (Object)bPMNProcessInfo);
        return (BPMNProcessInfo)this.bPMNProcessInfoRepository.save((Object)bPMNProcessInfo);
    }

    public BPMNProcessInfo save(BPMNProcessInfoView bpmnProcessInfoView) {
        this.log.debug("Request to save BPMNProcessInfoView : {}", (Object)bpmnProcessInfoView);
        return this.bpmnUtil.toBPMNProcessInfo(bpmnProcessInfoView);
    }

    @Transactional(readOnly=true)
    public List<BPMNProcessInfo> findAll() {
        this.log.debug("Request to get all BPMNProcessInfos");
        return this.bPMNProcessInfoRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<BPMNProcessInfo> findOne(Long id) {
        this.log.debug("Request to get BPMNProcessInfo : {}", (Object)id);
        return this.bPMNProcessInfoRepository.findById((Object)id);
    }

    @Transactional
    public void delete(Long id) {
        this.log.debug("Request to delete BPMNProcessInfo : {}", (Object)id);
        Optional optionalBPMNProcessInfo = this.bPMNProcessInfoRepository.findById((Object)id);
        if (optionalBPMNProcessInfo.isPresent()) {
            String processId = ((BPMNProcessInfo)optionalBPMNProcessInfo.get()).getProcessId();
            if (processId != null) {
                TransactionTemplate txTemplate = new TransactionTemplate(this.transactionManager);
                txTemplate.setPropagationBehavior(3);
                try {
                    txTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (TransactionException transactionException) {
                    this.log.warn("Ignoring outcome of the deletion of camunda process definition: {}", (Object)transactionException.getMessage());
                }
            } else {
                this.log.warn("No valid process id found while deleting BPMNProcessInfo : {}", (Object)id);
            }
            this.bPMNProcessInfoRepository.deleteById((Object)id);
        }
    }
}

