/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrUsage;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.exception.CAFailureException;
import de.trustable.ca3s.core.exception.KeyApplicableException;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AsyncNotificationService;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.CertificateService;
import de.trustable.ca3s.core.service.dto.KeyAlgoLengthOrSpec;
import de.trustable.ca3s.core.service.dto.NamedValues;
import de.trustable.ca3s.core.service.dto.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.service.dto.PkcsXXData;
import de.trustable.ca3s.core.service.dto.TypedValue;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.spec.AlgorithmParameterSpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.pqc.jcajce.provider.dilithium.BCDilithiumPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import org.bouncycastle.pqc.jcajce.spec.DilithiumParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertificateServiceImpl
implements CertificateService {
    private final Logger log = LoggerFactory.getLogger(CertificateServiceImpl.class);
    private final CertificateRepository certificateRepository;
    private final CryptoService cryptoUtil;
    private final ProtectedContentUtil protUtil;
    private final PreferenceUtil preferenceUtil;
    private final CertificateUtil certificateUtil;
    private final CSRUtil csrUtil;
    private final CSRRepository csrRepository;
    private final CertificateProcessingUtil cpUtil;
    private final AsyncNotificationService asyncNotificationService;
    private final AuditService auditService;

    public CertificateServiceImpl(CertificateRepository certificateRepository, CryptoService cryptoUtil, ProtectedContentUtil protUtil, PreferenceUtil preferenceUtil, CertificateUtil certificateUtil, CSRUtil csrUtil, CSRRepository csrRepository, CertificateProcessingUtil cpUtil, AsyncNotificationService asyncNotificationService, AuditService auditService) {
        this.certificateRepository = certificateRepository;
        this.cryptoUtil = cryptoUtil;
        this.protUtil = protUtil;
        this.preferenceUtil = preferenceUtil;
        this.certificateUtil = certificateUtil;
        this.csrUtil = csrUtil;
        this.csrRepository = csrRepository;
        this.cpUtil = cpUtil;
        this.asyncNotificationService = asyncNotificationService;
        this.auditService = auditService;
    }

    public Certificate save(Certificate certificate) {
        this.log.debug("Request to save Certificate : {}", (Object)certificate);
        return (Certificate)this.certificateRepository.save((Object)certificate);
    }

    @Transactional(readOnly=true)
    public Page<Certificate> findAll(Pageable pageable) {
        this.log.debug("Request to get all Certificates");
        return this.certificateRepository.findAll(pageable);
    }

    @Transactional(readOnly=true)
    public Optional<Certificate> findOne(Long id) {
        this.log.debug("Request to get Certificate : {}", (Object)id);
        return this.certificateRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Certificate : {}", (Object)id);
        this.certificateRepository.deleteById((Object)id);
    }

    public CSR createServersideKeyAndCertificate(Optional<Pipeline> optPipeline, KeyAlgoLengthOrSpec keyAlgoLength, NamedValues[] certAttributeArr, NamedValues[] arAttributeArr, CsrUsage csrUsage, User user, String secret, String requestorComment, boolean isTosAgreed, boolean tosAgreementRequired, String tosAgreementLink, boolean notifyRAOfficer) throws GeneralSecurityException, IOException, OperatorCreationException {
        KeyAlgoLengthOrSpec keyAlgoLengthOrSpec;
        DilithiumParameterSpec parameterSpec;
        JcaContentSignerBuilder csBuilder;
        KeyPair keypair = keyAlgoLength.generateKeyPair();
        X500NameBuilder namebuilder = new X500NameBuilder(X500Name.getDefaultStyle());
        ArrayList<GeneralName> gnList = new ArrayList<GeneralName>();
        for (NamedValues nv : certAttributeArr) {
            String name = nv.getName();
            if (CertificateUtil.nameOIDMap.containsKey(name)) {
                TypedValue[] oid = (TypedValue[])CertificateUtil.nameOIDMap.get(name);
                TypedValue[] typedValueArray = nv.getValues();
                int n = typedValueArray.length;
                for (int i = 0; i < n; ++i) {
                    TypedValue typedValue = typedValueArray[i];
                    if (typedValue.getValue() == null || typedValue.getValue().isEmpty()) continue;
                    namebuilder.addRDN((ASN1ObjectIdentifier)oid, typedValue.getValue());
                }
                continue;
            }
            if ("SAN".equalsIgnoreCase(name)) {
                for (TypedValue typedValue : nv.getValues()) {
                    String content = typedValue.getValue().trim();
                    if (content.isEmpty()) continue;
                    Integer sanType = 2;
                    if (CertificateUtil.nameGeneralNameMap.containsKey(typedValue.getType().toUpperCase())) {
                        sanType = (Integer)CertificateUtil.nameGeneralNameMap.get(typedValue.getType().toUpperCase());
                    } else {
                        this.log.warn("SAN certificate attribute has unknown type '{}'", (Object)typedValue.getType());
                    }
                    gnList.add(new GeneralName(sanType.intValue(), content));
                }
                continue;
            }
            this.log.warn("certificate attribute '{}' unknown ", (Object)name);
        }
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(namebuilder.build(), keypair.getPublic());
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        if (!gnList.isEmpty()) {
            GeneralName[] gns = new GeneralName[gnList.size()];
            gnList.toArray(gns);
            GeneralNames subjectAltName = new GeneralNames(gns);
            extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
        }
        if (CsrUsage.TLS_SERVER.equals((Object)csrUsage)) {
            extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
            extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        } else if (CsrUsage.TLS_CLIENT.equals((Object)csrUsage)) {
            extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
            extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        } else if (CsrUsage.DOC_SIGNING.equals((Object)csrUsage)) {
            extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(192));
        } else if (CsrUsage.CODE_SIGNING.equals((Object)csrUsage)) {
            extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
            extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_codeSigning));
        } else {
            this.log.warn("unexpected CsrUsage requested: '{}'", (Object)csrUsage);
        }
        p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
        PrivateKey pk = keypair.getPrivate();
        String algo = "SHA256withRSA";
        if (pk instanceof ECKey) {
            algo = "SHA256withECDSA";
            csBuilder = new JcaContentSignerBuilder(algo);
        } else if (pk instanceof EdDSAPrivateKey) {
            algo = "ed25519";
            csBuilder = new JcaContentSignerBuilder(algo);
        } else if (pk instanceof BCDilithiumPrivateKey) {
            parameterSpec = ((BCDilithiumPrivateKey)pk).getParameterSpec();
            keyAlgoLengthOrSpec = KeyAlgoLengthOrSpec.from((AlgorithmParameterSpec)parameterSpec);
            csBuilder = keyAlgoLengthOrSpec.buildJcaContentSignerBuilder();
        } else if (pk instanceof BCFalconPrivateKey) {
            parameterSpec = ((BCFalconPrivateKey)pk).getParameterSpec();
            keyAlgoLengthOrSpec = KeyAlgoLengthOrSpec.from((AlgorithmParameterSpec)parameterSpec);
            csBuilder = keyAlgoLengthOrSpec.buildJcaContentSignerBuilder();
        } else {
            csBuilder = new JcaContentSignerBuilder(algo);
        }
        ContentSigner signer = csBuilder.build(pk);
        PKCS10CertificationRequest p10CR = p10Builder.build(signer);
        String csrAsPem = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10CR);
        this.log.debug("created csr on behalf of user '{}':\n{}", (Object)user.getLogin(), (Object)csrAsPem);
        Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(p10CR);
        Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
        PkcsXXData p10ReqData = new PkcsXXData(p10ReqHolderShallow);
        CSR csr = this.startCertificateCreationProcess(csrAsPem, p10ReqData, user, requestorComment, arAttributeArr, optPipeline, isTosAgreed, tosAgreementRequired, tosAgreementLink, notifyRAOfficer);
        if (csr != null) {
            csr.setServersideKeyGeneration(Boolean.valueOf(true));
            this.csrRepository.save((Object)csr);
            Instant validTo = Instant.now().plus((long)this.preferenceUtil.getServerSideKeyDeleteAfterDays(), ChronoUnit.DAYS);
            int leftUsages = this.preferenceUtil.getServerSideKeyDeleteAfterUses();
            this.certificateUtil.storePrivateKey(csr, keypair, leftUsages, validTo);
            this.protUtil.createProtectedContent(secret, ProtectedContentType.PASSWORD, ContentRelationType.CSR, csr.getId().longValue(), leftUsages, validTo);
        }
        return csr;
    }

    private CSR startCertificateCreationProcess(String csrAsPem, PkcsXXData p10ReqData, User user, String requestorComment, NamedValues[] nvArr, Optional<Pipeline> optPipeline, boolean isTosAgreed, boolean tosAgreementRequired, String tosAgreementLink, boolean notifyRAOfficer) {
        if (optPipeline.isPresent()) {
            Pipeline pipeline = optPipeline.get();
            if (pipeline.isActive().booleanValue()) {
                ArrayList messageList = new ArrayList();
                CSR csr = null;
                try {
                    csr = this.cpUtil.buildCSR(csrAsPem, user.getLogin(), "WEB_CERTIFICATE_REQUESTED", requestorComment, pipeline, null, nvArr, messageList);
                }
                catch (KeyApplicableException keyApplicableException) {
                    // empty catch block
                }
                p10ReqData.setWarnings(messageList.toArray(new String[0]));
                if (csr != null) {
                    p10ReqData.setCreatedCSRId(csr.getId().toString());
                    csr.setTenant(user.getTenant());
                    if (isTosAgreed) {
                        this.csrUtil.setCsrAttribute(csr, "ATTRIBUTE_TOS_AGREED", "true", false);
                        this.csrUtil.setCsrAttribute(csr, "ATTRIBUTE_TOS_AGREEMENT_LINK", tosAgreementLink, false);
                    } else if (tosAgreementRequired) {
                        this.log.warn("startCertificateCreationProcess: ToS agreement required, but not set!");
                        return null;
                    }
                    if (pipeline.isApprovalRequired().booleanValue()) {
                        this.log.debug("deferring certificate creation for csr #{}", (Object)csr.getId());
                        p10ReqData.setCsrPending(true);
                        if (notifyRAOfficer) {
                            this.asyncNotificationService.notifyRAOfficerOnRequestAsync(csr);
                        }
                    } else {
                        this.auditService.saveAuditTrace(this.auditService.createAuditTraceWebAutoAccepted(csr));
                        try {
                            this.cpUtil.processCertificateRequest(csr, user.getLogin(), "WEB_CERTIFICATE_CREATED", pipeline);
                        }
                        catch (CAFailureException caFailureException) {
                            this.log.info("certificate creation failed", (Throwable)caFailureException);
                            String msg = "certificate creation failed '" + caFailureException.getMessage() + "'!";
                            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr, msg));
                            this.log.info(msg);
                        }
                    }
                    return csr;
                }
                this.log.warn("startCertificateCreationProcess: creation of CSR failed");
            } else {
                this.log.warn("startCertificateCreationProcess: pipeline {} not active", (Object)pipeline.getName());
            }
        } else {
            this.log.warn("startCertificateCreationProcess: no processing pipeline defined");
        }
        return null;
    }
}

