/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.mapper;

import de.trustable.ca3s.core.domain.Authority;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.service.dto.AdminUserDTO;
import de.trustable.ca3s.core.service.dto.UserDTO;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.springframework.stereotype.Service;

@Service
public class UserMapper {
    private final TenantRepository tenantRepository;

    public UserMapper(TenantRepository tenantRepository) {
        this.tenantRepository = tenantRepository;
    }

    public List<UserDTO> usersToUserDTOs(List<User> users) {
        return users.stream().filter(Objects::nonNull).map(arg_0 -> this.userToUserDTO(arg_0)).collect(Collectors.toList());
    }

    public UserDTO userToUserDTO(User user) {
        return new UserDTO(user, this.tenantRepository);
    }

    public List<AdminUserDTO> usersToAdminUserDTOs(List<User> users) {
        return users.stream().filter(Objects::nonNull).map(arg_0 -> this.userToAdminUserDTO(arg_0)).collect(Collectors.toList());
    }

    public AdminUserDTO userToAdminUserDTO(User user) {
        return new AdminUserDTO(user);
    }

    public List<User> userDTOsToUsers(List<AdminUserDTO> userDTOs) {
        return userDTOs.stream().filter(Objects::nonNull).map(arg_0 -> this.userDTOToUser(arg_0)).collect(Collectors.toList());
    }

    public User userDTOToUser(AdminUserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        User user = new User();
        user.setId(userDTO.getId());
        user.setLogin(userDTO.getLogin());
        user.setFirstName(userDTO.getFirstName());
        user.setLastName(userDTO.getLastName());
        user.setEmail(userDTO.getEmail());
        user.setPhone(userDTO.getPhone());
        user.setImageUrl(userDTO.getImageUrl());
        user.setActivated(userDTO.isActivated());
        user.setSecondFactorRequired(userDTO.isSecondFactorRequired());
        user.setLangKey(userDTO.getLangKey());
        Set authorities = this.authoritiesFromStrings(userDTO.getAuthorities());
        user.setAuthorities(authorities);
        return user;
    }

    public User userDTOToUser(UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        User user = new User();
        user.setId(userDTO.getId());
        user.setLogin(userDTO.getLogin());
        user.setFirstName(userDTO.getFirstName());
        user.setLastName(userDTO.getLastName());
        user.setEmail(userDTO.getEmail());
        user.setPhone(userDTO.getPhone());
        user.setImageUrl(userDTO.getImageUrl());
        user.setActivated(userDTO.isActivated());
        user.setSecondFactorRequired(userDTO.isSecondFactorRequired());
        user.setLangKey(userDTO.getLangKey());
        Set authorities = this.authoritiesFromStrings(userDTO.getAuthorities());
        user.setAuthorities(authorities);
        return user;
    }

    private Set<Authority> authoritiesFromStrings(Set<String> authoritiesAsString) {
        Set<Object> authorities = new HashSet<Authority>();
        if (authoritiesAsString != null) {
            authorities = authoritiesAsString.stream().map(string -> {
                Authority auth = new Authority();
                auth.setName(string);
                return auth;
            }).collect(Collectors.toSet());
        }
        return authorities;
    }

    public User userFromId(Long id) {
        if (id == null) {
            return null;
        }
        User user = new User();
        user.setId(id);
        return user;
    }

    @Named(value="id")
    @BeanMapping(ignoreByDefault=true)
    @Mapping(target="id", source="id")
    public UserDTO toDtoId(User user) {
        if (user == null) {
            return null;
        }
        UserDTO userDto = new UserDTO();
        userDto.setId(user.getId());
        return userDto;
    }

    @Named(value="idSet")
    @BeanMapping(ignoreByDefault=true)
    @Mapping(target="id", source="id")
    public Set<UserDTO> toDtoIdSet(Set<User> users) {
        if (users == null) {
            return Collections.emptySet();
        }
        HashSet<UserDTO> userSet = new HashSet<UserDTO>();
        for (User userEntity : users) {
            userSet.add(this.toDtoId(userEntity));
        }
        return userSet;
    }

    @Named(value="login")
    @BeanMapping(ignoreByDefault=true)
    @Mappings(value={@Mapping(target="id", source="id"), @Mapping(target="login", source="login")})
    public UserDTO toDtoLogin(User user) {
        if (user == null) {
            return null;
        }
        UserDTO userDto = new UserDTO();
        userDto.setId(user.getId());
        userDto.setLogin(user.getLogin());
        return userDto;
    }

    @Named(value="loginSet")
    @BeanMapping(ignoreByDefault=true)
    @Mappings(value={@Mapping(target="id", source="id"), @Mapping(target="login", source="login")})
    public Set<UserDTO> toDtoLoginSet(Set<User> users) {
        if (users == null) {
            return Collections.emptySet();
        }
        HashSet<UserDTO> userSet = new HashSet<UserDTO>();
        for (User userEntity : users) {
            userSet.add(this.toDtoLogin(userEntity));
        }
        return userSet;
    }
}

