/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.BPMNExecutor;
import de.trustable.ca3s.core.service.util.CertificateAsyncUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.util.HashMap;
import java.util.Optional;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class BPMNAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNAsyncUtil.class);
    public static final String NOTIFICATION_SEPARATOR = ":";
    private final BPMNExecutor bpmnExecutor;
    private final CertificateAsyncUtil certificateAsyncUtil;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certificateUtil;

    public BPMNAsyncUtil(BPMNExecutor bpmnExecutor, CertificateAsyncUtil certificateAsyncUtil, CertificateRepository certificateRepository, CertificateUtil certificateUtil) {
        this.bpmnExecutor = bpmnExecutor;
        this.certificateAsyncUtil = certificateAsyncUtil;
        this.certificateRepository = certificateRepository;
        this.certificateUtil = certificateUtil;
    }

    @Async
    @Transactional
    public void onChange(String processName, Long certificateId, Authentication auth) {
        LOG.info("******************  Async call to onChange( '{}', {})", (Object)processName, (Object)certificateId);
        if (certificateId == null) {
            return;
        }
        Optional optionalCertificate = this.certificateRepository.findById((Object)certificateId);
        if (optionalCertificate.isEmpty()) {
            return;
        }
        Certificate certificate = (Certificate)optionalCertificate.get();
        this.certificateUtil.setCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_PROCESS", processName, false);
        this.certificateUtil.setCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_COUNTER", "0", false);
        this.processChange(certificate, auth);
    }

    private void executeAfterTransactionCompletes(Certificate certificate) {
        LOG.info("********* register transaction sync 'afterComplete'");
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void processChange(Certificate certificate, Authentication auth) {
        String string;
        LOG.info("******************  processChange({}, {})", (Object)certificate.getId(), (Object)(auth == null ? null : auth.getName()));
        this.executeAfterTransactionCompletes(certificate);
        String processName = this.certificateUtil.getCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_PROCESS");
        if (processName == null) {
            return;
        }
        String counterString = this.certificateUtil.getCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_COUNTER");
        if (counterString == null) {
            return;
        }
        int retryCount = Integer.parseInt(counterString);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("certificateId", certificate.getId().toString());
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication currentAuth = securityContext.getAuthentication();
        try {
            if (auth != null) {
                LOG.info("Setting authentication to : {}", (Object)auth.getName());
                securityContext.setAuthentication(auth);
            }
            variables.put("currentAuth", (String)securityContext.getAuthentication());
            try {
                ProcessInstanceWithVariables processInstance = this.bpmnExecutor.executeBPMNProcessByName(processName, variables);
                if (processInstance != null) {
                    String status = processInstance.getVariables().get((Object)"status").toString();
                    LOG.info("ProcessInstance '{}' terminates with status {}", (Object)processInstance.getId(), (Object)status);
                }
            }
            catch (Exception processException) {
                String msg = "Exception while calling bpmn process '" + processName + "' fails, incrementing retryCount to " + ++retryCount;
                LOG.info(msg, (Throwable)processException);
                this.certificateUtil.setCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_PROCESS", processName + NOTIFICATION_SEPARATOR + retryCount, false);
            }
            string = currentAuth == null ? null : currentAuth.getName();
        }
        catch (Throwable throwable) {
            String currentAuthName = currentAuth == null ? null : currentAuth.getName();
            LOG.info("Restoring authentication to : {}", (Object)currentAuthName);
            securityContext.setAuthentication(currentAuth);
            throw throwable;
        }
        String currentAuthName = string;
        LOG.info("Restoring authentication to : {}", (Object)currentAuthName);
        securityContext.setAuthentication(currentAuth);
    }
}

