/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.BPMNProcessAttribute;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BPMNExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNExecutor.class);
    private final RuntimeService runtimeService;
    private final BPMNProcessInfoRepository bpnmInfoRepo;
    private final ProtectedContentUtil protectedContentUtil;

    public BPMNExecutor(RuntimeService runtimeService, BPMNProcessInfoRepository bpnmInfoRepo, ProtectedContentUtil protectedContentUtil) {
        this.runtimeService = runtimeService;
        this.bpnmInfoRepo = bpnmInfoRepo;
        this.protectedContentUtil = protectedContentUtil;
    }

    public ProcessInstanceWithVariables executeBPMNProcessByName(String processNameId, Map<String, Object> variables) {
        Optional bpmnProcessInfoOpt = this.bpnmInfoRepo.findByProcessId(processNameId);
        if (bpmnProcessInfoOpt.isPresent()) {
            return this.executeBPMNProcessByBPMNProcessInfo((BPMNProcessInfo)bpmnProcessInfoOpt.get(), variables);
        }
        throw new RuntimeException("processNameId '" + processNameId + "' unknown");
    }

    public ProcessInstanceWithVariables executeBPMNProcessByBPMNProcessInfo(BPMNProcessInfo bpmnProcessInfo, Map<String, Object> variables) {
        ProcessInstanceWithVariables processInstance;
        block8: {
            LOG.debug("execute BPMN Process Info ''{}' ", (Object)bpmnProcessInfo.getName());
            Set variableSet = bpmnProcessInfo.getBpmnProcessAttributes();
            HashSet<CallSite> protectedNameSet = new HashSet<CallSite>();
            for (BPMNProcessAttribute bpmnProcessAttribute : variableSet) {
                String value = bpmnProcessAttribute.getValue();
                if (Boolean.TRUE.equals(bpmnProcessAttribute.getProtectedContent())) {
                    protectedNameSet.add((CallSite)((Object)("processAttribute_" + bpmnProcessAttribute.getName())));
                    List protectedContents = this.protectedContentUtil.retrieveProtectedContent(ProtectedContentType.SECRET, ContentRelationType.BPMN_ATTRIBUTE, bpmnProcessAttribute.getId().longValue());
                    if (protectedContents.isEmpty()) {
                        LOG.warn("executeBPMNProcessByBPMNProcessInfo: no protected value found for BPMNProcessAttribute #{}", (Object)bpmnProcessAttribute.getId());
                    } else if (protectedContents.size() > 1) {
                        LOG.warn("executeBPMNProcessByBPMNProcessInfo: more than one ({}) protected values found for BPMNProcessAttribute #{}!", (Object)protectedContents.size(), (Object)bpmnProcessAttribute.getId());
                    }
                    ProtectedContent protectedContent = (ProtectedContent)protectedContents.get(0);
                    value = this.protectedContentUtil.unprotectString(protectedContent.getContentBase64());
                }
                variables.put("processAttribute_" + bpmnProcessAttribute.getName(), value);
            }
            variables.put("status", "Failed");
            variables.put("failureReason", "");
            processInstance = null;
            try {
                processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(bpmnProcessInfo.getProcessId()).setVariables(variables)).executeWithVariablesInReturn();
                String processInstanceId = processInstance.getId();
                LOG.info("ProcessInstance: {}", (Object)processInstanceId);
                VariableMap resultvariables = processInstance.getVariables();
                for (String key : resultvariables.keySet()) {
                    LOG.debug("bpmn process resultvariables: {}", (Object)key);
                    if (!protectedNameSet.contains(key)) continue;
                    resultvariables.replace(key, "**********");
                }
            }
            catch (Exception processException) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("Exception while calling bpmn process '" + bpmnProcessInfo.getProcessId() + "'", (Throwable)processException);
            }
        }
        return processInstance;
    }
}

