/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CAConnectorType;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.service.adcs.ADCSConnector;
import de.trustable.ca3s.core.service.cmp.CaCmpConnector;
import de.trustable.ca3s.core.service.dir.DirectoryConnector;
import de.trustable.ca3s.core.service.dto.CAConnectorStatus;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CaInternalConnector;
import de.trustable.ca3s.core.service.vault.VaultCertificateConnector;
import de.trustable.ca3s.core.service.vault.VaultPKIConnector;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x509.CRLReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaConnectorAdapter {
    Logger LOGGER = LoggerFactory.getLogger(CaConnectorAdapter.class);
    private final ADCSConnector adcsConnector;
    private final CaCmpConnector cmpConnector;
    private final VaultPKIConnector vaultPKIConnector;
    private final CaInternalConnector internalConnector;
    private final DirectoryConnector dirConnector;
    private final VaultCertificateConnector vaultCertificateConnector;
    private final CAConnectorConfigRepository caConfigRepository;
    private final CSRUtil csrUtil;
    private List<CAConnectorStatus> caConnectorStatus = new ArrayList();

    public CaConnectorAdapter(ADCSConnector adcsConnector, CaCmpConnector cmpConnector, VaultPKIConnector vaultPKIConnector, CaInternalConnector internalConnector, DirectoryConnector dirConnector, VaultCertificateConnector vaultCertificateConnector, CAConnectorConfigRepository caConfigRepository, CSRUtil csrUtil) {
        this.adcsConnector = adcsConnector;
        this.cmpConnector = cmpConnector;
        this.vaultPKIConnector = vaultPKIConnector;
        this.internalConnector = internalConnector;
        this.dirConnector = dirConnector;
        this.vaultCertificateConnector = vaultCertificateConnector;
        this.caConfigRepository = caConfigRepository;
        this.csrUtil = csrUtil;
    }

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        if (caConfig == null) {
            this.LOGGER.debug("CAConnectorType caConfig == null !");
            return CAStatus.Unknown;
        }
        if (!caConfig.isActive().booleanValue()) {
            this.LOGGER.debug("CAConnector '" + caConfig.getName() + "' is disabled");
            return CAStatus.Deactivated;
        }
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at " + caConfig.getCaUrl());
            return this.adcsConnector.getStatus(caConfig);
        }
        if (CAConnectorType.ADCS_CERTIFICATE_INVENTORY.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS_CERTIFICATE_INVENTORY at " + caConfig.getCaUrl());
            return this.adcsConnector.getStatus(caConfig);
        }
        if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at " + caConfig.getCaUrl());
            return this.cmpConnector.getStatus(caConfig);
        }
        if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL is enabled");
            return CAStatus.Active;
        }
        if (CAConnectorType.DIRECTORY.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType DIRECTORY for " + caConfig.getCaUrl());
            return this.dirConnector.getStatus(caConfig);
        }
        if (CAConnectorType.VAULT_INVENTORY.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType VAULT INVENTORY for " + caConfig.getCaUrl());
            return this.vaultCertificateConnector.getStatus(caConfig);
        }
        this.LOGGER.warn("unexpected ca connector type '" + String.valueOf(caConfig.getCaConnectorType()) + "' !");
        return CAStatus.Unknown;
    }

    public Certificate signCertificateRequest(String csrBase64, CAConnectorConfig caConfig) throws GeneralSecurityException, IOException {
        CSR csr = this.csrUtil.buildCSR(csrBase64, "SYSTEM", this.csrUtil.parseBase64CSR(csrBase64), PipelineType.INTERNAL, null);
        return this.signCertificateRequest(csr, caConfig);
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConfig) throws GeneralSecurityException {
        if (caConfig == null) {
            throw new GeneralSecurityException("CA connector not selected !");
        }
        Certificate cert = this.signCSR(csr, caConfig);
        return cert;
    }

    private Certificate signCSR(CSR csr, CAConnectorConfig caConfig) throws GeneralSecurityException {
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at {} signs CSR", (Object)caConfig.getCaUrl());
            return this.adcsConnector.signCertificateRequest(csr, caConfig);
        }
        if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at {} signs CSR", (Object)caConfig.getCaUrl());
            return this.cmpConnector.signCertificateRequest(csr, caConfig);
        }
        if (CAConnectorType.VAULT.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType Vault at {} signs CSR", (Object)caConfig.getCaUrl());
            return this.vaultPKIConnector.signCertificateRequest(csr, caConfig);
        }
        if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL signs CSR");
            return this.internalConnector.signCertificateRequest(csr, caConfig);
        }
        throw new GeneralSecurityException("unexpected ca connector type '" + String.valueOf(caConfig.getCaConnectorType()) + "' !");
    }

    @Transactional
    public void revokeCertificate(Certificate certificateDao, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConfig) throws GeneralSecurityException {
        if (caConfig == null) {
            throw new GeneralSecurityException("CA connector not selected !");
        }
        if (CAConnectorType.ADCS.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType ADCS at {} revokes certificate id {}", (Object)caConfig.getCaUrl(), (Object)certificateDao.getId());
            this.adcsConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else if (CAConnectorType.CMP.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType CMP at {} revokes certificate id {}", (Object)caConfig.getCaUrl(), (Object)certificateDao.getId());
            this.cmpConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else if (CAConnectorType.INTERNAL.equals((Object)caConfig.getCaConnectorType())) {
            this.LOGGER.debug("CAConnectorType INTERNAL revokes certificate id {}", (Object)certificateDao.getId());
            this.internalConnector.revokeCertificate(certificateDao, crlReason, revocationDate, caConfig);
        } else {
            throw new GeneralSecurityException("unexpected ca connector type '" + String.valueOf(caConfig.getCaConnectorType()) + "' !");
        }
    }

    public List<CAConnectorStatus> getCAConnectorStatus() {
        return this.caConnectorStatus;
    }

    public void updateCAConnectorStatus() {
        ArrayList<CAConnectorStatus> caStatusList = new ArrayList<CAConnectorStatus>();
        for (CAConnectorConfig cAConnectorConfig : this.caConfigRepository.findAll()) {
            CAStatus status;
            if (cAConnectorConfig.isActive().booleanValue()) {
                try {
                    status = this.getStatus(cAConnectorConfig);
                }
                catch (Exception ex) {
                    status = CAStatus.Problem;
                }
            } else {
                status = CAStatus.Deactivated;
            }
            CAConnectorStatus stat = new CAConnectorStatus(cAConnectorConfig.getId(), cAConnectorConfig.getName(), status);
            caStatusList.add(stat);
            this.LOGGER.debug("Connector {} is {}, status: {}", new Object[]{cAConnectorConfig.getName(), cAConnectorConfig.isActive() != false ? "enabled" : "disabled", status});
        }
        this.caConnectorStatus = caStatusList;
    }
}

