/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.KeyUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.PKILevel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CaInternalConnector {
    private static final Logger LOG = LoggerFactory.getLogger(CaInternalConnector.class);
    private final CertificateRepository certRepository;
    private final CSRRepository csrRepository;
    private final CryptoUtil cryptoUtil;
    private final CertificateUtil certUtil;
    private final CSRUtil csrUtil;
    private final KeyUtil keyUtil;
    private final int rootValidityDays;
    private final int intermediateValidityDays;
    private final int eeValidityDays;

    public CaInternalConnector(CertificateRepository certRepository, CSRRepository csrRepository, CryptoUtil cryptoUtil, CertificateUtil certUtil, CSRUtil csrUtil, KeyUtil keyUtil, @Value(value="${ca3s.internalCa.rootValidityDays:720}") int rootValidityDays, @Value(value="${ca3s.internalCa.intermediateValidityDays:600}") int intermediateValidityDays, @Value(value="${ca3s.internalCa.eeValidityDays:360}") int eeValidityDays) {
        this.certRepository = certRepository;
        this.csrRepository = csrRepository;
        this.cryptoUtil = cryptoUtil;
        this.certUtil = certUtil;
        this.csrUtil = csrUtil;
        this.keyUtil = keyUtil;
        this.rootValidityDays = rootValidityDays;
        this.intermediateValidityDays = intermediateValidityDays;
        this.eeValidityDays = eeValidityDays;
        if (intermediateValidityDays > rootValidityDays) {
            throw new RuntimeException("configured values for intermediateValidityDays > rootValidityDays");
        }
        if (eeValidityDays > intermediateValidityDays) {
            throw new RuntimeException("configured values for eeValidityDays > intermediateValidityDays");
        }
    }

    Certificate getRoot(int intermediateValidityDays) throws GeneralSecurityException, IOException {
        Instant minValidity = Instant.now().plus((long)intermediateValidityDays, ChronoUnit.DAYS);
        List certList = this.certRepository.findByAttributeValue("CA3S:ROOT", "true");
        Certificate certRoot = this.getLongestValidCertificate(certList);
        if (certRoot == null || certRoot.getValidTo().isBefore(minValidity)) {
            certRoot = this.createNewRoot();
        }
        return certRoot;
    }

    Certificate getIntermediate(int eeValidityDays) throws GeneralSecurityException, IOException {
        Instant minValidity = Instant.now().plus((long)eeValidityDays, ChronoUnit.DAYS);
        List certList = this.certRepository.findByAttributeValue("CA3S:INTERMEDIATE", "true");
        Certificate certIntermediate = this.getLongestValidCertificate(certList);
        if (certIntermediate == null || certIntermediate.getValidTo().isBefore(minValidity)) {
            certIntermediate = this.createNewIntermediate(this.getRoot(this.intermediateValidityDays));
        }
        return certIntermediate;
    }

    private Certificate createNewIntermediate(Certificate root) throws GeneralSecurityException, IOException {
        KeyPair keyPair = this.keyUtil.createKeyPair();
        X500Name subject = new X500Name("CN=CA3S-Intermediate" + System.currentTimeMillis() + ", OU=Dev/Test Only, O=trustable solutions, C=DE");
        PrivateKey privKeyRoot = this.certUtil.getPrivateKey(root);
        KeyPair kpRoot = new KeyPair(CertificateUtil.convertPemToCertificate((String)root.getContent()).getPublicKey(), privKeyRoot);
        X509Certificate x509Cert = this.cryptoUtil.issueCertificate(this.normalizeX500Name(new X500Name(root.getSubject())), kpRoot, this.normalizeX500Name(subject), keyPair.getPublic().getEncoded(), 5, this.intermediateValidityDays, PKILevel.INTERMEDIATE);
        Certificate intermediateCert = this.certUtil.createCertificate(x509Cert.getEncoded(), null, "", false);
        this.certUtil.storePrivateKey(intermediateCert, keyPair);
        this.certUtil.setCertAttribute(intermediateCert, "CA3S:INTERMEDIATE", "true");
        this.certRepository.save((Object)intermediateCert);
        LOG.info("############# createNewIntermediate returns cert #{}, serial {}", (Object)intermediateCert.getId(), (Object)intermediateCert.getSerial());
        return intermediateCert;
    }

    X500Name normalizeX500Name(X500Name dn) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
        this.addExistingRDN(BCStyle.C, dn, x500NameBuilder);
        this.addExistingRDN(BCStyle.OU, dn, x500NameBuilder);
        this.addExistingRDN(BCStyle.O, dn, x500NameBuilder);
        this.addExistingRDN(BCStyle.CN, dn, x500NameBuilder);
        return x500NameBuilder.build();
    }

    private void addExistingRDN(ASN1ObjectIdentifier identifier, X500Name dn, X500NameBuilder x500NameBuilder) {
        RDN[] rdnArr;
        for (RDN rdn : rdnArr = dn.getRDNs(identifier)) {
            x500NameBuilder.addRDN(identifier, rdn.getFirst().getValue().toString());
        }
    }

    private Certificate createNewRoot() throws GeneralSecurityException, IOException {
        KeyPair keyPair = this.keyUtil.createKeyPair();
        X500Name subject = new X500Name("CN=CA3S-InternalRoot" + System.currentTimeMillis() + ", OU=Dev/Test Only, O=trustable solutions, C=DE");
        X509Certificate x509Cert = this.cryptoUtil.issueCertificate(this.normalizeX500Name(subject), keyPair, this.normalizeX500Name(subject), keyPair.getPublic().getEncoded(), 5, this.rootValidityDays, PKILevel.ROOT);
        Certificate rootCert = this.certUtil.createCertificate(x509Cert.getEncoded(), null, "", false);
        this.certUtil.storePrivateKey(rootCert, keyPair);
        rootCert.setTrusted(Boolean.valueOf(true));
        this.certUtil.setCertAttribute(rootCert, "CA3S:ROOT", "true");
        this.certRepository.save((Object)rootCert);
        LOG.info("############# createNewRoot returns cert #{}, serial {}", (Object)rootCert.getId(), (Object)rootCert.getSerial());
        return rootCert;
    }

    private Certificate getLongestValidCertificate(List<Certificate> certList) {
        Instant now = Instant.now();
        Certificate certLongestValid = null;
        for (Certificate cert : certList) {
            if (!now.isAfter(cert.getValidFrom()) || !now.isBefore(cert.getValidTo())) continue;
            if (certLongestValid == null) {
                certLongestValid = cert;
                continue;
            }
            if (!certLongestValid.getValidTo().isBefore(cert.getValidTo())) continue;
            certLongestValid = cert;
        }
        return certLongestValid;
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig caConfig) throws GeneralSecurityException {
        try {
            Attribute[] certAttributes;
            this.csrUtil.setCsrAttribute(csr, "CA_PROCESSING_STARTED_TIMESTAMP", "" + System.currentTimeMillis(), false);
            csr.setStatus(CsrStatus.PROCESSING);
            Certificate intermediate = this.getIntermediate(this.eeValidityDays);
            PrivateKey privKeyIntermediate = this.certUtil.getPrivateKey(intermediate);
            KeyPair kpIntermediate = new KeyPair(CertificateUtil.convertPemToCertificate((String)intermediate.getContent()).getPublicKey(), privKeyIntermediate);
            PKCS10CertificationRequest p10 = this.cryptoUtil.convertPemToPKCS10CertificationRequest(csr.getCsrBase64());
            GeneralNames gns = null;
            for (Attribute attribute : certAttributes = p10.getAttributes()) {
                if (!attribute.getAttrType().equals((ASN1Primitive)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
                Extensions extensions = Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
                gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
            }
            X509Certificate x509Cert = this.cryptoUtil.issueCertificate(this.normalizeX500Name(new X500Name(intermediate.getSubject())), kpIntermediate, this.normalizeX500Name(p10.getSubject()), p10.getSubjectPublicKeyInfo(), 5, this.eeValidityDays, gns, null, PKILevel.END_ENTITY);
            Certificate cert = this.certUtil.createCertificate(x509Cert.getEncoded(), csr, "", false);
            cert.setRevocationCA(caConfig);
            this.certRepository.save((Object)cert);
            this.csrUtil.setCsrAttribute(csr, "CA_PROCESSING_FINISHED_TIMESTAMP", "" + System.currentTimeMillis(), true);
            csr.setStatus(CsrStatus.ISSUED);
            this.csrRepository.save((Object)csr);
            return cert;
        }
        catch (IOException e) {
            LOG.info("Problem signing certificate request", (Throwable)e);
            throw new GeneralSecurityException(e);
        }
    }

    public void revokeCertificate(Certificate cert, CRLReason crlReason, Date revocationDate, CAConnectorConfig caConfig) {
        if (cert.isRevoked()) {
            LOG.warn("failureReason: certificate with id '" + cert.getId() + "' already revoked.");
        }
        String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
        LOG.debug("crlReason : " + crlReasonStr);
        cert.setActive(Boolean.valueOf(false));
        cert.setRevoked(Boolean.valueOf(true));
        cert.setRevokedSince(Instant.now());
        cert.setRevocationReason(crlReasonStr);
        this.certRepository.save((Object)cert);
    }
}

