/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ReplacementCandidateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CertificateAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateAsyncUtil.class);
    private final ReplacementCandidateUtil replacementCandidateUtil;
    private final CertificateUtil certUtil;
    private final CertificateRepository certificateRepository;

    public CertificateAsyncUtil(ReplacementCandidateUtil replacementCandidateUtil, CertificateUtil certUtil, CertificateRepository certificateRepository) {
        this.replacementCandidateUtil = replacementCandidateUtil;
        this.certUtil = certUtil;
        this.certificateRepository = certificateRepository;
    }

    @Async
    @Transactional
    public void onChange(Certificate certificate, List<String> emailList) {
        LOG.debug("Async call to onChange( '{}')", (Object)certificate);
        if (certificate == null) {
            return;
        }
        this.replacementCandidateUtil.notifyOnExcessiveActiveCertificates(certificate, emailList);
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void incrementNotificationCounter(Certificate certificate) {
        String counterString = this.certUtil.getCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_COUNTER");
        if (counterString == null) {
            return;
        }
        int retryCount = Integer.parseInt(counterString) + 1;
        this.certUtil.setCertAttribute(certificate, "CERTIFICATE_NOTIFICATION_COUNTER", "" + retryCount, false);
        this.certificateRepository.save((Object)certificate);
        LOG.info("increment notification counter for cert #{} to {}", (Object)certificate.getId(), (Object)retryCount);
    }
}

