/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.util.PasswordUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProtectedContentUtil {
    public static final String PLAIN_SECRET_PLACEHOLDER = "******";
    private final Logger log = LoggerFactory.getLogger(ProtectedContentUtil.class);
    private final BasicTextEncryptor textEncryptor;
    public static final Instant MAX_INSTANT = Instant.parse("9990-12-30T23:59:59Z");
    private final ProtectedContentRepository protContentRepository;
    private final CertificateRepository certificateRepository;
    private final String salt;
    private final int iterations;
    private final String pbeAlgo;

    public ProtectedContentUtil(ProtectedContentRepository protContentRepository, CertificateRepository certificateRepository, @Value(value="${protectionSecret:mJvR25yt4NHTIqe5Hz7nUHhQNUuM}") String protectionSecretFallback, @Value(value="${ca3s.protectionSecret:#{null}}") String protectionSecret, @Value(value="${ca3s.connection.salt:ca3sSalt}") String salt, @Value(value="${ca3s.connection.iterations:4567}") int iterations, @Value(value="${ca3s.connection.pbeAlgo:PBKDF2WithHmacSHA256}") String pbeAlgo) {
        this.protContentRepository = protContentRepository;
        this.certificateRepository = certificateRepository;
        this.salt = salt;
        this.iterations = iterations;
        this.pbeAlgo = pbeAlgo;
        PasswordUtil passwordUtil = new PasswordUtil("^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{16,100}$");
        if (!(protectionSecret != null && protectionSecret.trim().length() != 0 || protectionSecretFallback == null || protectionSecretFallback.trim().isEmpty())) {
            if ("mJvR25yt4NHTIqe5Hz7nUHhQNUuM".equals(protectionSecretFallback)) {
                this.log.warn("Please provide a secure value for 'ca3s.protectionSecret'!");
            } else {
                this.log.warn("The configuration parameter 'protectionSecret' is deprecated! Use 'ca3s.protectionSecret'.");
            }
            protectionSecret = protectionSecretFallback;
        }
        if (protectionSecret == null || protectionSecret.trim().length() == 0) {
            this.log.warn("Configuration parameter 'protectionSecret' missing or invalid!!");
            throw new UnsupportedOperationException("Configuration parameter 'protectionSecret' missing or invalid");
        }
        passwordUtil.checkPassword(protectionSecret, "Value of 'ca3s.protectionSecret'");
        if (this.log.isDebugEnabled()) {
            this.log.debug("using protection secret '{}'", (Object)PasswordUtil.maskPassword((String)protectionSecret));
        }
        this.textEncryptor = new BasicTextEncryptor();
        this.textEncryptor.setPassword(protectionSecret);
    }

    public boolean hasMinimumOrLessLeftUsages(ProtectedContent protectedContent, int minNumber) {
        if (protectedContent.getLeftUsages() < 0) {
            return false;
        }
        return protectedContent.getLeftUsages() <= minNumber;
    }

    public String protectString(String content) {
        return this.textEncryptor.encrypt(content);
    }

    public String unprotectString(String protectedContent) {
        return this.textEncryptor.decrypt(protectedContent);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId) {
        return this.createProtectedContent(plainText, pct, crt, connectionId, -1, MAX_INSTANT);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId, Instant validTo) {
        return this.createProtectedContent(plainText, pct, crt, connectionId, -1, validTo);
    }

    public ProtectedContent createProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId, int leftUsages, Instant validTo) {
        return this.createPlainProtectedContent(this.protectString(plainText), pct, crt, connectionId, leftUsages, validTo);
    }

    public ProtectedContent createDerivedProtectedContent(String plainText, ProtectedContentType pct, ContentRelationType crt, long connectionId, int leftUsages, Instant validTo) {
        try {
            return this.createPlainProtectedContent(Base64.getEncoder().encodeToString(this.deriveSecret(plainText)), pct, crt, connectionId, leftUsages, validTo);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private ProtectedContent createPlainProtectedContent(String contentBase64, ProtectedContentType pct, ContentRelationType crt, long connectionId, int leftUsages, Instant validTo) {
        ProtectedContent pc = new ProtectedContent();
        pc.setContentBase64(contentBase64);
        pc.setType(pct);
        pc.setRelationType(crt);
        pc.setRelatedId(Long.valueOf(connectionId));
        pc.setCreatedOn(Instant.now());
        pc.setLeftUsages(Integer.valueOf(leftUsages));
        pc.setValidTo(validTo);
        pc.setDeleteAfter(validTo.plus(1L, ChronoUnit.DAYS));
        this.protContentRepository.save((Object)pc);
        return pc;
    }

    public List<ProtectedContent> findProtectedContentBySecret(String plainText, ProtectedContentType type, ContentRelationType crt) {
        String protectedString = null;
        try {
            protectedString = Base64.getEncoder().encodeToString(this.deriveSecret(plainText));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        this.log.debug("searching for protectedString '{}'", (Object)protectedString);
        return this.protContentRepository.findByTypeRelationContentB64(type, crt, protectedString);
    }

    public List<ProtectedContent> retrieveProtectedContent(ProtectedContentType type, ContentRelationType crt, long id) {
        List pcList = this.protContentRepository.findByTypeRelationId(type, crt, Long.valueOf(id));
        Instant now = Instant.now();
        Predicate<ProtectedContent> usableItem = pc -> (pc.getLeftUsages() == -1 || pc.getLeftUsages() > 0) && pc.getValidTo().isAfter(now);
        return pcList.stream().filter(usableItem).collect(Collectors.toList());
    }

    public void deleteProtectedContent(ProtectedContent pc) {
        this.protContentRepository.delete((Object)pc);
    }

    public void deleteProtectedContent(ProtectedContentType type, ContentRelationType crt, long id) {
        List pcList = this.protContentRepository.findByTypeRelationId(type, crt, Long.valueOf(id));
        this.protContentRepository.deleteAll((Iterable)pcList);
    }

    boolean isActive(ProtectedContent pc, Instant now) {
        return (pc.getLeftUsages() == -1 || pc.getLeftUsages() > 0) && pc.getValidTo().isAfter(now);
    }

    public List<ProtectedContent> getActiveCredentials(User user) {
        this.log.debug("getActiveCredentials for  : {}", (Object)user);
        Instant now = Instant.now();
        ArrayList<ProtectedContent> activeCredentialsList = new ArrayList<ProtectedContent>();
        block5: for (ProtectedContent protectedContent : this.protContentRepository.findByTypeRelationId(ProtectedContent.USER_CONTENT_RELATION_TYPE_LIST, user.getId())) {
            if (!this.isActive(protectedContent, now)) continue;
            switch (1.$SwitchMap$de$trustable$ca3s$core$domain$enumeration$ContentRelationType[protectedContent.getRelationType().ordinal()]) {
                case 1: {
                    Certificate userCert;
                    Optional certificateOptional = this.certificateRepository.findById((Object)protectedContent.getRelatedId());
                    if (!certificateOptional.isPresent() || !(userCert = (Certificate)certificateOptional.get()).isActive()) continue block5;
                    activeCredentialsList.add(protectedContent);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    activeCredentialsList.add(protectedContent);
                    break;
                }
                default: {
                    this.log.warn("Unexpected relation type '{}' occurred.", (Object)protectedContent.getRelationType());
                }
            }
        }
        return activeCredentialsList;
    }

    public void updateServersideKeyRetentionSettings(long csrId, Instant validTo, int usages) {
        this.log.info("Update the retention settings for csr #{} to validTo {}, left usages {} ", new Object[]{csrId, validTo, usages});
        List protectedKeys = this.retrieveProtectedContent(ProtectedContentType.KEY, ContentRelationType.CSR, csrId);
        for (ProtectedContent protectedContent : protectedKeys) {
            this.setRetentionSettings(protectedContent, validTo, usages);
        }
        this.protContentRepository.saveAll((Iterable)protectedKeys);
        List protectedPasswords = this.retrieveProtectedContent(ProtectedContentType.PASSWORD, ContentRelationType.CSR, csrId);
        for (ProtectedContent protectedContent : protectedPasswords) {
            this.setRetentionSettings(protectedContent, validTo, usages);
        }
        this.protContentRepository.saveAll((Iterable)protectedPasswords);
    }

    private void setRetentionSettings(ProtectedContent protectedContent, Instant validTo, int usages) {
        protectedContent.setValidTo(validTo);
        protectedContent.setDeleteAfter(validTo.plus(5L, ChronoUnit.DAYS));
        protectedContent.setLeftUsages(Integer.valueOf(usages));
    }

    public byte[] deriveSecret(String secret) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.deriveSecret(secret.toCharArray());
    }

    public byte[] deriveSecret(char[] secret) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory skf = SecretKeyFactory.getInstance(this.pbeAlgo);
        PBEKeySpec specSecKey = new PBEKeySpec(secret, this.salt.getBytes(), this.iterations, 256);
        return skf.generateSecret(specSecKey).getEncoded();
    }
}

