/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.vault;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.VaultUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.vault.core.VaultSysOperations;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultUnsealStatus;

@Service
public class VaultCertificateConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultCertificateConnector.class);
    public static final String BEGIN_CERTIFICATE_PEM = "-----BEGIN CERTIFICATE-----";
    private final CertificateUtil certUtil;
    private final VaultUtil vaultUtil;
    private final CertificateRepository certificateRepository;
    private final AuditService auditService;

    public VaultCertificateConnector(CertificateUtil certUtil, VaultUtil vaultUtil, CertificateRepository certificateRepository, AuditService auditService) {
        this.certUtil = certUtil;
        this.vaultUtil = vaultUtil;
        this.certificateRepository = certificateRepository;
        this.auditService = auditService;
    }

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        try {
            VaultTemplate vaultTemplate = this.vaultUtil.getVaultTemplate(caConfig);
            VaultSysOperations adminOperations = vaultTemplate.opsForSys();
            VaultUnsealStatus unsealStatus = adminOperations.getUnsealStatus();
            LOGGER.debug("VaultUnsealStatus : {}", (Object)unsealStatus.isSealed());
            if (unsealStatus.isSealed()) {
                return CAStatus.Deactivated;
            }
            return CAStatus.Active;
        }
        catch (GeneralSecurityException ge) {
            return CAStatus.Problem;
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int retrieveCertificates(CAConnectorConfig caConfig) throws IOException, GeneralSecurityException {
        VaultTemplate vaultTemplate = this.vaultUtil.getVaultTemplate(caConfig);
        VaultSysOperations adminOperations = vaultTemplate.opsForSys();
        VaultUnsealStatus unsealStatus = adminOperations.getUnsealStatus();
        LOGGER.debug("VaultUnsealStatus : {}", (Object)unsealStatus.isSealed());
        if (unsealStatus.isSealed()) {
            LOGGER.warn("vault '{}' is sealed. Please unseal", (Object)caConfig.getCaUrl());
            return 0;
        }
        String selector = caConfig.getSelector().trim();
        VaultResponse vaultResponseChain = vaultTemplate.read(selector + "/cert/ca_chain");
        String chain = (String)((Map)vaultResponseChain.getData()).get("ca_chain");
        for (String certPem : this.splitPemChain(chain)) {
            LOGGER.debug("ca chain splitted : {}", (Object)certPem);
            this.importCertificate(certPem, caConfig.getName(), null, caConfig);
        }
        List certKeyList = vaultTemplate.list(selector + "/certs");
        LOGGER.debug("certKeyList : {}", (Object)certKeyList);
        for (String vaultKey : certKeyList) {
            List knownCertList = this.certificateRepository.findByAttributeValue("ATTRIBUTE_VAULT_KEY", vaultKey);
            if (knownCertList.isEmpty()) {
                VaultResponse vaultResponse = vaultTemplate.read(selector + "/cert/" + vaultKey);
                LOGGER.debug("vaultResponse.getData() : {}", vaultResponse.getData());
                Certificate certificate = this.importCertificate((String)((Map)vaultResponse.getData()).get("certificate"), caConfig.getName(), vaultKey, caConfig);
                continue;
            }
            LOGGER.debug("certificate with vaultKey {} already imported", (Object)vaultKey);
        }
        return 0;
    }

    private List<String> splitPemChain(String pemChain) {
        String[] parts = pemChain.split(BEGIN_CERTIFICATE_PEM);
        ArrayList<String> certList = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            certList.add(BEGIN_CERTIFICATE_PEM + part);
        }
        return certList;
    }

    public Certificate importCertificate(String pemCert, String caName, String key, CAConnectorConfig config) {
        try {
            Certificate certDao = this.certUtil.getCertificateByPEM(pemCert);
            if (certDao == null) {
                certDao = this.certUtil.createCertificate(pemCert, null, null, false);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("AUDIT_VAULT_CERTIFICATE_IMPORTED", certDao));
            }
            this.certUtil.setCertAttribute(certDao, "PROCESSING_CA", caName);
            if (key != null) {
                this.certUtil.setCertAttribute(certDao, "ATTRIBUTE_VAULT_KEY", key);
            }
            this.certificateRepository.save((Object)certDao);
            LOGGER.debug("certificate with key '{}' imported from ca '{}'", (Object)key, (Object)caName);
            return certDao;
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.info("retrieving and importing certificate with key '{}' from ca '{}' causes {}", new Object[]{key, caName, e.getLocalizedMessage()});
            return null;
        }
    }
}

