/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.exception.PasswordRestrictionMismatchException;
import de.trustable.ca3s.core.exception.UserNotFoundException;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.repository.TenantRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.security.SecurityUtils;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.TotpService;
import de.trustable.ca3s.core.service.UserService;
import de.trustable.ca3s.core.service.dto.AccountCredentialView;
import de.trustable.ca3s.core.service.dto.AccountCredentialsType;
import de.trustable.ca3s.core.service.dto.CredentialUpdateType;
import de.trustable.ca3s.core.service.dto.Languages;
import de.trustable.ca3s.core.service.dto.PasswordChangeDTO;
import de.trustable.ca3s.core.service.dto.UserDTO;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.RandomUtil;
import de.trustable.ca3s.core.web.rest.AccountResource;
import de.trustable.ca3s.core.web.rest.data.OTPDetailsResponse;
import de.trustable.ca3s.core.web.rest.errors.AccountResourceException;
import de.trustable.ca3s.core.web.rest.errors.EmailAlreadyUsedException;
import de.trustable.ca3s.core.web.rest.errors.InvalidPasswordException;
import de.trustable.ca3s.core.web.rest.vm.KeyAndPasswordVM;
import de.trustable.ca3s.core.web.rest.vm.ManagedUserVM;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.bouncycastle.util.encoders.Base32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Transactional
@RequestMapping(value={"/api"})
public class AccountResource {
    @Value(value="${ca3s.ui.languages:en,de,pl}")
    private String availableLanguages;
    private final Logger log = LoggerFactory.getLogger(AccountResource.class);
    private final UserRepository userRepository;
    private final UserService userService;
    private final TenantRepository tenantRepository;
    private final ProtectedContentRepository protectedContentRepository;
    private final CertificateRepository certificateRepository;
    private final CertificateUtil certificateUtil;
    private final TotpService totpService;
    private final MailService mailService;

    public AccountResource(UserRepository userRepository, UserService userService, TenantRepository tenantRepository, ProtectedContentRepository protectedContentRepository, MailService mailService, CertificateRepository certificateRepository, CertificateUtil certificateUtil, TotpService totpService) {
        this.userRepository = userRepository;
        this.userService = userService;
        this.tenantRepository = tenantRepository;
        this.protectedContentRepository = protectedContentRepository;
        this.mailService = mailService;
        this.certificateRepository = certificateRepository;
        this.certificateUtil = certificateUtil;
        this.totpService = totpService;
    }

    @PostMapping(value={"/register"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void registerAccount(@Valid @RequestBody ManagedUserVM managedUserVM) throws MessagingException {
        this.checkPasswordLength(managedUserVM.getPassword());
        String activationKey = tech.jhipster.security.RandomUtil.generateActivationKey();
        User user = this.userService.registerUser((UserDTO)managedUserVM, managedUserVM.getPassword(), activationKey);
        this.mailService.sendActivationEmail(user, activationKey);
    }

    @GetMapping(value={"/activate"})
    public void activateAccount(@RequestParam(value="key") String key) {
        Optional user = this.userService.activateRegistration(key);
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this activation key");
        }
    }

    @GetMapping(value={"/authenticate"})
    public String isAuthenticated(HttpServletRequest request) {
        this.log.debug("REST request to check if the current user is authenticated");
        return request.getRemoteUser();
    }

    @Transactional
    @GetMapping(value={"/account"})
    public UserDTO getAccount() {
        Optional optUser = this.userService.getUserWithAuthorities();
        if (optUser.isPresent()) {
            Languages languages = new Languages(this.availableLanguages);
            User user = (User)optUser.get();
            if (user.getLangKey() == null) {
                user.setLangKey(languages.getLanguageArr()[0]);
            } else {
                user.setLangKey(languages.alignLanguage(user.getLangKey()));
            }
            UserDTO userDTO = new UserDTO(user, this.tenantRepository);
            return userDTO;
        }
        throw new AccountResourceException("User could not be found");
    }

    @Transactional
    @PostMapping(value={"/account"})
    public void saveAccount(@Valid @RequestBody UserDTO userDTO) {
        String userLogin = this.findCurrentUser().getLogin();
        Optional existingUser = this.userRepository.findOneByEmailIgnoreCase(userDTO.getEmail());
        if (existingUser.isPresent() && !((User)existingUser.get()).getLogin().equalsIgnoreCase(userLogin)) {
            throw new EmailAlreadyUsedException();
        }
        this.userService.updateUser(userDTO.getFirstName(), userDTO.getLastName(), userDTO.getEmail(), userDTO.getPhone(), userDTO.isSecondFactorRequired(), userDTO.getLangKey(), userDTO.getImageUrl(), userDTO.getTenantId());
    }

    private User findCurrentUser() {
        String userLogin = (String)SecurityUtils.getCurrentUserLogin().orElseThrow(() -> new AccountResourceException("Current user login not found"));
        Optional userOpt = this.userRepository.findOneByLogin(userLogin);
        if (!userOpt.isPresent()) {
            throw new AccountResourceException("User could not be found");
        }
        return (User)userOpt.get();
    }

    @GetMapping(path={"/account/credentials"})
    public List<AccountCredentialView> accountCredentialList() {
        User currentUser = this.findCurrentUser();
        List protectedContentList = this.protectedContentRepository.findByTypeRelationId(Arrays.asList(ProtectedContent.USER_CONTENT_RELATION_TYPES), currentUser.getId());
        ArrayList<AccountCredentialView> accountCredentialViewList = new ArrayList<AccountCredentialView>();
        for (ProtectedContent protectedContent : protectedContentList) {
            AccountCredentialView accountCredentialView = new AccountCredentialView();
            accountCredentialView.setId(protectedContent.getId());
            accountCredentialView.setLeftUsages(protectedContent.getLeftUsages());
            accountCredentialView.setCreatedOn(protectedContent.getCreatedOn());
            accountCredentialView.setValidTo(protectedContent.getValidTo());
            switch (1.$SwitchMap$de$trustable$ca3s$core$domain$enumeration$ContentRelationType[protectedContent.getRelationType().ordinal()]) {
                case 1: {
                    accountCredentialView.setRelationType(AccountCredentialsType.ACCOUNT_TOKEN);
                    break;
                }
                case 2: {
                    accountCredentialView.setRelationType(AccountCredentialsType.OTP_SECRET);
                    break;
                }
                case 3: {
                    accountCredentialView.setRelationType(AccountCredentialsType.SMS_ENABLED);
                    break;
                }
                default: {
                    this.log.warn("Unexpected relation type '{}' occurred.", (Object)protectedContent.getRelationType());
                }
            }
            accountCredentialViewList.add(accountCredentialView);
        }
        List certificateList = this.certificateRepository.findByAttributeValue("USER_CLIENT_CERT", currentUser.getId().toString());
        for (Certificate certificate : certificateList) {
            AccountCredentialView accountCredentialView = new AccountCredentialView();
            accountCredentialView.setId(certificate.getId());
            accountCredentialView.setLeftUsages(Integer.valueOf(Integer.MAX_VALUE));
            accountCredentialView.setCreatedOn(certificate.getValidFrom());
            accountCredentialView.setValidTo(certificate.getValidTo());
            accountCredentialView.setRelationType(AccountCredentialsType.CLIENT_CERTIFICATE);
            accountCredentialViewList.add(accountCredentialView);
        }
        return accountCredentialViewList;
    }

    @DeleteMapping(path={"/account/credentials/{type}/{id}"})
    public void deleteAccountCredential(@PathVariable AccountCredentialsType type, @PathVariable Long id) {
        this.userService.deleteCredential(type, id);
    }

    @PostMapping(path={"/account/change-password"})
    public void changePassword(@RequestBody PasswordChangeDTO passwordChangeDto) {
        if (passwordChangeDto.getCredentialUpdateType() == null) {
            passwordChangeDto.setCredentialUpdateType(CredentialUpdateType.PASSWORD);
        }
        if (CredentialUpdateType.PASSWORD.equals((Object)passwordChangeDto.getCredentialUpdateType())) {
            this.checkPasswordLength(passwordChangeDto.getNewPassword());
        }
        this.userService.changePassword(passwordChangeDto);
    }

    @PostMapping(path={"/account/reset-password/init"})
    public void requestPasswordReset(@RequestBody String username) throws MessagingException {
        this.mailService.sendPasswordResetMail((User)this.userService.requestPasswordReset(username).orElseThrow(UserNotFoundException::new));
    }

    @PostMapping(path={"/account/reset-password/finish"})
    public void finishPasswordReset(@RequestBody KeyAndPasswordVM keyAndPassword) {
        this.checkPasswordLength(keyAndPassword.getNewPassword());
        Optional user = this.userService.completePasswordReset(keyAndPassword.getNewPassword(), keyAndPassword.getKey());
        if (!user.isPresent()) {
            throw new AccountResourceException("No user was found for this reset key");
        }
    }

    private void checkPasswordLength(String password) {
        try {
            this.userService.checkPassword(password);
        }
        catch (PasswordRestrictionMismatchException passwordRestrictionMismatchException) {
            throw new InvalidPasswordException();
        }
    }

    @PostMapping(path={"/account/initOTP"})
    public OTPDetailsResponse initOTP() {
        String userLogin = (String)SecurityUtils.getCurrentUserLogin().orElseThrow(() -> new AccountResourceException("Current user login not found"));
        byte[] seed = new byte[20];
        RandomUtil.getSecureRandom().nextBytes(seed);
        OTPDetailsResponse otpDetailsResponse = new OTPDetailsResponse();
        otpDetailsResponse.setSeed(Base32.toBase32String((byte[])seed));
        String totpUrl = this.totpService.generateTotpUrlForUser(userLogin, otpDetailsResponse.getSeed());
        otpDetailsResponse.setTotpUrl(totpUrl);
        otpDetailsResponse.setQrCodeImg(this.generateQRasPNG(totpUrl));
        return otpDetailsResponse;
    }

    public byte[] generateQRasPNG(String code) {
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(code, BarcodeFormat.QR_CODE, 256, 256);
            BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            this.log.error("Error while creating QR code temp file: ", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Unable to generate QR Code!");
        }
        catch (WriterException e) {
            this.log.error("Error while generating QR code: ", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Unable to generate QR Code!");
        }
    }
}

