/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.service.AcmeOrderService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeOrderResource {
    private final Logger log = LoggerFactory.getLogger(AcmeOrderResource.class);
    private static final String ENTITY_NAME = "acmeOrder";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeOrderService acmeOrderService;

    public AcmeOrderResource(AcmeOrderService acmeOrderService) {
        this.acmeOrderService = acmeOrderService;
    }

    @GetMapping(value={"/acme-orders"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<AcmeOrder> getAllAcmeOrders() {
        this.log.debug("REST request to get all AcmeOrders");
        return this.acmeOrderService.findAll();
    }

    @GetMapping(value={"/acme-orders/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<AcmeOrder> getAcmeOrder(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeOrder : {}", (Object)id);
        Optional acmeOrder = this.acmeOrderService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeOrder);
    }
}

