/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.adcsCertUtil.ADCSInstanceDetails;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.exception.IntegrityException;
import de.trustable.ca3s.core.service.CAConnectorConfigService;
import de.trustable.ca3s.core.service.adcs.ADCSConnector;
import de.trustable.ca3s.core.service.dto.CaConnectorConfigView;
import de.trustable.ca3s.core.service.dto.adcs.ADCSInstanceDetailsView;
import de.trustable.ca3s.core.service.util.CaConnectorConfigUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@Transactional
@RequestMapping(value={"/api"})
public class CAConnectorConfigViewResource {
    private final Logger log = LoggerFactory.getLogger(CAConnectorConfigViewResource.class);
    private static final String ENTITY_NAME = "cAConnectorConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CAConnectorConfigService cAConnectorConfigService;
    private final CaConnectorConfigUtil caConnectorConfigUtil;
    private final ADCSConnector adcsConnector;

    public CAConnectorConfigViewResource(CAConnectorConfigService cAConnectorConfigService, CaConnectorConfigUtil caConnectorConfigUtil, ADCSConnector adcsConnector) {
        this.cAConnectorConfigService = cAConnectorConfigService;
        this.caConnectorConfigUtil = caConnectorConfigUtil;
        this.adcsConnector = adcsConnector;
    }

    @PostMapping(value={"/ca-connector-configViews"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CaConnectorConfigView> createPipeline(@Valid @RequestBody CaConnectorConfigView caConnectorConfigView) throws URISyntaxException {
        this.log.debug("REST request to save CAConnectorConfigView : {}", (Object)caConnectorConfigView);
        if (caConnectorConfigView.getId() != null) {
            throw new BadRequestAlertException("A new pipeline request cannot have an ID", ENTITY_NAME, "idexists");
        }
        CAConnectorConfig cfg = this.caConnectorConfigUtil.to(caConnectorConfigView);
        this.cAConnectorConfigService.save(cfg);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/ca-connector-configViews/" + cfg.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cfg.getId().toString()))).body((Object)caConnectorConfigView);
    }

    @PutMapping(value={"/ca-connector-configViews"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<CaConnectorConfigView> updatePipeline(@Valid @RequestBody CaConnectorConfigView caConnectorConfigView) throws URISyntaxException {
        this.log.debug("REST request to update CaConnectorConfig : {}", (Object)caConnectorConfigView);
        if (caConnectorConfigView.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        CAConnectorConfig cfg = this.caConnectorConfigUtil.to(caConnectorConfigView);
        this.cAConnectorConfigService.save(cfg);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cfg.getId().toString()))).body((Object)caConnectorConfigView);
    }

    @GetMapping(value={"/ca-connector-configViews"})
    public List<CaConnectorConfigView> getAllCaConnectorConfigs() {
        this.log.debug("REST request to get all CaConnectorConfigViews");
        ArrayList<CaConnectorConfigView> cvList = new ArrayList<CaConnectorConfigView>();
        for (CAConnectorConfig cfg : this.cAConnectorConfigService.findAll()) {
            cvList.add(this.caConnectorConfigUtil.from(cfg));
        }
        return cvList;
    }

    @GetMapping(value={"/ca-connector-configViews/{id}"})
    public ResponseEntity<CaConnectorConfigView> getCaConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to get CaConnectorConfigView : {}", (Object)id);
        Optional caConnectorConfigOpt = this.cAConnectorConfigService.findOne(id);
        Optional<Object> cvOpt = Optional.empty();
        if (caConnectorConfigOpt.isPresent()) {
            CAConnectorConfig cfg = (CAConnectorConfig)caConnectorConfigOpt.get();
            cvOpt = Optional.of(this.caConnectorConfigUtil.from(cfg));
        }
        return ResponseUtil.wrapOrNotFound(cvOpt);
    }

    @DeleteMapping(value={"/ca-connector-configViews/{id}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteCaConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to delete CaConnectorConfig : {}", (Object)id);
        try {
            this.cAConnectorConfigService.delete(id);
        }
        catch (RuntimeException dive) {
            this.log.debug("CaConnectorConfig deletion failed", (Throwable)dive);
            throw new IntegrityException("CaConnectorConfig already used");
        }
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/ca-connector-configViews/adcs/templates"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<ADCSInstanceDetailsView> getADCSTemplates(@Valid @RequestBody CaConnectorConfigView caConnectorConfigView) {
        this.log.debug("REST request to get getADCSTemplates");
        if (caConnectorConfigView.getCaUrl() == null || caConnectorConfigView.getCaUrl().isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        if (caConnectorConfigView.getAuthenticationParameter().getPlainSecret() == null || caConnectorConfigView.getAuthenticationParameter().getPlainSecret().isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        ADCSInstanceDetails adcsInstanceDetails = this.adcsConnector.getInstanceDetails(caConnectorConfigView.getCaUrl(), caConnectorConfigView.getAuthenticationParameter().getPlainSecret(), caConnectorConfigView.getAuthenticationParameter().getSalt(), (int)caConnectorConfigView.getAuthenticationParameter().getCycles(), caConnectorConfigView.getAuthenticationParameter().getApiKeySalt(), (int)caConnectorConfigView.getAuthenticationParameter().getApiKeyCycles());
        if (adcsInstanceDetails == null) {
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok((Object)new ADCSInstanceDetailsView(adcsInstanceDetails));
    }
}

