/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.service.dto.acme.DirectoryResponse;
import de.trustable.ca3s.core.service.dto.acme.MetaInformation;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/acme/{realm}/directory"})
public class DirectoryController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryController.class);
    private final PipelineUtil pipelineUtil;

    public DirectoryController(PipelineUtil pipelineUtil) {
        this.pipelineUtil = pipelineUtil;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DirectoryResponse getDirectory(@PathVariable String realm, @RequestHeader(value="X-CA3S-Forwarded-Host", required=false) String forwardedHost) {
        String eabMode;
        String webSiteLink;
        Pipeline pipeline = this.getPipelineForRealm(realm);
        DirectoryResponse resp = new DirectoryResponse();
        resp.setNewNonceUri(this.newNonceResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewAccountUri(this.newAccountResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewOrderUri(this.newOrderResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setNewAuthzUri(this.newAuthorizationResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setRevokeUri(this.revokeResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        resp.setKeyChangeUri(this.keyChangeResourceUriBuilderFrom(this.getEffectiveUriComponentsBuilder(realm, forwardedHost)).build().normalize().toUri());
        MetaInformation metaInformation = new MetaInformation();
        String caaListString = this.pipelineUtil.getPipelineAttribute(pipeline, "CAA_IDENTITIES", "");
        if (!caaListString.isEmpty()) {
            metaInformation.setCaaIdentities(caaListString.split(","));
        }
        if (!(webSiteLink = this.pipelineUtil.getPipelineAttribute(pipeline, "WEBSITE_LINK", "")).isEmpty()) {
            metaInformation.setWebsite(webSiteLink);
        }
        if (Boolean.TRUE.equals(this.pipelineUtil.getPipelineAttribute(pipeline, "TOS_AGREEMENT_REQUIRED", false))) {
            metaInformation.setTermsOfService(this.pipelineUtil.getPipelineAttribute(pipeline, "TOS_AGREEMENT_LINK", ""));
        }
        metaInformation.setExternalAccountRequired(!"EAB_MODE_NONE".equals(eabMode = this.pipelineUtil.getPipelineAttribute(pipeline, "EAB_MODE", "EAB_MODE_NONE")));
        resp.setMetaInformation(metaInformation);
        LOG.info("directory request, returning {}", (Object)resp);
        return resp;
    }
}

