/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.advice;

import de.trustable.ca3s.core.exception.UserNotAuthenticatedException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import javax.annotation.concurrent.Immutable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Immutable
public final class UserProblemsAdvice {
    @ExceptionHandler(value={UserNotAuthenticatedException.class})
    public ResponseEntity<ProblemDetail> respondTo(UserNotAuthenticatedException exception) {
        ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "User not authenticated!", HttpStatus.UNAUTHORIZED, exception.getMessage(), AcmeUtil.NO_INSTANCE);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<ProblemDetail> respondTo(BadCredentialsException exception) {
        ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Bad credentials", HttpStatus.FORBIDDEN, exception.getMessage(), AcmeUtil.NO_INSTANCE);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<ProblemDetail> respondTo(AuthenticationException exception) {
        ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Authentication problem", HttpStatus.FORBIDDEN, exception.getMessage(), AcmeUtil.NO_INSTANCE);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(AcmeController.APPLICATION_PROBLEM_JSON).body((Object)problem);
    }
}

