"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_admin_user-management_user-management-edit_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts&":
/*!************************************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts& ***!
  \************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuelidate/lib/validators */ "./node_modules/vuelidate/lib/validators/index.js");
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var _shared_model_user_model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/model/user.model */ "./src/main/webapp/app/shared/model/user.model.ts");
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ "./src/main/webapp/app/shared/alert/alert.mixin.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var loginValidator = function (value) {
    if (!value) {
        return true;
    }
    return /^[a-zA-Z0-9!$&*+=?^_`{|}~.-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*$|^[_.@A-Za-z0-9-]+$/.test(value);
};
var validations = {
    userAccount: {
        login: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.required,
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(254),
            pattern: loginValidator,
        },
        firstName: {
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(50),
        },
        lastName: {
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(50),
        },
        email: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.required,
            email: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.email,
            minLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.minLength)(5),
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(50),
        },
        phone: {
            minLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.minLength)(0),
            maxLength: (0,vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_3__.maxLength)(254),
        },
        tenantId: {},
    },
};
var JhiUserManagementEdit = /** @class */ (function (_super) {
    __extends(JhiUserManagementEdit, _super);
    function JhiUserManagementEdit() {
        var _this = _super.call(this) || this;
        _this.tenants = [];
        _this.isSaving = false;
        _this.authorities = [];
        _this.scndFactors = [];
        _this.languages = _this.$store.getters.languages;
        _this.userAccount = new _shared_model_user_model__WEBPACK_IMPORTED_MODULE_1__.User();
        _this.userAccount.authorities = [];
        return _this;
    }
    JhiUserManagementEdit.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            vm.initAuthorities();
            if (to.params.userId) {
                vm.init(to.params.userId);
            }
        });
    };
    JhiUserManagementEdit.prototype.mounted = function () {
        this.retrieveAllTenants();
        this.scndFactors = this.$store.state.uiConfigStore.config.scndFactorTypes;
    };
    JhiUserManagementEdit.prototype.initAuthorities = function () {
        var _this = this;
        this.userManagementService()
            .retrieveAuthorities()
            .then(function (_res) {
            _this.authorities = _res.data;
        });
    };
    JhiUserManagementEdit.prototype.retrieveAllTenants = function () {
        var _this = this;
        this.tenantService()
            .retrieve()
            .then(function (res) {
            _this.tenants = res.data;
        }, function (err) {
            _this.alertService().showAlert(err.response, 'warn');
        });
    };
    JhiUserManagementEdit.prototype.init = function (userId) {
        var _this = this;
        this.userManagementService()
            .get(userId)
            .then(function (res) {
            _this.userAccount = res.data;
        });
    };
    JhiUserManagementEdit.prototype.previousState = function () {
        this.$router.go(-1);
    };
    JhiUserManagementEdit.prototype.save = function () {
        this.isSaving = true;
        var self = this;
        if (this.userAccount.id) {
            this.userManagementService()
                .update(this.userAccount)
                .then(function (res) {
                self.returnToList();
                self.alertService().showAlert(self.$t('userManagement.updated', { param: self.userAccount.id }), 'info');
            })
                .catch(function (error) {
                console.log(error);
                var message = self.$t('problem processing request: ' + error);
                self.alertService().showAlert(message, 'info');
            });
        }
        else {
            this.userManagementService()
                .create(this.userAccount)
                .then(function (res) {
                self.returnToList();
                self.alertService().showAlert(self.$t('userManagement.created', { param: res.id }), 'info');
            })
                .catch(function (error) {
                console.log(error);
                var message = self.$t('problem processing request: ' + error);
                self.alertService().showAlert(message, 'info');
            });
        }
    };
    JhiUserManagementEdit.prototype.returnToList = function () {
        this.isSaving = false;
        this.$router.push('/admin/user-list');
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], JhiUserManagementEdit.prototype, "alertService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('userService'),
        __metadata("design:type", Function)
    ], JhiUserManagementEdit.prototype, "userManagementService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('tenantService'),
        __metadata("design:type", Function)
    ], JhiUserManagementEdit.prototype, "tenantService", void 0);
    JhiUserManagementEdit = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            validations: validations,
        }),
        __metadata("design:paramtypes", [])
    ], JhiUserManagementEdit);
    return JhiUserManagementEdit;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_4__.mixins)(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_2__["default"])));
/* harmony default export */ __webpack_exports__["default"] = (JhiUserManagementEdit);


/***/ }),

/***/ "./src/main/webapp/app/shared/alert/alert.mixin.ts":
/*!*********************************************************!*\
  !*** ./src/main/webapp/app/shared/alert/alert.mixin.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var AlertMixin = /** @class */ (function (_super) {
    __extends(AlertMixin, _super);
    function AlertMixin() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dismissCountDown = _this.$store.getters.dismissCountDown;
        _this.dismissSecs = _this.$store.getters.dismissSecs;
        _this.alertType = _this.$store.getters.alertType;
        _this.alertMessage = _this.$store.getters.alertMessage;
        return _this;
    }
    AlertMixin.prototype.getAlertFromStore = function () {
        this.dismissCountDown = this.$store.getters.dismissCountDown;
        this.dismissSecs = this.$store.getters.dismissSecs;
        this.alertType = this.$store.getters.alertType;
        this.alertMessage = this.$store.getters.alertMessage;
    };
    AlertMixin.prototype.countDownChanged = function (dismissCountDown) {
        this.alertService().countDownChanged(dismissCountDown);
        this.getAlertFromStore();
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], AlertMixin.prototype, "alertService", void 0);
    AlertMixin = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], AlertMixin);
    return AlertMixin;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (AlertMixin);


/***/ }),

/***/ "./src/main/webapp/app/shared/model/user.model.ts":
/*!********************************************************!*\
  !*** ./src/main/webapp/app/shared/model/user.model.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "User": function() { return /* binding */ User; }
/* harmony export */ });
var User = /** @class */ (function () {
    function User(id, login, firstName, lastName, email, phone, activated, langKey, authorities, createdBy, createdDate, lastModifiedBy, lastModifiedDate, password, tenantId, tenantName, failedLogins, blockedUntilDate, credentialsValidToDate, managedExternally, blocked) {
        this.id = id;
        this.login = login;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phone = phone;
        this.activated = activated;
        this.langKey = langKey;
        this.authorities = authorities;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.password = password;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.failedLogins = failedLogins;
        this.blockedUntilDate = blockedUntilDate;
        this.credentialsValidToDate = credentialsValidToDate;
        this.managedExternally = managedExternally;
        this.blocked = blocked;
    }
    return User;
}());



/***/ }),

/***/ "./src/main/webapp/app/admin/user-management/user-management-edit.vue":
/*!****************************************************************************!*\
  !*** ./src/main/webapp/app/admin/user-management/user-management-edit.vue ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./user-management-edit.vue?vue&type=template&id=4b1e1262& */ "./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262&");
/* harmony import */ var _user_management_edit_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./user-management-edit.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _user_management_edit_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__.render,
  _user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/admin/user-management/user-management-edit.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts&":
/*!**************************************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts& ***!
  \**************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_user_management_edit_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./user-management-edit.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/admin/user-management/user-management-edit.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_user_management_edit_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262&":
/*!***********************************************************************************************************!*\
  !*** ./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262& ***!
  \***********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_user_management_edit_vue_vue_type_template_id_4b1e1262___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./user-management-edit.vue?vue&type=template&id=4b1e1262& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262&":
/*!***************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/admin/user-management/user-management-edit.vue?vue&type=template&id=4b1e1262& ***!
  \***************************************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c(
    "div",
    { staticClass: "row justify-content-center" },
    [
      _c(
        "b-alert",
        {
          attrs: {
            show: _vm.dismissCountDown,
            dismissible: "",
            variant: _vm.alertType,
          },
          on: {
            dismissed: function ($event) {
              _vm.dismissCountDown = 0
            },
            "dismiss-count-down": _vm.countDownChanged,
          },
        },
        [_vm._v("\n        " + _vm._s(_vm.alertMessage) + "\n    ")]
      ),
      _vm._v(" "),
      _c("br"),
      _vm._v(" "),
      _c("div", { staticClass: "col-8" }, [
        _vm.userAccount
          ? _c(
              "form",
              {
                attrs: { name: "editForm", role: "form", novalidate: "" },
                on: {
                  submit: function ($event) {
                    $event.preventDefault()
                    return _vm.save()
                  },
                },
              },
              [
                _c(
                  "h2",
                  {
                    attrs: { id: "myUserLabel" },
                    domProps: {
                      textContent: _vm._s(
                        _vm.$t("userManagement.home.createOrEditLabel")
                      ),
                    },
                  },
                  [_vm._v("Create or edit a User")]
                ),
                _vm._v(" "),
                _c("div", [
                  _c(
                    "div",
                    {
                      staticClass: "form-group",
                      attrs: { hidden: !_vm.userAccount.id },
                    },
                    [
                      _c(
                        "label",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("global.field.id")),
                          },
                        },
                        [_vm._v("ID")]
                      ),
                      _vm._v(" "),
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.userAccount.id,
                            expression: "userAccount.id",
                          },
                        ],
                        staticClass: "form-control",
                        attrs: { type: "text", name: "id", readonly: "" },
                        domProps: { value: _vm.userAccount.id },
                        on: {
                          input: function ($event) {
                            if ($event.target.composing) return
                            _vm.$set(_vm.userAccount, "id", $event.target.value)
                          },
                        },
                      }),
                    ]
                  ),
                  _vm._v(" "),
                  !_vm.userAccount.managedExternally
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.login")
                              ),
                            },
                          },
                          [_vm._v("Login")]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.$v.userAccount.login.$model,
                              expression: "$v.userAccount.login.$model",
                            },
                          ],
                          staticClass: "form-control",
                          class: {
                            valid: !_vm.$v.userAccount.login.$invalid,
                            invalid: _vm.$v.userAccount.login.$invalid,
                          },
                          attrs: { type: "text", name: "login" },
                          domProps: { value: _vm.$v.userAccount.login.$model },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.$v.userAccount.login,
                                "$model",
                                $event.target.value
                              )
                            },
                          },
                        }),
                        _vm._v(" "),
                        _vm.$v.userAccount.login.$anyDirty &&
                        _vm.$v.userAccount.login.$invalid
                          ? _c("div", [
                              !_vm.$v.userAccount.login.required
                                ? _c(
                                    "small",
                                    {
                                      staticClass: "form-text text-danger",
                                      domProps: {
                                        textContent: _vm._s(
                                          _vm.$t("entity.validation.required")
                                        ),
                                      },
                                    },
                                    [
                                      _vm._v(
                                        "\n                            This field is required.\n                        "
                                      ),
                                    ]
                                  )
                                : _vm._e(),
                              _vm._v(" "),
                              !_vm.$v.userAccount.login.maxLength
                                ? _c(
                                    "small",
                                    {
                                      staticClass: "form-text text-danger",
                                      domProps: {
                                        textContent: _vm._s(
                                          _vm.$t(
                                            "entity.validation.maxlength",
                                            { max: 50 }
                                          )
                                        ),
                                      },
                                    },
                                    [
                                      _vm._v(
                                        "\n                            This field cannot be longer than 50 characters.\n                        "
                                      ),
                                    ]
                                  )
                                : _vm._e(),
                              _vm._v(" "),
                              !_vm.$v.userAccount.login.pattern
                                ? _c(
                                    "small",
                                    {
                                      staticClass: "form-text text-danger",
                                      domProps: {
                                        textContent: _vm._s(
                                          _vm.$t(
                                            "entity.validation.patternLogin"
                                          )
                                        ),
                                      },
                                    },
                                    [
                                      _vm._v(
                                        "\n                            This field can only contain letters, digits and e-mail addresses.\n                        "
                                      ),
                                    ]
                                  )
                                : _vm._e(),
                            ])
                          : _vm._e(),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  _vm.userAccount.managedExternally
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.managedExternally")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "Externally\n                        managed user"
                            ),
                          ]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.$v.userAccount.login.$model,
                              expression: "$v.userAccount.login.$model",
                            },
                          ],
                          staticClass: "form-control",
                          attrs: { type: "text", name: "login", disabled: "" },
                          domProps: { value: _vm.$v.userAccount.login.$model },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.$v.userAccount.login,
                                "$model",
                                $event.target.value
                              )
                            },
                          },
                        }),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-group" }, [
                    _c(
                      "label",
                      {
                        staticClass: "form-control-label",
                        attrs: { for: "firstName" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("userManagement.firstName")
                          ),
                        },
                      },
                      [_vm._v("First\n                        Name")]
                    ),
                    _vm._v(" "),
                    _c("input", {
                      directives: [
                        {
                          name: "model",
                          rawName: "v-model",
                          value: _vm.$v.userAccount.firstName.$model,
                          expression: "$v.userAccount.firstName.$model",
                        },
                      ],
                      staticClass: "form-control",
                      class: {
                        valid: !_vm.$v.userAccount.firstName.$invalid,
                        invalid: _vm.$v.userAccount.firstName.$invalid,
                      },
                      attrs: {
                        type: "text",
                        id: "firstName",
                        name: "firstName",
                        placeholder: _vm.$t(
                          "settings.form.firstname.placeholder"
                        ),
                        disabled: _vm.userAccount.managedExternally,
                      },
                      domProps: { value: _vm.$v.userAccount.firstName.$model },
                      on: {
                        input: function ($event) {
                          if ($event.target.composing) return
                          _vm.$set(
                            _vm.$v.userAccount.firstName,
                            "$model",
                            $event.target.value
                          )
                        },
                      },
                    }),
                    _vm._v(" "),
                    _vm.$v.userAccount.firstName.$anyDirty &&
                    _vm.$v.userAccount.firstName.$invalid
                      ? _c("div", [
                          !_vm.$v.userAccount.firstName.maxLength
                            ? _c(
                                "small",
                                {
                                  staticClass: "form-text text-danger",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t("entity.validation.maxlength", {
                                        max: 50,
                                      })
                                    ),
                                  },
                                },
                                [
                                  _vm._v(
                                    "\n                            This field cannot be longer than 50 characters.\n                        "
                                  ),
                                ]
                              )
                            : _vm._e(),
                        ])
                      : _vm._e(),
                  ]),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-group" }, [
                    _c(
                      "label",
                      {
                        staticClass: "form-control-label",
                        attrs: { for: "lastName" },
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("userManagement.lastName")
                          ),
                        },
                      },
                      [_vm._v("Last\n                        Name")]
                    ),
                    _vm._v(" "),
                    _c("input", {
                      directives: [
                        {
                          name: "model",
                          rawName: "v-model",
                          value: _vm.$v.userAccount.lastName.$model,
                          expression: "$v.userAccount.lastName.$model",
                        },
                      ],
                      staticClass: "form-control",
                      class: {
                        valid: !_vm.$v.userAccount.lastName.$invalid,
                        invalid: _vm.$v.userAccount.lastName.$invalid,
                      },
                      attrs: {
                        type: "text",
                        id: "lastName",
                        name: "lastName",
                        placeholder: _vm.$t(
                          "settings.form.lastname.placeholder"
                        ),
                        disabled: _vm.userAccount.managedExternally,
                      },
                      domProps: { value: _vm.$v.userAccount.lastName.$model },
                      on: {
                        input: function ($event) {
                          if ($event.target.composing) return
                          _vm.$set(
                            _vm.$v.userAccount.lastName,
                            "$model",
                            $event.target.value
                          )
                        },
                      },
                    }),
                    _vm._v(" "),
                    _vm.$v.userAccount.lastName.$anyDirty &&
                    _vm.$v.userAccount.lastName.$invalid
                      ? _c("div", [
                          !_vm.$v.userAccount.lastName.maxLength
                            ? _c(
                                "small",
                                {
                                  staticClass: "form-text text-danger",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t("entity.validation.maxlength", {
                                        max: 50,
                                      })
                                    ),
                                  },
                                },
                                [
                                  _vm._v(
                                    "\n                            This field cannot be longer than 50 characters.\n                        "
                                  ),
                                ]
                              )
                            : _vm._e(),
                        ])
                      : _vm._e(),
                  ]),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-group" }, [
                    _c(
                      "label",
                      {
                        staticClass: "form-control-label",
                        attrs: { for: "email" },
                        domProps: {
                          textContent: _vm._s(_vm.$t("userManagement.email")),
                        },
                      },
                      [_vm._v("Email")]
                    ),
                    _vm._v(" "),
                    _c("input", {
                      directives: [
                        {
                          name: "model",
                          rawName: "v-model",
                          value: _vm.$v.userAccount.email.$model,
                          expression: "$v.userAccount.email.$model",
                        },
                      ],
                      staticClass: "form-control",
                      class: {
                        valid: !_vm.$v.userAccount.email.$invalid,
                        invalid: _vm.$v.userAccount.email.$invalid,
                      },
                      attrs: {
                        type: "email",
                        id: "email",
                        name: "email",
                        placeholder: _vm.$t("global.form.email.placeholder."),
                        disabled: _vm.userAccount.managedExternally,
                        email: "",
                        required: "",
                      },
                      domProps: { value: _vm.$v.userAccount.email.$model },
                      on: {
                        input: function ($event) {
                          if ($event.target.composing) return
                          _vm.$set(
                            _vm.$v.userAccount.email,
                            "$model",
                            $event.target.value
                          )
                        },
                      },
                    }),
                    _vm._v(" "),
                    _vm.$v.userAccount.email.$anyDirty &&
                    _vm.$v.userAccount.email.$invalid
                      ? _c("div", [
                          !_vm.$v.userAccount.email.required
                            ? _c(
                                "small",
                                {
                                  staticClass: "form-text text-danger",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "global.messages.validate.email.required"
                                      )
                                    ),
                                  },
                                },
                                [
                                  _vm._v(
                                    "\n                            Your email is required.\n                        "
                                  ),
                                ]
                              )
                            : _vm._e(),
                          _vm._v(" "),
                          !_vm.$v.userAccount.email.email
                            ? _c(
                                "small",
                                {
                                  staticClass: "form-text text-danger",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "global.messages.validate.email.invalid"
                                      )
                                    ),
                                  },
                                },
                                [
                                  _vm._v(
                                    "\n                            Your email is invalid.\n                        "
                                  ),
                                ]
                              )
                            : _vm._e(),
                          _vm._v(" "),
                          !_vm.$v.userAccount.email.minLength
                            ? _c(
                                "small",
                                {
                                  staticClass: "form-text text-danger",
                                  domProps: {
                                    textContent: _vm._s(
                                      _vm.$t(
                                        "global.messages.validate.email.minlength"
                                      )
                                    ),
                                  },
                                },
                                [
                                  _vm._v(
                                    "\n                            Your email is required to be at least 5 characters.\n                        "
                                  ),
                                ]
                              )
                            : _vm._e(),
                          _vm._v(" "),
                          !_vm.$v.userAccount.email.maxLength
                            ? _c("small", {
                                staticClass: "form-text text-danger",
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t(
                                      "global.messages.validate.email.maxlength"
                                    )
                                  ),
                                },
                              })
                            : _vm._e(),
                        ])
                      : _vm._e(),
                  ]),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-group" }, [
                    _c("label", {
                      staticClass: "form-control-label",
                      attrs: { for: "phone" },
                      domProps: {
                        textContent: _vm._s(_vm.$t("userManagement.phone")),
                      },
                    }),
                    _vm._v(" "),
                    _c("input", {
                      directives: [
                        {
                          name: "model",
                          rawName: "v-model",
                          value: _vm.$v.userAccount.phone.$model,
                          expression: "$v.userAccount.phone.$model",
                        },
                      ],
                      staticClass: "form-control",
                      class: {
                        valid: !_vm.$v.userAccount.phone.$invalid,
                        invalid: _vm.$v.userAccount.phone.$invalid,
                      },
                      attrs: {
                        type: "text",
                        id: "phone",
                        name: "phone",
                        disabled: _vm.userAccount.managedExternally,
                      },
                      domProps: { value: _vm.$v.userAccount.phone.$model },
                      on: {
                        input: function ($event) {
                          if ($event.target.composing) return
                          _vm.$set(
                            _vm.$v.userAccount.phone,
                            "$model",
                            $event.target.value
                          )
                        },
                      },
                    }),
                    _vm._v(" "),
                    _vm.$v.userAccount.phone.$anyDirty &&
                    _vm.$v.userAccount.phone.$invalid
                      ? _c("div", [
                          !_vm.$v.userAccount.phone.maxLength
                            ? _c("small", {
                                staticClass: "form-text text-danger",
                                domProps: {
                                  textContent: _vm._s(
                                    _vm.$t(
                                      "global.messages.validate.phone.maxlength"
                                    )
                                  ),
                                },
                              })
                            : _vm._e(),
                        ])
                      : _vm._e(),
                  ]),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-check" }, [
                    _c(
                      "label",
                      {
                        staticClass: "form-check-label",
                        attrs: { for: "activated" },
                      },
                      [
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.userAccount.activated,
                              expression: "userAccount.activated",
                            },
                          ],
                          staticClass: "form-check-input",
                          attrs: {
                            disabled: _vm.userAccount.id === null,
                            type: "checkbox",
                            id: "activated",
                            name: "activated",
                          },
                          domProps: {
                            checked: Array.isArray(_vm.userAccount.activated)
                              ? _vm._i(_vm.userAccount.activated, null) > -1
                              : _vm.userAccount.activated,
                          },
                          on: {
                            change: function ($event) {
                              var $$a = _vm.userAccount.activated,
                                $$el = $event.target,
                                $$c = $$el.checked ? true : false
                              if (Array.isArray($$a)) {
                                var $$v = null,
                                  $$i = _vm._i($$a, $$v)
                                if ($$el.checked) {
                                  $$i < 0 &&
                                    _vm.$set(
                                      _vm.userAccount,
                                      "activated",
                                      $$a.concat([$$v])
                                    )
                                } else {
                                  $$i > -1 &&
                                    _vm.$set(
                                      _vm.userAccount,
                                      "activated",
                                      $$a
                                        .slice(0, $$i)
                                        .concat($$a.slice($$i + 1))
                                    )
                                }
                              } else {
                                _vm.$set(_vm.userAccount, "activated", $$c)
                              }
                            },
                          },
                        }),
                        _vm._v(" "),
                        _c(
                          "span",
                          {
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.activated")
                              ),
                            },
                          },
                          [_vm._v("Activated")]
                        ),
                      ]
                    ),
                  ]),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-check" }, [
                    _c(
                      "label",
                      {
                        staticClass: "form-check-label",
                        attrs: { for: "secondFactorRequired" },
                      },
                      [
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.userAccount.secondFactorRequired,
                              expression: "userAccount.secondFactorRequired",
                            },
                          ],
                          staticClass: "form-check-input",
                          attrs: {
                            disabled: _vm.userAccount.id === null,
                            type: "checkbox",
                            id: "activated",
                            name: "activated",
                          },
                          domProps: {
                            checked: Array.isArray(
                              _vm.userAccount.secondFactorRequired
                            )
                              ? _vm._i(
                                  _vm.userAccount.secondFactorRequired,
                                  null
                                ) > -1
                              : _vm.userAccount.secondFactorRequired,
                          },
                          on: {
                            change: function ($event) {
                              var $$a = _vm.userAccount.secondFactorRequired,
                                $$el = $event.target,
                                $$c = $$el.checked ? true : false
                              if (Array.isArray($$a)) {
                                var $$v = null,
                                  $$i = _vm._i($$a, $$v)
                                if ($$el.checked) {
                                  $$i < 0 &&
                                    _vm.$set(
                                      _vm.userAccount,
                                      "secondFactorRequired",
                                      $$a.concat([$$v])
                                    )
                                } else {
                                  $$i > -1 &&
                                    _vm.$set(
                                      _vm.userAccount,
                                      "secondFactorRequired",
                                      $$a
                                        .slice(0, $$i)
                                        .concat($$a.slice($$i + 1))
                                    )
                                }
                              } else {
                                _vm.$set(
                                  _vm.userAccount,
                                  "secondFactorRequired",
                                  $$c
                                )
                              }
                            },
                          },
                        }),
                        _vm._v(" "),
                        _c("span", {
                          domProps: {
                            textContent: _vm._s(
                              _vm.$t("userManagement.secondFactorRequired")
                            ),
                          },
                        }),
                      ]
                    ),
                  ]),
                  _vm._v(" "),
                  !_vm.userAccount.managedExternally
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            attrs: { for: "failedLogins" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.failedLogins")
                              ),
                            },
                          },
                          [_vm._v("failedLogins")]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.userAccount.failedLogins,
                              expression: "userAccount.failedLogins",
                            },
                          ],
                          staticClass: "form-control",
                          attrs: {
                            disabled: "",
                            type: "number",
                            id: "failedLogins",
                            name: "failedLogins",
                          },
                          domProps: { value: _vm.userAccount.failedLogins },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.userAccount,
                                "failedLogins",
                                $event.target.value
                              )
                            },
                          },
                        }),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  !_vm.userAccount.managedExternally &&
                  _vm.userAccount.blockedUntilDate
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            attrs: { for: "blockedUntilDate" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.blockedUntilDate")
                              ),
                            },
                          },
                          [_vm._v("blockedUntilDate")]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.userAccount.blockedUntilDate,
                              expression: "userAccount.blockedUntilDate",
                            },
                          ],
                          staticClass: "form-control",
                          attrs: {
                            disabled: "",
                            type: "datetime",
                            id: "blockedUntilDate",
                            name: "blockedUntilDate",
                          },
                          domProps: { value: _vm.userAccount.blockedUntilDate },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.userAccount,
                                "blockedUntilDate",
                                $event.target.value
                              )
                            },
                          },
                        }),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  !_vm.userAccount.managedExternally &&
                  _vm.userAccount.credentialsValidToDate
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            staticClass: "form-control-label",
                            attrs: { for: "blockedUntilDate" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.credentialsValidToDate")
                              ),
                            },
                          },
                          [_vm._v("credentialsValidToDate")]
                        ),
                        _vm._v(" "),
                        _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.userAccount.credentialsValidToDate,
                              expression: "userAccount.credentialsValidToDate",
                            },
                          ],
                          staticClass: "form-control",
                          attrs: {
                            disabled: "",
                            type: "datetime",
                            id: "blockedUntilDate",
                            name: "blockedUntilDate",
                          },
                          domProps: {
                            value: _vm.userAccount.credentialsValidToDate,
                          },
                          on: {
                            input: function ($event) {
                              if ($event.target.composing) return
                              _vm.$set(
                                _vm.userAccount,
                                "credentialsValidToDate",
                                $event.target.value
                              )
                            },
                          },
                        }),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  _vm.languages && Object.keys(_vm.languages).length > 0
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            attrs: { for: "langKey" },
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.langKey")
                              ),
                            },
                          },
                          [_vm._v("Language")]
                        ),
                        _vm._v(" "),
                        _c(
                          "select",
                          {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.userAccount.langKey,
                                expression: "userAccount.langKey",
                              },
                            ],
                            staticClass: "form-control",
                            attrs: { id: "langKey", name: "langKey" },
                            on: {
                              change: function ($event) {
                                var $$selectedVal = Array.prototype.filter
                                  .call($event.target.options, function (o) {
                                    return o.selected
                                  })
                                  .map(function (o) {
                                    var val = "_value" in o ? o._value : o.value
                                    return val
                                  })
                                _vm.$set(
                                  _vm.userAccount,
                                  "langKey",
                                  $event.target.multiple
                                    ? $$selectedVal
                                    : $$selectedVal[0]
                                )
                              },
                            },
                          },
                          _vm._l(_vm.languages, function (language, key) {
                            return _c(
                              "option",
                              { key: key, domProps: { value: key } },
                              [
                                _vm._v(
                                  _vm._s(language.name) +
                                    "\n                        "
                                ),
                              ]
                            )
                          }),
                          0
                        ),
                      ])
                    : _vm._e(),
                  _vm._v(" "),
                  _c("div", { staticClass: "form-group" }, [
                    _c(
                      "label",
                      {
                        domProps: {
                          textContent: _vm._s(
                            _vm.$t("userManagement.profiles")
                          ),
                        },
                      },
                      [_vm._v("Profiles")]
                    ),
                    _vm._v(" "),
                    _c(
                      "select",
                      {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.userAccount.authorities,
                            expression: "userAccount.authorities",
                          },
                        ],
                        staticClass: "form-control",
                        attrs: { multiple: "", name: "authority" },
                        on: {
                          change: function ($event) {
                            var $$selectedVal = Array.prototype.filter
                              .call($event.target.options, function (o) {
                                return o.selected
                              })
                              .map(function (o) {
                                var val = "_value" in o ? o._value : o.value
                                return val
                              })
                            _vm.$set(
                              _vm.userAccount,
                              "authorities",
                              $event.target.multiple
                                ? $$selectedVal
                                : $$selectedVal[0]
                            )
                          },
                        },
                      },
                      _vm._l(_vm.authorities, function (authority) {
                        return _c(
                          "option",
                          { key: authority, domProps: { value: authority } },
                          [
                            _vm._v(
                              _vm._s(authority) + "\n                        "
                            ),
                          ]
                        )
                      }),
                      0
                    ),
                  ]),
                  _vm._v(" "),
                  _vm.userAccount.authorities.includes("ROLE_USER")
                    ? _c("div", { staticClass: "form-group" }, [
                        _c(
                          "label",
                          {
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("userManagement.tenant")
                              ),
                            },
                          },
                          [_vm._v("Tenant")]
                        ),
                        _vm._v(" "),
                        _c(
                          "select",
                          {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.$v.userAccount.tenantId.$model,
                                expression: "$v.userAccount.tenantId.$model",
                              },
                            ],
                            staticClass: "form-control",
                            attrs: { name: "selectedTenants" },
                            on: {
                              change: function ($event) {
                                var $$selectedVal = Array.prototype.filter
                                  .call($event.target.options, function (o) {
                                    return o.selected
                                  })
                                  .map(function (o) {
                                    var val = "_value" in o ? o._value : o.value
                                    return val
                                  })
                                _vm.$set(
                                  _vm.$v.userAccount.tenantId,
                                  "$model",
                                  $event.target.multiple
                                    ? $$selectedVal
                                    : $$selectedVal[0]
                                )
                              },
                            },
                          },
                          [
                            _c("option", { key: "0", attrs: { value: "" } }),
                            _vm._v(" "),
                            _vm._l(_vm.tenants, function (tenant) {
                              return _c(
                                "option",
                                {
                                  key: tenant.id,
                                  domProps: { value: tenant.id },
                                },
                                [
                                  _vm._v(
                                    _vm._s(tenant.longname) +
                                      "\n                        "
                                  ),
                                ]
                              )
                            }),
                          ],
                          2
                        ),
                      ])
                    : _vm._e(),
                ]),
                _vm._v(" "),
                _c("div", [
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-secondary",
                      attrs: { type: "button" },
                      on: {
                        click: function ($event) {
                          return _vm.previousState()
                        },
                      },
                    },
                    [
                      _c("font-awesome-icon", { attrs: { icon: "ban" } }),
                      _vm._v(" "),
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("entity.action.cancel")),
                          },
                        },
                        [_vm._v("Cancel")]
                      ),
                    ],
                    1
                  ),
                  _vm._v(" "),
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-primary",
                      attrs: {
                        type: "submit",
                        disabled: _vm.$v.userAccount.$invalid || _vm.isSaving,
                      },
                    },
                    [
                      _c("font-awesome-icon", { attrs: { icon: "save" } }),
                      _vm._v(" "),
                      _c(
                        "span",
                        {
                          domProps: {
                            textContent: _vm._s(_vm.$t("entity.action.save")),
                          },
                        },
                        [_vm._v("Save")]
                      ),
                    ],
                    1
                  ),
                ]),
              ]
            )
          : _vm._e(),
      ]),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_admin_user-management_user-management-edit_vue.25624ed26f3548cd5617.chunk.js.map