"use strict";
(self["webpackChunkca_3_s"] = self["webpackChunkca_3_s"] || []).push([["src_main_webapp_app_entities_csr_csr-update_vue"],{

/***/ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts&":
/*!*****************************************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts& ***!
  \*****************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vue-class-component */ "./node_modules/vue-class-component/dist/vue-class-component.esm.js");
/* harmony import */ var _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/shared/data/data-utils.service */ "./src/main/webapp/app/shared/data/data-utils.service.ts");
/* harmony import */ var vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuelidate/lib/validators */ "./node_modules/vuelidate/lib/validators/index.js");
/* harmony import */ var date_fns_format__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns/format */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns_parse__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! date-fns/parse */ "./node_modules/date-fns/esm/parse/index.js");
/* harmony import */ var _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/shared/date/filters */ "./src/main/webapp/app/shared/date/filters.ts");
/* harmony import */ var _shared_model_csr_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/shared/model/csr.model */ "./src/main/webapp/app/shared/model/csr.model.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








var validations = {
    cSR: {
        csrBase64: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        subject: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        sans: {},
        requestedOn: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        requestedBy: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        pipelineType: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        status: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        administeredBy: {},
        approvedOn: {},
        rejectedOn: {},
        rejectionReason: {},
        processInstanceId: {},
        signingAlgorithm: {},
        isCSRValid: {},
        x509KeySpec: {},
        publicKeyAlgorithm: {},
        keyAlgorithm: {},
        keyLength: {},
        publicKeyHash: {},
        serversideKeyGeneration: {},
        subjectPublicKeyInfoBase64: {
            required: vuelidate_lib_validators__WEBPACK_IMPORTED_MODULE_4__.required,
        },
        requestorComment: {},
        administrationComment: {},
    },
};
var CSRUpdate = /** @class */ (function (_super) {
    __extends(CSRUpdate, _super);
    function CSRUpdate() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cSR = new _shared_model_csr_model__WEBPACK_IMPORTED_MODULE_3__.CSR();
        _this.rDNS = [];
        _this.requestAttributes = [];
        _this.csrAttributes = [];
        _this.pipelines = [];
        _this.certificates = [];
        _this.isSaving = false;
        return _this;
    }
    CSRUpdate.prototype.beforeRouteEnter = function (to, from, next) {
        next(function (vm) {
            if (to.params.cSRId) {
                vm.retrieveCSR(to.params.cSRId);
            }
            vm.initRelationships();
        });
    };
    CSRUpdate.prototype.save = function () {
        var _this = this;
        this.isSaving = true;
        if (this.cSR.id) {
            this.cSRService()
                .update(this.cSR)
                .then(function (param) {
                _this.isSaving = false;
                _this.$router.go(-1);
                var message = _this.$t('ca3SApp.cSR.updated', { param: param.id });
                _this.alertService().showAlert(message, 'info');
            });
        }
        else {
            this.cSRService()
                .create(this.cSR)
                .then(function (param) {
                _this.isSaving = false;
                _this.$router.go(-1);
                var message = _this.$t('ca3SApp.cSR.created', { param: param.id });
                _this.alertService().showAlert(message, 'success');
            });
        }
    };
    CSRUpdate.prototype.convertDateTimeFromServer = function (date) {
        if (date) {
            return (0,date_fns_format__WEBPACK_IMPORTED_MODULE_5__["default"])(date, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT);
        }
        return null;
    };
    CSRUpdate.prototype.updateInstantField = function (field, event) {
        if (event.target.value) {
            this.cSR[field] = (0,date_fns_parse__WEBPACK_IMPORTED_MODULE_6__["default"])(event.target.value, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT, new Date());
        }
        else {
            this.cSR[field] = null;
        }
    };
    CSRUpdate.prototype.updateZonedDateTimeField = function (field, event) {
        if (event.target.value) {
            this.cSR[field] = (0,date_fns_parse__WEBPACK_IMPORTED_MODULE_6__["default"])(event.target.value, _shared_date_filters__WEBPACK_IMPORTED_MODULE_2__.DATE_TIME_LONG_FORMAT, new Date());
        }
        else {
            this.cSR[field] = null;
        }
    };
    CSRUpdate.prototype.retrieveCSR = function (cSRId) {
        var _this = this;
        this.cSRService()
            .find(cSRId)
            .then(function (res) {
            res.requestedOn = new Date(res.requestedOn);
            res.approvedOn = new Date(res.approvedOn);
            res.rejectedOn = new Date(res.rejectedOn);
            _this.cSR = res;
        });
    };
    CSRUpdate.prototype.previousState = function () {
        this.$router.go(-1);
    };
    CSRUpdate.prototype.initRelationships = function () {
        var _this = this;
        this.rDNService()
            .retrieve()
            .then(function (res) {
            _this.rDNS = res.data;
        });
        this.requestAttributeService()
            .retrieve()
            .then(function (res) {
            _this.requestAttributes = res.data;
        });
        this.csrAttributeService()
            .retrieve()
            .then(function (res) {
            _this.csrAttributes = res.data;
        });
        this.pipelineService()
            .retrieve()
            .then(function (res) {
            _this.pipelines = res.data;
        });
        this.certificateService()
            .retrieve()
            .then(function (res) {
            _this.certificates = res.data;
        });
    };
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('alertService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "alertService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('cSRService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "cSRService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('rDNService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "rDNService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('requestAttributeService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "requestAttributeService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('csrAttributeService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "csrAttributeService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('pipelineService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "pipelineService", void 0);
    __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Inject)('certificateService'),
        __metadata("design:type", Function)
    ], CSRUpdate.prototype, "certificateService", void 0);
    CSRUpdate = __decorate([
        (0,vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component)({
            validations: validations,
        })
    ], CSRUpdate);
    return CSRUpdate;
}((0,vue_class_component__WEBPACK_IMPORTED_MODULE_7__.mixins)(_shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_1__["default"])));
/* harmony default export */ __webpack_exports__["default"] = (CSRUpdate);


/***/ }),

/***/ "./src/main/webapp/app/shared/data/data-utils.service.ts":
/*!***************************************************************!*\
  !*** ./src/main/webapp/app/shared/data/data-utils.service.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-property-decorator */ "./node_modules/vue-property-decorator/lib/index.js");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
Copyright 2013-2017 the original author or authors from the JHipster project.
This file is part of the JHipster project, see https://jhipster.github.io/
for more information.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * An utility service for data.
 */
var JhiDataUtils = /** @class */ (function (_super) {
    __extends(JhiDataUtils, _super);
    function JhiDataUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Method to abbreviate the text given
     */
    JhiDataUtils.prototype.abbreviate = function (text, append) {
        if (append === void 0) { append = '...'; }
        if (text.length < 30) {
            return text;
        }
        return text ? text.substring(0, 15) + append + text.slice(-10) : '';
    };
    /**
     * Method to find the byte size of the string provides
     */
    JhiDataUtils.prototype.byteSize = function (base64String) {
        return this.formatAsBytes(this.size(base64String));
    };
    /**
     * Method to open file
     */
    JhiDataUtils.prototype.openFile = function (contentType, data) {
        if (window.navigator && window.navigator.msSaveOrOpenBlob) {
            // To support IE and Edge
            var byteCharacters = atob(data);
            var byteNumbers = new Array(byteCharacters.length);
            for (var i = 0; i < byteCharacters.length; i++) {
                byteNumbers[i] = byteCharacters.charCodeAt(i);
            }
            var byteArray = new Uint8Array(byteNumbers);
            var blob = new Blob([byteArray], {
                type: contentType
            });
            window.navigator.msSaveOrOpenBlob(blob);
        }
        else {
            // Other browsers
            var fileURL = "data:".concat(contentType, ";base64,").concat(data);
            var win = window.open();
            win.document.write('<iframe src="' +
                fileURL +
                '" frameborder="0" style="border:0; top:0px; left:0px; bottom:0px; right:0px; width:100%; height:100%;" allowfullscreen></iframe>');
        }
    };
    /**
     * Method to convert the file to base64
     */
    JhiDataUtils.prototype.toBase64 = function (file, cb) {
        var fileReader = new FileReader();
        fileReader.readAsDataURL(file);
        fileReader.onload = function (e) {
            var base64Data = e.target.result.substr(e.target.result.indexOf('base64,') + 'base64,'.length);
            cb(base64Data);
        };
    };
    /**
     * Method to clear the input
     */
    JhiDataUtils.prototype.clearInputImage = function (entity, elementRef, field, fieldContentType, idInput) {
        if (entity && field && fieldContentType) {
            if (entity.hasOwnProperty(field)) {
                entity[field] = null;
            }
            if (entity.hasOwnProperty(fieldContentType)) {
                entity[fieldContentType] = null;
            }
            if (elementRef && idInput && elementRef.nativeElement.querySelector('#' + idInput)) {
                elementRef.nativeElement.querySelector('#' + idInput).value = null;
            }
        }
    };
    JhiDataUtils.prototype.endsWith = function (suffix, str) {
        return str.indexOf(suffix, str.length - suffix.length) !== -1;
    };
    JhiDataUtils.prototype.paddingSize = function (value) {
        if (this.endsWith('==', value)) {
            return 2;
        }
        if (this.endsWith('=', value)) {
            return 1;
        }
        return 0;
    };
    JhiDataUtils.prototype.size = function (value) {
        return (value.length / 4) * 3 - this.paddingSize(value);
    };
    JhiDataUtils.prototype.formatAsBytes = function (size) {
        return size.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ') + ' bytes';
    };
    JhiDataUtils.prototype.setFileData = function (event, entity, field, isImage) {
        if (event && event.target.files && event.target.files[0]) {
            var file_1 = event.target.files[0];
            if (isImage && !/^image\//.test(file_1.type)) {
                return;
            }
            this.toBase64(file_1, function (base64Data) {
                entity[field] = base64Data;
                entity["".concat(field, "ContentType")] = file_1.type;
            });
        }
    };
    /**
     * Method to download file
     */
    JhiDataUtils.prototype.downloadFile = function (contentType, data, fileName) {
        var byteCharacters = atob(data);
        var byteNumbers = new Array(byteCharacters.length);
        for (var i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        var byteArray = new Uint8Array(byteNumbers);
        var blob = new Blob([byteArray], {
            type: contentType
        });
        var tempLink = document.createElement('a');
        tempLink.href = window.URL.createObjectURL(blob);
        tempLink.download = fileName;
        tempLink.target = '_blank';
        tempLink.click();
    };
    JhiDataUtils = __decorate([
        vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Component
    ], JhiDataUtils);
    return JhiDataUtils;
}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_0__.Vue));
/* harmony default export */ __webpack_exports__["default"] = (JhiDataUtils);


/***/ }),

/***/ "./src/main/webapp/app/shared/model/csr.model.ts":
/*!*******************************************************!*\
  !*** ./src/main/webapp/app/shared/model/csr.model.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CSR": function() { return /* binding */ CSR; },
/* harmony export */   "CsrStatus": function() { return /* binding */ CsrStatus; },
/* harmony export */   "PipelineType": function() { return /* binding */ PipelineType; }
/* harmony export */ });
var PipelineType;
(function (PipelineType) {
    PipelineType["ACME"] = "ACME";
    PipelineType["SCEP"] = "SCEP";
    PipelineType["WEB"] = "WEB";
    PipelineType["INTERNAL"] = "INTERNAL";
})(PipelineType || (PipelineType = {}));
var CsrStatus;
(function (CsrStatus) {
    CsrStatus["PROCESSING"] = "PROCESSING";
    CsrStatus["ISSUED"] = "ISSUED";
    CsrStatus["REJECTED"] = "REJECTED";
    CsrStatus["PENDING"] = "PENDING";
})(CsrStatus || (CsrStatus = {}));
var CSR = /** @class */ (function () {
    function CSR(id, csrBase64, subject, sans, requestedOn, requestedBy, pipelineType, status, administeredBy, approvedOn, rejectedOn, rejectionReason, processInstanceId, signingAlgorithm, isCSRValid, x509KeySpec, publicKeyAlgorithm, keyAlgorithm, keyLength, publicKeyHash, serversideKeyGeneration, subjectPublicKeyInfoBase64, requestorComment, administrationComment, rdns, ras, csrAttributes, pipeline, certificate) {
        this.id = id;
        this.csrBase64 = csrBase64;
        this.subject = subject;
        this.sans = sans;
        this.requestedOn = requestedOn;
        this.requestedBy = requestedBy;
        this.pipelineType = pipelineType;
        this.status = status;
        this.administeredBy = administeredBy;
        this.approvedOn = approvedOn;
        this.rejectedOn = rejectedOn;
        this.rejectionReason = rejectionReason;
        this.processInstanceId = processInstanceId;
        this.signingAlgorithm = signingAlgorithm;
        this.isCSRValid = isCSRValid;
        this.x509KeySpec = x509KeySpec;
        this.publicKeyAlgorithm = publicKeyAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.keyLength = keyLength;
        this.publicKeyHash = publicKeyHash;
        this.serversideKeyGeneration = serversideKeyGeneration;
        this.subjectPublicKeyInfoBase64 = subjectPublicKeyInfoBase64;
        this.requestorComment = requestorComment;
        this.administrationComment = administrationComment;
        this.rdns = rdns;
        this.ras = ras;
        this.csrAttributes = csrAttributes;
        this.pipeline = pipeline;
        this.certificate = certificate;
        this.isCSRValid = this.isCSRValid || false;
        this.serversideKeyGeneration = this.serversideKeyGeneration || false;
    }
    return CSR;
}());



/***/ }),

/***/ "./src/main/webapp/app/entities/csr/csr-update.vue":
/*!*********************************************************!*\
  !*** ./src/main/webapp/app/entities/csr/csr-update.vue ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./csr-update.vue?vue&type=template&id=06bb884c& */ "./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c&");
/* harmony import */ var _csr_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./csr-update.component.ts?vue&type=script&lang=ts& */ "./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */
;
var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _csr_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__.render,
  _csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/main/webapp/app/entities/csr/csr-update.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts&":
/*!*******************************************************************************************!*\
  !*** ./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts& ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_csr_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./csr-update.component.ts?vue&type=script&lang=ts& */ "./node_modules/ts-loader/index.js??clonedRuleSet-1.use[0]!./src/main/webapp/app/entities/csr/csr-update.component.ts?vue&type=script&lang=ts&");
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_ts_loader_index_js_clonedRuleSet_1_use_0_csr_update_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c&":
/*!****************************************************************************************!*\
  !*** ./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c& ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__.render; },
/* harmony export */   "staticRenderFns": function() { return /* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns; }
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_lib_index_js_vue_loader_options_csr_update_vue_vue_type_template_id_06bb884c___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./csr-update.vue?vue&type=template&id=06bb884c& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c&":
/*!********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/main/webapp/app/entities/csr/csr-update.vue?vue&type=template&id=06bb884c& ***!
  \********************************************************************************************************************************************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": function() { return /* binding */ render; },
/* harmony export */   "staticRenderFns": function() { return /* binding */ staticRenderFns; }
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c,
    _setup = _vm._self._setupProxy
  return _c("div", { staticClass: "row justify-content-center" }, [
    _c("div", { staticClass: "col-8" }, [
      _c(
        "form",
        {
          attrs: { name: "editForm", role: "form", novalidate: "" },
          on: {
            submit: function ($event) {
              $event.preventDefault()
              return _vm.save()
            },
          },
        },
        [
          _c(
            "h2",
            {
              attrs: { id: "ca3SApp.cSR.home.createOrEditLabel" },
              domProps: {
                textContent: _vm._s(
                  _vm.$t("ca3SApp.cSR.home.createOrEditLabel")
                ),
              },
            },
            [_vm._v("Create or edit a CSR")]
          ),
          _vm._v(" "),
          _c("div", [
            _vm.cSR.id
              ? _c("div", { staticClass: "form-group" }, [
                  _c(
                    "label",
                    {
                      attrs: { for: "id" },
                      domProps: {
                        textContent: _vm._s(_vm.$t("global.field.id")),
                      },
                    },
                    [_vm._v("ID")]
                  ),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.cSR.id,
                        expression: "cSR.id",
                      },
                    ],
                    staticClass: "form-control",
                    attrs: { type: "text", id: "id", name: "id", readonly: "" },
                    domProps: { value: _vm.cSR.id },
                    on: {
                      input: function ($event) {
                        if ($event.target.composing) return
                        _vm.$set(_vm.cSR, "id", $event.target.value)
                      },
                    },
                  }),
                ])
              : _vm._e(),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-csrBase64" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.csrBase64")),
                  },
                },
                [_vm._v("Csr Base 64")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.csrBase64.$model,
                    expression: "$v.cSR.csrBase64.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.csrBase64.$invalid,
                  invalid: _vm.$v.cSR.csrBase64.$invalid,
                },
                attrs: { name: "csrBase64", id: "csr-csrBase64", required: "" },
                domProps: { value: _vm.$v.cSR.csrBase64.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.csrBase64,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.cSR.csrBase64.$anyDirty && _vm.$v.cSR.csrBase64.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.csrBase64.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-subject" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.subject")),
                  },
                },
                [_vm._v("Subject")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.subject.$model,
                    expression: "$v.cSR.subject.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.subject.$invalid,
                  invalid: _vm.$v.cSR.subject.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "subject",
                  id: "csr-subject",
                  required: "",
                },
                domProps: { value: _vm.$v.cSR.subject.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(_vm.$v.cSR.subject, "$model", $event.target.value)
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.cSR.subject.$anyDirty && _vm.$v.cSR.subject.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.subject.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-sans" },
                  domProps: { textContent: _vm._s(_vm.$t("ca3SApp.cSR.sans")) },
                },
                [_vm._v("Sans")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.sans.$model,
                    expression: "$v.cSR.sans.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.sans.$invalid,
                  invalid: _vm.$v.cSR.sans.$invalid,
                },
                attrs: { type: "text", name: "sans", id: "csr-sans" },
                domProps: { value: _vm.$v.cSR.sans.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(_vm.$v.cSR.sans, "$model", $event.target.value)
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-requestedOn" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.requestedOn")),
                  },
                },
                [_vm._v("Requested On")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.cSR.requestedOn.$invalid,
                    invalid: _vm.$v.cSR.requestedOn.$invalid,
                  },
                  attrs: {
                    id: "csr-requestedOn",
                    type: "datetime-local",
                    name: "requestedOn",
                    required: "",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.cSR.requestedOn.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("requestedOn", $event)
                    },
                  },
                }),
              ]),
              _vm._v(" "),
              _vm.$v.cSR.requestedOn.$anyDirty &&
              _vm.$v.cSR.requestedOn.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.requestedOn.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                    _vm._v(" "),
                    !_vm.$v.cSR.requestedOn.ZonedDateTimelocal
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.ZonedDateTimelocal")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field should be a date and time.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-requestedBy" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.requestedBy")),
                  },
                },
                [_vm._v("Requested By")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.requestedBy.$model,
                    expression: "$v.cSR.requestedBy.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.requestedBy.$invalid,
                  invalid: _vm.$v.cSR.requestedBy.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "requestedBy",
                  id: "csr-requestedBy",
                  required: "",
                },
                domProps: { value: _vm.$v.cSR.requestedBy.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.requestedBy,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.cSR.requestedBy.$anyDirty &&
              _vm.$v.cSR.requestedBy.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.requestedBy.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-pipelineType" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.pipelineType")),
                  },
                },
                [_vm._v("Pipeline Type")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.$v.cSR.pipelineType.$model,
                      expression: "$v.cSR.pipelineType.$model",
                    },
                  ],
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.cSR.pipelineType.$invalid,
                    invalid: _vm.$v.cSR.pipelineType.$invalid,
                  },
                  attrs: {
                    name: "pipelineType",
                    id: "csr-pipelineType",
                    required: "",
                  },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.$v.cSR.pipelineType,
                        "$model",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "ACME",
                        label: _vm.$t("ca3SApp.PipelineType.ACME"),
                      },
                    },
                    [_vm._v("ACME")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "SCEP",
                        label: _vm.$t("ca3SApp.PipelineType.SCEP"),
                      },
                    },
                    [_vm._v("SCEP")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "WEB",
                        label: _vm.$t("ca3SApp.PipelineType.WEB"),
                      },
                    },
                    [_vm._v("WEB")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "INTERNAL",
                        label: _vm.$t("ca3SApp.PipelineType.INTERNAL"),
                      },
                    },
                    [_vm._v("INTERNAL")]
                  ),
                ]
              ),
              _vm._v(" "),
              _vm.$v.cSR.pipelineType.$anyDirty &&
              _vm.$v.cSR.pipelineType.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.pipelineType.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-status" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.status")),
                  },
                },
                [_vm._v("Status")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.$v.cSR.status.$model,
                      expression: "$v.cSR.status.$model",
                    },
                  ],
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.cSR.status.$invalid,
                    invalid: _vm.$v.cSR.status.$invalid,
                  },
                  attrs: { name: "status", id: "csr-status", required: "" },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.$v.cSR.status,
                        "$model",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "PROCESSING",
                        label: _vm.$t("ca3SApp.CsrStatus.PROCESSING"),
                      },
                    },
                    [_vm._v("PROCESSING")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "ISSUED",
                        label: _vm.$t("ca3SApp.CsrStatus.ISSUED"),
                      },
                    },
                    [_vm._v("ISSUED")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "REJECTED",
                        label: _vm.$t("ca3SApp.CsrStatus.REJECTED"),
                      },
                    },
                    [_vm._v("REJECTED")]
                  ),
                  _vm._v(" "),
                  _c(
                    "option",
                    {
                      attrs: {
                        value: "PENDING",
                        label: _vm.$t("ca3SApp.CsrStatus.PENDING"),
                      },
                    },
                    [_vm._v("PENDING")]
                  ),
                ]
              ),
              _vm._v(" "),
              _vm.$v.cSR.status.$anyDirty && _vm.$v.cSR.status.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.status.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-administeredBy" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.administeredBy")),
                  },
                },
                [_vm._v("Administered By")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.administeredBy.$model,
                    expression: "$v.cSR.administeredBy.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.administeredBy.$invalid,
                  invalid: _vm.$v.cSR.administeredBy.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "administeredBy",
                  id: "csr-administeredBy",
                },
                domProps: { value: _vm.$v.cSR.administeredBy.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.administeredBy,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-approvedOn" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.approvedOn")),
                  },
                },
                [_vm._v("Approved On")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.cSR.approvedOn.$invalid,
                    invalid: _vm.$v.cSR.approvedOn.$invalid,
                  },
                  attrs: {
                    id: "csr-approvedOn",
                    type: "datetime-local",
                    name: "approvedOn",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.cSR.approvedOn.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("approvedOn", $event)
                    },
                  },
                }),
              ]),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-rejectedOn" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.rejectedOn")),
                  },
                },
                [_vm._v("Rejected On")]
              ),
              _vm._v(" "),
              _c("div", { staticClass: "d-flex" }, [
                _c("input", {
                  staticClass: "form-control",
                  class: {
                    valid: !_vm.$v.cSR.rejectedOn.$invalid,
                    invalid: _vm.$v.cSR.rejectedOn.$invalid,
                  },
                  attrs: {
                    id: "csr-rejectedOn",
                    type: "datetime-local",
                    name: "rejectedOn",
                  },
                  domProps: {
                    value: _vm.convertDateTimeFromServer(
                      _vm.$v.cSR.rejectedOn.$model
                    ),
                  },
                  on: {
                    change: function ($event) {
                      return _vm.updateInstantField("rejectedOn", $event)
                    },
                  },
                }),
              ]),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-rejectionReason" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.rejectionReason")),
                  },
                },
                [_vm._v("Rejection Reason")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.rejectionReason.$model,
                    expression: "$v.cSR.rejectionReason.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.rejectionReason.$invalid,
                  invalid: _vm.$v.cSR.rejectionReason.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "rejectionReason",
                  id: "csr-rejectionReason",
                },
                domProps: { value: _vm.$v.cSR.rejectionReason.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.rejectionReason,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-processInstanceId" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.cSR.processInstanceId")
                    ),
                  },
                },
                [_vm._v("Process Instance Id")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.processInstanceId.$model,
                    expression: "$v.cSR.processInstanceId.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.processInstanceId.$invalid,
                  invalid: _vm.$v.cSR.processInstanceId.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "processInstanceId",
                  id: "csr-processInstanceId",
                },
                domProps: { value: _vm.$v.cSR.processInstanceId.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.processInstanceId,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-signingAlgorithm" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.signingAlgorithm")),
                  },
                },
                [_vm._v("Signing Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.signingAlgorithm.$model,
                    expression: "$v.cSR.signingAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.signingAlgorithm.$invalid,
                  invalid: _vm.$v.cSR.signingAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "signingAlgorithm",
                  id: "csr-signingAlgorithm",
                },
                domProps: { value: _vm.$v.cSR.signingAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.signingAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-isCSRValid" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.isCSRValid")),
                  },
                },
                [_vm._v("Is CSR Valid")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.isCSRValid.$model,
                    expression: "$v.cSR.isCSRValid.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.cSR.isCSRValid.$invalid,
                  invalid: _vm.$v.cSR.isCSRValid.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "isCSRValid",
                  id: "csr-isCSRValid",
                },
                domProps: {
                  checked: Array.isArray(_vm.$v.cSR.isCSRValid.$model)
                    ? _vm._i(_vm.$v.cSR.isCSRValid.$model, null) > -1
                    : _vm.$v.cSR.isCSRValid.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.cSR.isCSRValid.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.cSR.isCSRValid,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.cSR.isCSRValid,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(_vm.$v.cSR.isCSRValid, "$model", $$c)
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-x509KeySpec" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.x509KeySpec")),
                  },
                },
                [_vm._v("X 509 Key Spec")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.x509KeySpec.$model,
                    expression: "$v.cSR.x509KeySpec.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.x509KeySpec.$invalid,
                  invalid: _vm.$v.cSR.x509KeySpec.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "x509KeySpec",
                  id: "csr-x509KeySpec",
                },
                domProps: { value: _vm.$v.cSR.x509KeySpec.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.x509KeySpec,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-publicKeyAlgorithm" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.cSR.publicKeyAlgorithm")
                    ),
                  },
                },
                [_vm._v("Public Key Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.publicKeyAlgorithm.$model,
                    expression: "$v.cSR.publicKeyAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.publicKeyAlgorithm.$invalid,
                  invalid: _vm.$v.cSR.publicKeyAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "publicKeyAlgorithm",
                  id: "csr-publicKeyAlgorithm",
                },
                domProps: { value: _vm.$v.cSR.publicKeyAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.publicKeyAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-keyAlgorithm" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.keyAlgorithm")),
                  },
                },
                [_vm._v("Key Algorithm")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.keyAlgorithm.$model,
                    expression: "$v.cSR.keyAlgorithm.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.keyAlgorithm.$invalid,
                  invalid: _vm.$v.cSR.keyAlgorithm.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "keyAlgorithm",
                  id: "csr-keyAlgorithm",
                },
                domProps: { value: _vm.$v.cSR.keyAlgorithm.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.keyAlgorithm,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-keyLength" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.keyLength")),
                  },
                },
                [_vm._v("Key Length")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model.number",
                    value: _vm.$v.cSR.keyLength.$model,
                    expression: "$v.cSR.keyLength.$model",
                    modifiers: { number: true },
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.keyLength.$invalid,
                  invalid: _vm.$v.cSR.keyLength.$invalid,
                },
                attrs: {
                  type: "number",
                  name: "keyLength",
                  id: "csr-keyLength",
                },
                domProps: { value: _vm.$v.cSR.keyLength.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.keyLength,
                      "$model",
                      _vm._n($event.target.value)
                    )
                  },
                  blur: function ($event) {
                    return _vm.$forceUpdate()
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-publicKeyHash" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.publicKeyHash")),
                  },
                },
                [_vm._v("Public Key Hash")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.publicKeyHash.$model,
                    expression: "$v.cSR.publicKeyHash.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.publicKeyHash.$invalid,
                  invalid: _vm.$v.cSR.publicKeyHash.$invalid,
                },
                attrs: {
                  type: "text",
                  name: "publicKeyHash",
                  id: "csr-publicKeyHash",
                },
                domProps: { value: _vm.$v.cSR.publicKeyHash.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.publicKeyHash,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-serversideKeyGeneration" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.cSR.serversideKeyGeneration")
                    ),
                  },
                },
                [_vm._v("Serverside Key Generation")]
              ),
              _vm._v(" "),
              _c("input", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.serversideKeyGeneration.$model,
                    expression: "$v.cSR.serversideKeyGeneration.$model",
                  },
                ],
                staticClass: "form-check",
                class: {
                  valid: !_vm.$v.cSR.serversideKeyGeneration.$invalid,
                  invalid: _vm.$v.cSR.serversideKeyGeneration.$invalid,
                },
                attrs: {
                  type: "checkbox",
                  name: "serversideKeyGeneration",
                  id: "csr-serversideKeyGeneration",
                },
                domProps: {
                  checked: Array.isArray(
                    _vm.$v.cSR.serversideKeyGeneration.$model
                  )
                    ? _vm._i(_vm.$v.cSR.serversideKeyGeneration.$model, null) >
                      -1
                    : _vm.$v.cSR.serversideKeyGeneration.$model,
                },
                on: {
                  change: function ($event) {
                    var $$a = _vm.$v.cSR.serversideKeyGeneration.$model,
                      $$el = $event.target,
                      $$c = $$el.checked ? true : false
                    if (Array.isArray($$a)) {
                      var $$v = null,
                        $$i = _vm._i($$a, $$v)
                      if ($$el.checked) {
                        $$i < 0 &&
                          _vm.$set(
                            _vm.$v.cSR.serversideKeyGeneration,
                            "$model",
                            $$a.concat([$$v])
                          )
                      } else {
                        $$i > -1 &&
                          _vm.$set(
                            _vm.$v.cSR.serversideKeyGeneration,
                            "$model",
                            $$a.slice(0, $$i).concat($$a.slice($$i + 1))
                          )
                      }
                    } else {
                      _vm.$set(
                        _vm.$v.cSR.serversideKeyGeneration,
                        "$model",
                        $$c
                      )
                    }
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-subjectPublicKeyInfoBase64" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.cSR.subjectPublicKeyInfoBase64")
                    ),
                  },
                },
                [_vm._v("Subject Public Key Info Base 64")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.subjectPublicKeyInfoBase64.$model,
                    expression: "$v.cSR.subjectPublicKeyInfoBase64.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.subjectPublicKeyInfoBase64.$invalid,
                  invalid: _vm.$v.cSR.subjectPublicKeyInfoBase64.$invalid,
                },
                attrs: {
                  name: "subjectPublicKeyInfoBase64",
                  id: "csr-subjectPublicKeyInfoBase64",
                  required: "",
                },
                domProps: {
                  value: _vm.$v.cSR.subjectPublicKeyInfoBase64.$model,
                },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.subjectPublicKeyInfoBase64,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
              _vm._v(" "),
              _vm.$v.cSR.subjectPublicKeyInfoBase64.$anyDirty &&
              _vm.$v.cSR.subjectPublicKeyInfoBase64.$invalid
                ? _c("div", [
                    !_vm.$v.cSR.subjectPublicKeyInfoBase64.required
                      ? _c(
                          "small",
                          {
                            staticClass: "form-text text-danger",
                            domProps: {
                              textContent: _vm._s(
                                _vm.$t("entity.validation.required")
                              ),
                            },
                          },
                          [
                            _vm._v(
                              "\n                            This field is required.\n                        "
                            ),
                          ]
                        )
                      : _vm._e(),
                  ])
                : _vm._e(),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-requestorComment" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.requestorComment")),
                  },
                },
                [_vm._v("Requestor Comment")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.requestorComment.$model,
                    expression: "$v.cSR.requestorComment.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.requestorComment.$invalid,
                  invalid: _vm.$v.cSR.requestorComment.$invalid,
                },
                attrs: { name: "requestorComment", id: "csr-requestorComment" },
                domProps: { value: _vm.$v.cSR.requestorComment.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.requestorComment,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-administrationComment" },
                  domProps: {
                    textContent: _vm._s(
                      _vm.$t("ca3SApp.cSR.administrationComment")
                    ),
                  },
                },
                [_vm._v("Administration Comment")]
              ),
              _vm._v(" "),
              _c("textarea", {
                directives: [
                  {
                    name: "model",
                    rawName: "v-model",
                    value: _vm.$v.cSR.administrationComment.$model,
                    expression: "$v.cSR.administrationComment.$model",
                  },
                ],
                staticClass: "form-control",
                class: {
                  valid: !_vm.$v.cSR.administrationComment.$invalid,
                  invalid: _vm.$v.cSR.administrationComment.$invalid,
                },
                attrs: {
                  name: "administrationComment",
                  id: "csr-administrationComment",
                },
                domProps: { value: _vm.$v.cSR.administrationComment.$model },
                on: {
                  input: function ($event) {
                    if ($event.target.composing) return
                    _vm.$set(
                      _vm.$v.cSR.administrationComment,
                      "$model",
                      $event.target.value
                    )
                  },
                },
              }),
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "form-group" }, [
              _c(
                "label",
                {
                  staticClass: "form-control-label",
                  attrs: { for: "csr-pipeline" },
                  domProps: {
                    textContent: _vm._s(_vm.$t("ca3SApp.cSR.pipeline")),
                  },
                },
                [_vm._v("Pipeline")]
              ),
              _vm._v(" "),
              _c(
                "select",
                {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.cSR.pipeline,
                      expression: "cSR.pipeline",
                    },
                  ],
                  staticClass: "form-control",
                  attrs: { id: "csr-pipeline", name: "pipeline" },
                  on: {
                    change: function ($event) {
                      var $$selectedVal = Array.prototype.filter
                        .call($event.target.options, function (o) {
                          return o.selected
                        })
                        .map(function (o) {
                          var val = "_value" in o ? o._value : o.value
                          return val
                        })
                      _vm.$set(
                        _vm.cSR,
                        "pipeline",
                        $event.target.multiple
                          ? $$selectedVal
                          : $$selectedVal[0]
                      )
                    },
                  },
                },
                [
                  _c("option", { domProps: { value: null } }),
                  _vm._v(" "),
                  _vm._l(_vm.pipelines, function (pipelineOption) {
                    return _c(
                      "option",
                      {
                        key: pipelineOption.id,
                        domProps: {
                          value:
                            _vm.cSR.pipeline &&
                            pipelineOption.id === _vm.cSR.pipeline.id
                              ? _vm.cSR.pipeline
                              : pipelineOption,
                        },
                      },
                      [_vm._v(_vm._s(pipelineOption.id))]
                    )
                  }),
                ],
                2
              ),
            ]),
          ]),
          _vm._v(" "),
          _c("div", [
            _c(
              "button",
              {
                staticClass: "btn btn-secondary",
                attrs: { type: "button", id: "cancel-save" },
                on: {
                  click: function ($event) {
                    return _vm.previousState()
                  },
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "ban" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.cancel")),
                    },
                  },
                  [_vm._v("Cancel")]
                ),
              ],
              1
            ),
            _vm._v(" "),
            _c(
              "button",
              {
                staticClass: "btn btn-primary",
                attrs: {
                  type: "submit",
                  id: "save-entity",
                  disabled: _vm.$v.cSR.$invalid || _vm.isSaving,
                },
              },
              [
                _c("font-awesome-icon", { attrs: { icon: "save" } }),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    domProps: {
                      textContent: _vm._s(_vm.$t("entity.action.save")),
                    },
                  },
                  [_vm._v("Save")]
                ),
              ],
              1
            ),
          ]),
        ]
      ),
    ]),
  ])
}
var staticRenderFns = []
render._withStripped = true



/***/ })

}]);
//# sourceMappingURL=src_main_webapp_app_entities_csr_csr-update_vue.a16370f313231d343ff3.chunk.js.map