/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import de.tschuehly.htmx.spring.supabase.auth.config.DefaultExceptionHandlerConfig;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.controller.SupabaseUserController;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseSecurityConfig;
import de.tschuehly.htmx.spring.supabase.auth.service.ISupabaseUserService;
import de.tschuehly.htmx.spring.supabase.auth.service.SupabaseUserServiceGoTrueImpl;
import io.github.jan.supabase.SupabaseClient;
import io.github.jan.supabase.SupabaseClientBuilder;
import io.github.jan.supabase.gotrue.GoTrue;
import io.github.jan.supabase.gotrue.GoTrueConfig;
import io.github.jan.supabase.plugins.MainConfig;
import io.github.jan.supabase.plugins.MainPlugin;
import io.github.jan.supabase.plugins.PluginManager;
import io.github.jan.supabase.plugins.SupabasePlugin;
import io.github.jan.supabase.plugins.SupabasePluginProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnProperty(prefix="supabase", name={"projectId"})
@EnableConfigurationProperties(value={SupabaseProperties.class})
@Import(value={SupabaseSecurityConfig.class, DefaultExceptionHandlerConfig.class})
@PropertySource(value={"classpath:application-supabase.properties"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseProperties", "()Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "supabaseClient", "Lio/github/jan/supabase/gotrue/GoTrue;", "supabaseController", "Lde/tschuehly/htmx/spring/supabase/auth/controller/SupabaseUserController;", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/ISupabaseUserService;", "supabaseJwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "supabaseService", "goTrueClient", "supabaseAuthenticationProvider", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "htmx-spring-supabase-auth"})
@SourceDebugExtension(value={"SMAP\nSupabaseAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n+ 2 MainPlugin.kt\nio/github/jan/supabase/plugins/MainPluginKt\n+ 3 SupabaseClientBuilder.kt\nio/github/jan/supabase/SupabaseClientBuilderKt\n+ 4 PluginManager.kt\nio/github/jan/supabase/plugins/PluginManager\n*L\n1#1,69:1\n86#2,2:70\n88#2,6:73\n112#3:72\n22#4:79\n15#4:80\n*S KotlinDebug\n*F\n+ 1 SupabaseAutoConfiguration.kt\nde/tschuehly/htmx/spring/supabase/auth/SupabaseAutoConfiguration\n*L\n56#1:70,2\n56#1:73,6\n56#1:72\n56#1:79\n56#1:80\n*E\n"})
public class SupabaseAutoConfiguration {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseAutoConfiguration(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ISupabaseUserService supabaseService(@NotNull GoTrue goTrueClient, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider) {
        Intrinsics.checkNotNullParameter((Object)goTrueClient, (String)"goTrueClient");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        this.getLogger().debug("Registering the SupabaseUserService");
        return new SupabaseUserServiceGoTrueImpl(this.getSupabaseProperties(), goTrueClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SupabaseUserController supabaseController(@NotNull ISupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.getLogger().debug("Registering the SupabaseUserController");
        return new SupabaseUserController(supabaseUserService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GoTrue supabaseClient(@NotNull SupabaseProperties supabaseProperties) {
        void url$iv;
        void provider$iv;
        void supabaseUrl$iv$iv;
        SupabaseClientBuilder supabaseClientBuilder;
        void apiKey$iv;
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        SupabasePluginProvider supabasePluginProvider = (SupabasePluginProvider)GoTrue.Companion;
        String string = "https://" + supabaseProperties.getProjectId() + ".supabase.co/auth/v1";
        String string2 = supabaseProperties.getAnonKey();
        boolean $i$f$standaloneSupabaseModule = false;
        String string3 = "";
        String string4 = apiKey$iv;
        if (string4 == null) {
            string4 = "";
        }
        void supabaseKey$iv$iv = string4;
        boolean $i$f$createSupabaseClient = false;
        SupabaseClientBuilder $this$standaloneSupabaseModule_u24lambda_u240$iv = supabaseClientBuilder = new SupabaseClientBuilder((String)supabaseUrl$iv$iv, (String)supabaseKey$iv$iv);
        boolean bl = false;
        $this$standaloneSupabaseModule_u24lambda_u240$iv.install((SupabasePluginProvider)provider$iv, (Function1)new Function1<GoTrueConfig, Unit>((String)url$iv){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull MainConfig $this$install) {
                Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                $this$install.setCustomUrl(this.$url);
                MainConfig mainConfig = $this$install;
                boolean bl = false;
            }
        });
        SupabaseClient underlyingClient$iv = supabaseClientBuilder.build();
        PluginManager this_$iv$iv = underlyingClient$iv.getPluginManager();
        boolean $i$f$getPlugin = false;
        PluginManager this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$getPluginOrNull = false;
        Object v = this_$iv$iv$iv.getInstalledPlugins().get(provider$iv.getKey());
        if (!(v instanceof GoTrue)) {
            v = null;
        }
        SupabasePlugin supabasePlugin = (SupabasePlugin)((GoTrue)v);
        if (supabasePlugin == null) {
            throw new IllegalStateException(("Plugin " + provider$iv.getKey() + " not installed or not of type " + Reflection.getOrCreateKotlinClass(GoTrue.class).getSimpleName() + ". Consider installing " + Reflection.getOrCreateKotlinClass(GoTrue.class).getSimpleName() + " within your SupabaseClientBuilder").toString());
        }
        return (GoTrue)((MainPlugin)supabasePlugin);
    }

    @Bean
    @NotNull
    public JWTVerifier supabaseJwtVerifier(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        JWTVerifier jWTVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)supabaseProperties.getJwtSecret())).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTVerifier, (String)"build(...)");
        return jWTVerifier;
    }
}

