/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.controller;

import de.tschuehly.htmx.spring.supabase.auth.exception.info.MissingCredentialsException;
import de.tschuehly.htmx.spring.supabase.auth.service.ISupabaseUserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"api/user"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J.\u0010\u0011\u001a\u00020\f2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0014\u0010\u0016\u001a\u00020\f2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0017J\u0012\u0010\u0018\u001a\u00020\f2\b\b\u0001\u0010\u0017\u001a\u00020\u0014H\u0017J,\u0010\u0019\u001a\u00020\f2\u0010\b\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u0014H\u0017J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001f\u001a\u00020\u0014H\u0017JD\u0010 \u001a\u00020\f*\u00020\u000e26\u0010!\u001a2\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\f0\"H\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/controller/SupabaseUserController;", "", "supabaseUserService", "Lde/tschuehly/htmx/spring/supabase/auth/service/ISupabaseUserService;", "(Lde/tschuehly/htmx/spring/supabase/auth/service/ISupabaseUserService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseUserService", "()Lde/tschuehly/htmx/spring/supabase/auth/service/ISupabaseUserService;", "authorizeWithJwtOrResetPassword", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "login", "credentials", "", "", "logout", "sendEmailOtp", "email", "sendPasswordResetEmail", "setRoles", "roles", "", "userId", "signUp", "updatePassword", "password", "checkCredentialsAndExecute", "function", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "htmx-spring-supabase-auth"})
public class SupabaseUserController {
    @NotNull
    private final ISupabaseUserService supabaseUserService;
    @NotNull
    private final Logger logger;

    public SupabaseUserController(@NotNull ISupabaseUserService supabaseUserService) {
        Intrinsics.checkNotNullParameter((Object)supabaseUserService, (String)"supabaseUserService");
        this.supabaseUserService = supabaseUserService;
        Logger logger = LoggerFactory.getLogger(SupabaseUserController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public ISupabaseUserService getSupabaseUserService() {
        return this.supabaseUserService;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @PostMapping(value={"/login"})
    public void login(@RequestParam @NotNull Map<String, String> credentials, @NotNull HttpServletResponse response, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.checkCredentialsAndExecute(request, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this, response){
            final /* synthetic */ SupabaseUserController this$0;
            final /* synthetic */ HttpServletResponse $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2);
            }

            public final void invoke(@NotNull String email, @NotNull String password) {
                Intrinsics.checkNotNullParameter((Object)email, (String)"email");
                Intrinsics.checkNotNullParameter((Object)password, (String)"password");
                this.this$0.getLogger().debug("User with the email " + email + " is trying to login");
                this.this$0.getSupabaseUserService().loginWithEmail(((Object)StringsKt.trim((CharSequence)email)).toString(), ((Object)StringsKt.trim((CharSequence)password)).toString(), this.$response);
            }
        }));
    }

    @PostMapping(value={"/signup"})
    public void signUp(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.checkCredentialsAndExecute(request, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this, response){
            final /* synthetic */ SupabaseUserController this$0;
            final /* synthetic */ HttpServletResponse $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2);
            }

            public final void invoke(@NotNull String email, @NotNull String password) {
                Intrinsics.checkNotNullParameter((Object)email, (String)"email");
                Intrinsics.checkNotNullParameter((Object)password, (String)"password");
                this.this$0.getLogger().debug("User with the email " + email + " is trying to signup");
                this.this$0.getSupabaseUserService().signUpWithEmail(email, password, this.$response);
            }
        }));
    }

    @PostMapping(value={"/sendEmailOtp"})
    public void sendEmailOtp(@RequestParam @Nullable String email) {
        if (email != null) {
            this.getLogger().debug("User with the email " + email + " is requesting an OTP");
            this.getSupabaseUserService().sendOtp(email);
        } else {
            MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
        }
    }

    private void checkCredentialsAndExecute(HttpServletRequest $this$checkCredentialsAndExecute, Function2<? super String, ? super String, Unit> function) {
        Object[] objectArray = (String[])$this$checkCredentialsAndExecute.getParameterMap().get("email");
        String email = objectArray != null ? (String)ArraysKt.firstOrNull((Object[])objectArray) : null;
        Object[] objectArray2 = (String[])$this$checkCredentialsAndExecute.getParameterMap().get("password");
        String password = objectArray2 != null ? (String)ArraysKt.firstOrNull((Object[])objectArray2) : null;
        CharSequence charSequence = email;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)password) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            MissingCredentialsException.Companion.MissingCredentials.PASSWORD_AND_EMAIL_MISSING.throwExc();
        } else {
            charSequence = email;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                MissingCredentialsException.Companion.MissingCredentials.EMAIL_MISSING.throwExc();
            } else {
                charSequence = password;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    MissingCredentialsException.Companion.MissingCredentials.PASSWORD_MISSING.throwExc();
                } else {
                    function.invoke((Object)((Object)StringsKt.trim((CharSequence)email)).toString(), (Object)((Object)StringsKt.trim((CharSequence)password)).toString());
                }
            }
        }
    }

    @PostMapping(value={"/jwt"})
    public void authorizeWithJwtOrResetPassword(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.getSupabaseUserService().authorizeWithJwtOrResetPassword(request, response);
    }

    @GetMapping(value={"/logout"})
    public void logout(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.getSupabaseUserService().logout(request, response);
    }

    @PutMapping(value={"/setRoles"})
    @ResponseBody
    public void setRoles(@RequestParam @Nullable List<String> roles, @NotNull HttpServletRequest request, @RequestParam @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (Intrinsics.areEqual((Object)userId, (Object)"")) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "UserId required");
        }
        this.getSupabaseUserService().setRolesWithRequest(request, userId, roles);
    }

    @PostMapping(value={"/sendPasswordResetEmail"})
    @ResponseBody
    public void sendPasswordResetEmail(@RequestParam @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.getLogger().debug("User with the email " + email + " requested a password reset");
        this.getSupabaseUserService().sendPasswordRecoveryEmail(email);
    }

    @PostMapping(value={"/updatePassword"})
    @ResponseBody
    public void updatePassword(@NotNull HttpServletRequest request, @RequestParam @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.getSupabaseUserService().updatePassword(request, password);
    }
}

