/*
 * Decompiled with CFR 0.152.
 */
package de.tschuehly.htmx.spring.supabase.auth.security;

import com.auth0.jwt.JWTVerifier;
import de.tschuehly.htmx.spring.supabase.auth.config.SupabaseProperties;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAccessDeniedHandler;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationEntryPoint;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseAuthenticationProvider;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseJwtFilter;
import de.tschuehly.htmx.spring.supabase.auth.security.SupabaseSecurityConfig;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.AuthorizeHttpRequestsDsl;
import org.springframework.security.config.annotation.web.ExceptionHandlingDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDslKt;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity(debug=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig;", "", "supabaseProperties", "Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "(Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getSupabaseProperties", "()Lde/tschuehly/htmx/spring/supabase/auth/config/SupabaseProperties;", "authManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "supabaseAuthenticationProvider", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseAuthenticationProvider;", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "supabaseJwtFilter", "Lde/tschuehly/htmx/spring/supabase/auth/security/SupabaseJwtFilter;", "supabaseAuthenticationManager", "supabaseAccessDeniedHandler", "Lorg/springframework/security/web/access/AccessDeniedHandler;", "supabaseAuthenticationEntryPoint", "Lorg/springframework/security/web/AuthenticationEntryPoint;", "jwtVerifier", "Lcom/auth0/jwt/JWTVerifier;", "authenticationManager", "authenticationEntryPoint", "htmx-spring-supabase-auth"})
@SourceDebugExtension(value={"SMAP\nSupabaseSecurityConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupabaseSecurityConfig.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n215#2,2:149\n37#3,2:151\n*S KotlinDebug\n*F\n+ 1 SupabaseSecurityConfig.kt\nde/tschuehly/htmx/spring/supabase/auth/security/SupabaseSecurityConfig\n*L\n37#1:149,2\n142#1:151,2\n*E\n"})
public class SupabaseSecurityConfig {
    @NotNull
    private final SupabaseProperties supabaseProperties;
    @NotNull
    private final Logger logger;

    public SupabaseSecurityConfig(@NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        this.supabaseProperties = supabaseProperties;
        Logger logger = LoggerFactory.getLogger(SupabaseSecurityConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public SupabaseProperties getSupabaseProperties() {
        return this.supabaseProperties;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http, @NotNull SupabaseJwtFilter supabaseJwtFilter, @NotNull AuthenticationManager supabaseAuthenticationManager) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)((Object)supabaseJwtFilter), (String)"supabaseJwtFilter");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationManager, (String)"supabaseAuthenticationManager");
        Map<String, SupabaseProperties.Role> $this$forEach$iv = this.getSupabaseProperties().getRoles();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SupabaseProperties.Role>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SupabaseProperties.Role> element$iv;
            Map.Entry<String, SupabaseProperties.Role> entry = element$iv = iterator.next();
            boolean bl = false;
            String role = entry.getKey();
            SupabaseProperties.Role paths = entry.getValue();
            HttpSecurityDslKt.invoke((HttpSecurity)http, (Function1)((Function1)new Function1<HttpSecurityDsl, Unit>(paths, this, role){
                final /* synthetic */ SupabaseProperties.Role $paths;
                final /* synthetic */ SupabaseSecurityConfig this$0;
                final /* synthetic */ String $role;
                {
                    this.$paths = $paths;
                    this.this$0 = $receiver;
                    this.$role = $role;
                    super(1);
                }

                public final void invoke(@NotNull HttpSecurityDsl $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.authorizeHttpRequests((Function1)new Function1<AuthorizeHttpRequestsDsl, Unit>(this.$paths, this.this$0, this.$role){
                        final /* synthetic */ SupabaseProperties.Role $paths;
                        final /* synthetic */ SupabaseSecurityConfig this$0;
                        final /* synthetic */ String $role;
                        {
                            this.$paths = $paths;
                            this.this$0 = $receiver;
                            this.$role = $role;
                            super(1);
                        }

                        public final void invoke(@NotNull AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
                            String path;
                            String element$iv;
                            int n;
                            String[] $this$forEach$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
                            String[] stringArray = this.$paths.getGet();
                            SupabaseSecurityConfig supabaseSecurityConfig = this.this$0;
                            String string = this.$role;
                            boolean $i$f$forEach = false;
                            int n2 = $this$forEach$iv.length;
                            for (n = 0; n < n2; ++n) {
                                path = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method GET is secured with Expression: hasRole('" + string + "')");
                                String string2 = string.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                                $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string2));
                            }
                            $this$forEach$iv = this.$paths.getPost();
                            supabaseSecurityConfig = this.this$0;
                            string = this.$role;
                            $i$f$forEach = false;
                            n2 = $this$forEach$iv.length;
                            for (n = 0; n < n2; ++n) {
                                path = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method POST is secured with Expression: hasRole('" + string + "')");
                                String string3 = string.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                                $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string3));
                            }
                            $this$forEach$iv = this.$paths.getDelete();
                            supabaseSecurityConfig = this.this$0;
                            string = this.$role;
                            $i$f$forEach = false;
                            n2 = $this$forEach$iv.length;
                            for (n = 0; n < n2; ++n) {
                                path = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method DELETE is secured with Expression: hasRole('" + string + "')");
                                String string4 = string.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                                $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string4));
                            }
                            $this$forEach$iv = this.$paths.getPut();
                            supabaseSecurityConfig = this.this$0;
                            string = this.$role;
                            $i$f$forEach = false;
                            n2 = $this$forEach$iv.length;
                            for (n = 0; n < n2; ++n) {
                                path = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method PUT is secured with Expression: hasRole('" + string + "')");
                                String string5 = string.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                                $this$authorizeHttpRequests.authorize(path, $this$authorizeHttpRequests.hasRole(string5));
                            }
                        }
                    });
                }
            }));
        }
        HttpSecurityDslKt.invoke((HttpSecurity)http, (Function1)((Function1)new Function1<HttpSecurityDsl, Unit>(supabaseAuthenticationManager, supabaseJwtFilter, this){
            final /* synthetic */ AuthenticationManager $supabaseAuthenticationManager;
            final /* synthetic */ SupabaseJwtFilter $supabaseJwtFilter;
            final /* synthetic */ SupabaseSecurityConfig this$0;
            {
                this.$supabaseAuthenticationManager = $supabaseAuthenticationManager;
                this.$supabaseJwtFilter = $supabaseJwtFilter;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull HttpSecurityDsl $this$invoke) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.authorizeHttpRequests((Function1)new Function1<AuthorizeHttpRequestsDsl, Unit>(this.this$0){
                    final /* synthetic */ SupabaseSecurityConfig this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
                        String path;
                        String element$iv;
                        int n;
                        String[] $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
                        String[] stringArray = this.this$0.getSupabaseProperties().getPublic().getGet();
                        SupabaseSecurityConfig supabaseSecurityConfig = this.this$0;
                        boolean $i$f$forEach = false;
                        int n2 = $this$forEach$iv.length;
                        for (n = 0; n < n2; ++n) {
                            path = element$iv = $this$forEach$iv[n];
                            boolean bl = false;
                            supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method GET is public");
                            HttpMethod httpMethod = HttpMethod.GET;
                            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"GET");
                            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
                        }
                        $this$forEach$iv = this.this$0.getSupabaseProperties().getPublic().getPost();
                        supabaseSecurityConfig = this.this$0;
                        $i$f$forEach = false;
                        n2 = $this$forEach$iv.length;
                        for (n = 0; n < n2; ++n) {
                            path = element$iv = $this$forEach$iv[n];
                            boolean bl = false;
                            supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method POST is public");
                            HttpMethod httpMethod = HttpMethod.POST;
                            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
                            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
                        }
                        $this$forEach$iv = this.this$0.getSupabaseProperties().getPublic().getDelete();
                        supabaseSecurityConfig = this.this$0;
                        $i$f$forEach = false;
                        n2 = $this$forEach$iv.length;
                        for (n = 0; n < n2; ++n) {
                            path = element$iv = $this$forEach$iv[n];
                            boolean bl = false;
                            supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method DELETE is public");
                            HttpMethod httpMethod = HttpMethod.DELETE;
                            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"DELETE");
                            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
                        }
                        $this$forEach$iv = this.this$0.getSupabaseProperties().getPublic().getPut();
                        supabaseSecurityConfig = this.this$0;
                        $i$f$forEach = false;
                        n2 = $this$forEach$iv.length;
                        for (n = 0; n < n2; ++n) {
                            path = element$iv = $this$forEach$iv[n];
                            boolean bl = false;
                            supabaseSecurityConfig.getLogger().info("Path: " + path + " with Method PUT is public");
                            HttpMethod httpMethod = HttpMethod.PUT;
                            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"PUT");
                            $this$authorizeHttpRequests.authorize(httpMethod, path, $this$authorizeHttpRequests.getPermitAll());
                        }
                        $this$authorizeHttpRequests.authorize($this$authorizeHttpRequests.getAnyRequest(), $this$authorizeHttpRequests.getAuthenticated());
                    }
                });
                $this$invoke.sessionManagement((Function1)filterChain.2.INSTANCE);
                $this$invoke.setAuthenticationManager(this.$supabaseAuthenticationManager);
                $this$invoke.httpBasic((Function1)filterChain.3.INSTANCE);
                $this$invoke.csrf((Function1)filterChain.4.INSTANCE);
                $this$invoke.headers((Function1)filterChain.5.INSTANCE);
                HttpSecurityDsl httpSecurityDsl = $this$invoke;
                Filter filter$iv = (Filter)this.$supabaseJwtFilter;
                boolean $i$f$addFilterBefore = false;
                this_$iv.addFilterBefore(filter$iv, UsernamePasswordAuthenticationFilter.class);
                $this$invoke.exceptionHandling((Function1)new Function1<ExceptionHandlingDsl, Unit>(this.this$0){
                    final /* synthetic */ SupabaseSecurityConfig this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ExceptionHandlingDsl $this$exceptionHandling) {
                        Intrinsics.checkNotNullParameter((Object)$this$exceptionHandling, (String)"$this$exceptionHandling");
                        $this$exceptionHandling.setAuthenticationEntryPoint(this.this$0.supabaseAuthenticationEntryPoint());
                        $this$exceptionHandling.setAccessDeniedHandler(this.this$0.supabaseAccessDeniedHandler());
                    }
                });
            }
        }));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public AccessDeniedHandler supabaseAccessDeniedHandler() {
        return new SupabaseAccessDeniedHandler(this.getSupabaseProperties());
    }

    @Bean
    @NotNull
    public AuthenticationEntryPoint supabaseAuthenticationEntryPoint() {
        return new SupabaseAuthenticationEntryPoint(this.getSupabaseProperties());
    }

    @Bean
    @NotNull
    public SupabaseAuthenticationProvider supabaseAuthenticationProvider(@NotNull JWTVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        return new SupabaseAuthenticationProvider(jwtVerifier);
    }

    @Bean
    @NotNull
    public SupabaseJwtFilter supabaseJwtFilter(@NotNull AuthenticationManager authenticationManager, @NotNull SupabaseProperties supabaseProperties, @NotNull JWTVerifier jwtVerifier, @NotNull AuthenticationEntryPoint authenticationEntryPoint) {
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)authenticationEntryPoint, (String)"authenticationEntryPoint");
        return new SupabaseJwtFilter(authenticationManager, supabaseProperties, authenticationEntryPoint);
    }

    @Bean
    @NotNull
    public AuthenticationManager authManager(@NotNull HttpSecurity http, @NotNull SupabaseAuthenticationProvider supabaseAuthenticationProvider, @NotNull SupabaseProperties supabaseProperties) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)supabaseAuthenticationProvider, (String)"supabaseAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)supabaseProperties, (String)"supabaseProperties");
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)supabaseAuthenticationProvider);
        if (supabaseProperties.getBasicAuth().getEnabled()) {
            Collection $this$toTypedArray$iv = supabaseProperties.getBasicAuth().getRoles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            authenticationManagerBuilder.inMemoryAuthentication().withUser(supabaseProperties.getBasicAuth().getUsername()).password(supabaseProperties.getBasicAuth().getPassword()).roles(Arrays.copyOf(stringArray, stringArray.length));
        }
        Object object = authenticationManagerBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AuthenticationManager)object;
    }
}

